/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.externalcontrol.semantics;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.moka.externalcontrol.advice.IControllerAdvice;
import org.eclipse.papyrus.moka.externalcontrol.controller.ExternalController;
import org.eclipse.papyrus.moka.externalcontrol.semantics.AbstractExternallyControlledActionActivation;
import org.eclipse.papyrus.moka.externalcontrol.semantics.ExternallyControlledActivityExecution;
import org.eclipse.papyrus.moka.fuml.Semantics.Actions.BasicActions.ICallActionActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.BasicBehaviors.IExecution;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.BasicBehaviors.IParameterValue;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Actions.BasicActions.CallActionActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.CommonBehaviors.BasicBehaviors.ParameterValue;
import org.eclipse.uml2.uml.CallAction;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;

public class ExternallyControlledCallActionActivation
extends AbstractExternallyControlledActionActivation<CallActionActivation>
implements ICallActionActivation {
    public List<IExecution> callExecutions = new ArrayList<IExecution>();
    private IExecution suspendedExecution;

    public ExternallyControlledCallActionActivation(CallActionActivation visitor, ExternalController controller, List<IControllerAdvice> advices) {
        super(visitor, controller, advices);
    }

    @Override
    protected void doSemanticAction() {
        this.doAction();
    }

    @Override
    public void doAction() {
        IExecution callExecution = this.getCallExecution();
        if (callExecution != null) {
            this.callExecutions.add(callExecution);
            CallAction callAction = (CallAction)this.getNode();
            EList argumentPins = callAction.getArguments();
            EList parameters = callExecution.getBehavior().getOwnedParameters();
            int pinNumber = 1;
            int i = 1;
            while (i <= parameters.size()) {
                Parameter parameter = (Parameter)parameters.get(i - 1);
                if (parameter.getDirection() == ParameterDirectionKind.IN_LITERAL | parameter.getDirection() == ParameterDirectionKind.INOUT_LITERAL) {
                    ParameterValue parameterValue = new ParameterValue();
                    parameterValue.parameter = parameter;
                    parameterValue.values = this.takeTokens((InputPin)argumentPins.get(pinNumber - 1));
                    callExecution.setParameterValue((IParameterValue)parameterValue);
                    ++pinNumber;
                }
                ++i;
            }
            callExecution.execute();
            this.suspendedExecution = callExecution;
        }
    }

    @Override
    public void doResumeExecution() {
        CallAction callAction = (CallAction)this.getNode();
        EList resultPins = callAction.getResults();
        EList parameters = this.suspendedExecution.getBehavior().getOwnedParameters();
        List outputParameterValues = this.suspendedExecution.getOutputParameterValues();
        int pinNumber = 1;
        int i = 1;
        while (i <= parameters.size()) {
            Parameter parameter = (Parameter)parameters.get(i - 1);
            if (parameter.getDirection() == ParameterDirectionKind.INOUT_LITERAL | parameter.getDirection() == ParameterDirectionKind.OUT_LITERAL | parameter.getDirection() == ParameterDirectionKind.RETURN_LITERAL) {
                int j = 0;
                while (j < outputParameterValues.size()) {
                    IParameterValue outputParameterValue = (IParameterValue)outputParameterValues.get(j);
                    if (outputParameterValue.getParameter() == parameter) {
                        OutputPin resultPin = (OutputPin)resultPins.get(pinNumber - 1);
                        this.putTokens(resultPin, outputParameterValue.getValues());
                    }
                    ++j;
                }
                ++pinNumber;
            }
            ++i;
        }
        this.suspendedExecution.destroy();
        this.removeCallExecution(this.suspendedExecution);
        this.suspendedExecution = null;
        List incomingTokens = ((CallActionActivation)this.delegatedVisitor).completeAction();
        if (incomingTokens.size() > 0) {
            this.fire(incomingTokens);
        }
        this.resume();
    }

    public IExecution getCallExecution() {
        IExecution execution = ((CallActionActivation)this.delegatedVisitor).getCallExecution();
        this.callExecutions.add(execution);
        if (execution instanceof ExternallyControlledActivityExecution) {
            ((ExternallyControlledActivityExecution)execution).setStackParent(this);
        }
        return execution;
    }

    public void removeCallExecution(IExecution execution) {
        ((CallActionActivation)this.delegatedVisitor).removeCallExecution(execution);
        this.callExecutions.remove(execution);
    }
}

