/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.externalcontrol.engine;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.moka.externalcontrol.advice.IControllerAdviceFactory;
import org.eclipse.papyrus.moka.externalcontrol.control.queue.ExternallyControlledExecutionLoop;
import org.eclipse.papyrus.moka.externalcontrol.controller.ExternalController;
import org.eclipse.papyrus.moka.externalcontrol.controller.IControlledVisitorPushPullStrategy;
import org.eclipse.papyrus.moka.externalcontrol.controller.NodeEdgeAlternatePushPullStrategy;
import org.eclipse.papyrus.moka.externalcontrol.semantics.ExternalControlExecutionFactory;
import org.eclipse.papyrus.moka.externalcontrol.semantics.ExternalControlExecutor;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.IExecutionFactory;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.IExecutor;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ILocus;
import org.eclipse.papyrus.moka.fuml.control.execution.RootExecution;
import org.eclipse.papyrus.moka.fuml.control.queue.ExecutionController;
import org.eclipse.papyrus.moka.fuml.control.queue.ExecutionLoop;
import org.eclipse.papyrus.moka.fuml.statemachines.Semantics.Loci.SM_Locus;
import org.eclipse.papyrus.moka.timedfuml.TimedUmlExecutionEngine;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;

public abstract class AbstractExternalControlExecutionEngine
extends TimedUmlExecutionEngine {
    protected ExternalController controller;

    protected abstract List<IControllerAdviceFactory> getAdviceFactories();

    protected abstract IExecutionFactory getDelegatedExecutionFactory();

    protected ILocus getLocus() {
        return new SM_Locus();
    }

    protected IExecutor getExecutor() {
        return new ExternalControlExecutor();
    }

    protected IControlledVisitorPushPullStrategy getControllerPushPullStrategy() {
        return new NodeEdgeAlternatePushPullStrategy();
    }

    public ILocus initializeLocus() {
        this.locus = this.getLocus();
        this.locus.setExecutor(this.getExecutor());
        IExecutionFactory delegatedFactory = this.getDelegatedExecutionFactory();
        ExternalControlExecutionFactory externalControlExecutionFactory = new ExternalControlExecutionFactory(delegatedFactory, this.controller, this.getAdviceFactories());
        this.locus.setFactory((IExecutionFactory)externalControlExecutionFactory);
        return this.locus;
    }

    public void start(IProgressMonitor monitor) {
        this.controller = new ExternalController(this.getControllerPushPullStrategy());
        super.start(monitor);
    }

    protected void run_() {
        RootExecution rootExecution = new RootExecution((Class)((Behavior)this.executionEntryPoint), this.executionArguments, this.locus);
        ExecutionController.getInstance().setExecutionLoop((ExecutionLoop)new ExternallyControlledExecutionLoop(this.controller));
        ExecutionController.getInstance().start(rootExecution);
    }
}

