/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.model.data.presentations;

import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.moka.debug.model.data.mapping.variables.MokaVariableAdapter;
import org.eclipse.uml2.uml.Element;

public abstract class MokaDebugLabelProvider
implements ILabelProvider {
    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void dispose() {
    }

    public String getText(Object element) {
        if (element != null) {
            try {
                return ((MokaVariableAdapter)((Object)element)).getName();
            }
            catch (DebugException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected ILabelProvider getPapyrusLabelProvider(Element element) {
        ILabelProvider papyrusProvider = null;
        if (element != null && element.eResource() != null) {
            ServicesRegistry registry = null;
            try {
                registry = ServiceUtilsForResource.getInstance().getServiceRegistry(element.eResource());
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            if (registry != null) {
                LabelProviderService service = null;
                try {
                    service = (LabelProviderService)registry.getService(LabelProviderService.class);
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
                if (service != null) {
                    papyrusProvider = service.getLabelProvider((Object)element);
                }
            }
        }
        return papyrusProvider;
    }
}

