/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.emf.structure2document.internal.utils;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.emf.documentstructure.TextDocument;
import org.eclipse.papyrus.model2doc.emf.structure2document.generator.helpers.CreateFileFromTextDocumentHelper;
import org.eclipse.papyrus.model2doc.emf.structure2document.generator.helpers.ITranscriptionFactory;
import org.eclipse.papyrus.model2doc.odt.emf.structure2document.Activator;
import org.eclipse.papyrus.model2doc.odt.emf.structure2document.internal.utils.ODTTranscriptionFactory;

public class GenerateODTFileUtils {
    public static String generateODTFile(TextDocument textDocument) {
        IProject project;
        CreateFileFromTextDocumentHelper helper = new CreateFileFromTextDocumentHelper(textDocument, (ITranscriptionFactory)new ODTTranscriptionFactory());
        String generatedFilePath = helper.generate();
        String projectToRefresh = textDocument.getDocumentGeneratorConfiguration().createDocumentOutputAccessor().getProjectName();
        if (projectToRefresh != null && !projectToRefresh.isEmpty() && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectToRefresh)) != null) {
            try {
                project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.log.error(NLS.bind((String)"An exception occured during the refresh of the project {0}", (Object)projectToRefresh), (Throwable)e);
            }
        }
        return generatedFilePath;
    }
}

