/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.opcua.uml2opcua.ui.handlers;

import java.io.OutputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.opcua.uml2opcua.qvt.Uml2OpcuaTransformer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UMLToOPCUAQvtHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(UMLToOPCUAQvtHandler.class);

    private MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        System.out.println("TransformWithQvtHandler is executed");
        logger.info("Testing the logger");
        MessageConsole myConsole = this.findConsole("Console");
        MessageConsoleStream out = myConsole.newMessageStream();
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ISelectionService service = window.getSelectionService();
        IStructuredSelection selection = (IStructuredSelection)service.getSelection();
        if (selection.size() > 1) {
            return null;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object selected = selection.getFirstElement();
        EObject selectedElement = EMFHelper.getEObject((Object)selection.getFirstElement());
        IAdapterManager am = Platform.getAdapterManager();
        IFile adapter = (IFile)am.getAdapter(selected, IFile.class);
        IFile file = adapter;
        String umlFilePath = file.getRawLocation().makeAbsolute().toString();
        if (!umlFilePath.endsWith("uml")) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)"The file extension needs to be uml");
            return null;
        }
        URI resourceURI = selectedElement.eResource().getURI();
        String opcuaNodesetFilePath = umlFilePath.replace(".uml", ".xml");
        String opcuaNodeIdsCsvFilePath = umlFilePath.replace(".uml", ".csv");
        Uml2OpcuaTransformer transformer = new Uml2OpcuaTransformer();
        ModelExtent[] transformationResults = new ModelExtent[2];
        boolean success = transformer.transform(resourceURI, null, transformationResults, (OutputStream)out);
        System.out.println("2 calling QVTo transformation" + success + "test");
        if (success) {
            ModelExtent opcuaNodesetOutput = transformationResults[0];
            ModelExtent opcuaNodeIdsCsvOutput = transformationResults[1];
            transformer.serializeNodeset(opcuaNodesetOutput, opcuaNodesetFilePath, (OutputStream)out);
            transformer.serializeNodeIdsCsv(opcuaNodeIdsCsvOutput, opcuaNodeIdsCsvFilePath, (OutputStream)out);
            try {
                file.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        try {
            file.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }
}

