/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.profile.ui.modelelement;

import java.util.List;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.aas.profile.ui.modelelement.CompositeValidator;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.ui.databinding.PapyrusObservableValue;
import org.eclipse.papyrus.infra.tools.databinding.DelegatingObservable;
import org.eclipse.papyrus.uml.properties.databinding.StereotypePropertyObservableValue;
import org.eclipse.papyrus.uml.properties.modelelement.StereotypeModelElement;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class AssStereotypeModelElement
extends StereotypeModelElement {
    public AssStereotypeModelElement(EObject stereotypeApplication, Stereotype stereotype, EditingDomain domain) {
        super(stereotypeApplication, stereotype, domain);
    }

    protected boolean isFeatureEditable(String propertyPath) {
        return !propertyPath.equals("idShort") && !propertyPath.equals("submodel");
    }

    public IObservable doGetObservable(String propertyPath) {
        if (propertyPath.equals("endpoint") || propertyPath.equals("endPoint") || propertyPath.equals("identification") || propertyPath.equals("value") && (this.stereotype.getName().equals("LangString") || this.stereotype.getName().equals("MultiLanguageProperty")) || propertyPath.equals("description")) {
            FeaturePath featurePath = this.getFeaturePath(propertyPath);
            EStructuralFeature feature = this.getFeature(featurePath);
            Element baseElement = UMLUtil.getBaseElement((EObject)this.source);
            if (feature.getUpperBound() != 1) {
                List wrappedList = (List)this.source.eGet(feature);
                StereotypePropertyObservableValue papy = new StereotypePropertyObservableValue(this.source, feature, this.domain, this.stereotype);
                IObservableValue wrap = (IObservableValue)DelegatingObservable.wrap((IObservable)papy);
                return wrap;
            }
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.source);
            PapyrusObservableValue papyrusObservableValue = new PapyrusObservableValue(this.source, feature, (EditingDomain)editingDomain, GMFtoEMFCommandWrapper::wrap);
            return papyrusObservableValue;
        }
        return super.doGetObservable(propertyPath);
    }

    public IValidator getValidator(String propertyPath) {
        IValidator result = super.getValidator(propertyPath);
        if (propertyPath.equals("name")) {
            result = CompositeValidator.of(result, new IValidator(){

                public IStatus validate(Object value) {
                    if (!((String)value).matches("[a-zA-Z]+\\\\w*")) {
                        return new Status(4, "org.eclipse.papyrus.aas.ui", "The name shall only feature letters, digits, underscore ('_'); starting with a small letter");
                    }
                    return Status.OK_STATUS;
                }
            });
        }
        return result;
    }
}

