/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.profile.ui.advices;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.EditHelperContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.aas.Asset;
import org.eclipse.papyrus.aas.AssetAdministrationShell;
import org.eclipse.papyrus.aas.profile.ui.advices.AASElementTypesEnumerator;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class AASEditHelperAdvice
extends AbstractEditHelperAdvice {
    private IProgressMonitor progressMonitor;
    private IAdaptable info;

    public ICommand getAfterEditCommand(IEditCommandRequest request) {
        Object element;
        Object context = request.getEditHelperContext();
        if (context instanceof EditHelperContext && ((EditHelperContext)context).getElementType() != null) {
            return super.getAfterEditCommand(request);
        }
        if (request.getElementsToEdit() != null && !request.getElementsToEdit().isEmpty() && (element = request.getElementsToEdit().get(0)) instanceof Element) {
            try {
                return this.getChangeContainerCommand((Element)element);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return super.getAfterEditCommand(request);
    }

    protected ICommand getChangeContainerCommand(Element element) throws ExecutionException {
        Package container = AASEditHelperAdvice.getSpecificElementPackage(element.getModel(), "AAS::AssetAdministrationShell");
        CompositeCommand changeContainerCommand = new CompositeCommand("Change Container");
        IElementEditService serviceEdit = ElementEditServiceUtils.getCommandProvider((EObject)element);
        EObject newElement = null;
        if (container == null) {
            IHintedType packageelementType = AASElementTypesEnumerator.AAS_Package;
            CreateElementRequest createElementRequest = new CreateElementRequest((EObject)element.getModel(), (IElementType)packageelementType);
            CreateElementCommand command = new CreateElementCommand(createElementRequest);
            try {
                command.execute(this.progressMonitor, this.info);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            newElement = command.getNewElement();
            if (newElement == null) {
                throw new ExecutionException("Element creation problem for " + packageelementType.getDisplayName() + ".");
            }
            container = (Package)newElement;
            if (packageelementType != null) {
                String packageName = "AASs";
                SetRequest setNameRequest = new SetRequest((EObject)container, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)packageName);
                ICommand setNameCommand = serviceEdit.getEditCommand((IEditCommandRequest)setNameRequest);
                changeContainerCommand.compose((IUndoableOperation)setNameCommand);
            }
        }
        EList packagedElements = container.getPackagedElements();
        ArrayList<PackageableElement> list = new ArrayList<PackageableElement>();
        list.addAll((Collection<PackageableElement>)packagedElements);
        list.add((PackageableElement)element);
        SetRequest setContainerRequest = new SetRequest((EObject)container, (EStructuralFeature)UMLPackage.eINSTANCE.getPackage_PackagedElement(), list);
        ICommand setContainerCommand = serviceEdit.getEditCommand((IEditCommandRequest)setContainerRequest);
        changeContainerCommand.compose((IUndoableOperation)setContainerCommand);
        return changeContainerCommand;
    }

    private static Package getSpecificElementPackage(Model model, String stereotypeName) {
        EList packages = model.getNestedPackages();
        if (packages != null && !packages.isEmpty()) {
            for (Package p : packages) {
                if (p.getAppliedStereotypes() == null || p.getAppliedStereotype(stereotypeName) == null) continue;
                return p;
            }
        }
        return null;
    }

    public ICommand getAfterConfigureCommand(ConfigureRequest request) {
        final EObject newElement = request.getElementToConfigure();
        final EObject container = newElement.eContainer();
        if (container != null && container instanceof Element) {
            return new ConfigureElementCommand(request){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    Asset asset = (Asset)UMLUtil.getStereotypeApplication((Element)((Element)container), Asset.class);
                    AssetAdministrationShell aas = (AssetAdministrationShell)UMLUtil.getStereotypeApplication((Element)((Element)newElement), AssetAdministrationShell.class);
                    if (asset != null && aas != null) {
                        aas.setAsset(asset);
                    }
                    return CommandResult.newOKCommandResult((Object)newElement);
                }
            };
        }
        return super.getAfterConfigureCommand(request);
    }
}

