/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.tables.configurations.manager.axis;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.papyrus.infra.emf.nattable.manager.axis.AbstractSynchronizedOnEStructuralFeatureAxisManager;
import org.eclipse.uml2.uml.Element;

public class RTSynchronizedOnFeatureAxisManager
extends AbstractSynchronizedOnEStructuralFeatureAxisManager {
    private boolean showExclusions;

    public void setShowExclusions(boolean showExclusions) {
        if (showExclusions == this.showExclusions) {
            return;
        }
        this.showExclusions = showExclusions;
        List exclusions = this.getFeaturesValue().stream().filter(Element.class::isInstance).map(Element.class::cast).collect(Collectors.toList());
        if (!exclusions.isEmpty()) {
            if (showExclusions) {
                this.updateManagedList(exclusions, Collections.emptyList());
            } else {
                this.updateManagedList(Collections.emptyList(), exclusions);
            }
        }
    }

    public boolean isShowExclusions() {
        return this.showExclusions;
    }

    public boolean isAllowedContents(Object object) {
        return (this.showExclusions || !(object instanceof Element)) && super.isAllowedContents(object);
    }

    public void handleExclusion(Object possiblyExcluded) {
        Element element;
        if (!this.showExclusions && possiblyExcluded instanceof Element && (element = (Element)possiblyExcluded).eResource() != null) {
            this.updateManagedList(Collections.emptyList(), Collections.singletonList(element));
        }
    }
}

