/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.tables.configurations.editors.cell;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.papyrus.aas.Key;
import org.eclipse.papyrus.aas.Reference;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.celleditor.config.ICellAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.nattable.mouse.action.AbstractCellMouseAction;
import org.eclipse.papyrus.infra.nattable.mouse.action.EmptyLineRowHeaderEventMatch;
import org.eclipse.papyrus.infra.nattable.tree.ITreeItemAxisHelper;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CreateKeyFromHeaderCellEditorConfiguration
implements ICellAxisConfiguration {
    public NatTable natTable;

    public String getConfigurationId() {
        return "org.eclipse.papyrus.aas.tables.configurations.editors.cell.CreateKeyFromHeaderCellEditorConfiguration";
    }

    public String getConfigurationDescription() {
        return "Create new Key on empty line";
    }

    public boolean handles(Table table, Object axisElement) {
        return false;
    }

    public void configureCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        NatTable natTable;
        INattableModelManager manager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
        this.natTable = natTable = (NatTable)manager.getAdapter(NatTable.class);
        UiBindingRegistry uiBindingRegistry = natTable.getUiBindingRegistry();
        uiBindingRegistry.registerSingleClickBinding(this.getMouseEventMatcher(), this.getMouseAction());
    }

    private IMouseEventMatcher getMouseEventMatcher() {
        return new EmptyLineRowHeaderEventMatch(0, "ROW_HEADER", 1);
    }

    private IMouseAction getMouseAction() {
        return new CreateElementCellMouseAction();
    }

    public static Reference getStereotypeApplication(Element element) {
        Reference ref = null;
        if (element != null) {
            ref = (Reference)UMLUtil.getStereotypeApplication((Element)element, Reference.class);
        }
        return ref;
    }

    private Key getKeyApplication(Object commandresult) {
        Key key = null;
        if (commandresult != null) {
            key = (Key)UMLUtil.getStereotypeApplication((Element)((Element)commandresult), Key.class);
        }
        return key;
    }

    protected void addTreeItemAxis(TransactionalEditingDomain domain, AbstractAxisProvider axisProvider, AxisManagerRepresentation rep, Object object, CompoundCommand command) {
        ITreeItemAxis axis = ITreeItemAxisHelper.createITreeItemAxis(null, null, (Object)object, (AxisManagerRepresentation)rep);
        Command addCommand = AddCommand.create((EditingDomain)domain, (Object)axisProvider, (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), Collections.singleton(axis));
        command.append(addCommand);
    }

    private class CreateElementCellMouseAction
    extends AbstractCellMouseAction {
        private CreateElementCellMouseAction() {
        }

        public void doRun(NatTable natTable, MouseEvent event, Object rowElement, Object columnElement) {
            ITreeItemAxis currentAxis;
            ITreeItemAxis parentAxis;
            Object parentElement;
            if (rowElement instanceof ITreeItemAxis && ((ITreeItemAxis)rowElement).getElement() == null && (parentElement = (parentAxis = (currentAxis = (ITreeItemAxis)rowElement).getParent()).getElement()) instanceof TreeFillingConfiguration) {
                IAxis axisProvider = ((TreeFillingConfiguration)parentElement).getAxisUsedAsAxisProvider();
                Object representedElement = AxisUtils.getRepresentedElement((Object)axisProvider);
                final INattableModelManager manager = (INattableModelManager)natTable.getConfigRegistry().getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
                EObject creationParent = manager.getTable().getContext();
                final Reference reference = CreateKeyFromHeaderCellEditorConfiguration.getStereotypeApplication((Element)creationParent);
                if (reference != null) {
                    CreateElementRequest request = new CreateElementRequest(creationParent, ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.aAS.Key"));
                    IElementEditService service = ElementEditServiceUtils.getCommandProvider((EObject)reference);
                    ICommand cmd = service.getEditCommand((IEditCommandRequest)request);
                    request.getEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(cmd));
                    Object commandresult = cmd.getCommandResult().getReturnValue();
                    final Key key = CreateKeyFromHeaderCellEditorConfiguration.this.getKeyApplication(commandresult);
                    AbstractTransactionalCommand c = new AbstractTransactionalCommand(request.getEditingDomain(), "Reference and set its key2", null){

                        protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
                            Table table = manager.getTable();
                            reference.getKey().add((Object)key);
                            AbstractAxisProvider axisProvider = table.getCurrentRowAxisProvider();
                            TableHeaderAxisConfiguration conf = (TableHeaderAxisConfiguration)HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTableConfiguration((Table)manager.getTable());
                            AxisManagerRepresentation rep = (AxisManagerRepresentation)conf.getAxisManagers().get(0);
                            return CommandResult.newOKCommandResult();
                        }
                    };
                    if (c != null && c.canExecute()) {
                        try {
                            c.execute(null, null);
                        }
                        catch (ExecutionException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

