/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.software.artefact.util;

import java.util.Map;

import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.EObjectValidator;

import org.eclipse.papyrus.iotml.software.artefact.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Validator</b> for the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.papyrus.iotml.software.artefact.ArtefactPackage
 * @generated
 */
public class ArtefactValidator extends EObjectValidator {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final ArtefactValidator INSTANCE = new ArtefactValidator();

	/**
	 * A constant for the {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes} from this package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.common.util.Diagnostic#getSource()
	 * @see org.eclipse.emf.common.util.Diagnostic#getCode()
	 * @generated
	 */
	public static final String DIAGNOSTIC_SOURCE = "org.eclipse.papyrus.iotml.software.artefact";

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'Property Access C1' of 'Property Access'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int PROPERTY_ACCESS__PROPERTY_ACCESS_C1 = 1;

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'Property Access C2' of 'Property Access'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int PROPERTY_ACCESS__PROPERTY_ACCESS_C2 = 2;

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'Property Access C3' of 'Property Access'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int PROPERTY_ACCESS__PROPERTY_ACCESS_C3 = 3;

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'Provide Service C2' of 'Provide Service'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int PROVIDE_SERVICE__PROVIDE_SERVICE_C2 = 4;

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'Provide Service C1' of 'Provide Service'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int PROVIDE_SERVICE__PROVIDE_SERVICE_C1 = 5;

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'Provide Resource C1' of 'Provide Resource'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int PROVIDE_RESOURCE__PROVIDE_RESOURCE_C1 = 6;

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'Provide Resource C2' of 'Provide Resource'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int PROVIDE_RESOURCE__PROVIDE_RESOURCE_C2 = 7;

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'Service C1' of 'Service'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int SERVICE__SERVICE_C1 = 8;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 8;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants in a derived class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final int DIAGNOSTIC_CODE_COUNT = GENERATED_DIAGNOSTIC_CODE_COUNT;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ArtefactValidator() {
		super();
	}

	/**
	 * Returns the package of this validator switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EPackage getEPackage() {
	  return ArtefactPackage.eINSTANCE;
	}

	/**
	 * Calls <code>validateXXX</code> for the corresponding classifier of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
		switch (classifierID) {
			case ArtefactPackage.PROPERTY_ACCESS:
				return validatePropertyAccess((PropertyAccess)value, diagnostics, context);
			case ArtefactPackage.DIGITAL_ARTEFACT:
				return validateDigitalArtefact((DigitalArtefact)value, diagnostics, context);
			case ArtefactPackage.VIRTUAL_ENTITY:
				return validateVirtualEntity((VirtualEntity)value, diagnostics, context);
			case ArtefactPackage.PROVIDE_SERVICE:
				return validateProvideService((ProvideService)value, diagnostics, context);
			case ArtefactPackage.PROVIDE_RESOURCE:
				return validateProvideResource((ProvideResource)value, diagnostics, context);
			case ArtefactPackage.SERVICE_DESCRIPTION:
				return validateServiceDescription((ServiceDescription)value, diagnostics, context);
			case ArtefactPackage.SERVICE:
				return validateService((Service)value, diagnostics, context);
			default:
				return true;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validatePropertyAccess(PropertyAccess propertyAccess, DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (!validate_NoCircularContainment(propertyAccess, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(propertyAccess, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(propertyAccess, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(propertyAccess, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(propertyAccess, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(propertyAccess, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(propertyAccess, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(propertyAccess, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(propertyAccess, diagnostics, context);
		if (result || diagnostics != null) result &= validatePropertyAccess_PropertyAccess_C1(propertyAccess, diagnostics, context);
		if (result || diagnostics != null) result &= validatePropertyAccess_PropertyAccess_C2(propertyAccess, diagnostics, context);
		if (result || diagnostics != null) result &= validatePropertyAccess_propertyAccess_C3(propertyAccess, diagnostics, context);
		return result;
	}

	/**
	 * Validates the PropertyAccess_C1 constraint of '<em>Property Access</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validatePropertyAccess_PropertyAccess_C1(PropertyAccess propertyAccess, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return propertyAccess.PropertyAccess_C1(diagnostics, context);
	}

	/**
	 * Validates the PropertyAccess_C2 constraint of '<em>Property Access</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validatePropertyAccess_PropertyAccess_C2(PropertyAccess propertyAccess, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return propertyAccess.PropertyAccess_C2(diagnostics, context);
	}

	/**
	 * Validates the propertyAccess_C3 constraint of '<em>Property Access</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validatePropertyAccess_propertyAccess_C3(PropertyAccess propertyAccess, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return propertyAccess.propertyAccess_C3(diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDigitalArtefact(DigitalArtefact digitalArtefact, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(digitalArtefact, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateVirtualEntity(VirtualEntity virtualEntity, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(virtualEntity, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateProvideService(ProvideService provideService, DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (!validate_NoCircularContainment(provideService, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(provideService, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(provideService, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(provideService, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(provideService, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(provideService, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(provideService, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(provideService, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(provideService, diagnostics, context);
		if (result || diagnostics != null) result &= validateProvideService_ProvideService_C2(provideService, diagnostics, context);
		if (result || diagnostics != null) result &= validateProvideService_ProvideService_C1(provideService, diagnostics, context);
		return result;
	}

	/**
	 * Validates the ProvideService_C2 constraint of '<em>Provide Service</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateProvideService_ProvideService_C2(ProvideService provideService, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return provideService.ProvideService_C2(diagnostics, context);
	}

	/**
	 * Validates the ProvideService_C1 constraint of '<em>Provide Service</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateProvideService_ProvideService_C1(ProvideService provideService, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return provideService.ProvideService_C1(diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateProvideResource(ProvideResource provideResource, DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (!validate_NoCircularContainment(provideResource, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(provideResource, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(provideResource, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(provideResource, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(provideResource, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(provideResource, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(provideResource, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(provideResource, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(provideResource, diagnostics, context);
		if (result || diagnostics != null) result &= validateProvideResource_ProvideResource_C1(provideResource, diagnostics, context);
		if (result || diagnostics != null) result &= validateProvideResource_ProvideResource_C2(provideResource, diagnostics, context);
		return result;
	}

	/**
	 * Validates the ProvideResource_C1 constraint of '<em>Provide Resource</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateProvideResource_ProvideResource_C1(ProvideResource provideResource, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return provideResource.ProvideResource_C1(diagnostics, context);
	}

	/**
	 * Validates the ProvideResource_C2 constraint of '<em>Provide Resource</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateProvideResource_ProvideResource_C2(ProvideResource provideResource, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return provideResource.ProvideResource_C2(diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateServiceDescription(ServiceDescription serviceDescription, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(serviceDescription, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateService(Service service, DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (!validate_NoCircularContainment(service, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(service, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(service, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(service, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(service, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(service, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(service, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(service, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(service, diagnostics, context);
		if (result || diagnostics != null) result &= validateService_Service_C1(service, diagnostics, context);
		return result;
	}

	/**
	 * Validates the Service_C1 constraint of '<em>Service</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateService_Service_C1(Service service, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return service.Service_C1(diagnostics, context);
	}

	/**
	 * Returns the resource locator that will be used to fetch messages for this validator's diagnostics.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		// TODO
		// Specialize this to return a resource locator for messages specific to this validator.
		// Ensure that you remove @generated or mark it @generated NOT
		return super.getResourceLocator();
	}

} //ArtefactValidator
