/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.hardware.sensor.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.papyrus.MARTE.MARTEPackage;

import org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwLogical.HwDevice.HwDevicePackage;

import org.eclipse.papyrus.MARTE_Library.BasicNFP_Types.BasicNFP_TypesPackage;

import org.eclipse.papyrus.MARTE_Library.GRM_BasicTypes.GRM_BasicTypesPackage;

import org.eclipse.papyrus.MARTE_Library.MARTE_DataTypes.MARTE_DataTypesPackage;

import org.eclipse.papyrus.MARTE_Library.MARTE_PrimitivesTypes.MARTE_PrimitivesTypesPackage;

import org.eclipse.papyrus.MARTE_Library.MeasurementUnits.MeasurementUnitsPackage;

import org.eclipse.papyrus.MARTE_Library.RS_Library.RS_LibraryPackage;

import org.eclipse.papyrus.MARTE_Library.TimeLibrary.TimeLibraryPackage;

import org.eclipse.papyrus.MARTE_Library.TimeTypesLibrary.TimeTypesLibraryPackage;

import org.eclipse.papyrus.iotml.IoTMLPackage;

import org.eclipse.papyrus.iotml.animate.AnimatePackage;

import org.eclipse.papyrus.iotml.animate.impl.AnimatePackageImpl;

import org.eclipse.papyrus.iotml.hardware.HardwarePackage;

import org.eclipse.papyrus.iotml.hardware.actuator.ActuatorPackage;

import org.eclipse.papyrus.iotml.hardware.actuator.impl.ActuatorPackageImpl;

import org.eclipse.papyrus.iotml.hardware.core.CorePackage;

import org.eclipse.papyrus.iotml.hardware.core.impl.CorePackageImpl;

import org.eclipse.papyrus.iotml.hardware.impl.HardwarePackageImpl;

import org.eclipse.papyrus.iotml.hardware.network.NetworkPackage;

import org.eclipse.papyrus.iotml.hardware.network.impl.NetworkPackageImpl;

import org.eclipse.papyrus.iotml.hardware.sensor.HwCommonSensor;
import org.eclipse.papyrus.iotml.hardware.sensor.HwRFIDReaderSensor;
import org.eclipse.papyrus.iotml.hardware.sensor.HwTag;
import org.eclipse.papyrus.iotml.hardware.sensor.SensorFactory;
import org.eclipse.papyrus.iotml.hardware.sensor.SensorPackage;

import org.eclipse.papyrus.iotml.hybrid.HybridPackage;

import org.eclipse.papyrus.iotml.hybrid.impl.HybridPackageImpl;

import org.eclipse.papyrus.iotml.impl.IoTMLPackageImpl;

import org.eclipse.papyrus.iotml.software.SoftwarePackage;
import org.eclipse.papyrus.iotml.software.artefact.ArtefactPackage;

import org.eclipse.papyrus.iotml.software.artefact.impl.ArtefactPackageImpl;

import org.eclipse.papyrus.iotml.software.core.structure.StructurePackage;

import org.eclipse.papyrus.iotml.software.core.structure.impl.StructurePackageImpl;

import org.eclipse.papyrus.iotml.software.impl.SoftwarePackageImpl;
import org.eclipse.papyrus.iotml.software.resource.ResourcePackage;

import org.eclipse.papyrus.iotml.software.resource.impl.ResourcePackageImpl;

import org.eclipse.papyrus.sysml14.blocks.BlocksPackage;

import org.eclipse.papyrus.sysml14.sysmlPackage;

import org.eclipse.uml2.types.TypesPackage;

import org.eclipse.uml2.uml.UMLPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class SensorPackageImpl extends EPackageImpl implements SensorPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass hwCommonSensorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass hwRFIDReaderSensorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass hwTagEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.papyrus.iotml.hardware.sensor.SensorPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private SensorPackageImpl() {
		super(eNS_URI, SensorFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 * 
	 * <p>This method is used to initialize {@link SensorPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static SensorPackage init() {
		if (isInited) return (SensorPackage)EPackage.Registry.INSTANCE.getEPackage(SensorPackage.eNS_URI);

		// Obtain or create and register package
		SensorPackageImpl theSensorPackage = (SensorPackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof SensorPackageImpl ? EPackage.Registry.INSTANCE.get(eNS_URI) : new SensorPackageImpl());

		isInited = true;

		// Initialize simple dependencies
		EcorePackage.eINSTANCE.eClass();
		MARTEPackage.eINSTANCE.eClass();
		MARTE_PrimitivesTypesPackage.eINSTANCE.eClass();
		MeasurementUnitsPackage.eINSTANCE.eClass();
		GRM_BasicTypesPackage.eINSTANCE.eClass();
		BasicNFP_TypesPackage.eINSTANCE.eClass();
		MARTE_DataTypesPackage.eINSTANCE.eClass();
		TimeTypesLibraryPackage.eINSTANCE.eClass();
		TimeLibraryPackage.eINSTANCE.eClass();
		RS_LibraryPackage.eINSTANCE.eClass();
		sysmlPackage.eINSTANCE.eClass();
		TypesPackage.eINSTANCE.eClass();
		UMLPackage.eINSTANCE.eClass();

		// Obtain or create and register interdependencies
		IoTMLPackageImpl theIoTMLPackage = (IoTMLPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(IoTMLPackage.eNS_URI) instanceof IoTMLPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(IoTMLPackage.eNS_URI) : IoTMLPackage.eINSTANCE);
		AnimatePackageImpl theAnimatePackage = (AnimatePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(AnimatePackage.eNS_URI) instanceof AnimatePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(AnimatePackage.eNS_URI) : AnimatePackage.eINSTANCE);
		HardwarePackageImpl theHardwarePackage = (HardwarePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(HardwarePackage.eNS_URI) instanceof HardwarePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(HardwarePackage.eNS_URI) : HardwarePackage.eINSTANCE);
		ActuatorPackageImpl theActuatorPackage = (ActuatorPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ActuatorPackage.eNS_URI) instanceof ActuatorPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ActuatorPackage.eNS_URI) : ActuatorPackage.eINSTANCE);
		NetworkPackageImpl theNetworkPackage = (NetworkPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(NetworkPackage.eNS_URI) instanceof NetworkPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(NetworkPackage.eNS_URI) : NetworkPackage.eINSTANCE);
		CorePackageImpl theCorePackage = (CorePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(CorePackage.eNS_URI) instanceof CorePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(CorePackage.eNS_URI) : CorePackage.eINSTANCE);
		HybridPackageImpl theHybridPackage = (HybridPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(HybridPackage.eNS_URI) instanceof HybridPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(HybridPackage.eNS_URI) : HybridPackage.eINSTANCE);
		SoftwarePackageImpl theSoftwarePackage = (SoftwarePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(SoftwarePackage.eNS_URI) instanceof SoftwarePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(SoftwarePackage.eNS_URI) : SoftwarePackage.eINSTANCE);
		ArtefactPackageImpl theArtefactPackage = (ArtefactPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ArtefactPackage.eNS_URI) instanceof ArtefactPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ArtefactPackage.eNS_URI) : ArtefactPackage.eINSTANCE);
		org.eclipse.papyrus.iotml.software.core.impl.CorePackageImpl theCorePackage_1 = (org.eclipse.papyrus.iotml.software.core.impl.CorePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(org.eclipse.papyrus.iotml.software.core.CorePackage.eNS_URI) instanceof org.eclipse.papyrus.iotml.software.core.impl.CorePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(org.eclipse.papyrus.iotml.software.core.CorePackage.eNS_URI) : org.eclipse.papyrus.iotml.software.core.CorePackage.eINSTANCE);
		StructurePackageImpl theStructurePackage = (StructurePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(StructurePackage.eNS_URI) instanceof StructurePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(StructurePackage.eNS_URI) : StructurePackage.eINSTANCE);
		ResourcePackageImpl theResourcePackage = (ResourcePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ResourcePackage.eNS_URI) instanceof ResourcePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ResourcePackage.eNS_URI) : ResourcePackage.eINSTANCE);

		// Create package meta-data objects
		theSensorPackage.createPackageContents();
		theIoTMLPackage.createPackageContents();
		theAnimatePackage.createPackageContents();
		theHardwarePackage.createPackageContents();
		theActuatorPackage.createPackageContents();
		theNetworkPackage.createPackageContents();
		theCorePackage.createPackageContents();
		theHybridPackage.createPackageContents();
		theSoftwarePackage.createPackageContents();
		theArtefactPackage.createPackageContents();
		theCorePackage_1.createPackageContents();
		theStructurePackage.createPackageContents();
		theResourcePackage.createPackageContents();

		// Initialize created meta-data
		theSensorPackage.initializePackageContents();
		theIoTMLPackage.initializePackageContents();
		theAnimatePackage.initializePackageContents();
		theHardwarePackage.initializePackageContents();
		theActuatorPackage.initializePackageContents();
		theNetworkPackage.initializePackageContents();
		theCorePackage.initializePackageContents();
		theHybridPackage.initializePackageContents();
		theSoftwarePackage.initializePackageContents();
		theArtefactPackage.initializePackageContents();
		theCorePackage_1.initializePackageContents();
		theStructurePackage.initializePackageContents();
		theResourcePackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theSensorPackage.freeze();

  
		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(SensorPackage.eNS_URI, theSensorPackage);
		return theSensorPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getHwCommonSensor() {
		return hwCommonSensorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getHwCommonSensor_InputValueType() {
		return (EReference)hwCommonSensorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getHwCommonSensor_OutputValueType() {
		return (EReference)hwCommonSensorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getHwCommonSensor_Hwcommonsensor() {
		return (EReference)hwCommonSensorEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getHwCommonSensor_TransferFunction() {
		return (EReference)hwCommonSensorEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getHwRFIDReaderSensor() {
		return hwRFIDReaderSensorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getHwRFIDReaderSensor_Tag() {
		return (EReference)hwRFIDReaderSensorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getHwTag() {
		return hwTagEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getHwTag_TageFrequency() {
		return (EAttribute)hwTagEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SensorFactory getSensorFactory() {
		return (SensorFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		hwCommonSensorEClass = createEClass(HW_COMMON_SENSOR);
		createEReference(hwCommonSensorEClass, HW_COMMON_SENSOR__INPUT_VALUE_TYPE);
		createEReference(hwCommonSensorEClass, HW_COMMON_SENSOR__OUTPUT_VALUE_TYPE);
		createEReference(hwCommonSensorEClass, HW_COMMON_SENSOR__HWCOMMONSENSOR);
		createEReference(hwCommonSensorEClass, HW_COMMON_SENSOR__TRANSFER_FUNCTION);

		hwRFIDReaderSensorEClass = createEClass(HW_RFID_READER_SENSOR);
		createEReference(hwRFIDReaderSensorEClass, HW_RFID_READER_SENSOR__TAG);

		hwTagEClass = createEClass(HW_TAG);
		createEAttribute(hwTagEClass, HW_TAG__TAGE_FREQUENCY);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		HwDevicePackage theHwDevicePackage = (HwDevicePackage)EPackage.Registry.INSTANCE.getEPackage(HwDevicePackage.eNS_URI);
		BlocksPackage theBlocksPackage = (BlocksPackage)EPackage.Registry.INSTANCE.getEPackage(BlocksPackage.eNS_URI);
		UMLPackage theUMLPackage = (UMLPackage)EPackage.Registry.INSTANCE.getEPackage(UMLPackage.eNS_URI);
		TypesPackage theTypesPackage = (TypesPackage)EPackage.Registry.INSTANCE.getEPackage(TypesPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		hwCommonSensorEClass.getESuperTypes().add(theHwDevicePackage.getHWSensor());
		hwRFIDReaderSensorEClass.getESuperTypes().add(this.getHwCommonSensor());
		hwTagEClass.getESuperTypes().add(theHwDevicePackage.getHwI_O());

		// Initialize classes and features; add operations and parameters
		initEClass(hwCommonSensorEClass, HwCommonSensor.class, "HwCommonSensor", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getHwCommonSensor_InputValueType(), theBlocksPackage.getValueType(), null, "inputValueType", null, 0, 1, HwCommonSensor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getHwCommonSensor_OutputValueType(), theBlocksPackage.getValueType(), null, "outputValueType", null, 0, 1, HwCommonSensor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getHwCommonSensor_Hwcommonsensor(), this.getHwCommonSensor(), null, "hwcommonsensor", null, 1, 1, HwCommonSensor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getHwCommonSensor_TransferFunction(), theUMLPackage.getBehavior(), null, "transferFunction", null, 0, 1, HwCommonSensor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(hwRFIDReaderSensorEClass, HwRFIDReaderSensor.class, "HwRFIDReaderSensor", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getHwRFIDReaderSensor_Tag(), this.getHwTag(), null, "tag", null, 0, -1, HwRFIDReaderSensor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(hwTagEClass, HwTag.class, "HwTag", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getHwTag_TageFrequency(), theTypesPackage.getReal(), "tageFrequency", null, 0, 1, HwTag.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		// Create annotations
		// http://www.eclipse.org/uml2/2.0.0/UML
		createUMLAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/uml2/2.0.0/UML</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createUMLAnnotations() {
		String source = "http://www.eclipse.org/uml2/2.0.0/UML";	
		addAnnotation
		  (this, 
		   source, 
		   new String[] {
			 "originalName", "Sensor"
		   });
	}

} //SensorPackageImpl
