/*****************************************************************************
 * Copyright (c) 2017 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Nicolas FAUVERGUE (CEA LIST) nicolas.fauvergue@cea.fr - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrus.interoperability.sysml14.sysml.utils;

/**
 * This allows to declare the needed constants for the SysML interoperability.
 */
public class SysMLMigrationConstantsUtils {

	/**
	 * The eAnnotation source string.
	 */
	public static final String VERSIONING_EANNOTATION_SOURCE = "Imported_From_SysML_1.1"; //$NON-NLS-1$

	/**
	 * The key of the eAnnotation for the source project.
	 */
	public static final String VERSIONING_EANNOTATION_DETAIL_KEY_PAPYRUS_SOURCE_PROJECT_NAME = "Papyrus_Source_Model_Name"; //$NON-NLS-1$

	/**
	 * The key of the eAnnotatio for the migration date.
	 */
	public static final String VERSIONING_EANNOTATION_DETAIL_KEY_PAPYRUS_MIGRATION_DATE = "Papyrus_SysML_Migration_Date"; //$NON-NLS-1$

	/**
	 * The key of the eAnnotatio for the bundle version.
	 */
	public static final String VERSIONING_EANNOTATION_DETAIL_KEY_PAPYRUS_MIGRATION_BUNDLE_VERSION = "Papyrus_SysML_Migration_Bundle_Version"; //$NON-NLS-1$

}
