/*****************************************************************************
 * Copyright (c) 2017 CEA LIST and Others.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Nicolas FAUVERGUE (CEA LIST) nicolas.fauvergue@cea.fr - Initial API and implementation
 *  
 *****************************************************************************/

package org.eclipse.papyrus.interoperability.sysml14.sysml.handlers;

import org.eclipse.papyrus.infra.core.resource.sasheditor.DiModel;
import org.eclipse.papyrus.interoperability.sysml14.sysml.transformations.SysMLImportTransformationLauncher;
import org.eclipse.papyrus.uml.m2m.qvto.common.MigrationParameters.ThreadConfig;
import org.eclipse.papyrus.uml.m2m.qvto.common.handler.AbstractMigrationHandler;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.IImportTransformationLauncher;
import org.eclipse.swt.widgets.Control;

import com.google.common.collect.Sets;

/**
 * The handler to run SysML1.1 import action when a file is selected.
 */
public class ImportSysMLHandler extends AbstractMigrationHandler {

	/**
	 * Constructor.
	 */
	public ImportSysMLHandler() {
		super(Sets.newHashSet(DiModel.DI_FILE_EXTENSION));
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see org.eclipse.papyrus.migration.common.handler.AbstractMigrationHandler#createImportTransformationLauncher(org.eclipse.papyrus.migration.common.MigrationParameters.Config, org.eclipse.swt.widgets.Control)
	 */
	@Override
	protected IImportTransformationLauncher createImportTransformationLauncher(final ThreadConfig config, final Control baseControl) {
		return new SysMLImportTransformationLauncher(config, baseControl);
	}

}
