/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.architecture.migration;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.architecture.representation.ModelRule;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.nattable.common.reconciler.TableReconciler;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.representation.PapyrusTable;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusView;

public class SysMLTableReconciler_1_3_0
extends TableReconciler {
    private static final String ALLOCATION_TABLE = "Allocation Table";
    private static final String ALLOCATION_TABLE_URI = "org.eclipse.papyrus.sysml.nattable.allocation.config/resources/allocationTable.configuration";
    private static final String REQUIREMENT_TABLE = "Requirement Table";
    private static final String REQUIREMENT_TABLE_URI = "org.eclipse.papyrus.sysml.nattable.requirement.config/configs/requirementTable.configuration";

    public ICommand getReconcileCommand(Table table) {
        PapyrusView oldTableKind;
        PapyrusTable newTableKind = null;
        if (table.getPrototype() instanceof PapyrusView && (oldTableKind = (PapyrusView)table.getPrototype()).eIsProxy()) {
            if (EcoreUtil.getURI((EObject)oldTableKind).toString().contains(ALLOCATION_TABLE_URI)) {
                newTableKind = this.getTableKind(ALLOCATION_TABLE, table);
            } else if (EcoreUtil.getURI((EObject)oldTableKind).toString().contains(REQUIREMENT_TABLE_URI)) {
                newTableKind = this.getTableKind(REQUIREMENT_TABLE, table);
            }
        }
        if (newTableKind != null) {
            return new ReplaceTablePrototypeCommand(table, (RepresentationKind)newTableKind);
        }
        return null;
    }

    protected PapyrusTable getTableKind(String name, Table table) {
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        MergedArchitectureDescriptionLanguage context = (MergedArchitectureDescriptionLanguage)manager.getArchitectureContextById("org.eclipse.papyrus.sysml.architecture.SysML");
        for (RepresentationKind pKind : context.getRepresentationKinds()) {
            PapyrusTable tKind;
            if (!pKind.getName().equals(name) || !((ModelRule)(tKind = (PapyrusTable)pKind).getModelRules().get(0)).getElement().isInstance((Object)table.getContext())) continue;
            return tKind;
        }
        return null;
    }

    protected class ReplaceTablePrototypeCommand
    extends AbstractCommand {
        private Table table;
        private RepresentationKind newKind;

        public ReplaceTablePrototypeCommand(Table table, RepresentationKind newKind) {
            super("Replace the papyrus view style from 1.0.0 to 1.1.0");
            this.table = table;
            this.newKind = newKind;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            this.table.setPrototype(null);
            this.table.setTableKindId(this.newKind.getId());
            return CommandResult.newOKCommandResult();
        }

        public boolean canUndo() {
            return false;
        }

        public boolean canRedo() {
            return false;
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canRedo false");
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canUndo false");
        }
    }
}

