/**
 *   Copyright (c) 2016 CEA LIST and others.
 *   
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     CEA LIST - Initial API and implementation
 * 
 */
package org.eclipse.papyrus.interoperability.rpy.rpymetamodel.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EStructuralFeature;

import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

import org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISysMLPort;
import org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyFactory;
import org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage;

/**
 * This is the item provider adapter for a {@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISysMLPort} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ISysMLPortItemProvider extends IInstanceItemProvider {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ISysMLPortItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addMultiplicityPropertyDescriptor(object);
			addOtherClassPropertyDescriptor(object);
			addDirectionPropertyDescriptor(object);
			addLastIDPropertyDescriptor(object);
			addReversedPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Multiplicity feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addMultiplicityPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_End2_Type_multiplicity_feature"), //$NON-NLS-1$
				 getString("_UI_PropertyDescriptor_description", "_UI_End2_Type_multiplicity_feature", "_UI_End2_Type_type"), //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				 UMLRpyPackage.eINSTANCE.getEnd2_Type_Multiplicity(),
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Other Class feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addOtherClassPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_ISysMLPort_otherClass_feature"), //$NON-NLS-1$
				 getString("_UI_PropertyDescriptor_description", "_UI_ISysMLPort_otherClass_feature", "_UI_ISysMLPort_type"), //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				 UMLRpyPackage.eINSTANCE.getISysMLPort_OtherClass(),
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Direction feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addDirectionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_ISysMLPort_direction_feature"), //$NON-NLS-1$
				 getString("_UI_PropertyDescriptor_description", "_UI_ISysMLPort_direction_feature", "_UI_ISysMLPort_type"), //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				 UMLRpyPackage.eINSTANCE.getISysMLPort_Direction(),
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Last ID feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addLastIDPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_ISysMLPort_lastID_feature"), //$NON-NLS-1$
				 getString("_UI_PropertyDescriptor_description", "_UI_ISysMLPort_lastID_feature", "_UI_ISysMLPort_type"), //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				 UMLRpyPackage.eINSTANCE.getISysMLPort_LastID(),
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Reversed feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addReversedPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_ISysMLPort_reversed_feature"), //$NON-NLS-1$
				 getString("_UI_PropertyDescriptor_description", "_UI_ISysMLPort_reversed_feature", "_UI_ISysMLPort_type"), //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				 UMLRpyPackage.eINSTANCE.getISysMLPort_Reversed(),
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(UMLRpyPackage.eINSTANCE.getToLinkType_ImplicitClass());
			childrenFeatures.add(UMLRpyPackage.eINSTANCE.getISysMLPort_Dependencies());
			childrenFeatures.add(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes());
			childrenFeatures.add(UMLRpyPackage.eINSTANCE.getISysMLPort_Tags());
			childrenFeatures.add(UMLRpyPackage.eINSTANCE.getISysMLPort_Description());
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns ISysMLPort.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator().getImage("full/obj16/ISysMLPort")); //$NON-NLS-1$
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		String label = ((ISysMLPort)object).getName();
		return label == null || label.length() == 0 ?
			getString("_UI_ISysMLPort_type") : //$NON-NLS-1$
			getString("_UI_ISysMLPort_type") + " " + label; //$NON-NLS-1$ //$NON-NLS-2$
	}
	

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(ISysMLPort.class)) {
			case UMLRpyPackage.ISYS_ML_PORT__MULTIPLICITY:
			case UMLRpyPackage.ISYS_ML_PORT__DIRECTION:
			case UMLRpyPackage.ISYS_ML_PORT__LAST_ID:
			case UMLRpyPackage.ISYS_ML_PORT__REVERSED:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
				return;
			case UMLRpyPackage.ISYS_ML_PORT__IMPLICIT_CLASS:
			case UMLRpyPackage.ISYS_ML_PORT__DEPENDENCIES:
			case UMLRpyPackage.ISYS_ML_PORT__STEREOTYPES:
			case UMLRpyPackage.ISYS_ML_PORT__TAGS:
			case UMLRpyPackage.ISYS_ML_PORT__DESCRIPTION:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getToLinkType_ImplicitClass(),
				 UMLRpyFactory.eINSTANCE.createIClass()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getToLinkType_ImplicitClass(),
				 UMLRpyFactory.eINSTANCE.createIAssociationClass()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getToLinkType_ImplicitClass(),
				 UMLRpyFactory.eINSTANCE.createIStateChart()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Dependencies(),
				 UMLRpyFactory.eINSTANCE.createIDependency()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Dependencies(),
				 UMLRpyFactory.eINSTANCE.createIHyperLink()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIUnit()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIClassifier()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIActor()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIAnnotation()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIVariable()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIArgument()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIClass()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIAssociationClass()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIAttribute()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIDiagram()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createICollaborationDiagram()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIComment()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIComponent()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIComponentDiagram()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIConstraint()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIControlledFile()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIDeploymentDiagram()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIInterfaceItem()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIEvent()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIEventReception()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIFile()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIFlowItem()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIRelation()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIInstance()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createILink()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIMatrixLayout()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIMatrixView()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIModule()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createINode()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIObjectModelDiagram()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIOperation()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIPackage()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIPanelDiagram()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIPort()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIProfile()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIProject()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIRequirement()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createISequenceDiagram()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIStateChart()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIStateChartDiagram()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIStereotype()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIStructureDiagram()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createISysMLPort()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createITableLayout()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createITableView()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createITag()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createITemplateParameter()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIType()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIUseCase()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes(),
				 UMLRpyFactory.eINSTANCE.createIUseCaseDiagram()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Tags(),
				 UMLRpyFactory.eINSTANCE.createITag()));

		newChildDescriptors.add
			(createChildParameter
				(UMLRpyPackage.eINSTANCE.getISysMLPort_Description(),
				 UMLRpyFactory.eINSTANCE.createIDescription()));
	}

	/**
	 * This returns the label text for {@link org.eclipse.emf.edit.command.CreateChildCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
		Object childFeature = feature;
		Object childObject = child;

		boolean qualify =
			childFeature == UMLRpyPackage.eINSTANCE.getToLinkType_ImplicitClass() ||
			childFeature == UMLRpyPackage.eINSTANCE.getISysMLPort_Stereotypes() ||
			childFeature == UMLRpyPackage.eINSTANCE.getISysMLPort_Tags();

		if (qualify) {
			return getString
				("_UI_CreateChild_text2", //$NON-NLS-1$
				 new Object[] { getTypeText(childObject), getFeatureText(childFeature), getTypeText(owner) });
		}
		return super.getCreateChildText(owner, feature, child, selection);
	}

}
