/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rpy.geometry.utils;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Position;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Rectangle;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyPort;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix;
import org.eclipse.papyrus.interoperability.rpy.geometry.utils.GeometryUtils;
import org.eclipse.papyrus.interoperability.rpy.geometry.utils.PointsOperations;
import org.eclipse.papyrus.interoperability.rpy.geometry.utils.RectangleOperations;
import org.eclipse.papyrus.interoperability.rpy.geometry.utils.RpyShapeOperations;
import org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage;

public class RpyPortOperations
extends RpyShapeOperations {
    public static String M_POSITION_FEATURE_NAME = UMLRpyPackage.eINSTANCE.getCGIPortConnector_M_position().getName();

    public static void initializeShape(RpyPort rpyPort, EObject rpyMMObj) {
        RpyPortOperations.initializeTransform(rpyPort, rpyMMObj);
        RpyPortOperations.initializeRectangle(rpyPort, rpyMMObj);
        RpyPortOperations.initializeParent(rpyPort, rpyMMObj);
        RpyPortOperations.initializeParentEdge(rpyPort);
        RpyPortOperations.initializePositionAndSize(rpyPort);
        RpyPortOperations.fixPortOffsets(rpyPort);
    }

    public static void initializeRectangle(RpyShape rpyShape, EObject rpyMMObj) {
        Object polygonObj = GeometryUtils.getFeatureValue(rpyMMObj, M_POSITION_FEATURE_NAME);
        if (polygonObj instanceof List) {
            Rectangle rectangle = RectangleOperations.getRectangle((List)polygonObj);
            rpyShape.setRectangle(rectangle);
        }
    }

    private static void fixPortOffsets(RpyPort rpyPort) {
        double xOffset = 0.0;
        double yOffset = 0.0;
        switch (rpyPort.getPosition()) {
            case EAST: {
                yOffset = 20.0;
                break;
            }
            case NORTH: {
                xOffset = 20.0;
                break;
            }
            case SOUTH: {
                xOffset = -40.0;
                break;
            }
            case WEST: {
                yOffset = -40.0;
                break;
            }
        }
        Point offset = PointsOperations.getPoint(xOffset, yOffset);
        Point absolutePosition = rpyPort.getAbsolutePosition();
        Point relativePosition = rpyPort.getParentRelativePosition();
        rpyPort.setAbsolutePosition(absolutePosition.add(offset));
        rpyPort.setParentRelativePosition(relativePosition.add(offset));
    }

    private static void initializeParentEdge(RpyPort rpyPort) {
        TransformMatrix transform = rpyPort.getTransform();
        if (transform != null) {
            boolean topOrBottom;
            boolean bl = topOrBottom = transform.getB() == 0.0 || Math.abs(transform.getA() / transform.getB()) > 100.0;
            if (topOrBottom) {
                if (transform.getA() > 0.0) {
                    rpyPort.setPosition(Position.NORTH);
                } else {
                    rpyPort.setPosition(Position.SOUTH);
                }
            } else if (transform.getB() > 0.0) {
                rpyPort.setPosition(Position.EAST);
            } else {
                rpyPort.setPosition(Position.WEST);
            }
        } else {
            rpyPort.setPosition(Position.NORTH);
        }
    }
}

