/*****************************************************************************
 * Copyright (c) 2017 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   CEA LIST - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrus.interoperability.rpy.blackboxes;

/**
 * This blackboxes provides constants used by the RPy files
 *
 */
public class ConstantsBlackboxes {

	/** The EAnnotation source key to get the rpy filename owning the object */
	public static final String EANNOTATION_SOURCE__RPY_FILENAME = "Rpy Filename"; //$NON-NLS-1$

	/** The EAnnotation detail key key to get the rpy filename owning the object */
	public static final String EANNOTATION_DETAIL__RPY_FILENAME_KEY = "fileName"; //$NON-NLS-1$

	/**
	 * @see EANNOTATION_SOURCE__RPY_FILENAME
	 * @return the EAnnotation source key to get the rpy filename owning the object
	 */
	public String getEAnnotationFileNameSourceKey() {
		return EANNOTATION_SOURCE__RPY_FILENAME;
	}

	/**
	 * @see EANNOTATION_DETAIL__RPY_FILENAME_KEY
	 * @return the EAnnotation detail key key to get the rpy filename owning the object
	 */
	public String getEAnnotationFileNameDetailKey() {
		return EANNOTATION_DETAIL__RPY_FILENAME_KEY;
	}

}
