/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.util;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException;

public class ECoreUtils {
    public static boolean isAncestorInstanceOf(EObject child, EClass type) {
        try {
            ECoreUtils.lookupAncestorOfType(child, type);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    public static EObject lookupAncestorOfType(EObject child, EClass type) throws NotFoundException {
        if (child != null) {
            if (type.isInstance((Object)child)) {
                return child;
            }
            int count = 0;
            EObject parent = child.eContainer();
            while (parent != null) {
                if (++count > 100000) {
                    return ECoreUtils.lookupAncestorOfType(child, type);
                }
                if (type.isInstance((Object)parent)) {
                    return parent;
                }
                if (parent == child) {
                    throw new IllegalStateException("There is a cycle in the containment hierarchy of " + child);
                }
                parent = parent.eContainer();
            }
        }
        throw new NotFoundException("No ancestor of the specified type");
    }
}

