/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.LayersException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerExpression;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerOperator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerOperatorDescriptor;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersContainer;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersPackage;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStack;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.LayerExpressionImpl;

public abstract class LayerOperatorImpl
extends LayerExpressionImpl
implements LayerOperator {
    protected EList<LayerExpression> layers;
    protected static final String LAYER_OPERATOR_DESCRIPTOR_NAME_EDEFAULT = null;
    protected String layerOperatorDescriptorName = LAYER_OPERATOR_DESCRIPTOR_NAME_EDEFAULT;
    protected LayerOperatorDescriptor layerOperatorDescriptor;

    protected LayerOperatorImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return LayersPackage.Literals.LAYER_OPERATOR;
    }

    @Override
    public List<LayerExpression> getLayers() {
        if (this.layers == null) {
            this.layers = new EObjectContainmentEList(LayerExpression.class, (InternalEObject)this, 8);
        }
        return this.layers;
    }

    @Override
    public String getLayerOperatorDescriptorName() {
        return this.layerOperatorDescriptorName;
    }

    @Override
    public void setLayerOperatorDescriptorName(String newLayerOperatorDescriptorName) {
        String oldLayerOperatorDescriptorName = this.layerOperatorDescriptorName;
        this.layerOperatorDescriptorName = newLayerOperatorDescriptorName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldLayerOperatorDescriptorName, (Object)this.layerOperatorDescriptorName));
        }
    }

    @Override
    public LayerOperatorDescriptor getLayerOperatorDescriptor() {
        if (this.layerOperatorDescriptor != null && this.layerOperatorDescriptor.eIsProxy()) {
            InternalEObject oldLayerOperatorDescriptor = (InternalEObject)this.layerOperatorDescriptor;
            this.layerOperatorDescriptor = (LayerOperatorDescriptor)this.eResolveProxy(oldLayerOperatorDescriptor);
            if (this.layerOperatorDescriptor != oldLayerOperatorDescriptor && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 10, (Object)oldLayerOperatorDescriptor, (Object)this.layerOperatorDescriptor));
            }
        }
        return this.layerOperatorDescriptor;
    }

    public LayerOperatorDescriptor basicGetLayerOperatorDescriptor() {
        return this.layerOperatorDescriptor;
    }

    @Override
    public void setLayerOperatorDescriptor(LayerOperatorDescriptor newLayerOperatorDescriptor) {
        LayerOperatorDescriptor oldLayerOperatorDescriptor = this.layerOperatorDescriptor;
        this.layerOperatorDescriptor = newLayerOperatorDescriptor;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldLayerOperatorDescriptor, (Object)this.layerOperatorDescriptor));
        }
    }

    @Override
    public void addLayer(LayerExpression layer) {
        this.getLayers().add(0, layer);
    }

    @Override
    public boolean isDescriptorSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resetDescriptor() {
        throw new UnsupportedOperationException();
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return ((InternalEList)this.getLayers()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getLayers();
            }
            case 9: {
                return this.getLayerOperatorDescriptorName();
            }
            case 10: {
                if (resolve) {
                    return this.getLayerOperatorDescriptor();
                }
                return this.basicGetLayerOperatorDescriptor();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.getLayers().clear();
                this.getLayers().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.setLayerOperatorDescriptorName((String)newValue);
                return;
            }
            case 10: {
                this.setLayerOperatorDescriptor((LayerOperatorDescriptor)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.getLayers().clear();
                return;
            }
            case 9: {
                this.setLayerOperatorDescriptorName(LAYER_OPERATOR_DESCRIPTOR_NAME_EDEFAULT);
                return;
            }
            case 10: {
                this.setLayerOperatorDescriptor(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.layers != null && !this.layers.isEmpty();
            }
            case 9: {
                return LAYER_OPERATOR_DESCRIPTOR_NAME_EDEFAULT == null ? this.layerOperatorDescriptorName != null : !LAYER_OPERATOR_DESCRIPTOR_NAME_EDEFAULT.equals(this.layerOperatorDescriptorName);
            }
            case 10: {
                return this.layerOperatorDescriptor != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eDerivedOperationID(int baseOperationID, Class<?> baseClass) {
        if (baseClass == LayersContainer.class) {
            switch (baseOperationID) {
                case 0: {
                    return 9;
                }
            }
            return -1;
        }
        return super.eDerivedOperationID(baseOperationID, baseClass);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 9: {
                this.addLayer((LayerExpression)arguments.get(0));
                return null;
            }
            case 10: {
                return this.isDescriptorSet();
            }
            case 11: {
                this.resetDescriptor();
                return null;
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (layerOperatorDescriptorName: ");
        result.append(this.layerOperatorDescriptorName);
        result.append(')');
        return result.toString();
    }

    @Override
    public void setIsBranchEnabled(boolean newIsBranchEnabled) {
        super.setIsBranchEnabled(newIsBranchEnabled);
        boolean value = this.isBranchEnabled();
        for (LayerExpression layer : this.getLayers()) {
            layer.setIsBranchEnabled(value);
        }
    }

    @Override
    public void setOwningLayersStack(LayersStack newOwningLayersStack) {
        super.setOwningLayersStack(newOwningLayersStack);
        LayersStack value = this.getOwningLayersStack();
        for (LayerExpression layer : this.getLayers()) {
            layer.setOwningLayersStack(value);
        }
    }

    @Override
    public void attach() throws LayersException {
        super.attach();
        for (LayerExpression l : this.getLayers()) {
            l.attach();
        }
    }

    @Override
    public void detach() throws LayersException {
        super.detach();
        for (LayerExpression l : this.getLayers()) {
            l.detach();
        }
    }

    @Override
    @Deprecated
    public void attachToLayersStack(LayersStack owningLayersStack) {
        this.setOwningLayersStack(owningLayersStack);
        for (LayerExpression l : this.getLayers()) {
            l.attachToLayersStack(owningLayersStack);
        }
        this.startBehaviors();
    }
}

