/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.ui.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.LayersException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.AbstractLayer;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStackApplication;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Property;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.ui.Activator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.ui.commands.AbstractLayersCommand;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class AttachPropertyFromListToLayer
extends AbstractLayersCommand {
    @Override
    public String getCommandName() {
        return "Attach a property";
    }

    @Override
    protected void doExecute(ExecutionEvent event, IEvaluationContext context, List<Object> selections) {
        if (!this.isEnabled(context, selections)) {
            return;
        }
        try {
            LayersStackApplication application = this.lookupLayersStackApplicationChecked(context);
            AbstractLayer layer = (AbstractLayer)this.getSelections(context).get(0);
            Property[] properties = application.getPropertyRegistry().getProperties().toArray(new Property[0]);
            MyContentProvider contentProvider = new MyContentProvider();
            MyLabelProvider labelProvider = new MyLabelProvider();
            ListSelectionDialog dialog = new ListSelectionDialog(Display.getCurrent().getActiveShell(), (Object)properties, (IStructuredContentProvider)contentProvider, (ILabelProvider)labelProvider, "Select properties to attach");
            List initialSelection = layer.getAttachedProperties();
            dialog.setInitialSelections((Object[])initialSelection.toArray(new Property[initialSelection.size()]));
            if (dialog.open() != 0) {
                return;
            }
            Object[] res = dialog.getResult();
            ArrayList<Property> finalSelection = new ArrayList<Property>(res.length);
            ArrayList<Property> unchangedProperties = new ArrayList<Property>(initialSelection.size());
            ArrayList<Property> setProperties = new ArrayList<Property>(finalSelection.size());
            Object[] objectArray = res;
            int n = res.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                finalSelection.add((Property)o);
                if (initialSelection.contains(o)) {
                    unchangedProperties.add((Property)o);
                } else {
                    setProperties.add((Property)o);
                }
                ++n2;
            }
            ArrayList unsetProperties = new ArrayList(initialSelection);
            unsetProperties.removeAll(unchangedProperties);
            for (Property property : unsetProperties) {
                if (Activator.log.isDebugEnabled()) {
                    Activator.log.debug("unset Property " + property.getName());
                }
                layer.removePropertyInstance(property);
            }
            for (Property property : setProperties) {
                if (Activator.log.isDebugEnabled()) {
                    Activator.log.debug("set Property " + property.getName());
                }
                layer.addPropertyInstance(property);
            }
        }
        catch (LayersException e) {
            e.printStackTrace();
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isEnabled(IEvaluationContext context, List<Object> selections) {
        return this.selectionFirstElementInstanceOf(selections, AbstractLayer.class);
    }

    private class MyContentProvider
    implements IStructuredContentProvider {
        private MyContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (Property[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class MyLabelProvider
    extends LabelProvider {
        private MyLabelProvider() {
        }

        public String getText(Object element) {
            return ((Property)element).getName();
        }
    }
}

