/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.uml.tools.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Type;

public class ParameterUtils {
    protected static final String WRONG_ARGUMENT = "Passed element is neither a behavioral feature nor a behavior";
    public static final String RET = "ret";

    public static List<Parameter> getOwnedParameters(NamedElement opOrBehavior) {
        if (opOrBehavior instanceof BehavioralFeature) {
            return ((BehavioralFeature)opOrBehavior).getOwnedParameters();
        }
        if (opOrBehavior instanceof Behavior) {
            return ((Behavior)opOrBehavior).getOwnedParameters();
        }
        throw new IllegalArgumentException(WRONG_ARGUMENT);
    }

    public static List<Parameter> getOwnedParametersCopy(NamedElement opOrBehavior) {
        ArrayList<Parameter> paramListCopy = new ArrayList<Parameter>();
        List<Parameter> ownedParameters = ParameterUtils.getOwnedParameters(opOrBehavior);
        if (ownedParameters != null) {
            paramListCopy.addAll(ownedParameters);
        }
        return paramListCopy;
    }

    public static Parameter createOwnedParameter(NamedElement opOrBehavior, String paramName, Type type) {
        if (opOrBehavior instanceof BehavioralFeature) {
            return ((BehavioralFeature)opOrBehavior).createOwnedParameter(paramName, type);
        }
        if (opOrBehavior instanceof Behavior) {
            return ((Behavior)opOrBehavior).createOwnedParameter(paramName, type);
        }
        return null;
    }

    public static Parameter createReturnResult(NamedElement opOrBehavior, Type type) {
        Parameter parameter = ParameterUtils.createOwnedParameter(opOrBehavior, RET, type);
        parameter.setDirection(ParameterDirectionKind.RETURN_LITERAL);
        return parameter;
    }

    public static void resetParameters(NamedElement opOrBehavior, List<Parameter> paramList) {
        ParameterUtils.getOwnedParameters(opOrBehavior).clear();
        ParameterUtils.getOwnedParameters(opOrBehavior).addAll(paramList);
    }

    public static Parameter getParameterViaName(List<Parameter> paramList, String parameterName) {
        for (Parameter existingParameter : paramList) {
            if (!(parameterName == null ? existingParameter.getDirection() == ParameterDirectionKind.RETURN_LITERAL : existingParameter.getName().equals(parameterName))) continue;
            return existingParameter;
        }
        return null;
    }
}

