/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.base.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.DeploymentPlan;
import org.eclipse.papyrus.designer.transformation.base.Messages;
import org.eclipse.papyrus.designer.transformation.base.utils.StdModelLibs;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.ExecuteTrafoChain;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafoChain;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLUtil;

public class TrafoUtils {
    public static final String TRAFOS_M2MTRANSFORMATIONS_SIMPLE = "trafos::m2mtransformations::Simple";
    public static final String TRAFOS_M2MTRANSFORMATIONS_STANDARD = "trafos::m2mtransformations::Standard";

    public static M2MTrafoChain getTransformationChain(Package cdp) {
        M2MTrafoChain chain = null;
        boolean isDeploymentPlan = false;
        if (cdp != null) {
            ExecuteTrafoChain execTrafoChain = (ExecuteTrafoChain)UMLUtil.getStereotypeApplication((Element)cdp, ExecuteTrafoChain.class);
            isDeploymentPlan = execTrafoChain instanceof DeploymentPlan;
            if (execTrafoChain != null) {
                chain = execTrafoChain.getChain();
            }
        }
        if (chain == null) {
            ElementUtils.loadPackage((URI)StdModelLibs.DESIGNER_TRAFOLIB_URI, (Element)cdp);
            NamedElement defaultChainNE = ElementUtils.getQualifiedElementFromRS((Element)cdp, (String)(isDeploymentPlan ? TRAFOS_M2MTRANSFORMATIONS_STANDARD : TRAFOS_M2MTRANSFORMATIONS_SIMPLE));
            if (defaultChainNE != null) {
                chain = (M2MTrafoChain)UMLUtil.getStereotypeApplication((Element)defaultChainNE, M2MTrafoChain.class);
            }
            if (chain == null) {
                throw new RuntimeException(Messages.TrafoUtils_CANT_FIND_DEFAULT_CHAIN);
            }
        }
        return chain;
    }

    public static List<M2MTrafo> getAdditionalTransformations(Package cdp) {
        ExecuteTrafoChain execTrafoChain;
        if (cdp != null && (execTrafoChain = (ExecuteTrafoChain)UMLUtil.getStereotypeApplication((Element)cdp, ExecuteTrafoChain.class)) != null) {
            ArrayList<M2MTrafo> additionalTransformations = new ArrayList<M2MTrafo>();
            additionalTransformations.addAll((Collection<M2MTrafo>)execTrafoChain.getAdditionalTrafos());
            for (M2MTrafoChain additionalChain : execTrafoChain.getAdditionalChains()) {
                for (Property attribute : additionalChain.getBase_Class().getAllAttributes()) {
                    M2MTrafo trafo = (M2MTrafo)UMLUtil.getStereotypeApplication((Element)attribute.getType(), M2MTrafo.class);
                    additionalTransformations.add(trafo);
                }
            }
            return additionalTransformations;
        }
        return Collections.emptyList();
    }
}

