/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse.utils;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.IStructureTemplate;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.papyrus.designer.languages.cpp.codegen.transformation.CppLocationStrategy;
import org.eclipse.papyrus.designer.languages.cpp.library.CppUriConstants;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.BatchReverseFunctionBody;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.ReverseUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class RoundtripCppUtils {
    public static final String EXTERNAL_PACKAGE_NAME = "external";

    public static Classifier getOrCreateClassifier(IStructure iStructure, ITranslationUnit iTu, String projectName, Model model) {
        Classifier classifier = null;
        String[] arrayNames = ((String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)iTu.getLocation().toString().split(projectName))))).substring(1).split("/");
        final ArrayList names = new ArrayList();
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String it) {
                names.add(it);
            }
        };
        ((List)Conversions.doWrapArray((Object)arrayNames)).forEach(_function);
        if (classifier == null) {
            boolean _tripleEquals;
            Model parentPack = ReverseUtils.getCorrespondingModel(iTu);
            Type _ownedType = parentPack.getOwnedType(iStructure.getElementName());
            boolean bl = _tripleEquals = _ownedType == null;
            if (_tripleEquals) {
                parentPack.createOwnedClass(iStructure.getElementName(), false);
            }
            Type _ownedType_1 = parentPack.getOwnedType(iStructure.getElementName());
            classifier = (Classifier)_ownedType_1;
        }
        return classifier;
    }

    public static String getFileName(NamedElement element) {
        CppLocationStrategy cppLocationStrategy = new CppLocationStrategy();
        return cppLocationStrategy.getFileName(element);
    }

    public static Type getPrimitiveType(String name, Model model) {
        boolean isPrimitive = RoundtripCppUtils.isPrimitiveCppType(name);
        if (isPrimitive) {
            Package ansiPack = PackageUtil.loadPackage((URI)CppUriConstants.ANSIC_LIB_URI, (ResourceSet)model.eResource().getResourceSet());
            return RoundtripCppUtils.getTypeFromModel(name, ansiPack);
        }
        return null;
    }

    public static boolean isPrimitiveCppType(final String name) {
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                return it.equals(name);
            }
        };
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)BatchReverseFunctionBody.ansiTypes)), (Functions.Function1)_function));
        return !_isEmpty;
    }

    public static Type getTypeFromModel(String name, Package pack) {
        if (pack == null) {
            return null;
        }
        PackageableElement ret = pack.getPackagedElement(name);
        if (ret == null || !(ret instanceof Type)) {
            return null;
        }
        return (Type)ret;
    }

    public static EList<EObject> applyProfile(Model model, String uri) {
        try {
            EList _xblockexpression = null;
            Resource resource = model.eResource().getResourceSet().getResource(URI.createURI((String)uri), false);
            if (resource == null) {
                resource = model.eResource().getResourceSet().createResource(URI.createURI((String)uri));
                resource.load(null);
            }
            Profile profile = (Profile)IterableExtensions.head((Iterable)Iterables.filter((Iterable)resource.getContents(), Profile.class));
            EList _xifexpression = null;
            if (profile != null && !model.isProfileApplied(profile)) {
                _xifexpression = model.applyProfile(profile);
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Operation findMatchOperation(Classifier classifier, IASTFunctionDeclarator declarator, String[] names, ITranslationUnit iTu) {
        Operation ret;
        block17: {
            String classifierName;
            block18: {
                boolean _greaterThan;
                block16: {
                    boolean _equals;
                    ret = null;
                    if (classifier == null) return ret;
                    if (declarator == null) return ret;
                    if (names == null) return ret;
                    if (iTu == null) return ret;
                    int _length = names.length;
                    if (_length == 1) {
                        return null;
                    }
                    boolean bl = _equals = false;
                    if (!_equals) break block16;
                    return null;
                }
                int _length_1 = names.length;
                boolean bl = _greaterThan = _length_1 > 1;
                if (!_greaterThan) break block17;
                int _length_2 = names.length;
                int _minus = _length_2 - 2;
                classifierName = names[_minus];
                boolean _equals_1 = classifier.getName().equals(classifierName);
                if (!_equals_1) return null;
                boolean bl2 = false;
                boolean _not = bl2;
                if (!_not) break block18;
                return null;
            }
            UniqueEList contextNamespaces = new UniqueEList();
            String qualifiedTypeName = "";
            int _length_3 = names.length;
            int _minus_1 = _length_3 - 1;
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _minus_1, true);
            for (Integer i : _doubleDotLessThan) {
                boolean _notEquals;
                String _qualifiedTypeName = qualifiedTypeName;
                String _get = names[i];
                qualifiedTypeName = String.valueOf(_qualifiedTypeName) + _get;
                int _length_4 = names.length;
                int _minus_2 = _length_4 - 2;
                boolean bl = _notEquals = i != _minus_2;
                if (!_notEquals) continue;
                String _qualifiedTypeName_1 = qualifiedTypeName;
                qualifiedTypeName = String.valueOf(_qualifiedTypeName_1) + "::";
            }
            contextNamespaces.add(qualifiedTypeName);
            Type ownerClass = ReverseUtils.getUMLType(classifierName, (ICElement)iTu);
            if (!(ownerClass instanceof Classifier)) break block17;
            if (!Objects.equal((Object)ownerClass, (Object)classifier)) return null;
            boolean bl = false;
            boolean _notEquals = bl;
            if (!_notEquals) break block17;
            return null;
        }
        try {
            boolean _equals_2;
            int nParmeters = IterableExtensions.size((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)declarator.getChildren())), IASTParameterDeclaration.class));
            Iterable parameterFunctionList = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)declarator.getChildren())), IASTParameterDeclaration.class);
            int _size = IterableExtensions.size((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)declarator.getChildren())), IASTParameterDeclaration.class));
            boolean bl = _equals_2 = _size == 1;
            if (_equals_2) {
                boolean _tripleNotEquals;
                IASTParameterDeclaration parameterNode = ((IASTParameterDeclaration[])Conversions.unwrapArray((Object)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)declarator.getChildren())), IASTParameterDeclaration.class), IASTParameterDeclaration.class))[0];
                IASTDeclSpecifier _declSpecifier = parameterNode.getDeclSpecifier();
                boolean bl3 = _tripleNotEquals = _declSpecifier != null;
                if (_tripleNotEquals) {
                    String type = "";
                    IToken tokens = parameterNode.getDeclSpecifier().getSyntax();
                    while (tokens != null) {
                        String _type = type;
                        String _string = tokens.toString();
                        type = String.valueOf(_type) + _string;
                        tokens = tokens.getNext();
                    }
                    boolean _equals_3 = type.trim().equals("void");
                    if (_equals_3) {
                        nParmeters = 0;
                    }
                }
            }
            final int numberParameter = nParmeters;
            int _length_4 = names.length;
            int _minus_2 = _length_4 - 1;
            final String functionName = names[_minus_2];
            Functions.Function1<Operation, Boolean> _function = new Functions.Function1<Operation, Boolean>(){

                public Boolean apply(Operation it) {
                    return it.getName().equals(functionName);
                }
            };
            Iterable sameNames = IterableExtensions.filter((Iterable)classifier.getAllOperations(), (Functions.Function1)_function);
            Functions.Function1<Operation, Boolean> _function_1 = new Functions.Function1<Operation, Boolean>(){

                public Boolean apply(Operation it) {
                    Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

                        public Boolean apply(Parameter it_1) {
                            ParameterDirectionKind _direction = it_1.getDirection();
                            return !Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
                        }
                    };
                    int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)it.getOwnedParameters(), (Functions.Function1)_function));
                    return _size == numberParameter;
                }
            };
            Iterable sameNumberOfParameters = IterableExtensions.filter((Iterable)sameNames, (Functions.Function1)_function_1);
            for (Operation op : sameNumberOfParameters) {
                if (ret != null) continue;
                boolean isMatch = true;
                Functions.Function1<Parameter, Boolean> _function_2 = new Functions.Function1<Parameter, Boolean>(){

                    public Boolean apply(Parameter it) {
                        ParameterDirectionKind _direction = it.getDirection();
                        return !Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
                    }
                };
                Iterable parameterList = IterableExtensions.filter((Iterable)op.getOwnedParameters(), (Functions.Function1)_function_2);
                int i_1 = 0;
                while (i_1 < numberParameter) {
                    IASTName paramName;
                    boolean _not_1;
                    Iterable _converted_parameterList = parameterList;
                    boolean _equals_4 = ((Parameter[])Conversions.unwrapArray((Object)_converted_parameterList, Parameter.class))[i_1].getType().getName().equals(RoundtripCppUtils.getCppTypeName(((IASTParameterDeclaration[])Conversions.unwrapArray((Object)parameterFunctionList, IASTParameterDeclaration.class))[i_1].getDeclSpecifier()));
                    boolean bl4 = _not_1 = !_equals_4;
                    if (_not_1) {
                        isMatch = false;
                    } else if ((((Parameter[])Conversions.unwrapArray((Object)parameterList, Parameter.class))[i_1].getName() == null || ((Parameter[])Conversions.unwrapArray((Object)parameterList, Parameter.class))[i_1].getName().equals("")) && (paramName = ((IASTParameterDeclaration[])Conversions.unwrapArray((Object)parameterFunctionList, IASTParameterDeclaration.class))[i_1].getDeclarator().getName()) != null) {
                        Iterable _converted_parameterList_1 = parameterList;
                        Parameter _get = ((Parameter[])Conversions.unwrapArray((Object)_converted_parameterList_1, Parameter.class))[i_1];
                        _get.setName(paramName.toString());
                    }
                    ++i_1;
                }
                if (!isMatch) continue;
                ret = op;
            }
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static String getCppTypeName(IASTDeclSpecifier declarator) {
        String parameterTypeName;
        block5: {
            parameterTypeName = "";
            try {
                IToken token = declarator.getSyntax();
                while (token != null) {
                    boolean _equals_3;
                    boolean _equals_2;
                    boolean _equals_1;
                    String tokenStr = token.toString();
                    boolean _equals = tokenStr.equals("*");
                    if (!(_equals || (_equals_1 = tokenStr.equals("&")) || (_equals_2 = tokenStr.equals("const")) || (_equals_3 = tokenStr.equals("volatile")))) {
                        boolean _greaterThan;
                        int _length = parameterTypeName.length();
                        boolean bl = _greaterThan = _length > 0;
                        if (_greaterThan) {
                            String _parameterTypeName = parameterTypeName;
                            parameterTypeName = String.valueOf(_parameterTypeName) + " ";
                        }
                        String _parameterTypeName_1 = parameterTypeName;
                        parameterTypeName = String.valueOf(_parameterTypeName_1) + tokenStr;
                    }
                    token = token.getNext();
                }
            }
            catch (Throwable _t) {
                if (_t instanceof ExpansionOverlapsBoundaryException) break block5;
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return parameterTypeName;
    }

    public static List<IStructureTemplate> getAllStructureTemplates(IParent parent) {
        try {
            UniqueEList ret = new UniqueEList();
            ICElement[] childrend = parent.getChildren();
            int i = 0;
            while (i < childrend.length) {
                ICElement child = childrend[i];
                boolean _matched = false;
                if (child instanceof IStructureTemplate) {
                    _matched = true;
                    ICElement _get = childrend[i];
                    IStructureTemplate istructureTemplate = (IStructureTemplate)_get;
                    ret.add(istructureTemplate);
                }
                if (!_matched && child instanceof IParent) {
                    _matched = true;
                    ret.addAll(RoundtripCppUtils.getAllStructureTemplates((IParent)child));
                }
                ++i;
            }
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static Package getOrcreateExternalPackage(Package parentPack, boolean create) {
        boolean _tripleEquals;
        Package _xblockexpression = null;
        Package _nestedPackage = parentPack.getNestedPackage(EXTERNAL_PACKAGE_NAME);
        boolean bl = _tripleEquals = _nestedPackage == null;
        if (_tripleEquals && create) {
            Package createdPack = parentPack.createNestedPackage(EXTERNAL_PACKAGE_NAME);
            StereotypeUtil.apply((Element)createdPack, NoCodeGen.class);
        }
        _xblockexpression = parentPack.getNestedPackage(EXTERNAL_PACKAGE_NAME);
        return _xblockexpression;
    }
}

