/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.common.testutils;

import java.io.InputStream;
import java.util.Scanner;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;

public class FileComparison {
    public static void assertGeneratedMatchesExpected(IFolder generatedFolder, IContainer expectedFolder, String fileName, String ... depthSegments) throws Exception {
        Assert.assertTrue((String)("Default generated folder \"" + generatedFolder + "\" was not generated"), (boolean)generatedFolder.exists());
        IFolder generatedPackageFolder = null;
        int i = 0;
        while (i < depthSegments.length) {
            generatedPackageFolder = i == 0 ? generatedFolder.getFolder(depthSegments[i]) : generatedPackageFolder.getFolder(depthSegments[i]);
            Assert.assertTrue((String)("Package folder \"" + depthSegments[i] + "\" was not generated."), (boolean)generatedPackageFolder.exists());
            ++i;
        }
        IFile generatedFile = null;
        generatedFile = generatedPackageFolder != null ? generatedPackageFolder.getFile(fileName) : generatedFolder.getFile(fileName);
        Assert.assertTrue((String)String.format("File %s was not generated in folder %s", fileName, generatedFolder.getName()), (boolean)generatedFile.exists());
        String fileContent = FileComparison.getFileContents(generatedFile);
        int i2 = 0;
        while (i2 < depthSegments.length) {
            expectedFolder = expectedFolder instanceof IProject ? ((IProject)expectedFolder).getFolder(depthSegments[i2]) : ((IFolder)expectedFolder).getFolder(depthSegments[i2]);
            Assert.assertTrue((String)("Expected folder \"" + depthSegments[i2] + "\" does not exist."), (boolean)expectedFolder.exists());
            ++i2;
        }
        IFile expectedFile = null;
        expectedFile = expectedFolder instanceof IProject ? ((IProject)expectedFolder).getFile(fileName) : ((IFolder)expectedFolder).getFile(fileName);
        Assert.assertTrue((String)("Expected file " + fileName + " does not exist."), (boolean)expectedFile.exists());
        String expectedFileContent = FileComparison.getFileContents(expectedFile);
        FileComparison.assertContentMatches(fileName, fileContent, expectedFileContent);
    }

    public static void assertGeneratedMatchesExpected(IContainer generatedFolder, IContainer expectedFolder) {
        try {
            IResource[] iResourceArray = expectedFolder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource memberExp = iResourceArray[n2];
                IResource memberGen = generatedFolder.findMember(memberExp.getName());
                MatcherAssert.assertThat((String)String.format("expected file or folder \"%s\" does not exist in generated code", memberExp.getName()), (memberGen != null ? 1 : 0) != 0);
                if (memberGen instanceof IFile) {
                    MatcherAssert.assertThat((String)"expected resource exists, but is not a file in generated code", (boolean)(memberGen instanceof IFile));
                    String generatedFileContent = FileComparison.getFileContents((IFile)memberGen);
                    String expectedFileContent = FileComparison.getFileContents((IFile)memberExp);
                    FileComparison.assertContentMatches(memberGen.getName(), generatedFileContent, expectedFileContent);
                } else if (memberGen instanceof IFolder) {
                    MatcherAssert.assertThat((String)"expected resource exists, but is not a folder in generated code", (boolean)(memberGen instanceof IFolder));
                    FileComparison.assertGeneratedMatchesExpected((IContainer)((IFolder)memberGen), (IContainer)((IFolder)memberExp));
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static IProject getGeneratedProject(String genProjectName) {
        IProject genProject = ResourcesPlugin.getWorkspace().getRoot().getProject(genProjectName);
        if (genProject == null || !genProject.exists()) {
            throw new AssertionError((Object)"Generated project not found");
        }
        return genProject;
    }

    public static String getFileContents(IFile file) throws CoreException {
        InputStream inStream = file.getContents();
        Assert.assertNotNull((String)("Contents of file \"" + file.getName() + "\" are empty."), (Object)inStream);
        String content = null;
        Scanner s = new Scanner(inStream);
        s.useDelimiter("\\Z");
        content = s.hasNext() ? s.next() : "";
        s.close();
        return content;
    }

    public static void assertContentMatches(String filename, String generated, String expected) {
        Scanner expectedScanner = new Scanner(expected.trim());
        char[] strippedGen = generated.replaceAll("\\s+", "").trim().toCharArray();
        int genCharsTraversed = 0;
        boolean outofchars = false;
        try {
            int lineNumber = 1;
            int lineCharBegin = 0;
            while (!outofchars && expectedScanner.hasNextLine()) {
                lineCharBegin = genCharsTraversed;
                String eLine = expectedScanner.nextLine();
                String strippedELine = eLine.replaceAll("\\s+", "").trim();
                char[] strippedExpected = strippedELine.toCharArray();
                int i = 0;
                while (i < strippedExpected.length) {
                    if (strippedExpected[i] != strippedGen[genCharsTraversed]) {
                        Assert.fail((String)(String.valueOf(filename) + ':' + lineNumber + " expected '" + eLine.trim() + "' but found '" + FileComparison.rebuildStringForLineError(generated.trim(), eLine.trim(), i, genCharsTraversed, lineCharBegin) + "'"));
                    }
                    if (++genCharsTraversed == strippedGen.length) {
                        outofchars = true;
                    }
                    ++i;
                }
                ++lineNumber;
            }
            if (expectedScanner.hasNextLine()) {
                Assert.fail((String)(String.valueOf(filename) + ':' + lineNumber + " expected '" + expectedScanner.nextLine() + "' but found end-of-file"));
            } else if (!outofchars && strippedGen.length > 0) {
                Assert.fail((String)(String.valueOf(filename) + ':' + lineNumber + " expected end-of-file but found '" + FileComparison.rebuildStringForEndOfFileError(generated.trim(), genCharsTraversed) + '\''));
            }
        }
        finally {
            if (expectedScanner != null) {
                expectedScanner.close();
            }
        }
    }

    private static String rebuildStringForLineError(String generatedString, String expectedLine, int beginInExpectedLine, int genCharsTraversed, int firstCharInExpLine) {
        String brokenLine = "";
        int lengthFromFirstDiff = expectedLine.replaceAll("\\s+", "").length() - beginInExpectedLine;
        char[] generatedChars = generatedString.replaceAll("\\s+", " ").toCharArray();
        int nonwhitechars = 0;
        int i = 0;
        while (i < generatedChars.length) {
            if (generatedChars[i] != ' ') {
                ++nonwhitechars;
            }
            if (nonwhitechars >= firstCharInExpLine && nonwhitechars < genCharsTraversed + lengthFromFirstDiff) {
                brokenLine = String.valueOf(brokenLine) + generatedChars[i];
            } else if (nonwhitechars == genCharsTraversed + lengthFromFirstDiff) {
                if (generatedChars[i + 1] == '\u0000') break;
                brokenLine = String.valueOf(brokenLine) + "...";
                break;
            }
            ++i;
        }
        return brokenLine;
    }

    private static String rebuildStringForEndOfFileError(String generatedString, int genCharsTraversed) {
        String brokenLine = "";
        char[] generatedChars = generatedString.replaceAll("\\s+", " ").toCharArray();
        int nonwhitechars = 0;
        int i = 0;
        while (i < generatedChars.length) {
            if (generatedChars[i] != ' ') {
                ++nonwhitechars;
            }
            if (nonwhitechars > genCharsTraversed && generatedChars[i] != '\u0000') {
                brokenLine = String.valueOf(brokenLine) + generatedChars[i];
            } else if (nonwhitechars == genCharsTraversed + 15 || generatedChars[i] == '\u0000') {
                if (generatedChars[i + 1] == '\u0000') break;
                brokenLine = String.valueOf(brokenLine) + "...";
                break;
            }
            ++i;
        }
        return brokenLine;
    }
}

