/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.c.codegen.lib;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.c.codegen.preferences.CCodeGenUtils;
import org.eclipse.papyrus.designer.languages.c.codegen.services.UmlCommentServices;
import org.eclipse.papyrus.designer.languages.c.codegen.utils.CClassUtils;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.CppRoot;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.ExternLibrary;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.External;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Include;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Template;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ImportScript {
    public static CharSequence genHeaderIncludes(Classifier classifier) {
        StringConcatenation _builder = new StringConcatenation();
        String _partComment = UmlCommentServices.partComment((Element)classifier, "Includes and declares");
        _builder.append(_partComment);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("// Derived includes");
        _builder.newLine();
        List _sort = IterableExtensions.sort(ImportScript.CClassAllIncludesHeader(classifier));
        for (String path : _sort) {
            String _includeDirective = ImportScript.includeDirective(path);
            _builder.append(_includeDirective);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("// End of Derived includes");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t");
        _builder.append("// Derived declarations");
        _builder.newLine();
        List _sort_1 = IterableExtensions.sort(ImportScript.CClassAllDeclares(classifier));
        for (String path_1 : _sort_1) {
            String _declareDirective = ImportScript.declareDirective(path_1);
            _builder.append(_declareDirective);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("// End of Derived declares");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        String _CIncludeHeader = ImportScript.CIncludeHeader((NamedElement)classifier);
        _builder.append(_CIncludeHeader, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// Std headers");
        _builder.newLine();
        CharSequence _genStdInclude = ImportScript.genStdInclude();
        _builder.append((Object)_genStdInclude);
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
        _builder.append("// End of Std headers");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence genBodyIncludes(Classifier classifier) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\t\t");
        String _CIncludePreBody = ImportScript.CIncludePreBody((NamedElement)classifier);
        _builder.append(_CIncludePreBody, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("// Include self header");
        _builder.newLine();
        String _name = classifier.getName();
        String _plus = String.valueOf(_name) + ".";
        String _headerSuffix = CCodeGenUtils.getHeaderSuffix();
        String _plus_1 = String.valueOf(_plus) + _headerSuffix;
        String _includeDirective = ImportScript.includeDirective(_plus_1);
        _builder.append(_includeDirective);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("// Derived includes");
        _builder.newLine();
        List _sort = IterableExtensions.sort(ImportScript.CClassAllIncludesBody(classifier));
        for (String path : _sort) {
            String _includeDirective_1 = ImportScript.includeDirective(path);
            _builder.append(_includeDirective_1);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        String _CIncludeBody = ImportScript.CIncludeBody((NamedElement)classifier);
        _builder.append(_CIncludeBody, "\t\t");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence genStdInclude() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#include <stdio.h>");
        _builder.newLine();
        _builder.append("#include <stdlib.h>");
        _builder.newLine();
        _builder.append("#include <stdint.h>");
        _builder.newLine();
        return _builder;
    }

    public static String includeDirective(String path) {
        if (path != null && path.length() > 0) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("#include ");
            String _plus = String.valueOf(_builder.toString()) + "\"";
            String _plus_1 = String.valueOf(_plus) + path;
            return String.valueOf(_plus_1) + "\"";
        }
        return null;
    }

    public static Iterable<String> CClassAllIncludesHeader(Classifier clazz) {
        return ImportScript.cClassAllIncludes(clazz, CClassUtils.includedClassifiers(clazz));
    }

    public static Iterable<String> CClassAllIncludesBody(Classifier classifier) {
        return ImportScript.cClassAllIncludes(classifier, CClassUtils.includedImplementationClassifiers(classifier));
    }

    public static Iterable<String> cClassAllIncludes(Classifier classifier, EList<Classifier> list) {
        ArrayList<String> newList = new ArrayList<String>();
        for (Classifier cl : list) {
            if ((Objects.equal((Object)cl, (Object)classifier) || GenUtils.hasStereotype((Element)cl, NoCodeGen.class)) && !GenUtils.hasStereotype((Element)cl, External.class)) continue;
            if ((cl instanceof Enumeration || cl instanceof PrimitiveType) && !GenUtils.hasStereotype((Element)cl, External.class) && !GenUtils.hasStereotypeTree((Element)cl, ExternLibrary.class)) {
                if (!(cl.getOwner() instanceof Package)) continue;
                Objects.equal((Object)cl.getOwner(), (Object)classifier.getOwner());
                continue;
            }
            List<String> _cClassIncludes = ImportScript.cClassIncludes((NamedElement)cl);
            for (String includePath : _cClassIncludes) {
                boolean _not;
                boolean _contains = newList.contains(includePath);
                boolean bl = _not = !_contains;
                if (!_not) continue;
                newList.add(includePath);
            }
        }
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String str) {
                return str != null;
            }
        };
        return IterableExtensions.filter(newList, (Functions.Function1)_function);
    }

    public static String cOwnerPackageIncludePath(Package pkg) {
        if (pkg != null && !GenUtils.hasStereotype((Element)pkg, CppRoot.class)) {
            String _fullPath = GenUtils.getFullPath((Package)pkg);
            String _plus = String.valueOf(_fullPath) + "/Pkg_";
            String _name = pkg.getName();
            String _plus_1 = String.valueOf(_plus) + _name;
            return String.valueOf(_plus_1) + ".h";
        }
        return null;
    }

    public static List<String> cClassIncludes(NamedElement ne) {
        ArrayList<String> result = new ArrayList<String>();
        boolean _hasStereotypeTree = GenUtils.hasStereotypeTree((Element)ne, ExternLibrary.class);
        if (_hasStereotypeTree) {
            String incPath;
            result.addAll((Collection<String>)((ExternLibrary)GenUtils.getApplicationTree((Element)ne, ExternLibrary.class)).getIncludes());
            boolean _hasStereotype = GenUtils.hasStereotype((Element)ne, External.class);
            if (_hasStereotype && (incPath = ImportScript.includeName(ne)) != null) {
                result.add(incPath);
            }
        } else {
            result.add(ImportScript.includeName(ne));
        }
        return result;
    }

    public static String includeName(NamedElement ne) {
        boolean _hasStereotypeTree = GenUtils.hasStereotypeTree((Element)ne, Template.class);
        if (_hasStereotypeTree) {
            return ((Template)UMLUtil.getStereotypeApplication((Element)ne, Template.class)).getDeclaration();
        }
        boolean _hasStereotypeTree_1 = GenUtils.hasStereotypeTree((Element)ne, External.class);
        if (_hasStereotypeTree_1) {
            return ((External)UMLUtil.getStereotypeApplication((Element)ne, External.class)).getIncPath();
        }
        String path = GenUtils.getFullPath((Package)ne.getNearestPackage());
        boolean _equals = path.equals(ne.getModel().getName());
        if (_equals) {
            path = "";
        } else {
            String _name = ne.getModel().getName();
            String _plus = String.valueOf(_name) + "/";
            boolean _startsWith = path.startsWith(_plus);
            if (_startsWith) {
                String _plus_2;
                String _fullPath = GenUtils.getFullPath((Package)ne.getNearestPackage());
                String _name_1 = ne.getModel().getName();
                String _plus_1 = String.valueOf(_name_1) + "/";
                String _replace = _fullPath.replace(_plus_1, "");
                path = _plus_2 = String.valueOf(_replace) + "/";
            }
        }
        String _name_2 = ne.getName();
        String _plus_3 = String.valueOf(path) + _name_2;
        String _plus_4 = String.valueOf(_plus_3) + ".";
        String _headerSuffix = CCodeGenUtils.getHeaderSuffix();
        return String.valueOf(_plus_4) + _headerSuffix;
    }

    public static String declareDirective(String path) {
        if (path != null && path.length() > 0) {
            return path;
        }
        return null;
    }

    public static Iterable<String> CClassAllDeclares(Classifier clazz) {
        return ImportScript.cClassAllDeclares(clazz, CClassUtils.declaredClassifiers(clazz), CClassUtils.includedClassifiers(clazz));
    }

    public static Iterable<String> cClassAllDeclares(Classifier classifier, EList<Classifier> declaredClassifiers, EList<Classifier> includedClassifiers) {
        ArrayList<String> newList = new ArrayList<String>();
        if (declaredClassifiers != null) {
            if (includedClassifiers != null) {
                declaredClassifiers.removeAll(includedClassifiers);
            }
            for (Classifier cl : declaredClassifiers) {
                boolean _not;
                boolean _notEquals;
                if ((Objects.equal((Object)cl, (Object)classifier) || GenUtils.hasStereotype((Element)cl, NoCodeGen.class)) && !GenUtils.hasStereotype((Element)cl, External.class)) continue;
                String declaration = "";
                if (!(cl instanceof Enumeration) && !(cl instanceof PrimitiveType)) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("typedef struct ");
                    String _name = cl.getName();
                    _builder.append(_name);
                    _builder.append(" ");
                    String _name_1 = cl.getName();
                    _builder.append(_name_1);
                    _builder.append(";");
                    declaration = _builder.toString();
                }
                boolean bl = _notEquals = !Objects.equal((Object)declaration, (Object)"");
                if (!_notEquals) continue;
                boolean _contains = newList.contains(declaration);
                boolean bl2 = _not = !_contains;
                if (!_not) continue;
                newList.add(declaration);
            }
        }
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String str) {
                return str != null;
            }
        };
        return IterableExtensions.filter(newList, (Functions.Function1)_function);
    }

    public static String CIncludeHeader(NamedElement ne) {
        boolean _hasStereotype = GenUtils.hasStereotype((Element)ne, Include.class);
        if (_hasStereotype) {
            UMLUtil.getStereotypeApplication((Element)ne, Include.class);
            String header = ((Include)UMLUtil.getStereotypeApplication((Element)ne, Include.class)).getHeader();
            if (header != null && header.length() > 0) {
                CharSequence _constIncludeHeaderStart = ImportScript.constIncludeHeaderStart();
                String _cleanCR = GenUtils.cleanCR((String)header);
                String _plus = _constIncludeHeaderStart + _cleanCR;
                String _plus_1 = String.valueOf(_plus) + "\n";
                CharSequence _constIncludeHeaderEnd = ImportScript.constIncludeHeaderEnd();
                String includeHeader = String.valueOf(_plus_1) + _constIncludeHeaderEnd;
                return includeHeader;
            }
        }
        return null;
    }

    public static CharSequence constIncludeHeaderStart() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// Include from Include stereotype (header)");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence constIncludeHeaderEnd() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// End of Include stereotype (header)");
        _builder.newLine();
        return _builder;
    }

    public static String CIncludePreBody(NamedElement ne) {
        String preBody;
        boolean _hasStereotype = GenUtils.hasStereotype((Element)ne, Include.class);
        if (_hasStereotype && (preBody = ((Include)UMLUtil.getStereotypeApplication((Element)ne, Include.class)).getPreBody()) != null && preBody.length() > 0) {
            CharSequence _constIncludePreBodyStart = ImportScript.constIncludePreBodyStart();
            String _cleanCR = GenUtils.cleanCR((String)preBody);
            String _plus = _constIncludePreBodyStart + _cleanCR;
            String _plus_1 = String.valueOf(_plus) + "\n";
            CharSequence _constIncludePreBodyEnd = ImportScript.constIncludePreBodyEnd();
            String includePreBody = String.valueOf(_plus_1) + _constIncludePreBodyEnd;
            return includePreBody;
        }
        return null;
    }

    public static CharSequence constIncludePreBodyStart() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// Include from Include stereotype (preBody)");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence constIncludePreBodyEnd() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// End of Include from Include stereotype (preBody)");
        _builder.newLine();
        return _builder;
    }

    public static String CIncludeBody(NamedElement ne) {
        String body;
        boolean _hasStereotype = GenUtils.hasStereotype((Element)ne, Include.class);
        if (_hasStereotype && (body = ((Include)UMLUtil.getStereotypeApplication((Element)ne, Include.class)).getBody()) != null && body.length() > 0) {
            CharSequence _constIncludeBodyStart = ImportScript.constIncludeBodyStart();
            String _cleanCR = GenUtils.cleanCR((String)body);
            String _plus = _constIncludeBodyStart + _cleanCR;
            String _plus_1 = String.valueOf(_plus) + "\n";
            CharSequence _constIncludeBodyEnd = ImportScript.constIncludeBodyEnd();
            String includeBody = String.valueOf(_plus_1) + _constIncludeBodyEnd;
            return includeBody;
        }
        return null;
    }

    public static CharSequence constIncludeBodyStart() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// Include from Include stereotype (body)");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence constIncludeBodyEnd() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// End of Include from Include stereotype (body)");
        _builder.newLine();
        return _builder;
    }
}

