/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.modellibs.core.mappingrules;

import java.util.Iterator;
import org.eclipse.papyrus.designer.components.FCM.Port;
import org.eclipse.papyrus.designer.components.fcm.profile.IMappingRule;
import org.eclipse.papyrus.designer.components.fcm.profile.utils.PortMapUtil;
import org.eclipse.papyrus.designer.transformation.base.utils.RealizationUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Type;

public class AMIpoll
implements IMappingRule {
    private static final String IAMI_POLL = "IAMIPoll_";
    private static final String AMI_POLL = "AMIPoll_";

    public Type calcDerivedType(Port p, boolean update) {
        String name;
        Type type = p.getType();
        if (!(type instanceof Interface)) {
            return null;
        }
        Class derivedType = PortMapUtil.getDerivedClass((Port)p, (String)AMI_POLL);
        Interface typingInterface = (Interface)type;
        Interface derivedInterface = PortMapUtil.getDerivedInterface((Port)p, (String)IAMI_POLL);
        RealizationUtils.addUsage((Class)derivedType, (Interface)derivedInterface);
        if (!update) {
            return derivedType;
        }
        for (Operation operation : typingInterface.getOwnedOperations()) {
            Type paramType;
            String paramName;
            name = operation.getName();
            Operation derivedOperation = derivedInterface.getOperation(name, null, null);
            if (derivedOperation == null) {
                derivedOperation = derivedInterface.createOwnedOperation(name, null, null);
            }
            if (AMIpoll.hasOutParameters(operation)) {
                String pollName = String.valueOf(name) + "Poll";
                Iterator derivedPollOperation = derivedInterface.getOperation(pollName, null, null);
                if (derivedPollOperation == null) {
                    derivedPollOperation = derivedInterface.createOwnedOperation(pollName, null, null);
                }
                derivedPollOperation.createOwnedParameter("timeout", null);
                for (Parameter parameter : operation.getOwnedParameters()) {
                    Type paramType2;
                    String paramName2;
                    if (parameter.getDirection() == ParameterDirectionKind.IN_LITERAL || derivedPollOperation.getOwnedParameter(paramName2 = parameter.getName(), paramType2 = parameter.getType()) != null) continue;
                    Parameter newParameter = derivedPollOperation.createOwnedParameter(parameter.getName(), parameter.getType());
                    newParameter.setDirection(parameter.getDirection());
                    newParameter.setLower(parameter.getLower());
                    newParameter.setUpper(parameter.getUpper());
                }
            }
            for (Parameter parameter : operation.getOwnedParameters()) {
                if (parameter.getDirection() != ParameterDirectionKind.IN_LITERAL && parameter.getDirection() != ParameterDirectionKind.INOUT_LITERAL || derivedOperation.getOwnedParameter(paramName = parameter.getName(), paramType = parameter.getType()) != null) continue;
                Parameter newParameter = derivedOperation.createOwnedParameter(parameter.getName(), parameter.getType());
                newParameter.setDirection(parameter.getDirection());
                newParameter.setLower(parameter.getLower());
                newParameter.setUpper(parameter.getUpper());
            }
            Iterator derivedParameters = derivedOperation.getOwnedParameters().iterator();
            while (derivedParameters.hasNext()) {
                Parameter parameter = (Parameter)derivedParameters.next();
                paramName = parameter.getName();
                paramType = parameter.getType();
                if (paramName.equals("timeout") || operation.getOwnedParameter(paramName, paramType) != null) continue;
                derivedParameters.remove();
            }
        }
        Iterator derivedOperations = derivedInterface.getOwnedOperations().iterator();
        while (derivedOperations.hasNext()) {
            Operation derivedOperation = (Operation)derivedOperations.next();
            name = derivedOperation.getName();
            if (name == null) continue;
            if (name.endsWith("Poll")) {
                name = name.substring(0, name.length() - 4);
            }
            if (typingInterface.getOperation(name, null, null) != null) continue;
            derivedOperations.remove();
        }
        return derivedType;
    }

    public static boolean hasOutParameters(Operation operation) {
        for (Parameter parameter : operation.getOwnedParameters()) {
            if (parameter.getDirection() == ParameterDirectionKind.IN_LITERAL) continue;
            return true;
        }
        return false;
    }

    public boolean needsUpdate(Port p) {
        return this.calcDerivedType(p, false) == null;
    }
}

