/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.CDefinitions;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.SM2ClassesTransformationCore;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.TransitionGraph;
import org.eclipse.papyrus.designer.transformation.library.statemachine.SMCommon;
import org.eclipse.papyrus.designer.transformation.library.statemachine.TransformationUtil;
import org.eclipse.papyrus.designer.transformation.library.xtend.BehaviorUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.TransitionKind;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class EventTransformation {
    @Extension
    protected CDefinitions cdefs;
    private SM2ClassesTransformationCore core;
    private Class superContext;
    private List<Pseudostate> joins = new ArrayList<Pseudostate>();

    public EventTransformation(SM2ClassesTransformationCore core) {
        this.core = core;
        this.superContext = core.superContext;
    }

    public List<Event> getDeferredEvents(State s) {
        Functions.Function1<Trigger, Event> _function = new Functions.Function1<Trigger, Event>(){

            public Event apply(Trigger it) {
                return it.getEvent();
            }
        };
        return IterableExtensions.toList((Iterable)ListExtensions.map((List)s.getDeferrableTriggers(), (Functions.Function1)_function));
    }

    public String completionEventCheck(String eventName, String stateId) {
        boolean _equals = Objects.equal((Object)eventName, (Object)"CompletionEvent");
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(" ");
            _builder.append("&& (currentEvent->associatedState == ");
            _builder.append(stateId, " ");
            _builder.append(")");
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        return _builder_1.toString();
    }

    public Operation createEventMethod(final String eventName, List<Transition> transitions) {
        boolean _greaterThan_3;
        Operation method = this.superContext.createOwnedOperation("process" + eventName, null, null);
        Functions.Function1<Transition, Vertex> _function = new Functions.Function1<Transition, Vertex>(){

            public Vertex apply(Transition it) {
                return it.getSource();
            }
        };
        List tempSources = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)ListExtensions.map(transitions, (Functions.Function1)_function), State.class));
        final ArrayList sources = new ArrayList();
        Consumer<State> _function_1 = new Consumer<State>(){

            @Override
            public void accept(State it) {
                boolean _not;
                boolean _contains = sources.contains(it);
                boolean bl = _not = !_contains;
                if (_not) {
                    sources.add(it);
                }
            }
        };
        tempSources.forEach(_function_1);
        HashMap map = new HashMap();
        for (State source : sources) {
            boolean _not;
            boolean _tripleNotEquals;
            State _state = source.getContainer().getState();
            boolean bl = _tripleNotEquals = _state != null;
            if (!_tripleNotEquals) continue;
            boolean _containsKey = map.containsKey(source.getContainer().getState());
            boolean bl2 = _not = !_containsKey;
            if (_not) {
                State _state_1 = source.getContainer().getState();
                ArrayList _arrayList = new ArrayList();
                map.put(_state_1, _arrayList);
            }
            ((List)map.get(source.getContainer().getState())).add(source);
        }
        List arraySet = IterableExtensions.toList(map.keySet());
        int size = arraySet.size();
        int i = 0;
        while (i < size) {
            int j = i + 1;
            while (j < size) {
                int _calculateDepth_1;
                boolean _lessEqualsThan;
                int _calculateDepth = SMCommon.calculateDepth((Region)this.core.topRegion, (State)((State)arraySet.get(i)));
                boolean bl = _lessEqualsThan = _calculateDepth <= (_calculateDepth_1 = SMCommon.calculateDepth((Region)this.core.topRegion, (State)((State)arraySet.get(j))));
                if (_lessEqualsThan) {
                    State tmp = (State)arraySet.remove(j);
                    arraySet.add(i, tmp);
                }
                ++j;
            }
            ++i;
        }
        List rootSourceStates = SMCommon.getRootStates((Region)this.core.topRegion, sources);
        final ArrayList<Transition> passeds = new ArrayList<Transition>();
        Functions.Function1<CallEvent, Boolean> _function_2 = new Functions.Function1<CallEvent, Boolean>(){

            public Boolean apply(CallEvent it) {
                String _eventName = TransformationUtil.eventName((Event)it);
                return Objects.equal((Object)_eventName, (Object)eventName);
            }
        };
        int _size = IterableExtensions.size((Iterable)IterableExtensions.filter(this.core.callEvents, (Functions.Function1)_function_2));
        boolean isCallEvent = _size > 0;
        StringConcatenation _builder = new StringConcatenation();
        if (isCallEvent) {
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("systemState");
        _builder.append(" = SystemStateEnum_t.EVENT_PROCESSING;");
        _builder.newLineIfNotEmpty();
        for (State s : arraySet) {
            boolean _isOrthogonal = s.isOrthogonal();
            if (_isOrthogonal) {
                List<State> _actualStateList = this.getActualStateList((List)map.get(s), transitions);
                for (final State sub : _actualStateList) {
                    boolean _greaterThan_1;
                    boolean _greaterThan;
                    Functions.Function1<Transition, Boolean> _function_3 = new Functions.Function1<Transition, Boolean>(){

                        public Boolean apply(Transition it) {
                            Vertex _source = it.getSource();
                            return Objects.equal((Object)_source, (Object)sub);
                        }
                    };
                    Functions.Function1<Transition, Boolean> _function_4 = new Functions.Function1<Transition, Boolean>(){

                        public Boolean apply(Transition it) {
                            boolean _contains = passeds.contains(it);
                            return !_contains;
                        }
                    };
                    int _size_1 = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(transitions, (Functions.Function1)_function_3), (Functions.Function1)_function_4));
                    boolean bl = _greaterThan = _size_1 > 0;
                    if (!_greaterThan) continue;
                    if (Objects.equal((Object)eventName, (Object)"CompletionEvent") && IterableExtensions.size((Iterable)IterableExtensions.filter(transitions, (Functions.Function1)new Functions.Function1<Transition, Boolean>(){

                        public Boolean apply(Transition it) {
                            return Objects.equal((Object)it.getSource(), (Object)sub) && it.getTarget() instanceof Pseudostate && Objects.equal((Object)((Pseudostate)it.getTarget()).getKind(), (Object)PseudostateKind.JOIN_LITERAL);
                        }
                    })) > 0) {
                        Functions.Function1<Transition, Boolean> _function_5 = new Functions.Function1<Transition, Boolean>(){

                            public Boolean apply(Transition it) {
                                return Objects.equal((Object)it.getSource(), (Object)sub) && it.getTarget() instanceof Pseudostate && Objects.equal((Object)((Pseudostate)it.getTarget()).getKind(), (Object)PseudostateKind.JOIN_LITERAL);
                            }
                        };
                        Iterable trans = IterableExtensions.filter(transitions, (Functions.Function1)_function_5);
                        _builder.newLineIfNotEmpty();
                        Functions.Function1<Transition, Boolean> _function_6 = new Functions.Function1<Transition, Boolean>(){

                            public Boolean apply(Transition it) {
                                boolean _contains = EventTransformation.this.joins.contains(it.getTarget());
                                return !_contains;
                            }
                        };
                        Functions.Function1<Transition, Vertex> _function_7 = new Functions.Function1<Transition, Vertex>(){

                            public Vertex apply(Transition it) {
                                return it.getTarget();
                            }
                        };
                        Vertex join = (Vertex)IterableExtensions.head((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)trans, (Functions.Function1)_function_6), (Functions.Function1)_function_7));
                        _builder.newLineIfNotEmpty();
                        Functions.Function1<Transition, Vertex> _function_8 = new Functions.Function1<Transition, Vertex>(){

                            public Vertex apply(Transition it) {
                                return it.getSource();
                            }
                        };
                        List sourcesOfJoin = ListExtensions.map((List)join.getIncomings(), (Functions.Function1)_function_8);
                        _builder.newLineIfNotEmpty();
                        _builder.append("if (");
                        boolean _hasElements = false;
                        for (Vertex src : sourcesOfJoin) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)" || ", "");
                            }
                            _builder.append("(currentEvent->associatedState == ");
                            String _upperCase = src.getName().toUpperCase();
                            _builder.append(_upperCase);
                            _builder.append("_ID)");
                        }
                        _builder.append(") {");
                        _builder.newLineIfNotEmpty();
                        Functions.Function1<Transition, Boolean> _function_9 = new Functions.Function1<Transition, Boolean>(){

                            public Boolean apply(Transition it) {
                                Vertex _source = it.getSource();
                                return Objects.equal((Object)_source, (Object)sub);
                            }
                        };
                        Functions.Function1<Transition, Boolean> _function_10 = new Functions.Function1<Transition, Boolean>(){

                            public Boolean apply(Transition it) {
                                boolean _contains = passeds.contains(it);
                                return !_contains;
                            }
                        };
                        Iterable _filter = IterableExtensions.filter((Iterable)IterableExtensions.filter(transitions, (Functions.Function1)_function_9), (Functions.Function1)_function_10);
                        for (Transition t : _filter) {
                            _builder.append("\t");
                            boolean _add = passeds.add(t);
                            _builder.append((Object)_add, "\t");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            String _generateTransitionCode = this.generateTransitionCode(sub, t);
                            _builder.append(_generateTransitionCode, "\t");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append("}");
                        _builder.newLine();
                        continue;
                    }
                    _builder.append("if (");
                    String _hasSubstatesAcceptingEvent = SMCommon.hasSubstatesAcceptingEvent((State)sub, sources);
                    _builder.append(_hasSubstatesAcceptingEvent);
                    _builder.append("states");
                    _builder.append("[");
                    String _upperCase_1 = s.getName().toUpperCase();
                    _builder.append(_upperCase_1);
                    _builder.append("_ID].");
                    _builder.append("actives");
                    _builder.append("[");
                    int _regionNumber = SMCommon.getRegionNumber((Region)this.core.topRegion, (State)sub);
                    _builder.append((Object)_regionNumber);
                    _builder.append("] == ");
                    String _upperCase_2 = sub.getName().toUpperCase();
                    _builder.append(_upperCase_2);
                    _builder.append("_ID");
                    String _upperCase_3 = sub.getName().toUpperCase();
                    String _plus = String.valueOf(_upperCase_3) + "_ID";
                    String _completionEventCheck = this.completionEventCheck(eventName, _plus);
                    _builder.append(_completionEventCheck);
                    _builder.append(") {");
                    _builder.newLineIfNotEmpty();
                    Functions.Function1<Event, Boolean> _function_11 = new Functions.Function1<Event, Boolean>(){

                        public Boolean apply(Event it) {
                            String _name = it.getName();
                            return Objects.equal((Object)_name, (Object)eventName);
                        }
                    };
                    int _size_2 = IterableExtensions.size((Iterable)IterableExtensions.filter(this.getDeferredEvents(sub), (Functions.Function1)_function_11));
                    boolean bl3 = _greaterThan_1 = _size_2 > 0;
                    if (_greaterThan_1) {
                        _builder.append("\t");
                        _builder.append("systemState", "\t");
                        _builder.append(" = SystemStateEnum_t.EVENT_DEFERRED;");
                        _builder.newLineIfNotEmpty();
                    } else {
                        Functions.Function1<Transition, Boolean> _function_12 = new Functions.Function1<Transition, Boolean>(){

                            public Boolean apply(Transition it) {
                                Vertex _source = it.getSource();
                                return Objects.equal((Object)_source, (Object)sub);
                            }
                        };
                        Functions.Function1<Transition, Boolean> _function_13 = new Functions.Function1<Transition, Boolean>(){

                            public Boolean apply(Transition it) {
                                boolean _contains = passeds.contains(it);
                                return !_contains;
                            }
                        };
                        Iterable _filter_1 = IterableExtensions.filter((Iterable)IterableExtensions.filter(transitions, (Functions.Function1)_function_12), (Functions.Function1)_function_13);
                        for (Transition t_1 : _filter_1) {
                            _builder.append("\t");
                            boolean _add_1 = passeds.add(t_1);
                            _builder.append((Object)_add_1, "\t");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            String _generateTransitionCode_1 = this.generateTransitionCode(sub, t_1);
                            _builder.append(_generateTransitionCode_1, "\t");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                    _builder.append("}");
                    _builder.newLine();
                }
                continue;
            }
            List _get = (List)map.get(s);
            boolean _hasElements_1 = false;
            for (final State sub_1 : _get) {
                boolean _greaterThan_2;
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)" else ", "");
                }
                _builder.append("if (");
                String _hasSubstatesAcceptingEvent_1 = SMCommon.hasSubstatesAcceptingEvent((State)sub_1, sources);
                _builder.append(_hasSubstatesAcceptingEvent_1);
                _builder.append("states");
                _builder.append("[");
                String _upperCase_4 = s.getName().toUpperCase();
                _builder.append(_upperCase_4);
                _builder.append("_ID].");
                _builder.append("actives");
                _builder.append("[0] == ");
                String _upperCase_5 = sub_1.getName().toUpperCase();
                _builder.append(_upperCase_5);
                _builder.append("_ID");
                String _upperCase_6 = sub_1.getName().toUpperCase();
                String _plus_1 = String.valueOf(_upperCase_6) + "_ID";
                String _completionEventCheck_1 = this.completionEventCheck(eventName, _plus_1);
                _builder.append(_completionEventCheck_1);
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                Functions.Function1<Event, Boolean> _function_14 = new Functions.Function1<Event, Boolean>(){

                    public Boolean apply(Event it) {
                        String _name = it.getName();
                        return Objects.equal((Object)_name, (Object)eventName);
                    }
                };
                int _size_3 = IterableExtensions.size((Iterable)IterableExtensions.filter(this.getDeferredEvents(sub_1), (Functions.Function1)_function_14));
                boolean bl = _greaterThan_2 = _size_3 > 0;
                if (_greaterThan_2) {
                    _builder.append("\t");
                    _builder.append("systemState", "\t");
                    _builder.append(" = SystemStateEnum_t.EVENT_DEFERRED;");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("\t");
                    Functions.Function1<Transition, Boolean> _function_15 = new Functions.Function1<Transition, Boolean>(){

                        public Boolean apply(Transition it) {
                            return Objects.equal((Object)it.getSource(), (Object)sub_1) && it.getGuard() != null;
                        }
                    };
                    Iterable hasGuards = IterableExtensions.filter(transitions, (Functions.Function1)_function_15);
                    _builder.newLineIfNotEmpty();
                    Functions.Function1<Transition, Boolean> _function_16 = new Functions.Function1<Transition, Boolean>(){

                        public Boolean apply(Transition it) {
                            return Objects.equal((Object)it.getSource(), (Object)sub_1) && it.getGuard() != null;
                        }
                    };
                    Iterable _filter_2 = IterableExtensions.filter(transitions, (Functions.Function1)_function_16);
                    boolean _hasElements_2 = false;
                    for (Transition t_2 : _filter_2) {
                        if (!_hasElements_2) {
                            _hasElements_2 = true;
                        } else {
                            _builder.appendImmediate((Object)" else ", "\t");
                        }
                        _builder.append("\t");
                        String _generateTransitionCode_2 = this.generateTransitionCode(sub_1, t_2);
                        _builder.append(_generateTransitionCode_2, "\t");
                        _builder.newLineIfNotEmpty();
                    }
                    boolean _isEmpty = IterableExtensions.isEmpty((Iterable)hasGuards);
                    if (_isEmpty) {
                        _builder.append("\t");
                        Functions.Function1<Transition, Boolean> _function_17 = new Functions.Function1<Transition, Boolean>(){

                            public Boolean apply(Transition it) {
                                return Objects.equal((Object)it.getSource(), (Object)sub_1) && it.getGuard() == null;
                            }
                        };
                        String _generateTransitionCode_3 = this.generateTransitionCode(sub_1, (Transition)IterableExtensions.head((Iterable)IterableExtensions.filter(transitions, (Functions.Function1)_function_17)));
                        _builder.append(_generateTransitionCode_3, "\t");
                        _builder.newLineIfNotEmpty();
                    } else {
                        boolean _tripleNotEquals_1;
                        Functions.Function1<Transition, Boolean> _function_18 = new Functions.Function1<Transition, Boolean>(){

                            public Boolean apply(Transition it) {
                                return Objects.equal((Object)it.getSource(), (Object)sub_1) && it.getGuard() == null;
                            }
                        };
                        Transition _head = (Transition)IterableExtensions.head((Iterable)IterableExtensions.filter(transitions, (Functions.Function1)_function_18));
                        boolean bl4 = _tripleNotEquals_1 = _head != null;
                        if (_tripleNotEquals_1) {
                            _builder.append("\t");
                            _builder.append("else {");
                            _builder.newLine();
                            _builder.append("\t");
                            _builder.append("\t");
                            Functions.Function1<Transition, Boolean> _function_19 = new Functions.Function1<Transition, Boolean>(){

                                public Boolean apply(Transition it) {
                                    return Objects.equal((Object)it.getSource(), (Object)sub_1) && it.getGuard() == null;
                                }
                            };
                            String _generateTransitionCode_4 = this.generateTransitionCode(sub_1, (Transition)IterableExtensions.head((Iterable)IterableExtensions.filter(transitions, (Functions.Function1)_function_19)));
                            _builder.append(_generateTransitionCode_4, "\t\t");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("}");
                            _builder.newLine();
                        }
                    }
                }
                _builder.append("}");
                _builder.newLine();
            }
        }
        int _size_4 = rootSourceStates.size();
        boolean bl = _greaterThan_3 = _size_4 > 0;
        if (_greaterThan_3) {
            _builder.append("if (");
            _builder.append("systemState");
            _builder.append(" == SystemStateEnum_t.EVENT_PROCESSING");
            String _completionEventCheck_2 = this.completionEventCheck(eventName, "activeStateID");
            _builder.append(_completionEventCheck_2);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("switch(");
            _builder.append("activeStateID", "\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            for (final State root : rootSourceStates) {
                boolean _greaterThan_4;
                _builder.append("\t\t");
                _builder.append("case ");
                String _upperCase_7 = root.getName().toUpperCase();
                _builder.append(_upperCase_7, "\t\t");
                _builder.append("_ID: ");
                _builder.newLineIfNotEmpty();
                Functions.Function1<Event, Boolean> _function_20 = new Functions.Function1<Event, Boolean>(){

                    public Boolean apply(Event it) {
                        String _name = it.getName();
                        return Objects.equal((Object)_name, (Object)eventName);
                    }
                };
                int _size_5 = IterableExtensions.size((Iterable)IterableExtensions.filter(this.getDeferredEvents(root), (Functions.Function1)_function_20));
                boolean bl5 = _greaterThan_4 = _size_5 > 0;
                if (_greaterThan_4) {
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("systemState", "\t\t\t");
                    _builder.append(" = SystemStateEnum_t.EVENT_DEFERRED;");
                    _builder.newLineIfNotEmpty();
                } else {
                    Functions.Function1<Transition, Boolean> _function_21 = new Functions.Function1<Transition, Boolean>(){

                        public Boolean apply(Transition it) {
                            Vertex _source = it.getSource();
                            return Objects.equal((Object)_source, (Object)root);
                        }
                    };
                    Iterable _filter_3 = IterableExtensions.filter(transitions, (Functions.Function1)_function_21);
                    boolean _hasElements_3 = false;
                    for (Transition t_3 : _filter_3) {
                        if (!_hasElements_3) {
                            _hasElements_3 = true;
                        } else {
                            _builder.appendImmediate((Object)" else ", "\t\t\t");
                        }
                        _builder.append("\t\t");
                        _builder.append("\t");
                        String _generateTransitionCode_5 = this.generateTransitionCode(root, t_3);
                        _builder.append(_generateTransitionCode_5, "\t\t\t");
                        _builder.newLineIfNotEmpty();
                    }
                }
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("break;");
                _builder.newLine();
            }
            _builder.append("\t\t");
            _builder.append("default:");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("//do nothing");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        if (isCallEvent) {
            _builder.append("\t");
            _builder.newLine();
        }
        String body = _builder.toString();
        this.core.createOpaqueBehavior(this.superContext, method, body);
        return method;
    }

    private List<State> getActualStateList(List<State> l, List<Transition> trans) {
        boolean _greaterThan;
        Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition it) {
                return it.getTarget() instanceof Pseudostate && Objects.equal((Object)((Pseudostate)it.getTarget()).getKind(), (Object)PseudostateKind.JOIN_LITERAL);
            }
        };
        Iterable transComingToJoin = IterableExtensions.filter(trans, (Functions.Function1)_function);
        final ArrayList<State> ret = new ArrayList<State>();
        ret.addAll(l);
        int _size = IterableExtensions.size((Iterable)transComingToJoin);
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            final ArrayList<Pseudostate> joins = new ArrayList<Pseudostate>();
            Functions.Function1<Transition, Vertex> _function_1 = new Functions.Function1<Transition, Vertex>(){

                public Vertex apply(Transition it) {
                    return it.getTarget();
                }
            };
            Consumer<Pseudostate> _function_2 = new Consumer<Pseudostate>(){

                @Override
                public void accept(Pseudostate it) {
                    boolean _not;
                    boolean _contains = joins.contains(it);
                    boolean bl = _not = !_contains;
                    if (_not) {
                        joins.add(it);
                    }
                }
            };
            Iterables.filter((Iterable)IterableExtensions.map((Iterable)transComingToJoin, (Functions.Function1)_function_1), Pseudostate.class).forEach(_function_2);
            Consumer<Pseudostate> _function_3 = new Consumer<Pseudostate>(){

                @Override
                public void accept(Pseudostate it) {
                    Functions.Function1<Transition, Vertex> _function = new Functions.Function1<Transition, Vertex>(){

                        public Vertex apply(Transition it) {
                            return it.getSource();
                        }
                    };
                    List toRemoveds = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)it.getIncomings(), (Functions.Function1)_function), State.class));
                    toRemoveds.remove(IterableExtensions.head((Iterable)toRemoveds));
                    ret.removeAll(toRemoveds);
                }
            };
            joins.forEach(_function_3);
        }
        return ret;
    }

    public String generateTransitionCode(State s, Transition t) {
        StringConcatenation _builder = new StringConcatenation();
        String ret = _builder.toString();
        Constraint _guard = t.getGuard();
        boolean hasGuard = _guard != null;
        Vertex _target = t.getTarget();
        if (_target instanceof State) {
            TransitionKind _kind;
            boolean _equals;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("process");
            _builder_1.append("CompletionEvent");
            _builder_1.append("();");
            String callCompletionEvent = _builder_1.toString();
            Vertex _target_1 = t.getTarget();
            if (_target_1 instanceof FinalState) {
                State composite = t.getTarget().getContainer().getState();
                if (composite == null) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    callCompletionEvent = _builder_2.toString();
                } else {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("if (");
                    EList _regions = composite.getRegions();
                    boolean _hasElements = false;
                    for (Region r : _regions) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder_3.appendImmediate((Object)" && ", "");
                        }
                        _builder_3.append("(");
                        _builder_3.append("states");
                        _builder_3.append("[");
                        String _upperCase = composite.getName().toUpperCase();
                        _builder_3.append(_upperCase);
                        _builder_3.append("_ID].");
                        _builder_3.append("actives");
                        _builder_3.append("[");
                        int _indexOf = composite.getRegions().indexOf((Object)r);
                        _builder_3.append((Object)_indexOf);
                        _builder_3.append("] == ");
                        _builder_3.append("STATE_MAX");
                        _builder_3.append(")");
                    }
                    _builder_3.append(") {");
                    _builder_3.newLineIfNotEmpty();
                    _builder_3.append("\t");
                    _builder_3.append("eventQueue", "\t");
                    _builder_3.append(".push(statemachine::EventPriority_t::PRIORITY_1, NULL, COMPLETIONEVENT_ID, statemachine::COMPLETION_EVENT, ");
                    String _upperCase_1 = composite.getName().toUpperCase();
                    _builder_3.append(_upperCase_1, "\t");
                    _builder_3.append("_ID);");
                    _builder_3.newLineIfNotEmpty();
                    _builder_3.append("}");
                    callCompletionEvent = _builder_3.toString();
                }
            }
            if (_equals = Objects.equal((Object)(_kind = t.getKind()), (Object)TransitionKind.INTERNAL_LITERAL)) {
                boolean _tripleNotEquals;
                StringConcatenation _builder_4 = new StringConcatenation();
                Behavior _effect = t.getEffect();
                boolean bl = _tripleNotEquals = _effect != null;
                if (_tripleNotEquals) {
                    Behavior _effect_1 = t.getEffect();
                    String _head = (String)IterableExtensions.head((Iterable)((OpaqueBehavior)_effect_1).getBodies());
                    _builder_4.append(_head);
                    _builder_4.newLineIfNotEmpty();
                }
                ret = _builder_4.toString();
            } else {
                TransitionKind _kind_1 = t.getKind();
                boolean _equals_1 = Objects.equal((Object)_kind_1, (Object)TransitionKind.LOCAL_LITERAL);
                if (_equals_1) {
                    State parent = null;
                    State child = null;
                    boolean _contains = TransformationUtil.transitiveSubStates((State)s).contains(t.getTarget());
                    if (_contains) {
                        parent = s;
                        Vertex _target_2 = t.getTarget();
                        final State finalChild = child = (State)_target_2;
                        StringConcatenation _builder_5 = new StringConcatenation();
                        String _generateExitingSubStates = this.core.generateExitingSubStates(s, false);
                        _builder_5.append(_generateExitingSubStates);
                        _builder_5.newLineIfNotEmpty();
                        String _transitionEffect = TransformationUtil.getTransitionEffect((Transition)t);
                        _builder_5.append(_transitionEffect);
                        _builder_5.newLineIfNotEmpty();
                        Vertex _target_3 = t.getTarget();
                        if (_target_3 instanceof FinalState) {
                            Region _container = t.getTarget().getContainer();
                            boolean _equals_2 = Objects.equal((Object)_container, (Object)this.core.topRegion);
                            if (_equals_2) {
                                _builder_5.append("activeStateID");
                                _builder_5.append(" = ");
                                _builder_5.append("STATE_MAX");
                                _builder_5.append(";");
                                _builder_5.newLineIfNotEmpty();
                            } else {
                                _builder_5.append("states");
                                _builder_5.append("[");
                                String _upperCase_2 = t.getTarget().getContainer().getState().getName().toUpperCase();
                                _builder_5.append(_upperCase_2);
                                _builder_5.append("_ID].");
                                _builder_5.append("actives");
                                _builder_5.append("[");
                                int _indexOf_1 = t.getTarget().getContainer().getState().getRegions().indexOf((Object)t.getTarget().getContainer());
                                _builder_5.append((Object)_indexOf_1);
                                _builder_5.append("] = ");
                                _builder_5.append("STATE_MAX");
                                _builder_5.append(";");
                                _builder_5.newLineIfNotEmpty();
                            }
                            _builder_5.append(callCompletionEvent);
                            _builder_5.append(";");
                            _builder_5.newLineIfNotEmpty();
                        } else {
                            Functions.Function1<Region, Boolean> _function = new Functions.Function1<Region, Boolean>(){

                                public Boolean apply(Region it) {
                                    return EventTransformation.this.core.allSubVertexes(it).contains(finalChild);
                                }
                            };
                            Region region = (Region)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)parent.getRegions(), (Functions.Function1)_function));
                            _builder_5.newLineIfNotEmpty();
                            String _regionMethodName = this.core.getRegionMethodName(region);
                            _builder_5.append(_regionMethodName);
                            _builder_5.append("(");
                            String _vertexMacroName = this.core.getVertexMacroName((Vertex)child);
                            _builder_5.append(_vertexMacroName);
                            _builder_5.append(");");
                            _builder_5.newLineIfNotEmpty();
                        }
                        ret = _builder_5.toString();
                    } else {
                        Vertex _target_4 = t.getTarget();
                        boolean _contains_1 = TransformationUtil.transitiveSubStates((State)((State)_target_4)).contains(s);
                        if (_contains_1) {
                            Vertex _target_5 = t.getTarget();
                            parent = (State)_target_5;
                            final State finalChild_1 = child = s;
                            StringConcatenation _builder_6 = new StringConcatenation();
                            String _generateExitingSubStates_1 = this.core.generateExitingSubStates(s, false);
                            _builder_6.append(_generateExitingSubStates_1);
                            _builder_6.newLineIfNotEmpty();
                            String _transitionEffect_1 = TransformationUtil.getTransitionEffect((Transition)t);
                            _builder_6.append(_transitionEffect_1);
                            _builder_6.newLineIfNotEmpty();
                            Vertex _target_6 = t.getTarget();
                            if (_target_6 instanceof FinalState) {
                                Region _container_1 = t.getTarget().getContainer();
                                boolean _equals_3 = Objects.equal((Object)_container_1, (Object)this.core.topRegion);
                                if (_equals_3) {
                                    _builder_6.append("activeStateID");
                                    _builder_6.append(" = ");
                                    _builder_6.append("STATE_MAX");
                                    _builder_6.append(";");
                                    _builder_6.newLineIfNotEmpty();
                                } else {
                                    _builder_6.append("states");
                                    _builder_6.append("[");
                                    String _upperCase_3 = t.getTarget().getContainer().getState().getName().toUpperCase();
                                    _builder_6.append(_upperCase_3);
                                    _builder_6.append("_ID].");
                                    _builder_6.append("actives");
                                    _builder_6.append("[");
                                    int _indexOf_2 = t.getTarget().getContainer().getState().getRegions().indexOf((Object)t.getTarget().getContainer());
                                    _builder_6.append((Object)_indexOf_2);
                                    _builder_6.append("] = ");
                                    _builder_6.append("STATE_MAX");
                                    _builder_6.append(";");
                                    _builder_6.newLineIfNotEmpty();
                                }
                                _builder_6.append(callCompletionEvent);
                                _builder_6.append(";");
                                _builder_6.newLineIfNotEmpty();
                            } else {
                                Functions.Function1<Region, Boolean> _function_1 = new Functions.Function1<Region, Boolean>(){

                                    public Boolean apply(Region it) {
                                        return EventTransformation.this.core.allSubVertexes(it).contains(finalChild_1);
                                    }
                                };
                                Region region_1 = (Region)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)parent.getRegions(), (Functions.Function1)_function_1));
                                _builder_6.newLineIfNotEmpty();
                                String _regionMethodName_1 = this.core.getRegionMethodName(region_1);
                                _builder_6.append(_regionMethodName_1);
                                _builder_6.append("(");
                                String _initialMacroName = this.core.getInitialMacroName(region_1);
                                _builder_6.append(_initialMacroName);
                                _builder_6.append(");");
                                _builder_6.newLineIfNotEmpty();
                            }
                            ret = _builder_6.toString();
                        }
                    }
                } else {
                    StringConcatenation _builder_7 = new StringConcatenation();
                    String _generateBetweenVertex = this.core.pseudostateGenerator.generateBetweenVertex((Vertex)s, t.getTarget(), t);
                    _builder_7.append(_generateBetweenVertex);
                    ret = _builder_7.toString();
                }
            }
            StringConcatenation _builder_8 = new StringConcatenation();
            _builder_8.append("//from ");
            String _name = t.getSource().getName();
            _builder_8.append(_name);
            _builder_8.append(" to ");
            String _name_1 = t.getTarget().getName();
            _builder_8.append(_name_1);
            _builder_8.newLineIfNotEmpty();
            _builder_8.append("if (");
            if (hasGuard) {
                String _guard_1 = this.core.getGuard(t);
                _builder_8.append(_guard_1);
            } else {
                _builder_8.append("true");
            }
            _builder_8.append(") {");
            _builder_8.newLineIfNotEmpty();
            _builder_8.append(ret);
            _builder_8.newLineIfNotEmpty();
            _builder_8.append("systemState");
            _builder_8.append(" = SystemStateEnum_t.EVENT_CONSUMED;");
            _builder_8.newLineIfNotEmpty();
            String _generateTransitionCode = this.core.monitoringTransformation.generateTransitionCode(t);
            _builder_8.append(_generateTransitionCode);
            _builder_8.newLineIfNotEmpty();
            _builder_8.append("}");
            ret = _builder_8.toString();
        } else {
            StringConcatenation _builder_9 = new StringConcatenation();
            _builder_9.append("//from ");
            String _name_2 = t.getSource().getName();
            _builder_9.append(_name_2);
            _builder_9.append(" to ");
            String _name_3 = t.getTarget().getName();
            _builder_9.append(_name_3);
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("if (");
            if (hasGuard) {
                String _guard_2 = this.core.getGuard(t);
                _builder_9.append(_guard_2);
            } else {
                _builder_9.append("true");
            }
            _builder_9.append(") {");
            _builder_9.newLineIfNotEmpty();
            String _generateTransitionGraphCode = this.generateTransitionGraphCode(s, t);
            _builder_9.append(_generateTransitionGraphCode);
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("systemState");
            _builder_9.append(" = SystemStateEnum_t.EVENT_CONSUMED;");
            _builder_9.newLineIfNotEmpty();
            String _generateTransitionCode_1 = this.core.monitoringTransformation.generateTransitionCode(t);
            _builder_9.append(_generateTransitionCode_1);
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("}");
            ret = _builder_9.toString();
        }
        return ret;
    }

    public int getIndexOfUnguardTransition(Pseudostate junction) {
        Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition it) {
                Constraint _guard = it.getGuard();
                return _guard == null;
            }
        };
        Iterable unguards = IterableExtensions.filter((Iterable)junction.getOutgoings(), (Functions.Function1)_function);
        if (!IterableExtensions.isEmpty((Iterable)unguards)) {
            IterableExtensions.size((Iterable)unguards);
        }
        Transition unguard = (Transition)IterableExtensions.head((Iterable)unguards);
        return junction.getOutgoings().indexOf((Object)unguard);
    }

    public OpaqueBehavior createEventMethod(Event e, List<Transition> transitions) {
        OpaqueBehavior _xblockexpression = null;
        Operation evMethod = this.createEventMethod(TransformationUtil.eventName((Event)e), transitions);
        OpaqueBehavior _xifexpression = null;
        if (e instanceof CallEvent) {
            Behavior existingMethod;
            boolean _greaterThan;
            OpaqueBehavior _xblockexpression_1 = null;
            Operation op = ((CallEvent)e).getOperation();
            this.core.copyParameters(op, evMethod, false);
            EList params = evMethod.getOwnedParameters();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("process");
            String _eventName = TransformationUtil.eventName((Event)e);
            _builder.append(_eventName);
            _builder.append("(");
            boolean _hasElements = false;
            for (Parameter p : params) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _name = p.getName();
                _builder.append(_name);
            }
            _builder.append(");");
            String body = _builder.toString();
            String existingBody = null;
            int _size = op.getMethods().size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan && (existingBody = BehaviorUtil.body((Behavior)(existingMethod = (Behavior)op.getMethods().get(0)), (String)"JAVA")) == null) {
                existingBody = BehaviorUtil.body((Behavior)existingMethod, (String)"JAVA");
            }
            if (existingBody != null) {
                String _body = body;
                body = String.valueOf(_body) + "\n// original method code\n" + existingBody;
            }
            _xifexpression = _xblockexpression_1 = this.core.createOpaqueBehavior(this.superContext, op, body);
        } else {
            Object _xifexpression_1 = null;
            if (e instanceof SignalEvent) {
                boolean _tripleNotEquals;
                Object _xblockexpression_2 = null;
                String _name = ((SignalEvent)e).getName();
                String _plus = "send" + _name;
                Operation send = this.superContext.createOwnedOperation(_plus, null, null);
                Object _xifexpression_2 = null;
                Signal _signal = ((SignalEvent)e).getSignal();
                boolean bl = _tripleNotEquals = _signal != null;
                if (_tripleNotEquals) {
                    _xifexpression_2 = null;
                }
                _xifexpression_1 = _xblockexpression_2 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String generateTransitionGraphCode(State s, Transition t) {
        TransitionGraph graph = this.core.calculateTransitionGraphs(s, t);
        Vertex _target = t.getTarget();
        Pseudostate target = (Pseudostate)_target;
        Functions.Function1<Pseudostate, Boolean> _function = new Functions.Function1<Pseudostate, Boolean>(){

            public Boolean apply(Pseudostate it) {
                PseudostateKind _kind = it.getKind();
                return Objects.equal((Object)_kind, (Object)PseudostateKind.JUNCTION_LITERAL);
            }
        };
        List junctions = IterableExtensions.toList((Iterable)IterableExtensions.filter(graph.P, (Functions.Function1)_function));
        Pseudostate join = null;
        PseudostateKind _kind = target.getKind();
        boolean _equals = Objects.equal((Object)_kind, (Object)PseudostateKind.JOIN_LITERAL);
        if (_equals) {
            join = target;
        }
        if (join != null && this.joins.contains(join)) {
            StringConcatenation _builder = new StringConcatenation();
            return _builder.toString();
        }
        this.joins.add(join);
        StringConcatenation _builder_1 = new StringConcatenation();
        String ret = _builder_1.toString();
        ArrayList<Vertex> exits = new ArrayList<Vertex>();
        ArrayList<Vertex> enters = new ArrayList<Vertex>();
        this.calculateExitsEnters(t, exits, enters);
        Vertex cpEx = (Vertex)IterableExtensions.last(exits);
        Vertex cpEn = (Vertex)IterableExtensions.last(enters);
        StringConcatenation _builder_2 = new StringConcatenation();
        for (Pseudostate junction : junctions) {
            String _name = junction.getName();
            _builder_2.append(_name);
            _builder_2.append(" = ");
            int _indexOfUnguardTransition = this.getIndexOfUnguardTransition(junction);
            _builder_2.append((Object)_indexOfUnguardTransition);
            _builder_2.append(";");
            _builder_2.newLineIfNotEmpty();
            Functions.Function1<Transition, Boolean> _function_1 = new Functions.Function1<Transition, Boolean>(){

                public Boolean apply(Transition it) {
                    Constraint _guard = it.getGuard();
                    return _guard != null;
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)junction.getOutgoings(), (Functions.Function1)_function_1);
            boolean _hasElements = false;
            for (Transition tr : _filter) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder_2.appendImmediate((Object)" else ", "");
                }
                _builder_2.append("if (");
                String _guard = this.core.getGuard(tr);
                _builder_2.append(_guard);
                _builder_2.append(") {");
                _builder_2.newLineIfNotEmpty();
                _builder_2.append("\t");
                String _name_1 = junction.getName();
                _builder_2.append(_name_1, "\t");
                _builder_2.append(" = ");
                int _indexOf = junction.getOutgoings().indexOf((Object)tr);
                _builder_2.append((Object)_indexOf, "\t");
                _builder_2.append(";");
                _builder_2.newLineIfNotEmpty();
                _builder_2.append("}");
                _builder_2.newLine();
            }
        }
        _builder_2.append(ret);
        _builder_2.newLineIfNotEmpty();
        if (cpEx instanceof State) {
            String _generateExitingSubStates = this.core.generateExitingSubStates((State)cpEx, true);
            _builder_2.append(_generateExitingSubStates);
            _builder_2.newLineIfNotEmpty();
        }
        if (join != null) {
            _builder_2.append("//TODO: concurrency");
            _builder_2.newLine();
            EList _incomings = join.getIncomings();
            for (Transition in : _incomings) {
                String _transitionEffect = TransformationUtil.getTransitionEffect((Transition)in);
                _builder_2.append(_transitionEffect);
                _builder_2.newLineIfNotEmpty();
            }
        } else {
            String _transitionEffect_1 = TransformationUtil.getTransitionEffect((Transition)t);
            _builder_2.append(_transitionEffect_1);
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("\t\t");
        }
        String bodyInside = _builder_2.toString();
        Vertex innermost = (Vertex)IterableExtensions.head(enters);
        if (innermost instanceof State) {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append(bodyInside);
            _builder_3.newLineIfNotEmpty();
            if (innermost instanceof FinalState) {
                Region _container = ((FinalState)innermost).getContainer();
                boolean _equals_1 = Objects.equal((Object)_container, (Object)this.core.topRegion);
                if (_equals_1) {
                    _builder_3.append("activeStateID");
                    _builder_3.append(" = ");
                    _builder_3.append("STATE_MAX");
                    _builder_3.append(";");
                    _builder_3.newLineIfNotEmpty();
                } else {
                    _builder_3.append("states");
                    _builder_3.append("[");
                    _builder_3.append("activeStateID");
                    _builder_3.append("].");
                    _builder_3.append("actives");
                    _builder_3.append("[");
                    int _indexOf_1 = ((FinalState)innermost).getContainer().getState().getRegions().indexOf((Object)((FinalState)innermost).getContainer());
                    _builder_3.append((Object)_indexOf_1);
                    _builder_3.append("] = ");
                    _builder_3.append("STATE_MAX");
                    _builder_3.append(";");
                    _builder_3.newLineIfNotEmpty();
                    String _generateCompletionCall = this.core.generateCompletionCall((State)innermost);
                    _builder_3.append(_generateCompletionCall);
                    _builder_3.newLineIfNotEmpty();
                }
            } else {
                String _generateEnteringOnSubVertex = this.core.generateEnteringOnSubVertex((State)cpEn, innermost);
                _builder_3.append(_generateEnteringOnSubVertex);
                _builder_3.newLineIfNotEmpty();
                _builder_3.append("\t\t\t");
            }
            bodyInside = _builder_3.toString();
        } else {
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append(bodyInside);
            _builder_4.newLineIfNotEmpty();
            if (cpEn instanceof State) {
                String _generateEnteringOnSubVertex_1 = this.core.generateEnteringOnSubVertex((State)cpEn, innermost);
                _builder_4.append(_generateEnteringOnSubVertex_1);
                _builder_4.newLineIfNotEmpty();
            } else {
                String _generatePseudo = this.core.pseudostateGenerator.generatePseudo((Pseudostate)innermost);
                _builder_4.append(_generatePseudo);
                _builder_4.newLineIfNotEmpty();
                _builder_4.append("\t\t\t");
            }
            bodyInside = _builder_4.toString();
        }
        StringConcatenation _builder_5 = new StringConcatenation();
        if (join != null) {
            _builder_5.append("if (");
            Functions.Function1<Transition, Vertex> _function_2 = new Functions.Function1<Transition, Vertex>(){

                public Vertex apply(Transition it) {
                    return it.getSource();
                }
            };
            List _map = ListExtensions.map((List)join.getIncomings(), (Functions.Function1)_function_2);
            boolean _hasElements_1 = false;
            for (Vertex src : _map) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder_5.appendImmediate((Object)" && ", "");
                }
                _builder_5.append("(");
                _builder_5.append("states");
                _builder_5.append("[");
                String _upperCase = src.getContainer().getState().getName().toUpperCase();
                _builder_5.append(_upperCase);
                _builder_5.append("_ID].");
                _builder_5.append("actives");
                _builder_5.append("[");
                int _indexOf_2 = src.getContainer().getState().getRegions().indexOf((Object)src.getContainer());
                _builder_5.append((Object)_indexOf_2);
                _builder_5.append("] == ");
                String _upperCase_1 = src.getName().toUpperCase();
                _builder_5.append(_upperCase_1);
                _builder_5.append("_ID)");
            }
            _builder_5.append(") {");
            _builder_5.newLineIfNotEmpty();
        }
        _builder_5.append("\t");
        _builder_5.append(bodyInside, "\t");
        _builder_5.newLineIfNotEmpty();
        if (join != null) {
            _builder_5.append("}");
            _builder_5.newLine();
        }
        ret = _builder_5.toString();
        return ret;
    }

    public boolean calculateExitsEnters(Transition t, List<Vertex> exits, List<Vertex> enters) {
        boolean _xblockexpression = false;
        ArrayList<Object> tp1 = new ArrayList<Object>();
        tp1.addAll(this.core.getTransitiveParentStates(t.getSource()));
        tp1.add(0, t.getSource());
        ArrayList<Object> tp2 = new ArrayList<Object>();
        tp2.addAll(this.core.getTransitiveParentStates(t.getTarget()));
        tp2.add(0, t.getTarget());
        Vertex bound1 = null;
        Vertex bound2 = null;
        for (final Vertex vertex : tp1) {
            Functions.Function1<Vertex, Boolean> _function = new Functions.Function1<Vertex, Boolean>(){

                public Boolean apply(Vertex it) {
                    Region _container = it.getContainer();
                    Region _container_1 = vertex.getContainer();
                    return Objects.equal((Object)_container, (Object)_container_1);
                }
            };
            Vertex tp = (Vertex)IterableExtensions.head((Iterable)IterableExtensions.filter(tp2, (Functions.Function1)_function));
            if (bound1 != null || bound2 != null || tp == null) continue;
            bound1 = vertex;
            bound2 = tp;
        }
        int n = tp1.indexOf(bound1);
        int index2 = tp2.indexOf(bound2);
        exits.addAll(tp1.subList(0, n + 1));
        _xblockexpression = enters.addAll(tp2.subList(0, index2 + 1));
        return _xblockexpression;
    }
}

