/**
 * Copyright (c) 2016 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *  Van Cam Pham        <VanCam.PHAM@cea.fr>
 *  Shuai Li (CEA LIST) <shuai.li@cea.fr> - Bug 530251
 */
package org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.CppGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ref;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.CDefinitions;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.SM2ClassesTransformationCore;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.TransitionGraph;
import org.eclipse.papyrus.designer.transformation.library.statemachine.SMCodeGeneratorConstants;
import org.eclipse.papyrus.designer.transformation.library.statemachine.SMCommon;
import org.eclipse.papyrus.designer.transformation.library.statemachine.TransformationUtil;
import org.eclipse.papyrus.designer.transformation.library.xtend.BehaviorUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.TransitionKind;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class EventTransformation {
  @Extension
  protected CDefinitions cdefs;
  
  private SM2ClassesTransformationCore core;
  
  private org.eclipse.uml2.uml.Class superContext;
  
  private List<Pseudostate> joins = new ArrayList<Pseudostate>();
  
  public EventTransformation(final SM2ClassesTransformationCore core) {
    this.core = core;
    this.superContext = core.superContext;
  }
  
  public List<Event> getDeferredEvents(final State s) {
    final Function1<Trigger, Event> _function = new Function1<Trigger, Event>() {
      @Override
      public Event apply(final Trigger it) {
        return it.getEvent();
      }
    };
    return IterableExtensions.<Event>toList(ListExtensions.<Trigger, Event>map(s.getDeferrableTriggers(), _function));
  }
  
  public String completionEventCheck(final String eventName, final String stateId) {
    boolean _equals = Objects.equal(eventName, "CompletionEvent");
    if (_equals) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append(" ");
      _builder.append("&& (currentEvent->associatedState == ");
      _builder.append(stateId, " ");
      _builder.append(")");
      return _builder.toString();
    }
    StringConcatenation _builder_1 = new StringConcatenation();
    return _builder_1.toString();
  }
  
  public Operation createEventMethod(final String eventName, final List<Transition> transitions) {
    Operation method = this.superContext.createOwnedOperation(("process" + eventName), null, null);
    final Function1<Transition, Vertex> _function = new Function1<Transition, Vertex>() {
      @Override
      public Vertex apply(final Transition it) {
        return it.getSource();
      }
    };
    final List<State> tempSources = IterableExtensions.<State>toList(Iterables.<State>filter(ListExtensions.<Transition, Vertex>map(transitions, _function), State.class));
    final ArrayList<State> sources = new ArrayList<State>();
    final Consumer<State> _function_1 = new Consumer<State>() {
      @Override
      public void accept(final State it) {
        boolean _contains = sources.contains(it);
        boolean _not = (!_contains);
        if (_not) {
          sources.add(it);
        }
      }
    };
    tempSources.forEach(_function_1);
    final Map<State, List<State>> map = new HashMap<State, List<State>>();
    for (final State source : sources) {
      State _state = source.getContainer().getState();
      boolean _tripleNotEquals = (_state != null);
      if (_tripleNotEquals) {
        boolean _containsKey = map.containsKey(source.getContainer().getState());
        boolean _not = (!_containsKey);
        if (_not) {
          State _state_1 = source.getContainer().getState();
          ArrayList<State> _arrayList = new ArrayList<State>();
          map.put(_state_1, _arrayList);
        }
        map.get(source.getContainer().getState()).add(source);
      }
    }
    List<State> arraySet = IterableExtensions.<State>toList(map.keySet());
    int size = arraySet.size();
    for (int i = 0; (i < size); i++) {
      for (int j = (i + 1); (j < size); j++) {
        int _calculateDepth = SMCommon.calculateDepth(this.core.topRegion, arraySet.get(i));
        int _calculateDepth_1 = SMCommon.calculateDepth(this.core.topRegion, arraySet.get(j));
        boolean _lessEqualsThan = (_calculateDepth <= _calculateDepth_1);
        if (_lessEqualsThan) {
          State tmp = arraySet.remove(j);
          arraySet.add(i, tmp);
        }
      }
    }
    List<State> rootSourceStates = SMCommon.getRootStates(this.core.topRegion, sources);
    final ArrayList<Transition> passeds = new ArrayList<Transition>();
    final Function1<CallEvent, Boolean> _function_2 = new Function1<CallEvent, Boolean>() {
      @Override
      public Boolean apply(final CallEvent it) {
        String _eventName = TransformationUtil.eventName(it);
        return Boolean.valueOf(Objects.equal(_eventName, eventName));
      }
    };
    int _size = IterableExtensions.size(IterableExtensions.<CallEvent>filter(this.core.callEvents, _function_2));
    boolean isCallEvent = (_size > 0);
    StringConcatenation _builder = new StringConcatenation();
    {
      if (isCallEvent) {
        String _upperCase = this.superContext.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_GET_CONTROL");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR);
    _builder.append(" = statemachine::SystemStateEnum_t::EVENT_PROCESSING;");
    _builder.newLineIfNotEmpty();
    {
      for(final State s : arraySet) {
        {
          boolean _isOrthogonal = s.isOrthogonal();
          if (_isOrthogonal) {
            {
              List<State> _actualStateList = this.getActualStateList(map.get(s), transitions);
              for(final State sub : _actualStateList) {
                {
                  final Function1<Transition, Boolean> _function_3 = new Function1<Transition, Boolean>() {
                    @Override
                    public Boolean apply(final Transition it) {
                      Vertex _source = it.getSource();
                      return Boolean.valueOf(Objects.equal(_source, sub));
                    }
                  };
                  final Function1<Transition, Boolean> _function_4 = new Function1<Transition, Boolean>() {
                    @Override
                    public Boolean apply(final Transition it) {
                      boolean _contains = passeds.contains(it);
                      return Boolean.valueOf((!_contains));
                    }
                  };
                  int _size_1 = IterableExtensions.size(IterableExtensions.<Transition>filter(IterableExtensions.<Transition>filter(transitions, _function_3), _function_4));
                  boolean _greaterThan = (_size_1 > 0);
                  if (_greaterThan) {
                    {
                      if ((Objects.equal(eventName, "CompletionEvent") && (IterableExtensions.size(IterableExtensions.<Transition>filter(transitions, new Function1<Transition, Boolean>() {
                        @Override
                        public Boolean apply(final Transition it) {
                          return Boolean.valueOf(((Objects.equal(it.getSource(), sub) && (it.getTarget() instanceof Pseudostate)) && Objects.equal(((Pseudostate) it.getTarget()).getKind(), PseudostateKind.JOIN_LITERAL)));
                        }
                      })) > 0))) {
                        final Function1<Transition, Boolean> _function_5 = new Function1<Transition, Boolean>() {
                          @Override
                          public Boolean apply(final Transition it) {
                            return Boolean.valueOf(((Objects.equal(it.getSource(), sub) && (it.getTarget() instanceof Pseudostate)) && Objects.equal(((Pseudostate) it.getTarget()).getKind(), PseudostateKind.JOIN_LITERAL)));
                          }
                        };
                        Iterable<Transition> trans = IterableExtensions.<Transition>filter(transitions, _function_5);
                        _builder.newLineIfNotEmpty();
                        final Function1<Transition, Boolean> _function_6 = new Function1<Transition, Boolean>() {
                          @Override
                          public Boolean apply(final Transition it) {
                            boolean _contains = EventTransformation.this.joins.contains(it.getTarget());
                            return Boolean.valueOf((!_contains));
                          }
                        };
                        final Function1<Transition, Vertex> _function_7 = new Function1<Transition, Vertex>() {
                          @Override
                          public Vertex apply(final Transition it) {
                            return it.getTarget();
                          }
                        };
                        Vertex join = IterableExtensions.<Vertex>head(IterableExtensions.<Transition, Vertex>map(IterableExtensions.<Transition>filter(trans, _function_6), _function_7));
                        _builder.newLineIfNotEmpty();
                        final Function1<Transition, Vertex> _function_8 = new Function1<Transition, Vertex>() {
                          @Override
                          public Vertex apply(final Transition it) {
                            return it.getSource();
                          }
                        };
                        List<Vertex> sourcesOfJoin = ListExtensions.<Transition, Vertex>map(join.getIncomings(), _function_8);
                        _builder.newLineIfNotEmpty();
                        _builder.append("if (");
                        {
                          boolean _hasElements = false;
                          for(final Vertex src : sourcesOfJoin) {
                            if (!_hasElements) {
                              _hasElements = true;
                            } else {
                              _builder.appendImmediate(" || ", "");
                            }
                            _builder.append("(currentEvent->associatedState == ");
                            String _upperCase_1 = src.getName().toUpperCase();
                            _builder.append(_upperCase_1);
                            _builder.append("_ID)");
                          }
                        }
                        _builder.append(") {");
                        _builder.newLineIfNotEmpty();
                        {
                          final Function1<Transition, Boolean> _function_9 = new Function1<Transition, Boolean>() {
                            @Override
                            public Boolean apply(final Transition it) {
                              Vertex _source = it.getSource();
                              return Boolean.valueOf(Objects.equal(_source, sub));
                            }
                          };
                          final Function1<Transition, Boolean> _function_10 = new Function1<Transition, Boolean>() {
                            @Override
                            public Boolean apply(final Transition it) {
                              boolean _contains = passeds.contains(it);
                              return Boolean.valueOf((!_contains));
                            }
                          };
                          Iterable<Transition> _filter = IterableExtensions.<Transition>filter(IterableExtensions.<Transition>filter(transitions, _function_9), _function_10);
                          for(final Transition t : _filter) {
                            _builder.append("\t");
                            boolean _add = passeds.add(t);
                            _builder.append(_add, "\t");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            String _generateTransitionCode = this.generateTransitionCode(sub, t);
                            _builder.append(_generateTransitionCode, "\t");
                            _builder.newLineIfNotEmpty();
                          }
                        }
                        _builder.append("}");
                        _builder.newLine();
                      } else {
                        _builder.append("if (");
                        String _hasSubstatesAcceptingEvent = SMCommon.hasSubstatesAcceptingEvent(sub, sources);
                        _builder.append(_hasSubstatesAcceptingEvent);
                        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
                        _builder.append("[");
                        String _upperCase_2 = s.getName().toUpperCase();
                        _builder.append(_upperCase_2);
                        _builder.append("_ID].");
                        _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
                        _builder.append("[");
                        int _regionNumber = SMCommon.getRegionNumber(this.core.topRegion, sub);
                        _builder.append(_regionNumber);
                        _builder.append("] == ");
                        String _upperCase_3 = sub.getName().toUpperCase();
                        _builder.append(_upperCase_3);
                        _builder.append("_ID");
                        String _upperCase_4 = sub.getName().toUpperCase();
                        String _plus = (_upperCase_4 + "_ID");
                        String _completionEventCheck = this.completionEventCheck(eventName, _plus);
                        _builder.append(_completionEventCheck);
                        _builder.append(") {");
                        _builder.newLineIfNotEmpty();
                        {
                          final Function1<Event, Boolean> _function_11 = new Function1<Event, Boolean>() {
                            @Override
                            public Boolean apply(final Event it) {
                              String _name = it.getName();
                              return Boolean.valueOf(Objects.equal(_name, eventName));
                            }
                          };
                          int _size_2 = IterableExtensions.size(IterableExtensions.<Event>filter(this.getDeferredEvents(sub), _function_11));
                          boolean _greaterThan_1 = (_size_2 > 0);
                          if (_greaterThan_1) {
                            _builder.append("\t");
                            _builder.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "\t");
                            _builder.append(" = statemachine::SystemStateEnum_t::EVENT_DEFERRED;");
                            _builder.newLineIfNotEmpty();
                          } else {
                            {
                              final Function1<Transition, Boolean> _function_12 = new Function1<Transition, Boolean>() {
                                @Override
                                public Boolean apply(final Transition it) {
                                  Vertex _source = it.getSource();
                                  return Boolean.valueOf(Objects.equal(_source, sub));
                                }
                              };
                              final Function1<Transition, Boolean> _function_13 = new Function1<Transition, Boolean>() {
                                @Override
                                public Boolean apply(final Transition it) {
                                  boolean _contains = passeds.contains(it);
                                  return Boolean.valueOf((!_contains));
                                }
                              };
                              Iterable<Transition> _filter_1 = IterableExtensions.<Transition>filter(IterableExtensions.<Transition>filter(transitions, _function_12), _function_13);
                              for(final Transition t_1 : _filter_1) {
                                _builder.append("\t");
                                boolean _add_1 = passeds.add(t_1);
                                _builder.append(_add_1, "\t");
                                _builder.newLineIfNotEmpty();
                                _builder.append("\t");
                                String _generateTransitionCode_1 = this.generateTransitionCode(sub, t_1);
                                _builder.append(_generateTransitionCode_1, "\t");
                                _builder.newLineIfNotEmpty();
                              }
                            }
                          }
                        }
                        _builder.append("}");
                        _builder.newLine();
                      }
                    }
                  }
                }
              }
            }
          } else {
            {
              List<State> _get = map.get(s);
              boolean _hasElements_1 = false;
              for(final State sub_1 : _get) {
                if (!_hasElements_1) {
                  _hasElements_1 = true;
                } else {
                  _builder.appendImmediate(" else ", "");
                }
                _builder.append("if (");
                String _hasSubstatesAcceptingEvent_1 = SMCommon.hasSubstatesAcceptingEvent(sub_1, sources);
                _builder.append(_hasSubstatesAcceptingEvent_1);
                _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
                _builder.append("[");
                String _upperCase_5 = s.getName().toUpperCase();
                _builder.append(_upperCase_5);
                _builder.append("_ID].");
                _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
                _builder.append("[0] == ");
                String _upperCase_6 = sub_1.getName().toUpperCase();
                _builder.append(_upperCase_6);
                _builder.append("_ID");
                String _upperCase_7 = sub_1.getName().toUpperCase();
                String _plus_1 = (_upperCase_7 + "_ID");
                String _completionEventCheck_1 = this.completionEventCheck(eventName, _plus_1);
                _builder.append(_completionEventCheck_1);
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                {
                  final Function1<Event, Boolean> _function_14 = new Function1<Event, Boolean>() {
                    @Override
                    public Boolean apply(final Event it) {
                      String _name = it.getName();
                      return Boolean.valueOf(Objects.equal(_name, eventName));
                    }
                  };
                  int _size_3 = IterableExtensions.size(IterableExtensions.<Event>filter(this.getDeferredEvents(sub_1), _function_14));
                  boolean _greaterThan_2 = (_size_3 > 0);
                  if (_greaterThan_2) {
                    _builder.append("\t");
                    _builder.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "\t");
                    _builder.append(" = statemachine::SystemStateEnum_t::EVENT_DEFERRED;");
                    _builder.newLineIfNotEmpty();
                  } else {
                    _builder.append("\t");
                    final Function1<Transition, Boolean> _function_15 = new Function1<Transition, Boolean>() {
                      @Override
                      public Boolean apply(final Transition it) {
                        return Boolean.valueOf((Objects.equal(it.getSource(), sub_1) && (it.getGuard() != null)));
                      }
                    };
                    Iterable<Transition> hasGuards = IterableExtensions.<Transition>filter(transitions, _function_15);
                    _builder.newLineIfNotEmpty();
                    {
                      final Function1<Transition, Boolean> _function_16 = new Function1<Transition, Boolean>() {
                        @Override
                        public Boolean apply(final Transition it) {
                          return Boolean.valueOf((Objects.equal(it.getSource(), sub_1) && (it.getGuard() != null)));
                        }
                      };
                      Iterable<Transition> _filter_2 = IterableExtensions.<Transition>filter(transitions, _function_16);
                      boolean _hasElements_2 = false;
                      for(final Transition t_2 : _filter_2) {
                        if (!_hasElements_2) {
                          _hasElements_2 = true;
                        } else {
                          _builder.appendImmediate(" else ", "\t");
                        }
                        _builder.append("\t");
                        String _generateTransitionCode_2 = this.generateTransitionCode(sub_1, t_2);
                        _builder.append(_generateTransitionCode_2, "\t");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    {
                      boolean _isEmpty = IterableExtensions.isEmpty(hasGuards);
                      if (_isEmpty) {
                        _builder.append("\t");
                        final Function1<Transition, Boolean> _function_17 = new Function1<Transition, Boolean>() {
                          @Override
                          public Boolean apply(final Transition it) {
                            return Boolean.valueOf((Objects.equal(it.getSource(), sub_1) && (it.getGuard() == null)));
                          }
                        };
                        String _generateTransitionCode_3 = this.generateTransitionCode(sub_1, IterableExtensions.<Transition>head(IterableExtensions.<Transition>filter(transitions, _function_17)));
                        _builder.append(_generateTransitionCode_3, "\t");
                        _builder.newLineIfNotEmpty();
                      } else {
                        final Function1<Transition, Boolean> _function_18 = new Function1<Transition, Boolean>() {
                          @Override
                          public Boolean apply(final Transition it) {
                            return Boolean.valueOf((Objects.equal(it.getSource(), sub_1) && (it.getGuard() == null)));
                          }
                        };
                        Transition _head = IterableExtensions.<Transition>head(IterableExtensions.<Transition>filter(transitions, _function_18));
                        boolean _tripleNotEquals_1 = (_head != null);
                        if (_tripleNotEquals_1) {
                          _builder.append("\t");
                          _builder.append("else {");
                          _builder.newLine();
                          _builder.append("\t");
                          _builder.append("\t");
                          final Function1<Transition, Boolean> _function_19 = new Function1<Transition, Boolean>() {
                            @Override
                            public Boolean apply(final Transition it) {
                              return Boolean.valueOf((Objects.equal(it.getSource(), sub_1) && (it.getGuard() == null)));
                            }
                          };
                          String _generateTransitionCode_4 = this.generateTransitionCode(sub_1, IterableExtensions.<Transition>head(IterableExtensions.<Transition>filter(transitions, _function_19)));
                          _builder.append(_generateTransitionCode_4, "\t\t");
                          _builder.newLineIfNotEmpty();
                          _builder.append("\t");
                          _builder.append("}");
                          _builder.newLine();
                        }
                      }
                    }
                  }
                }
                _builder.append("}");
                _builder.newLine();
              }
            }
          }
        }
      }
    }
    {
      int _size_4 = rootSourceStates.size();
      boolean _greaterThan_3 = (_size_4 > 0);
      if (_greaterThan_3) {
        _builder.append("if (");
        _builder.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR);
        _builder.append(" == statemachine::SystemStateEnum_t::EVENT_PROCESSING");
        String _completionEventCheck_2 = this.completionEventCheck(eventName, SMCodeGeneratorConstants.ACTIVE_ROOT_STATE_ID);
        _builder.append(_completionEventCheck_2);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("switch(");
        _builder.append(SMCodeGeneratorConstants.ACTIVE_ROOT_STATE_ID, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        {
          for(final State root : rootSourceStates) {
            _builder.append("\t\t");
            _builder.append("case ");
            String _upperCase_8 = root.getName().toUpperCase();
            _builder.append(_upperCase_8, "\t\t");
            _builder.append("_ID: ");
            _builder.newLineIfNotEmpty();
            {
              final Function1<Event, Boolean> _function_20 = new Function1<Event, Boolean>() {
                @Override
                public Boolean apply(final Event it) {
                  String _name = it.getName();
                  return Boolean.valueOf(Objects.equal(_name, eventName));
                }
              };
              int _size_5 = IterableExtensions.size(IterableExtensions.<Event>filter(this.getDeferredEvents(root), _function_20));
              boolean _greaterThan_4 = (_size_5 > 0);
              if (_greaterThan_4) {
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "\t\t\t");
                _builder.append(" = statemachine::SystemStateEnum_t::EVENT_DEFERRED;");
                _builder.newLineIfNotEmpty();
              } else {
                {
                  final Function1<Transition, Boolean> _function_21 = new Function1<Transition, Boolean>() {
                    @Override
                    public Boolean apply(final Transition it) {
                      Vertex _source = it.getSource();
                      return Boolean.valueOf(Objects.equal(_source, root));
                    }
                  };
                  Iterable<Transition> _filter_3 = IterableExtensions.<Transition>filter(transitions, _function_21);
                  boolean _hasElements_3 = false;
                  for(final Transition t_3 : _filter_3) {
                    if (!_hasElements_3) {
                      _hasElements_3 = true;
                    } else {
                      _builder.appendImmediate(" else ", "\t\t\t");
                    }
                    _builder.append("\t\t");
                    _builder.append("\t");
                    String _generateTransitionCode_5 = this.generateTransitionCode(root, t_3);
                    _builder.append(_generateTransitionCode_5, "\t\t\t");
                    _builder.newLineIfNotEmpty();
                  }
                }
              }
            }
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("break;");
            _builder.newLine();
          }
        }
        _builder.append("\t\t");
        _builder.append("default:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("//do nothing");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("break;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    {
      if (isCallEvent) {
        String _upperCase_9 = this.superContext.getName().toUpperCase();
        _builder.append(_upperCase_9);
        _builder.append("_RELEASE_CONTROL");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
      }
    }
    String body = _builder.toString();
    this.core.createOpaqueBehavior(this.superContext, method, body);
    return method;
  }
  
  private List<State> getActualStateList(final List<State> l, final List<Transition> trans) {
    final Function1<Transition, Boolean> _function = new Function1<Transition, Boolean>() {
      @Override
      public Boolean apply(final Transition it) {
        return Boolean.valueOf(((it.getTarget() instanceof Pseudostate) && Objects.equal(((Pseudostate) it.getTarget()).getKind(), PseudostateKind.JOIN_LITERAL)));
      }
    };
    Iterable<Transition> transComingToJoin = IterableExtensions.<Transition>filter(trans, _function);
    final ArrayList<State> ret = new ArrayList<State>();
    ret.addAll(l);
    int _size = IterableExtensions.size(transComingToJoin);
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      final ArrayList<Pseudostate> joins = new ArrayList<Pseudostate>();
      final Function1<Transition, Vertex> _function_1 = new Function1<Transition, Vertex>() {
        @Override
        public Vertex apply(final Transition it) {
          return it.getTarget();
        }
      };
      final Consumer<Pseudostate> _function_2 = new Consumer<Pseudostate>() {
        @Override
        public void accept(final Pseudostate it) {
          boolean _contains = joins.contains(it);
          boolean _not = (!_contains);
          if (_not) {
            joins.add(it);
          }
        }
      };
      Iterables.<Pseudostate>filter(IterableExtensions.<Transition, Vertex>map(transComingToJoin, _function_1), Pseudostate.class).forEach(_function_2);
      final Consumer<Pseudostate> _function_3 = new Consumer<Pseudostate>() {
        @Override
        public void accept(final Pseudostate it) {
          final Function1<Transition, Vertex> _function = new Function1<Transition, Vertex>() {
            @Override
            public Vertex apply(final Transition it) {
              return it.getSource();
            }
          };
          List<State> toRemoveds = IterableExtensions.<State>toList(Iterables.<State>filter(ListExtensions.<Transition, Vertex>map(it.getIncomings(), _function), State.class));
          toRemoveds.remove(IterableExtensions.<State>head(toRemoveds));
          ret.removeAll(toRemoveds);
        }
      };
      joins.forEach(_function_3);
    }
    return ret;
  }
  
  public String generateTransitionCode(final State s, final Transition t) {
    StringConcatenation _builder = new StringConcatenation();
    String ret = _builder.toString();
    Constraint _guard = t.getGuard();
    boolean hasGuard = (_guard != null);
    Vertex _target = t.getTarget();
    if ((_target instanceof State)) {
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("process");
      _builder_1.append(SMCodeGeneratorConstants.COMPLETION_EVENT);
      _builder_1.append("();");
      String callCompletionEvent = _builder_1.toString();
      Vertex _target_1 = t.getTarget();
      if ((_target_1 instanceof FinalState)) {
        State composite = t.getTarget().getContainer().getState();
        if ((composite == null)) {
          StringConcatenation _builder_2 = new StringConcatenation();
          callCompletionEvent = _builder_2.toString();
        } else {
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.append("if (");
          {
            EList<Region> _regions = composite.getRegions();
            boolean _hasElements = false;
            for(final Region r : _regions) {
              if (!_hasElements) {
                _hasElements = true;
              } else {
                _builder_3.appendImmediate(" && ", "");
              }
              _builder_3.append("(");
              _builder_3.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
              _builder_3.append("[");
              String _upperCase = composite.getName().toUpperCase();
              _builder_3.append(_upperCase);
              _builder_3.append("_ID].");
              _builder_3.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
              _builder_3.append("[");
              int _indexOf = composite.getRegions().indexOf(r);
              _builder_3.append(_indexOf);
              _builder_3.append("] == ");
              _builder_3.append(SMCodeGeneratorConstants.STATE_MAX);
              _builder_3.append(")");
            }
          }
          _builder_3.append(") {");
          _builder_3.newLineIfNotEmpty();
          _builder_3.append("\t");
          _builder_3.append(SMCodeGeneratorConstants.EVENT_QUEUE, "\t");
          _builder_3.append(".push(statemachine::EventPriority_t::PRIORITY_1, NULL, COMPLETIONEVENT_ID, statemachine::COMPLETION_EVENT, ");
          String _upperCase_1 = composite.getName().toUpperCase();
          _builder_3.append(_upperCase_1, "\t");
          _builder_3.append("_ID);");
          _builder_3.newLineIfNotEmpty();
          _builder_3.append("}");
          callCompletionEvent = _builder_3.toString();
        }
      }
      TransitionKind _kind = t.getKind();
      boolean _equals = Objects.equal(_kind, TransitionKind.INTERNAL_LITERAL);
      if (_equals) {
        StringConcatenation _builder_4 = new StringConcatenation();
        {
          Behavior _effect = t.getEffect();
          boolean _tripleNotEquals = (_effect != null);
          if (_tripleNotEquals) {
            Behavior _effect_1 = t.getEffect();
            String _head = IterableExtensions.<String>head(((OpaqueBehavior) _effect_1).getBodies());
            _builder_4.append(_head);
            _builder_4.newLineIfNotEmpty();
          }
        }
        ret = _builder_4.toString();
      } else {
        TransitionKind _kind_1 = t.getKind();
        boolean _equals_1 = Objects.equal(_kind_1, TransitionKind.LOCAL_LITERAL);
        if (_equals_1) {
          State parent = null;
          State child = null;
          boolean _contains = TransformationUtil.transitiveSubStates(s).contains(t.getTarget());
          if (_contains) {
            parent = s;
            Vertex _target_2 = t.getTarget();
            child = ((State) _target_2);
            final State finalChild = child;
            StringConcatenation _builder_5 = new StringConcatenation();
            String _generateExitingSubStates = this.core.generateExitingSubStates(s, false);
            _builder_5.append(_generateExitingSubStates);
            _builder_5.newLineIfNotEmpty();
            String _transitionEffect = TransformationUtil.getTransitionEffect(t);
            _builder_5.append(_transitionEffect);
            _builder_5.newLineIfNotEmpty();
            {
              Vertex _target_3 = t.getTarget();
              if ((_target_3 instanceof FinalState)) {
                {
                  Region _container = t.getTarget().getContainer();
                  boolean _equals_2 = Objects.equal(_container, this.core.topRegion);
                  if (_equals_2) {
                    _builder_5.append(SMCodeGeneratorConstants.ACTIVE_ROOT_STATE_ID);
                    _builder_5.append(" = ");
                    _builder_5.append(SMCodeGeneratorConstants.STATE_MAX);
                    _builder_5.append(";");
                    _builder_5.newLineIfNotEmpty();
                  } else {
                    _builder_5.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
                    _builder_5.append("[");
                    String _upperCase_2 = t.getTarget().getContainer().getState().getName().toUpperCase();
                    _builder_5.append(_upperCase_2);
                    _builder_5.append("_ID].");
                    _builder_5.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
                    _builder_5.append("[");
                    int _indexOf_1 = t.getTarget().getContainer().getState().getRegions().indexOf(t.getTarget().getContainer());
                    _builder_5.append(_indexOf_1);
                    _builder_5.append("] = ");
                    _builder_5.append(SMCodeGeneratorConstants.STATE_MAX);
                    _builder_5.append(";");
                    _builder_5.newLineIfNotEmpty();
                  }
                }
                _builder_5.append(callCompletionEvent);
                _builder_5.append(";");
                _builder_5.newLineIfNotEmpty();
              } else {
                final Function1<Region, Boolean> _function = new Function1<Region, Boolean>() {
                  @Override
                  public Boolean apply(final Region it) {
                    return Boolean.valueOf(EventTransformation.this.core.allSubVertexes(it).contains(finalChild));
                  }
                };
                Region region = IterableExtensions.<Region>head(IterableExtensions.<Region>filter(parent.getRegions(), _function));
                _builder_5.newLineIfNotEmpty();
                String _regionMethodName = this.core.getRegionMethodName(region);
                _builder_5.append(_regionMethodName);
                _builder_5.append("(");
                String _vertexMacroName = this.core.getVertexMacroName(child);
                _builder_5.append(_vertexMacroName);
                _builder_5.append(");");
                _builder_5.newLineIfNotEmpty();
              }
            }
            ret = _builder_5.toString();
          } else {
            Vertex _target_4 = t.getTarget();
            boolean _contains_1 = TransformationUtil.transitiveSubStates(((State) _target_4)).contains(s);
            if (_contains_1) {
              Vertex _target_5 = t.getTarget();
              parent = ((State) _target_5);
              child = s;
              final State finalChild_1 = child;
              StringConcatenation _builder_6 = new StringConcatenation();
              String _generateExitingSubStates_1 = this.core.generateExitingSubStates(s, false);
              _builder_6.append(_generateExitingSubStates_1);
              _builder_6.newLineIfNotEmpty();
              String _transitionEffect_1 = TransformationUtil.getTransitionEffect(t);
              _builder_6.append(_transitionEffect_1);
              _builder_6.newLineIfNotEmpty();
              {
                Vertex _target_6 = t.getTarget();
                if ((_target_6 instanceof FinalState)) {
                  {
                    Region _container_1 = t.getTarget().getContainer();
                    boolean _equals_3 = Objects.equal(_container_1, this.core.topRegion);
                    if (_equals_3) {
                      _builder_6.append(SMCodeGeneratorConstants.ACTIVE_ROOT_STATE_ID);
                      _builder_6.append(" = ");
                      _builder_6.append(SMCodeGeneratorConstants.STATE_MAX);
                      _builder_6.append(";");
                      _builder_6.newLineIfNotEmpty();
                    } else {
                      _builder_6.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
                      _builder_6.append("[");
                      String _upperCase_3 = t.getTarget().getContainer().getState().getName().toUpperCase();
                      _builder_6.append(_upperCase_3);
                      _builder_6.append("_ID].");
                      _builder_6.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
                      _builder_6.append("[");
                      int _indexOf_2 = t.getTarget().getContainer().getState().getRegions().indexOf(t.getTarget().getContainer());
                      _builder_6.append(_indexOf_2);
                      _builder_6.append("] = ");
                      _builder_6.append(SMCodeGeneratorConstants.STATE_MAX);
                      _builder_6.append(";");
                      _builder_6.newLineIfNotEmpty();
                    }
                  }
                  _builder_6.append(callCompletionEvent);
                  _builder_6.append(";");
                  _builder_6.newLineIfNotEmpty();
                } else {
                  final Function1<Region, Boolean> _function_1 = new Function1<Region, Boolean>() {
                    @Override
                    public Boolean apply(final Region it) {
                      return Boolean.valueOf(EventTransformation.this.core.allSubVertexes(it).contains(finalChild_1));
                    }
                  };
                  Region region_1 = IterableExtensions.<Region>head(IterableExtensions.<Region>filter(parent.getRegions(), _function_1));
                  _builder_6.newLineIfNotEmpty();
                  String _regionMethodName_1 = this.core.getRegionMethodName(region_1);
                  _builder_6.append(_regionMethodName_1);
                  _builder_6.append("(");
                  String _initialMacroName = this.core.getInitialMacroName(region_1);
                  _builder_6.append(_initialMacroName);
                  _builder_6.append(");");
                  _builder_6.newLineIfNotEmpty();
                }
              }
              ret = _builder_6.toString();
            }
          }
        } else {
          StringConcatenation _builder_7 = new StringConcatenation();
          String _generateBetweenVertex = this.core.pseudostateGenerator.generateBetweenVertex(s, t.getTarget(), t);
          _builder_7.append(_generateBetweenVertex);
          ret = _builder_7.toString();
        }
      }
      StringConcatenation _builder_8 = new StringConcatenation();
      _builder_8.append("//from ");
      String _name = t.getSource().getName();
      _builder_8.append(_name);
      _builder_8.append(" to ");
      String _name_1 = t.getTarget().getName();
      _builder_8.append(_name_1);
      _builder_8.newLineIfNotEmpty();
      _builder_8.append("if (");
      {
        if (hasGuard) {
          String _guard_1 = this.core.getGuard(t);
          _builder_8.append(_guard_1);
        } else {
          _builder_8.append("true");
        }
      }
      _builder_8.append(") {");
      _builder_8.newLineIfNotEmpty();
      _builder_8.append(ret);
      _builder_8.newLineIfNotEmpty();
      _builder_8.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR);
      _builder_8.append(" = statemachine::SystemStateEnum_t::EVENT_CONSUMED;");
      _builder_8.newLineIfNotEmpty();
      String _generateTransitionCode = this.core.monitoringTransformation.generateTransitionCode(t);
      _builder_8.append(_generateTransitionCode);
      _builder_8.newLineIfNotEmpty();
      _builder_8.append("}");
      ret = _builder_8.toString();
    } else {
      StringConcatenation _builder_9 = new StringConcatenation();
      _builder_9.append("//from ");
      String _name_2 = t.getSource().getName();
      _builder_9.append(_name_2);
      _builder_9.append(" to ");
      String _name_3 = t.getTarget().getName();
      _builder_9.append(_name_3);
      _builder_9.newLineIfNotEmpty();
      _builder_9.append("if (");
      {
        if (hasGuard) {
          String _guard_2 = this.core.getGuard(t);
          _builder_9.append(_guard_2);
        } else {
          _builder_9.append("true");
        }
      }
      _builder_9.append(") {");
      _builder_9.newLineIfNotEmpty();
      String _generateTransitionGraphCode = this.generateTransitionGraphCode(s, t);
      _builder_9.append(_generateTransitionGraphCode);
      _builder_9.newLineIfNotEmpty();
      _builder_9.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR);
      _builder_9.append(" = statemachine::SystemStateEnum_t::EVENT_CONSUMED;");
      _builder_9.newLineIfNotEmpty();
      String _generateTransitionCode_1 = this.core.monitoringTransformation.generateTransitionCode(t);
      _builder_9.append(_generateTransitionCode_1);
      _builder_9.newLineIfNotEmpty();
      _builder_9.append("}");
      ret = _builder_9.toString();
    }
    return ret;
  }
  
  public int getIndexOfUnguardTransition(final Pseudostate junction) {
    final Function1<Transition, Boolean> _function = new Function1<Transition, Boolean>() {
      @Override
      public Boolean apply(final Transition it) {
        Constraint _guard = it.getGuard();
        return Boolean.valueOf((_guard == null));
      }
    };
    Iterable<Transition> unguards = IterableExtensions.<Transition>filter(junction.getOutgoings(), _function);
    if ((IterableExtensions.isEmpty(unguards) || (IterableExtensions.size(unguards) > 1))) {
    }
    Transition unguard = IterableExtensions.<Transition>head(unguards);
    return junction.getOutgoings().indexOf(unguard);
  }
  
  public OpaqueBehavior createEventMethod(final Event e, final List<Transition> transitions) {
    OpaqueBehavior _xblockexpression = null;
    {
      Operation evMethod = this.createEventMethod(TransformationUtil.eventName(e), transitions);
      OpaqueBehavior _xifexpression = null;
      if ((e instanceof CallEvent)) {
        OpaqueBehavior _xblockexpression_1 = null;
        {
          final Operation op = ((CallEvent) e).getOperation();
          SMCommon.copyParameters(op, evMethod, false);
          final EList<Parameter> params = evMethod.getOwnedParameters();
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("this->process");
          String _eventName = TransformationUtil.eventName(e);
          _builder.append(_eventName);
          _builder.append("(");
          {
            boolean _hasElements = false;
            for(final Parameter p : params) {
              if (!_hasElements) {
                _hasElements = true;
              } else {
                _builder.appendImmediate(", ", "");
              }
              String _name = p.getName();
              _builder.append(_name);
            }
          }
          _builder.append(");");
          String body = _builder.toString();
          String existingBody = null;
          int _size = op.getMethods().size();
          boolean _greaterThan = (_size > 0);
          if (_greaterThan) {
            final Behavior existingMethod = op.getMethods().get(0);
            existingBody = BehaviorUtil.body(existingMethod, "C++");
            if ((existingBody == null)) {
              existingBody = BehaviorUtil.body(existingMethod, "C/C++");
            }
          }
          if ((existingBody != null)) {
            String _body = body;
            body = (_body + ("\n// original method code\n" + existingBody));
          }
          _xblockexpression_1 = this.core.createOpaqueBehavior(this.superContext, op, body);
        }
        _xifexpression = _xblockexpression_1;
      } else {
        OpaqueBehavior _xifexpression_1 = null;
        if ((e instanceof SignalEvent)) {
          OpaqueBehavior _xblockexpression_2 = null;
          {
            String _name = ((SignalEvent)e).getName();
            String _plus = ("send" + _name);
            Operation send = this.superContext.createOwnedOperation(_plus, null, null);
            Signal _signal = ((SignalEvent)e).getSignal();
            boolean _tripleNotEquals = (_signal != null);
            if (_tripleNotEquals) {
              StereotypeUtil.apply(send.createOwnedParameter("sig", ((SignalEvent)e).getSignal()), Ref.class);
              StereotypeUtil.apply(evMethod.createOwnedParameter("sig", ((SignalEvent)e).getSignal()), Ref.class);
            }
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(SMCodeGeneratorConstants.EVENT_QUEUE);
            _builder.append(".push(statemachine::EventPriority_t::PRIORITY_2, ");
            {
              Signal _signal_1 = ((SignalEvent)e).getSignal();
              boolean _tripleNotEquals_1 = (_signal_1 != null);
              if (_tripleNotEquals_1) {
                _builder.append("&sig");
              } else {
                _builder.append("NULL");
              }
            }
            _builder.append(", ");
            String _upperCase = ((SignalEvent)e).getName().toUpperCase();
            _builder.append(_upperCase);
            _builder.append("_ID, statemachine::EventType_t::SIGNAL_EVENT, 0");
            {
              Signal _signal_2 = ((SignalEvent)e).getSignal();
              boolean _tripleNotEquals_2 = (_signal_2 != null);
              if (_tripleNotEquals_2) {
                _builder.append(", sizeof(");
                String _cppQualifiedName = CppGenUtils.cgu(this.superContext).cppQualifiedName(((SignalEvent)e).getSignal());
                _builder.append(_cppQualifiedName);
                _builder.append(")");
              }
            }
            _builder.append(");");
            _xblockexpression_2 = this.core.createOpaqueBehavior(this.superContext, send, _builder.toString());
          }
          _xifexpression_1 = _xblockexpression_2;
        }
        _xifexpression = _xifexpression_1;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  public String generateTransitionGraphCode(final State s, final Transition t) {
    TransitionGraph graph = this.core.calculateTransitionGraphs(s, t);
    Vertex _target = t.getTarget();
    Pseudostate target = ((Pseudostate) _target);
    final Function1<Pseudostate, Boolean> _function = new Function1<Pseudostate, Boolean>() {
      @Override
      public Boolean apply(final Pseudostate it) {
        PseudostateKind _kind = it.getKind();
        return Boolean.valueOf(Objects.equal(_kind, PseudostateKind.JUNCTION_LITERAL));
      }
    };
    List<Pseudostate> junctions = IterableExtensions.<Pseudostate>toList(IterableExtensions.<Pseudostate>filter(graph.P, _function));
    Pseudostate join = null;
    PseudostateKind _kind = target.getKind();
    boolean _equals = Objects.equal(_kind, PseudostateKind.JOIN_LITERAL);
    if (_equals) {
      join = target;
    }
    if (((join != null) && this.joins.contains(join))) {
      StringConcatenation _builder = new StringConcatenation();
      return _builder.toString();
    }
    this.joins.add(join);
    StringConcatenation _builder_1 = new StringConcatenation();
    String ret = _builder_1.toString();
    ArrayList<Vertex> exits = new ArrayList<Vertex>();
    ArrayList<Vertex> enters = new ArrayList<Vertex>();
    this.calculateExitsEnters(t, exits, enters);
    Vertex cpEx = IterableExtensions.<Vertex>last(exits);
    Vertex cpEn = IterableExtensions.<Vertex>last(enters);
    StringConcatenation _builder_2 = new StringConcatenation();
    {
      for(final Pseudostate junction : junctions) {
        String _name = junction.getName();
        _builder_2.append(_name);
        _builder_2.append(" = ");
        int _indexOfUnguardTransition = this.getIndexOfUnguardTransition(junction);
        _builder_2.append(_indexOfUnguardTransition);
        _builder_2.append(";");
        _builder_2.newLineIfNotEmpty();
        {
          final Function1<Transition, Boolean> _function_1 = new Function1<Transition, Boolean>() {
            @Override
            public Boolean apply(final Transition it) {
              Constraint _guard = it.getGuard();
              return Boolean.valueOf((_guard != null));
            }
          };
          Iterable<Transition> _filter = IterableExtensions.<Transition>filter(junction.getOutgoings(), _function_1);
          boolean _hasElements = false;
          for(final Transition tr : _filter) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder_2.appendImmediate(" else ", "");
            }
            _builder_2.append("if (");
            String _guard = this.core.getGuard(tr);
            _builder_2.append(_guard);
            _builder_2.append(") {");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("\t");
            String _name_1 = junction.getName();
            _builder_2.append(_name_1, "\t");
            _builder_2.append(" = ");
            int _indexOf = junction.getOutgoings().indexOf(tr);
            _builder_2.append(_indexOf, "\t");
            _builder_2.append(";");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("}");
            _builder_2.newLine();
          }
        }
      }
    }
    _builder_2.append(ret);
    _builder_2.newLineIfNotEmpty();
    {
      if ((cpEx instanceof State)) {
        String _generateExitingSubStates = this.core.generateExitingSubStates(((State) cpEx), true);
        _builder_2.append(_generateExitingSubStates);
        _builder_2.newLineIfNotEmpty();
      }
    }
    {
      if ((join != null)) {
        _builder_2.append("//TODO: concurrency");
        _builder_2.newLine();
        {
          EList<Transition> _incomings = join.getIncomings();
          for(final Transition in : _incomings) {
            String _transitionEffect = TransformationUtil.getTransitionEffect(in);
            _builder_2.append(_transitionEffect);
            _builder_2.newLineIfNotEmpty();
          }
        }
      } else {
        String _transitionEffect_1 = TransformationUtil.getTransitionEffect(t);
        _builder_2.append(_transitionEffect_1);
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("\t\t");
      }
    }
    String bodyInside = _builder_2.toString();
    Vertex innermost = IterableExtensions.<Vertex>head(enters);
    if ((innermost instanceof State)) {
      StringConcatenation _builder_3 = new StringConcatenation();
      _builder_3.append(bodyInside);
      _builder_3.newLineIfNotEmpty();
      {
        if ((innermost instanceof FinalState)) {
          {
            Region _container = ((FinalState)innermost).getContainer();
            boolean _equals_1 = Objects.equal(_container, this.core.topRegion);
            if (_equals_1) {
              _builder_3.append(SMCodeGeneratorConstants.ACTIVE_ROOT_STATE_ID);
              _builder_3.append(" = ");
              _builder_3.append(SMCodeGeneratorConstants.STATE_MAX);
              _builder_3.append(";");
              _builder_3.newLineIfNotEmpty();
            } else {
              _builder_3.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
              _builder_3.append("[");
              _builder_3.append(SMCodeGeneratorConstants.ACTIVE_ROOT_STATE_ID);
              _builder_3.append("].");
              _builder_3.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
              _builder_3.append("[");
              int _indexOf_1 = ((FinalState)innermost).getContainer().getState().getRegions().indexOf(((FinalState)innermost).getContainer());
              _builder_3.append(_indexOf_1);
              _builder_3.append("] = ");
              _builder_3.append(SMCodeGeneratorConstants.STATE_MAX);
              _builder_3.append(";");
              _builder_3.newLineIfNotEmpty();
              String _generateCompletionCall = this.core.generateCompletionCall(((State)innermost));
              _builder_3.append(_generateCompletionCall);
              _builder_3.newLineIfNotEmpty();
            }
          }
        } else {
          CharSequence _generateEnteringOnSubVertex = this.core.generateEnteringOnSubVertex(((State) cpEn), innermost);
          _builder_3.append(_generateEnteringOnSubVertex);
          _builder_3.newLineIfNotEmpty();
          _builder_3.append("\t\t\t");
        }
      }
      bodyInside = _builder_3.toString();
    } else {
      StringConcatenation _builder_4 = new StringConcatenation();
      _builder_4.append(bodyInside);
      _builder_4.newLineIfNotEmpty();
      {
        if ((cpEn instanceof State)) {
          CharSequence _generateEnteringOnSubVertex_1 = this.core.generateEnteringOnSubVertex(((State)cpEn), innermost);
          _builder_4.append(_generateEnteringOnSubVertex_1);
          _builder_4.newLineIfNotEmpty();
        } else {
          String _generatePseudo = this.core.pseudostateGenerator.generatePseudo(((Pseudostate) innermost));
          _builder_4.append(_generatePseudo);
          _builder_4.newLineIfNotEmpty();
          _builder_4.append("\t\t\t");
        }
      }
      bodyInside = _builder_4.toString();
    }
    StringConcatenation _builder_5 = new StringConcatenation();
    {
      if ((join != null)) {
        _builder_5.append("if (");
        {
          final Function1<Transition, Vertex> _function_2 = new Function1<Transition, Vertex>() {
            @Override
            public Vertex apply(final Transition it) {
              return it.getSource();
            }
          };
          List<Vertex> _map = ListExtensions.<Transition, Vertex>map(join.getIncomings(), _function_2);
          boolean _hasElements_1 = false;
          for(final Vertex src : _map) {
            if (!_hasElements_1) {
              _hasElements_1 = true;
            } else {
              _builder_5.appendImmediate(" && ", "");
            }
            _builder_5.append("(");
            _builder_5.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
            _builder_5.append("[");
            String _upperCase = src.getContainer().getState().getName().toUpperCase();
            _builder_5.append(_upperCase);
            _builder_5.append("_ID].");
            _builder_5.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
            _builder_5.append("[");
            int _indexOf_2 = src.getContainer().getState().getRegions().indexOf(src.getContainer());
            _builder_5.append(_indexOf_2);
            _builder_5.append("] == ");
            String _upperCase_1 = src.getName().toUpperCase();
            _builder_5.append(_upperCase_1);
            _builder_5.append("_ID)");
          }
        }
        _builder_5.append(") {");
        _builder_5.newLineIfNotEmpty();
      }
    }
    _builder_5.append("\t");
    _builder_5.append(bodyInside, "\t");
    _builder_5.newLineIfNotEmpty();
    {
      if ((join != null)) {
        _builder_5.append("}");
        _builder_5.newLine();
      }
    }
    ret = _builder_5.toString();
    return ret;
  }
  
  public boolean calculateExitsEnters(final Transition t, final List<Vertex> exits, final List<Vertex> enters) {
    boolean _xblockexpression = false;
    {
      ArrayList<Vertex> tp1 = new ArrayList<Vertex>();
      tp1.addAll(SMCommon.getTransitiveParentStates(t.getSource()));
      tp1.add(0, t.getSource());
      ArrayList<Vertex> tp2 = new ArrayList<Vertex>();
      tp2.addAll(SMCommon.getTransitiveParentStates(t.getTarget()));
      tp2.add(0, t.getTarget());
      Vertex bound1 = null;
      Vertex bound2 = null;
      for (final Vertex v : tp1) {
        {
          final Function1<Vertex, Boolean> _function = new Function1<Vertex, Boolean>() {
            @Override
            public Boolean apply(final Vertex it) {
              Region _container = it.getContainer();
              Region _container_1 = v.getContainer();
              return Boolean.valueOf(Objects.equal(_container, _container_1));
            }
          };
          Vertex tp = IterableExtensions.<Vertex>head(IterableExtensions.<Vertex>filter(tp2, _function));
          if ((((bound1 == null) && (bound2 == null)) && (tp != null))) {
            bound1 = v;
            bound2 = tp;
          }
        }
      }
      int index1 = tp1.indexOf(bound1);
      int index2 = tp2.indexOf(bound2);
      exits.addAll(tp1.subList(0, (index1 + 1)));
      _xblockexpression = enters.addAll(tp2.subList(0, (index2 + 1)));
    }
    return _xblockexpression;
  }
}
