/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.ucm.profile.UCMProfile.ucm_interactions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PortElementKind implements Enumerator
{
    PROVIDED(0, "PROVIDED", "PROVIDED"),
    REQUIRED(1, "REQUIRED", "REQUIRED");

    public static final int PROVIDED_VALUE = 0;
    public static final int REQUIRED_VALUE = 1;
    private static final PortElementKind[] VALUES_ARRAY;
    public static final List<PortElementKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PortElementKind[]{PROVIDED, REQUIRED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PortElementKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PortElementKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PortElementKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PortElementKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PortElementKind get(int value) {
        switch (value) {
            case 0: {
                return PROVIDED;
            }
            case 1: {
                return REQUIRED;
            }
        }
        return null;
    }

    private PortElementKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

