/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.library.xtend;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.transformation.base.utils.OperationUtils;
import org.eclipse.papyrus.designer.transformation.library.xtend.CppUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class Marshalling {
    public static CharSequence marshall(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// now marshall in and inout parameters via ASN.1");
        _builder.newLine();
        EList _parametersInInout = OperationUtils.parametersInInout((Operation)operation);
        for (Parameter parameter : _parametersInInout) {
            CharSequence _marshall = Marshalling.marshall(parameter);
            _builder.append((Object)_marshall, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static CharSequence marshallOutInout(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// now marshall out and inout parameters via ASN.1");
        _builder.newLine();
        EList _parametersOutInout = OperationUtils.parametersOutInout((Operation)operation);
        for (Parameter parameter : _parametersOutInout) {
            CharSequence _marshall = Marshalling.marshall(parameter);
            _builder.append((Object)_marshall, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static CharSequence marshall(Parameter parameter) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        Type _type = parameter.getType();
        CharSequence _cppType = CppUtils.cppType(_type);
        _builder.append((Object)_cppType, "\t");
        _builder.append(" varName_ASN = ");
        String _name = parameter.getName();
        _builder.append(_name, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("BEncAsnContent (&pBuffer, &varName_ASN);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence unmarshall(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        EList _parametersInInout = OperationUtils.parametersInInout((Operation)operation);
        List _reverse = ListExtensions.reverse((List)_parametersInInout);
        for (Parameter parameter : _reverse) {
            CharSequence _unmarshall = Marshalling.unmarshall(parameter);
            _builder.append((Object)_unmarshall, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static CharSequence unmarshallOutInout(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        EList _parametersOutInout = OperationUtils.parametersOutInout((Operation)operation);
        List _reverse = ListExtensions.reverse((List)_parametersOutInout);
        for (Parameter parameter : _reverse) {
            CharSequence _unmarshall = Marshalling.unmarshall(parameter);
            _builder.append((Object)_unmarshall, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static CharSequence unmarshall(Parameter parameter) {
        StringConcatenation _builder = new StringConcatenation();
        Type _type = parameter.getType();
        CharSequence _cppType = CppUtils.cppType(_type);
        _builder.append((Object)_cppType, "");
        _builder.append(" ");
        String _name = parameter.getName();
        _builder.append(_name, "");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        Type _type_1 = parameter.getType();
        CharSequence _cppType_1 = CppUtils.cppType(_type_1);
        _builder.append((Object)_cppType_1, "\t");
        _builder.append(" varName_ASN;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("BDecAsnContent (&pBuffer, &varName_ASN);");
        _builder.newLine();
        _builder.append("\t");
        String _name_1 = parameter.getName();
        _builder.append(_name_1, "\t");
        _builder.append(" = varName_ASN;");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence cppParameterStorage(Class clazz) {
        StringConcatenation _builder = new StringConcatenation();
        EList _ownedOperations = clazz.getOwnedOperations();
        for (Operation operation : _ownedOperations) {
            _builder.append("struct Op_");
            String _name = operation.getName();
            _builder.append(_name, "");
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            EList _ownedParameters = operation.getOwnedParameters();
            for (Parameter parameter : _ownedParameters) {
                _builder.append("\t");
                Type _type = parameter.getType();
                CharSequence _cppType = CppUtils.cppType(_type);
                _builder.append((Object)_cppType, "\t");
                _builder.append(" ");
                String _name_1 = parameter.getName();
                _builder.append(_name_1, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("} op_");
            String _name_2 = operation.getName();
            _builder.append(_name_2, "");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }
}

