/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.deployment.tools;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.SRM.SW_Concurrency.SwSchedulableResource;
import org.eclipse.papyrus.MARTE.MARTE_Foundations.Alloc.Allocate;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.uml.tools.utils.ConnectorUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Node;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.UMLPackage;

public class AllocUtils {
    public static final String startPortName = "start";
    public static final String startPortType = "IStart";

    public static EList<InstanceSpecification> getAllNodes(InstanceSpecification instance) {
        EList<InstanceSpecification> nodeList = AllocUtils.getNodes(instance);
        for (Slot slot : instance.getSlots()) {
            InstanceSpecification containedInstance;
            if (DepUtils.isShared(slot) || (containedInstance = DepUtils.getInstance(slot)) == null) continue;
            nodeList.addAll(AllocUtils.getAllNodes(containedInstance));
        }
        return nodeList;
    }

    public static EList<InstanceSpecification> getAllNodes(Collection<InstanceSpecification> instances) {
        UniqueEList nodeList = new UniqueEList();
        for (InstanceSpecification instance : instances) {
            nodeList.addAll(AllocUtils.getAllNodes(instance));
        }
        return nodeList;
    }

    public static Property getThreadAlloc(Property instanceAttribute) {
        for (DirectedRelationship relation : instanceAttribute.getSourceDirectedRelationships()) {
            Property target;
            Element targetElem;
            if (!StereotypeUtil.isApplied((Element)relation, Allocate.class) || relation.getTargets().size() != 1 || !((targetElem = (Element)relation.getTargets().get(0)) instanceof Property) || !StereotypeUtil.isApplied((Element)(target = (Property)targetElem).getType(), SwSchedulableResource.class)) continue;
            return target;
        }
        return null;
    }

    public static EList<InstanceSpecification> getAllNodesOrThreadsParent(InstanceSpecification instance) {
        EList<InstanceSpecification> nodeList = AllocUtils.getNodesOrThreads(instance);
        Package cdp = instance.getNearestPackage();
        for (NamedElement parentNE : cdp.getMembers()) {
            InstanceSpecification parentIS;
            if (!(parentNE instanceof InstanceSpecification) || !DepUtils.getContainedInstances(parentIS = (InstanceSpecification)parentNE).contains((Object)instance)) continue;
            nodeList.addAll(AllocUtils.getAllNodesOrThreadsParent(parentIS));
        }
        return nodeList;
    }

    public static InstanceSpecification getNode(InstanceSpecification instance) {
        EList<InstanceSpecification> nodeList = AllocUtils.getNodes(instance);
        if (nodeList.size() != 0) {
            return (InstanceSpecification)nodeList.get(0);
        }
        return null;
    }

    public static InstanceSpecification getNodeOrThread(InstanceSpecification instanceOrThread) {
        EList<InstanceSpecification> nodeList = AllocUtils.getNodesOrThreads(instanceOrThread);
        if (nodeList.size() != 0) {
            return (InstanceSpecification)nodeList.get(0);
        }
        return null;
    }

    public static EList<InstanceSpecification> getNodesOrThreads(InstanceSpecification instanceOrThread) {
        UniqueEList nodeList = new UniqueEList();
        for (DirectedRelationship relationship : instanceOrThread.getSourceDirectedRelationships(UMLPackage.eINSTANCE.getAbstraction())) {
            Abstraction abstraction = (Abstraction)relationship;
            if (!StereotypeUtil.isApplied((Element)abstraction, Allocate.class)) continue;
            for (Element target : abstraction.getTargets()) {
                if (!(target instanceof InstanceSpecification)) continue;
                nodeList.add((Object)((InstanceSpecification)target));
            }
        }
        return nodeList;
    }

    public static EList<InstanceSpecification> getNodes(InstanceSpecification instanceOrThread) {
        UniqueEList nodeList = new UniqueEList();
        EList<InstanceSpecification> nodeOrThreads = AllocUtils.getNodesOrThreads(instanceOrThread);
        for (InstanceSpecification nodeOrThread : nodeOrThreads) {
            Classifier nodeOrThreadC = DepUtils.getClassifier(nodeOrThread);
            if (StereotypeUtil.isApplied((Element)nodeOrThreadC, SwSchedulableResource.class)) {
                InstanceSpecification threadAlloc = AllocUtils.getNode(nodeOrThread);
                if (threadAlloc == null) continue;
                nodeList.add((Object)threadAlloc);
                continue;
            }
            nodeList.add((Object)nodeOrThread);
        }
        return nodeList;
    }

    public static EList<Node> updateAllocation(InstanceSpecification instance, InstanceSpecification oldNode, InstanceSpecification newNode) {
        UniqueEList nodeList = new UniqueEList();
        block0: for (Abstraction abstraction : instance.getSourceDirectedRelationships(UMLPackage.eINSTANCE.getAbstraction())) {
            if (!StereotypeUtil.isApplied((Element)abstraction, Allocate.class)) continue;
            EList suppliers = abstraction.getSuppliers();
            int index = 0;
            while (index < suppliers.size()) {
                if (suppliers.get(index) == oldNode) {
                    if (newNode == null) {
                        abstraction.destroy();
                        continue block0;
                    }
                    suppliers.set(index, (Object)newNode);
                    continue block0;
                }
                ++index;
            }
        }
        return nodeList;
    }

    public static EList<InstanceSpecification> getAllNodesForPort(InstanceSpecification instance, Port port) {
        EList<InstanceSpecification> nodeList = AllocUtils.getNodes(instance);
        Classifier composite = DepUtils.getClassifier(instance);
        if (composite instanceof Class) {
            Class compositeCL = (Class)composite;
            for (Slot slot : instance.getSlots()) {
                Property containedProperty = (Property)slot.getDefiningFeature();
                for (Connector connection : compositeCL.getOwnedConnectors()) {
                    ConnectorEnd end = ConnectorUtil.connEndForPart((Connector)connection, (Property)containedProperty);
                    if (end == null || !ConnectorUtil.connectsPort((Connector)connection, (Port)port)) continue;
                    Port containedPort = (Port)end.getRole();
                    nodeList.addAll(AllocUtils.getAllNodesForPort(DepUtils.getInstance(slot), containedPort));
                }
            }
        }
        return nodeList;
    }

    public static boolean allocate(InstanceSpecification instance, InstanceSpecification node) {
        Package cdp = (Package)instance.getOwner();
        Abstraction allocation = (Abstraction)cdp.createPackagedElement("allocate " + instance.getName() + " to " + node.getName(), UMLPackage.eINSTANCE.getAbstraction());
        if (StereotypeUtil.apply((Element)allocation, Allocate.class) == null) {
            allocation.destroy();
            return false;
        }
        allocation.getClients().add((Object)instance);
        allocation.getSuppliers().add((Object)node);
        return true;
    }

    public static void propagateNodesViaPort(InstanceSpecification instance, Port port, EList<InstanceSpecification> nodes) {
        if (instance == null) {
            return;
        }
        EList slots = instance.getSlots();
        Class composite = DepUtils.getImplementation(instance);
        for (InstanceSpecification node : nodes) {
            AllocUtils.allocate(instance, node);
        }
        if (composite != null && port != null) {
            Class compositeCL = composite;
            for (Slot slot : slots) {
                Property containedProperty = (Property)slot.getDefiningFeature();
                for (Connector connection : compositeCL.getOwnedConnectors()) {
                    ConnectorEnd end;
                    if (!ConnectorUtil.connectsPort((Connector)connection, (Port)port) || (end = ConnectorUtil.connEndForPart((Connector)connection, (Property)containedProperty)) == null) continue;
                    Port containedPort = (Port)end.getRole();
                    AllocUtils.propagateNodesViaPort(DepUtils.getInstance(slot), containedPort, nodes);
                }
            }
        }
    }

    public static Port getStartPort(Class component) {
        Port startPort;
        NamedElement startPortElem = ElementUtils.getNamedElementFromList((EList)component.getAllAttributes(), (String)startPortName);
        if (startPortElem instanceof Port && (startPort = (Port)startPortElem).getType().getName().equals(startPortType)) {
            return startPort;
        }
        return null;
    }
}

