/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.serializer;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.xtext.base.serializer.CommentSegmentSupport;
import org.eclipse.ocl.xtext.base.serializer.SerializationMetaData;
import org.eclipse.ocl.xtext.base.serializer.SerializationSegment;
import org.eclipse.ocl.xtext.base.serializer.UserElementAnalysis;
import org.eclipse.ocl.xtext.base.serializer.UserModelAnalysis;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.nodemodel.INode;

public class UserElementFormatter {
    protected final @NonNull INode node;
    protected final @NonNull AbstractElement compoundedGrammarElement;
    protected final @NonNull UserElementAnalysis elementAnalysis;
    protected final @NonNull SerializationMetaData serializationMetaData;

    public UserElementFormatter(@NonNull INode node, @NonNull AbstractElement compoundedGrammarElement, @NonNull UserModelAnalysis modelAnalysis, @NonNull EObject element) {
        this.node = node;
        this.compoundedGrammarElement = compoundedGrammarElement;
        this.elementAnalysis = modelAnalysis.getElementAnalysis(element);
        this.serializationMetaData = this.elementAnalysis.getSerializationMetaData();
    }

    public void addCommentSupport(@NonNull CommentSegmentSupport commentSegmentSupport) {
        this.elementAnalysis.getModelAnalysis().addCommentSupport(commentSegmentSupport);
    }

    public @NonNull EObject getElement() {
        return this.elementAnalysis.getEObject();
    }

    public @NonNull SerializationSegment @NonNull [] getInnerFormattingSegments() {
        @NonNull SerializationSegment[] innerFormattingSegments = this.serializationMetaData.getInnerFormattingSegments(this.compoundedGrammarElement);
        return innerFormattingSegments;
    }

    public @NonNull INode getNode() {
        return this.node;
    }

    public @NonNull SerializationSegment @NonNull [] getOuterFormattingSegments() {
        @NonNull SerializationSegment[] outerFormattingSegments = this.serializationMetaData.getOuterFormattingSegments(this.compoundedGrammarElement);
        return outerFormattingSegments;
    }

    public @NonNull SerializationSegment @NonNull [] getRuleFormattingSegments() {
        ParserRule parserRule = GrammarUtil.containingParserRule((EObject)this.compoundedGrammarElement);
        AbstractElement rootGrammarElement = parserRule.getAlternatives();
        assert (rootGrammarElement != null);
        return this.serializationMetaData.getInnerFormattingSegments(rootGrammarElement);
    }

    public @NonNull SerializationMetaData getSerializationMetaData() {
        return this.serializationMetaData;
    }
}

