/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.tests.TestFile;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.uml.UMLStandaloneSetup;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.ThreadLocalExecutor;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.basecs.RootPackageCS;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.xtext.resource.XtextResource;

public class SerializeTests
extends XtextTestCase {
    public static final @NonNull SerializeTestHelper DEFAULT_HELPER = new SerializeTestHelper(){};
    public static final @NonNull SerializeTestHelper FULL_SERIALIZATION_HELPER = new SerializeTestHelper(){

        @Override
        public void conditionAS(@NonNull ASResource asResource) {
            for (EObject eObject : new TreeIterable((Resource)asResource)) {
                if (!(eObject instanceof ExpressionInOCL)) continue;
                ((ExpressionInOCL)eObject).setBody(null);
            }
        }
    };
    public static final @NonNull SerializeTestHelper NO_VALIDATION = new SerializeTestHelper(){

        @Override
        public @NonNull String @NonNull [] asFirstValidationMessages() {
            return SUPPRESS_VALIDATION;
        }
    };

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        if (DEBUG_GC) {
            System.gc();
            System.runFinalization();
        }
        super.tearDown();
    }

    public void doSerialize(@NonNull URI inputURI, @NonNull SerializeTestHelper testHelper) throws Exception {
        this.doSerialize(inputURI, inputURI, testHelper);
    }

    public void doSerialize(@NonNull URI inputURI, @NonNull URI referenceURI, @NonNull SerializeTestHelper testHelper) throws Exception {
        String stem = inputURI.trimFileExtension().lastSegment();
        String outputName = String.valueOf(stem) + ".serialized.oclinecore";
        URI outputURI = this.getTestFileURI(outputName);
        OCL ocl1 = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        ResourceSet resourceSet1 = ocl1.getResourceSet();
        testHelper.initializeResourceSet(resourceSet1);
        Resource ecoreResource = this.loadEcore(resourceSet1, inputURI);
        XtextResource xtextResource1 = null;
        try {
            ASResource asResource = ocl1.ecore2as(ecoreResource);
            SerializeTests.assertNoResourceErrors("Normalisation failed", (Resource)asResource);
            @NonNull String @Nullable [] asValidationMessages = testHelper.asFirstValidationMessages();
            if (asValidationMessages != SUPPRESS_VALIDATION) {
                SerializeTests.assertValidationDiagnostics("Normalisation invalid 1", (Resource)asResource, asValidationMessages);
                @NonNull String @Nullable [] asReValidationMessages = testHelper.asFirstReValidationMessages();
                if (asReValidationMessages != SUPPRESS_VALIDATION) {
                    SerializeTests.assertValidationDiagnostics("Normalisation invalid 2", (Resource)asResource, asReValidationMessages);
                }
            }
            testHelper.conditionAS(asResource);
            xtextResource1 = SerializeTests.as2cs(ocl1, asResource, outputURI);
        }
        finally {
            ocl1.dispose();
            ocl1 = null;
        }
        ThreadLocalExecutor.resetEnvironmentFactory();
        OCL ocl2 = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        ResourceSet resourceSet2 = ocl2.getResourceSet();
        testHelper.initializeResourceSet(resourceSet2);
        BaseCSResource xtextResource2 = null;
        try {
            xtextResource2 = (BaseCSResource)resourceSet2.createResource(outputURI);
            assert (xtextResource2 != null);
            ocl2.getEnvironmentFactory().adapt((Notifier)xtextResource2);
            xtextResource2.load(null);
            String cs2asErrors = testHelper.cs2asErrorMessages();
            if (cs2asErrors != null) {
                String string = cs2asErrors.toString();
                SerializeTests.assertResourceErrors("Reload failed", (Resource)xtextResource2, string);
                if (string.length() > 0) {
                    return;
                }
            } else {
                SerializeTests.assertNoResourceErrors("Reload failed", (Resource)xtextResource2);
                SerializeTests.assertNoUnresolvedProxies("unresolved reload proxies", (Resource)xtextResource2);
            }
            String pivotName2 = String.valueOf(stem) + "2.ecore.oclas";
            URI pivotURI2 = this.getTestFileURI(pivotName2);
            Resource pivotResource2 = SerializeTests.cs2as((CSResource)xtextResource2, pivotURI2);
            String inputName2 = String.valueOf(stem) + "2.ecore";
            URI ecoreURI2 = this.getTestFileURI(inputName2);
            @NonNull String @Nullable [] asValidationMessages2 = testHelper.asSecondValidationMessages();
            Resource ecoreResource2 = SerializeTests.as2ecore(ocl2.getEnvironmentFactory(), pivotResource2, ecoreURI2, asValidationMessages2);
            Resource referenceResource = this.loadEcore(resourceSet2, referenceURI);
            testHelper.assertSameModel(referenceResource, ecoreResource2);
            testHelper.extraXtextResourceValidate(xtextResource2);
            return;
        }
        finally {
            if (xtextResource2 != null) {
                xtextResource2.eAdapters().remove((Object)ocl2.getEnvironmentFactory().adapt((Notifier)xtextResource2));
            }
            ocl2.dispose();
            ocl2 = null;
        }
    }

    public void doSerializeUML(@NonNull URI inputURI, @NonNull SerializeTestHelper testHelper) throws Exception {
        UMLPackage.eINSTANCE.getClass();
        OCLInternal ocl1 = OCLInternal.newInstance((ProjectManager)SerializeTests.getProjectMap(), null);
        ResourceSet resourceSet1 = ocl1.getResourceSet();
        UML2AS.initialize((ResourceSet)resourceSet1);
        Resource umlResource = this.loadUML(resourceSet1, inputURI);
        Object xtextResource = null;
        try {
            EnvironmentFactoryInternal environmentFactory1 = ocl1.getEnvironmentFactory();
            Resource resource = this.getPivotFromUML(environmentFactory1, umlResource, testHelper.asFirstValidationMessages());
        }
        finally {
            ocl1.dispose();
            ocl1 = null;
        }
    }

    protected Resource getPivotFromUML(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Resource umlResource, @NonNull String @NonNull [] asValidationMessages) throws ParserException {
        UML2AS uml2as = UML2AS.getAdapter((Resource)umlResource, (EnvironmentFactoryInternal)environmentFactory);
        Model pivotModel = uml2as.getASModel();
        Resource asResource = (Resource)ClassUtil.nonNullState((Object)pivotModel.eResource());
        SerializeTests.assertNoResourceErrors("Normalisation failed", asResource);
        SerializeTests.assertValidationDiagnostics("Normalisation invalid", asResource, asValidationMessages);
        return asResource;
    }

    protected @NonNull Resource loadEcore(@NonNull ResourceSet resourceSet, @NonNull URI inputURI) {
        Map uriMap = resourceSet.getURIConverter().getURIMap();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            uriMap.putAll(EcorePlugin.computePlatformURIMap((boolean)true));
        }
        Resource ecoreResource = (Resource)ClassUtil.nonNullState((Object)resourceSet.getResource(inputURI, true));
        this.mapOwnURI(ecoreResource);
        SerializeTests.assertNoResourceErrors("Load failed", ecoreResource);
        return ecoreResource;
    }

    protected @NonNull Resource loadUML(@NonNull ResourceSet resourceSet, @NonNull URI inputURI) {
        Resource umlResource = resourceSet.getResource(inputURI, true);
        this.mapOwnURI(umlResource);
        SerializeTests.assertNoResourceErrors("Load failed", umlResource);
        return umlResource;
    }

    public void testSerialize_Bug320689() throws Exception {
        this.doSerialize(SerializeTests.getTestModelURI("models/ecore/Bug320689.ecore"), DEFAULT_HELPER);
    }

    public void testSerialize_Bug323741() throws Exception {
        this.doSerialize(SerializeTests.getTestModelURI("models/ecore/Bug323741.ecore"), DEFAULT_HELPER);
    }

    public void testSerialize_Bug354336() throws Exception {
        this.doSerialize(SerializeTests.getTestModelURI("models/ecore/Bug354336.ecore"), SerializeTests.getTestModelURI("models/ecore/Bug354336.ecore"), DEFAULT_HELPER);
    }

    public void testSerialize_Bug362620() throws Exception {
        this.doSerialize(SerializeTests.getTestModelURI("models/ecore/Bug362620.ecore"), DEFAULT_HELPER);
    }

    public void testSerialize_Bug376488() throws Exception {
        this.doSerialize(SerializeTests.getTestModelURI("models/ecore/Bug376488.ecore"), SerializeTests.getTestModelURI("models/ecore/Bug376488.ecore"), NO_VALIDATION);
    }

    public void testSerialize_Bug382956() throws Exception {
        String testFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\" name=\"Bug382956\" nsURI=\"http://Bug382956\" nsPrefix=\"Bug382956\">\n  <eClassifiers xsi:type=\"ecore:EEnum\" name=\"ComparisonKind\">\n    <eLiterals name=\"EQ\" literal=\"=\"/>\n    <eLiterals name=\"GT\" value=\"1\" literal=\">\"/>\n    <eLiterals name=\"LT\" value=\"2\" literal=\"&lt;\"/>\n  </eClassifiers>\n  <eClassifiers xsi:type=\"ecore:EClass\" name=\"MyClass\">\n    <eStructuralFeatures xsi:type=\"ecore:EAttribute\" name=\"comparison\" eType=\"#//ComparisonKind\"\n        defaultValueLiteral=\"=\"/>\n  </eClassifiers>\n</ecore:EPackage>\n";
        TestFile ecoreFile = this.createOCLinEcoreFile("Bug382956.ecore", testFile);
        this.doSerialize(ecoreFile.getFileURI(), DEFAULT_HELPER);
    }

    public void testSerialize_Bug388282() throws Exception {
        String testFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\" name=\"rootPackage\" nsURI=\"http://www.example.com/rootPackage/1.0\"\n    nsPrefix=\"rootPackage\">\n  <eClassifiers xsi:type=\"ecore:EClass\" name=\"Element\" abstract=\"true\">\n    <eStructuralFeatures xsi:type=\"ecore:EAttribute\" name=\"name\" lowerBound=\"1\" eType=\"ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EString\"\n        defaultValueLiteral=\"\"/>\n  </eClassifiers>\n  <eSubpackages name=\"subPackage\" nsURI=\"http://www.example.com/subPackage/1.0\" nsPrefix=\"subPackage\">\n    <eClassifiers xsi:type=\"ecore:EClass\" name=\"Element\" abstract=\"true\" eSuperTypes=\"#//Element\"/>\n  </eSubpackages>\n</ecore:EPackage>\n\n";
        TestFile ecoreFile = this.createOCLinEcoreFile("Bug388282.ecore", testFile);
        this.doSerialize(ecoreFile.getFileURI(), DEFAULT_HELPER);
    }

    public void testSerialize_Bug397917() throws Exception {
        String testFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n   xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\" name=\"test1\" nsURI=\"http://test1/1.0\" nsPrefix=\"test1\">\n <eClassifiers xsi:type=\"ecore:EClass\" name=\"Model\">\n   <eStructuralFeatures xsi:type=\"ecore:EReference\" name=\"node\" upperBound=\"-1\" eType=\"#//Node\" containment=\"true\"/>\n   <eStructuralFeatures xsi:type=\"ecore:EReference\" name=\"link\" upperBound=\"-1\" eType=\"#//Link\" containment=\"true\"/>\n </eClassifiers>\n <eClassifiers xsi:type=\"ecore:EClass\" name=\"Node\">\n   <eStructuralFeatures xsi:type=\"ecore:EAttribute\" name=\"uuid\" eType=\"ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EString\" iD=\"true\"/>\n   <eStructuralFeatures xsi:type=\"ecore:EReference\" name=\"outgoing\" eType=\"#//Link\" eOpposite=\"#//Link/from\" eKeys=\"#//Link/uuid\"/>\n   <eStructuralFeatures xsi:type=\"ecore:EReference\" name=\"incoming\" eType=\"#//Link\" eOpposite=\"#//Link/to\" eKeys=\"#//Link/uuid\"/>\n </eClassifiers>\n <eClassifiers xsi:type=\"ecore:EClass\" name=\"Link\">\n   <eStructuralFeatures xsi:type=\"ecore:EAttribute\" name=\"uuid\" eType=\"ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EString\" defaultValueLiteral=\"\" iD=\"true\"/>\n   <eStructuralFeatures xsi:type=\"ecore:EReference\" name=\"from\" lowerBound=\"1\" eType=\"#//Node\" eOpposite=\"#//Node/outgoing\" eKeys=\"#//Node/uuid\"/>\n   <eStructuralFeatures xsi:type=\"ecore:EReference\" name=\"to\" lowerBound=\"1\" eType=\"#//Node\" eOpposite=\"#//Node/incoming\" eKeys=\"#//Node/uuid\"/>\n </eClassifiers>\n</ecore:EPackage>";
        TestFile ecoreFile = this.createOCLinEcoreFile("Bug397917.ecore", testFile);
        this.doSerialize(ecoreFile.getFileURI(), DEFAULT_HELPER);
    }

    public void testSerialize_Bug404493() throws Exception {
        String testFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\" name=\"company\" nsURI=\"http://www.eclipse.org/ocl/test/Pivot/Company.ecore\"\n    nsPrefix=\"co\">\n  <eAnnotations source=\"http://www.eclipse.org/emf/2002/Ecore\">\n    <details key=\"invocationDelegates\" value=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\"/>\n    <details key=\"settingDelegates\" value=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\"/>\n    <details key=\"validationDelegates\" value=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\"/>\n  </eAnnotations>\n  <eClassifiers xsi:type=\"ecore:EClass\" name=\"Employee\">\n    <eStructuralFeatures xsi:type=\"ecore:EAttribute\" name=\"name\" eType=\"ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EString\"/>\n    <eStructuralFeatures xsi:type=\"ecore:EAttribute\" name=\"hasNameAsAttribute\" eType=\"ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EBoolean\"\n        changeable=\"false\" volatile=\"true\" transient=\"true\" derived=\"true\">\n      <eAnnotations source=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\">\n        <details key=\"derivation\" value=\"name &lt;> null -- trailing comment\"/>\n      </eAnnotations>\n    </eStructuralFeatures>\n  </eClassifiers>\n</ecore:EPackage>\n";
        TestFile ecoreFile = this.createOCLinEcoreFile("Bug404493.ecore", testFile);
        this.doSerialize(ecoreFile.getFileURI(), new SerializeTestHelper(){

            @Override
            public void assertSameModel(@NonNull Resource expectedResource, @NonNull Resource actualResource) {
            }
        });
    }

    public void testSerialize_Bug425506() throws Exception {
        String testFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\" name=\"p\" nsURI=\"p\" nsPrefix=\"p\">\n  <eAnnotations source=\"http://www.eclipse.org/emf/2002/Ecore\">\n    <details key=\"invocationDelegates\" value=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\"/>\n    <details key=\"settingDelegates\" value=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\"/>\n    <details key=\"validationDelegates\" value=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\"/>\n  </eAnnotations>\n  <eAnnotations source=\"http://www.eclipse.org/OCL/Import\">\n    <details key=\"ecore\" value=\"http://www.eclipse.org/emf/2002/Ecore\"/>\n  </eAnnotations>\n  <eClassifiers xsi:type=\"ecore:EClass\" name=\"A\">\n    <eAnnotations source=\"http://www.eclipse.org/emf/2002/Ecore\">\n      <details key=\"constraints\" value=\"inv2\"/>\n    </eAnnotations>\n    <eAnnotations source=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\">\n      <details key=\"inv2\" value=\"true\"/>\n    </eAnnotations>\n    <eOperations name=\"f\">\n      <eAnnotations source=\"http://www.eclipse.org/emf/2002/GenModel\">\n        <details key=\"documentation\" value=\"function doc\"/>\n        <details key=\"body\" value=\"return 1;\"/>\n      </eAnnotations>\n    </eOperations>\n    <eOperations name=\"inv\" eType=\"ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EBoolean\">\n      <eAnnotations source=\"http://www.eclipse.org/emf/2002/GenModel\">\n        <details key=\"documentation\" value=\"invariant doc\"/>\n        <details key=\"body\" value=\"return 1;\"/>\n      </eAnnotations>\n      <eParameters name=\"diagnostics\" eType=\"ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EDiagnosticChain\"/>\n      <eParameters name=\"context\">\n        <eGenericType eClassifier=\"ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EMap\">\n          <eTypeArguments eClassifier=\"ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EJavaObject\"/>\n          <eTypeArguments eClassifier=\"ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EJavaObject\"/>\n        </eGenericType>\n      </eParameters>\n    </eOperations>\n  </eClassifiers>\n</ecore:EPackage>\n";
        TestFile ecoreFile = this.createOCLinEcoreFile("Bug425506.ecore", testFile);
        this.doSerialize(ecoreFile.getFileURI(), DEFAULT_HELPER);
    }

    public void testSerialize_Bug457043() throws Exception {
        String testFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\"\n    name=\"bug457043\" nsURI=\"http://bug/457043\" nsPrefix=\"bug\">\n  <eAnnotations source=\"http://www.eclipse.org/emf/2002/GenModel\">\n    <details key=\"documentation\"/>\n  </eAnnotations>\n</ecore:EPackage>\n";
        TestFile ecoreFile = this.createOCLinEcoreFile("Bug457043.ecore", testFile);
        this.doSerialize(ecoreFile.getFileURI(), DEFAULT_HELPER);
    }

    public void testSerialize_Bug463877() throws Exception {
        String testFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\" name=\"my\" nsURI=\"http://my\" nsPrefix=\"my\">\n  <eClassifiers xsi:type=\"ecore:EClass\" name=\"Node\">\n    <eStructuralFeatures xsi:type=\"ecore:EReference\"/>\n  </eClassifiers>\n</ecore:EPackage>\n";
        TestFile ecoreFile = this.createOCLinEcoreFile("Bug463877.ecore", testFile);
        this.doSerialize(ecoreFile.getFileURI(), new SerializeTestHelper(){

            @Override
            public void assertSameModel(@NonNull Resource expectedResource, @NonNull Resource actualResource) {
            }

            @Override
            public @NonNull String @NonNull [] asFirstValidationMessages() {
                return SUPPRESS_VALIDATION;
            }
        });
    }

    public void testSerialize_Bug464062() throws Exception {
        String testFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\" name=\"env\" nsURI=\"http://cs2as/tests/example2/env/1.0\" nsPrefix=\"env\">\n  <eClassifiers xsi:type=\"ecore:EClass\" name=\"Environment\">\n    <eOperations name=\"addElements\" eType=\"#//Environment\">\n      <eTypeParameters name=\"E\">\n        <eBounds eClassifier=\"#//Element\"/>\n      </eTypeParameters>\n      <eParameters name=\"elements\" upperBound=\"-1\">\n        <eGenericType eTypeParameter=\"#//Environment/addElements/E\"/>\n      </eParameters>\n    </eOperations>\n  </eClassifiers>\n  <eClassifiers xsi:type=\"ecore:EClass\" name=\"Element\" abstract=\"true\"/>\n</ecore:EPackage>\n";
        TestFile ecoreFile = this.createOCLinEcoreFile("Bug464062.ecore", testFile);
        this.doSerialize(ecoreFile.getFileURI(), DEFAULT_HELPER);
    }

    public void testSerialize_Bug516274() throws Exception {
        String testFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\" name=\"bug516274\" nsURI=\"http:/org/eclipse/ocl/examples/test/xtext/models/Bug516274.oclinecore\"\n    nsPrefix=\"my\">\n  <eClassifiers xsi:type=\"ecore:EClass\" name=\"Generic\" abstract=\"true\">\n    <eTypeParameters name=\"T\">\n      <eBounds eClassifier=\"#//Generic\">\n        <eTypeArguments eTypeParameter=\"#//Generic/T\"/>\n      </eBounds>\n    </eTypeParameters>\n  </eClassifiers>\n  <eClassifiers xsi:type=\"ecore:EClass\" name=\"Concrete\">\n    <eGenericSuperTypes eClassifier=\"#//Generic\">\n      <eTypeArguments eClassifier=\"#//Concrete\"/>\n    </eGenericSuperTypes>\n  </eClassifiers>\n</ecore:EPackage>\n";
        TestFile ecoreFile = this.createOCLinEcoreFile("Bug516274.ecore", testFile);
        this.doSerialize(ecoreFile.getFileURI(), DEFAULT_HELPER);
    }

    public void testSerialize_Bug516301() throws Exception {
        String testFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\" name=\"My\" nsURI=\"http://example.org/my\" nsPrefix=\"my\">\n  <eAnnotations source=\"http://www.eclipse.org/OCL/Import\">\n    <details key=\"ecore\" value=\"http://www.eclipse.org/emf/2002/Ecore\"/>\n  </eAnnotations>\n  <eAnnotations source=\"http://www.eclipse.org/emf/2002/Ecore\">\n    <details key=\"invocationDelegates\" value=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\"/>\n    <details key=\"settingDelegates\" value=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\"/>\n    <details key=\"validationDelegates\" value=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\"/>\n  </eAnnotations>\n  <eClassifiers xsi:type=\"ecore:EClass\" name=\"DocTest\">\n    <eOperations name=\"testJava\" lowerBound=\"1\" eType=\"ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EInt\">\n      <eAnnotations source=\"http://www.eclipse.org/emf/2002/GenModel\">\n        <details key=\"documentation\" value=\"Java Documentation\"/>\n        <details key=\"body\" value=\"return 1;\"/>\n      </eAnnotations>\n    </eOperations>\n    <eOperations name=\"testOCL\" lowerBound=\"1\" eType=\"ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EInt\">\n      <eAnnotations source=\"http://www.eclipse.org/emf/2002/GenModel\">\n        <details key=\"documentation\" value=\"OCL Documentation\"/>\n      </eAnnotations>\n      <eAnnotations source=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\">\n        <details key=\"body\" value=\"1\"/>\n      </eAnnotations>\n    </eOperations>\n  </eClassifiers>\n</ecore:EPackage>";
        TestFile ecoreFile = this.createOCLinEcoreFile("Bug516301.ecore", testFile);
        this.doSerialize(ecoreFile.getFileURI(), DEFAULT_HELPER);
    }

    public void testSerialize_Company() throws Exception {
        this.doSerialize(SerializeTests.getTestModelURI("models/ecore/Company.ecore"), SerializeTests.getTestModelURI("models/ecore/Company.reference.ecore"), DEFAULT_HELPER);
    }

    public void testSerialize_ConstraintMessages() throws Exception {
        this.doSerialize(SerializeTests.getTestModelURI("models/ecore/ConstraintMessages.ecore"), SerializeTests.getTestModelURI("models/ecore/ConstraintMessages.reference.ecore"), DEFAULT_HELPER);
    }

    public void testSerialize_Ecore() throws Exception {
        this.doSerialize(SerializeTests.getTestModelURI("models/ecore/Ecore.ecore"), DEFAULT_HELPER);
    }

    public void testSerialize_Expressions() throws Exception {
        String testFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\" name=\"b\" nsURI=\"bbb\" nsPrefix=\"bb\">\n  <eAnnotations source=\"http://www.eclipse.org/emf/2002/Ecore\">\n    <details key=\"invocationDelegates\" value=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\"/>\n    <details key=\"settingDelegates\" value=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\"/>\n    <details key=\"validationDelegates\" value=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\"/>\n  </eAnnotations>\n  <eClassifiers xsi:type=\"ecore:EClass\" name=\"Expressions\">\n    <eAnnotations source=\"http://www.eclipse.org/emf/2002/Ecore\">\n      <details key=\"constraints\" value=\"SimpleIf SingleElseIf DoubleElseIf MapIterators\"/>\n    </eAnnotations>\n    <eAnnotations source=\"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot\">\n      <details key=\"SimpleIf\" value=\"if true then 1 else 2 endif &lt;> 0\"/>\n      <details key=\"SingleElseIf\" value=\"if true then 1 elseif true then 2 else 3 endif &lt;> 0\"/>\n      <details key=\"DoubleElseIf\" value=\"if true then 1 elseif true then 2 elseif true then 3 else 4 endif &lt;> 0\"/>\n      <details key=\"MapIterators\" value=\"Map{1 &lt;- 1}-&gt;collect(v &lt;- k | v * k)-&gt;notEmpty()\"/>\n    </eAnnotations>\n  </eClassifiers>\n</ecore:EPackage>\n";
        TestFile ecoreFile = this.createOCLinEcoreFile("Expressions.ecore", testFile);
        this.doSerialize(ecoreFile.getFileURI(), DEFAULT_HELPER);
    }

    public void testSerialize_Imports() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)SerializeTests.getProjectMap());
        this.getTestFile("LittleModel.ecore", ocl, SerializeTests.getTestModelURI("models/ecore/LittleModel.ecore"));
        TestFile testFile = this.getTestFile("Imports.ecore", ocl, SerializeTests.getTestModelURI("models/ecore/Imports.ecore"));
        ocl.dispose();
        this.doSerialize(testFile.getFileURI(), new SerializeTestHelper(){

            @Override
            public void extraXtextResourceValidate(@NonNull BaseCSResource xtextResource) {
                RootPackageCS documentCS = (RootPackageCS)xtextResource.getContents().get(0);
                EList imports = documentCS.getOwnedImports();
                SerializeTests.assertEquals((String)"One import", (int)1, (int)imports.size());
            }
        });
    }

    public void testSerialize_Keys() throws Exception {
        this.doSerialize(SerializeTests.getTestModelURI("models/ecore/Keys.ecore"), DEFAULT_HELPER);
    }

    public void testSerialize_Names() throws Exception {
        this.doSerialize(SerializeTests.getTestModelURI("models/ecore/Names.ecore"), DEFAULT_HELPER);
    }

    public void testSerialize_Opposites() throws Exception {
        this.doSerialize(SerializeTests.getTestModelURI("models/ecore/Opposites.ecore"), DEFAULT_HELPER);
    }

    public void testSerialize_BaseCST() throws Exception {
        URI uri = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.xtext.base/model/BaseCS.ecore", (boolean)true);
        this.doSerialize(uri, new SerializeTestHelper(){

            @Override
            public void assertSameModel(@NonNull Resource expectedResource, @NonNull Resource actualResource) {
            }
        });
    }

    public void testSerialize_EssentialOCLCST() throws Exception {
        URI uri = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.xtext.essentialocl/model/EssentialOCLCS.ecore", (boolean)true);
        this.doSerialize(uri, new SerializeTestHelper(){

            @Override
            public void assertSameModel(@NonNull Resource expectedResource, @NonNull Resource actualResource) {
            }

            @Override
            public void initializeResourceSet(@NonNull ResourceSet resourceSet) {
                SerializeTests.getProjectMap().configureLoadFirst(resourceSet, "http://www.eclipse.org/emf/2002/Ecore");
            }
        });
    }

    public void testSerialize_OCLinEcoreCST() throws Exception {
        URI uri = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.xtext.oclinecore/model/OCLinEcoreCS.ecore", (boolean)true);
        this.doSerialize(uri, new SerializeTestHelper(){

            @Override
            public void assertSameModel(@NonNull Resource expectedResource, @NonNull Resource actualResource) {
            }

            @Override
            public void initializeResourceSet(@NonNull ResourceSet resourceSet) {
                SerializeTests.getProjectMap().configureLoadFirst(resourceSet, "http://www.eclipse.org/emf/2002/Ecore");
            }
        });
    }

    public void testSerialize_OCLstdlib() throws Exception {
        this.doSerialize(SerializeTests.getTestModelURI("models/ecore/OCLstdlib.ecore"), DEFAULT_HELPER);
    }

    public void testSerialize_OCLCST() throws Exception {
        this.doSerialize(SerializeTests.getTestModelURI("models/ecore/OCLCST.ecore"), DEFAULT_HELPER);
    }

    public void testSerialize_QVT() throws Exception {
        this.doSerialize(SerializeTests.getTestModelURI("models/ecore/QVT.ecore"), new SerializeTestHelper(){

            @Override
            public void assertSameModel(@NonNull Resource expectedResource, @NonNull Resource actualResource) throws IOException, InterruptedException {
                XMLResourceImpl xmlResourceImpl = (XMLResourceImpl)expectedResource;
                for (EObject eObject : new TreeIterable(expectedResource)) {
                    xmlResourceImpl.setID(eObject, null);
                }
                SerializeTestHelper.super.assertSameModel(expectedResource, actualResource);
            }
        });
    }

    public void testSerialize_RoyalAndLoyal_ecore() throws Exception {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            @NonNull URI inputURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.project.royalandloyal/model/RoyalAndLoyal.ecore", (boolean)true);
            this.doSerialize(inputURI, DEFAULT_HELPER);
        }
    }

    public void testSerialize_States() throws Exception {
        final String message1 = StringUtil.bind((String)PivotMessagesInternal.ValidationConstraintIsInvalid_ERROR_, (Object[])new Object[]{"\u00abinvariant\u00bb", "states::State::NameIsLeadingUpperCase", "let firstLetter : String = invalid.substring(1, 1) in firstLetter.toUpperCase() = firstLetter'\n1:36: Unresolved Operation 'OclInvalid::substring(1, 1)"});
        final String message2 = StringUtil.bind((String)"The ''CallExp::TypeIsNotInvalid'' constraint is violated for ''invalid.oclBadOperation()''", (Object[])new Object[0]);
        this.doSerialize(SerializeTests.getTestModelURI("models/ecore/States.ecore"), SerializeTests.getTestModelURI("models/ecore/States.ecore"), new SerializeTestHelper(){

            @Override
            public @NonNull String @NonNull [] asFirstReValidationMessages() {
                return SerializeTests.getMessages(message2);
            }

            @Override
            public @NonNull String @NonNull [] asFirstValidationMessages() {
                return SerializeTests.getMessages(message1, message2);
            }

            @Override
            public @NonNull String cs2asErrorMessages() {
                return StringUtil.bind((String)PivotMessagesInternal.UnresolvedOperationCall_ERROR_, (Object[])new Object[]{"OclInvalid", "substring", "1, 1"});
            }
        });
    }

    public void testSerialize_Tutorial_echoed() throws Exception {
        this.doSerialize(SerializeTests.getTestModelURI("models/documentation/Tutorial1.ecore"), DEFAULT_HELPER);
    }

    public void testSerialize_Tutorial_reformatted() throws Exception {
        this.doSerialize(SerializeTests.getTestModelURI("models/documentation/Tutorial1.ecore"), SerializeTests.getTestModelURI("models/documentation/Tutorial1ref.ecore"), FULL_SERIALIZATION_HELPER);
    }

    public void testSerialize_XMLNamespace() throws Exception {
        this.doSerialize(SerializeTests.getTestModelURI("models/ecore/XMLNamespace.ecore"), DEFAULT_HELPER);
    }

    public void test_StateMachines_uml_Serialize() throws Exception {
        UMLStandaloneSetup.init();
        this.doSerializeUML(SerializeTests.getTestModelURI("models/uml/StateMachines.uml"), new SerializeTestHelper(){

            @Override
            public @NonNull String @NonNull [] asFirstValidationMessages() {
                return new String[]{"The 'Feature::TypeIsNotNull' constraint is violated for 'Model::C1::o1() : \u00abnull\u00bb[1]'", "The 'Feature::TypeIsNotNull' constraint is violated for 'Model::C2::o2() : \u00abnull\u00bb[1]'"};
            }
        });
    }

    public static interface SerializeTestHelper {
        default public void assertSameModel(@NonNull Resource expectedResource, @NonNull Resource actualResource) throws IOException, InterruptedException {
            TestUtil.assertSameModel(expectedResource, actualResource);
        }

        default public @NonNull String @NonNull [] asFirstReValidationMessages() {
            return this.asFirstValidationMessages();
        }

        default public @NonNull String @NonNull [] asFirstValidationMessages() {
            return NO_MESSAGES;
        }

        default public @NonNull String @NonNull [] asSecondValidationMessages() {
            return this.asFirstValidationMessages();
        }

        default public void conditionAS(@NonNull ASResource asResource) {
        }

        default public @Nullable String cs2asErrorMessages() {
            return null;
        }

        default public void extraXtextResourceValidate(@NonNull BaseCSResource xtextResource) {
        }

        default public void initializeResourceSet(@NonNull ResourceSet resourceSet) {
        }
    }
}

