/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.build.analysis;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.build.analysis.AbstractRuleAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.ActionAssignmentAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.AnalysisUtils;
import org.eclipse.ocl.examples.xtext.build.analysis.AssignmentAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.DirectAssignmentAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.GrammarAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.IdiomGrammarMatch;
import org.eclipse.ocl.examples.xtext.build.analysis.LocatorHelper;
import org.eclipse.ocl.examples.xtext.build.analysis.SerializationRuleAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.UniqueList;
import org.eclipse.ocl.examples.xtext.build.elements.AbstractAssignedSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.AbstractSerializationElement;
import org.eclipse.ocl.examples.xtext.build.elements.AlternativeAssignedKeywordsSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.AlternativeAssignsSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.AlternativeUnassignedKeywordsSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.AssignedCrossReferenceSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.AssignedCurrentSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.AssignedKeywordSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.AssignedRuleCallSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.AssignedSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.ListOfListOfSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.ListOfSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.NullSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.SequenceSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.SerializationElement;
import org.eclipse.ocl.examples.xtext.build.elements.SerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.SerializationRuleAnalysisComparator;
import org.eclipse.ocl.examples.xtext.build.elements.UnassignedGrammarRuleCallSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.UnassignedKeywordSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.UnassignedSerializationRuleCallSerializationNode;
import org.eclipse.ocl.examples.xtext.idioms.Idiom;
import org.eclipse.ocl.examples.xtext.idioms.IdiomsUtils;
import org.eclipse.ocl.examples.xtext.idioms.Locator;
import org.eclipse.ocl.examples.xtext.idioms.ReferredLocator;
import org.eclipse.ocl.examples.xtext.idioms.SubIdiom;
import org.eclipse.ocl.examples.xtext.idioms.impl.LocatorImpl;
import org.eclipse.ocl.examples.xtext.serializer.GrammarCardinality;
import org.eclipse.ocl.examples.xtext.serializer.GrammarRuleVector;
import org.eclipse.ocl.examples.xtext.serializer.Indexed;
import org.eclipse.ocl.examples.xtext.serializer.ParserRuleValue;
import org.eclipse.ocl.examples.xtext.serializer.SerializationRule;
import org.eclipse.ocl.examples.xtext.serializer.SerializationSegment;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.util.XtextSwitch;

public class ParserRuleAnalysis
extends AbstractRuleAnalysis
implements Indexed {
    protected final @NonNull EClass eClass;
    private final @NonNull Map<@NonNull EStructuralFeature, @NonNull List<@NonNull AssignmentAnalysis>> eFeature2assignmentAnalyses = new HashMap<EStructuralFeature, List<AssignmentAnalysis>>();
    private @Nullable List<@NonNull SerializationRuleAnalysis> serializationRuleAnalyses = null;
    private @Nullable Set<@NonNull ParserRuleAnalysis> superRuleAnalyses = null;
    private @Nullable List<@NonNull ParserRuleAnalysis> superRuleAnalysesClosure = null;
    private final @NonNull List<@NonNull ParserRuleAnalysis> subRuleAnalysesClosure = new UniqueList<ParserRuleAnalysis>();
    private @Nullable ParserRuleValue parserRuleValue = null;
    private @Nullable Map<@NonNull AbstractElement, @NonNull List<@NonNull SubIdiom>> grammarElement2subIdioms = null;

    public ParserRuleAnalysis(@NonNull GrammarAnalysis grammarAnalysis, int index, @NonNull ParserRule parserRule, @NonNull EClass eClass) {
        super(grammarAnalysis, index, (AbstractRule)parserRule);
        this.eClass = eClass;
    }

    protected void addAssignmentAnalysis(@NonNull AssignmentAnalysis assignmentAnalysis) {
        this.grammarAnalysis.addAssignmentAnalysis(assignmentAnalysis);
        EStructuralFeature eStructuralFeature = assignmentAnalysis.getEStructuralFeature();
        ArrayList<@NonNull AssignmentAnalysis> assignmentAnalyses = (ArrayList<AssignmentAnalysis>)SerializationUtils.maybeNull(this.eFeature2assignmentAnalyses.get(eStructuralFeature));
        if (assignmentAnalyses == null) {
            assignmentAnalyses = new ArrayList<AssignmentAnalysis>();
            this.eFeature2assignmentAnalyses.put(eStructuralFeature, assignmentAnalyses);
        }
        assignmentAnalyses.add(assignmentAnalysis);
    }

    protected void addSuperRuleAnalysis(@NonNull ParserRuleAnalysis superRuleAnalysis) {
        Set<@NonNull ParserRuleAnalysis> superRuleAnalyses2 = this.superRuleAnalyses;
        if (superRuleAnalyses2 == null) {
            this.superRuleAnalyses = superRuleAnalyses2 = new HashSet<ParserRuleAnalysis>();
        }
        superRuleAnalyses2.add(superRuleAnalysis);
    }

    public @Nullable RuleCall analyzeActionsAndAssignments() {
        ActionAndAssignmentAnalysisSwitch actionAndAssignmentAnalysisSwitch = new ActionAndAssignmentAnalysisSwitch(this);
        return actionAndAssignmentAnalysisSwitch.analyze();
    }

    public void analyzeMatches() {
        assert (this.serializationRuleAnalyses != null);
        for (SerializationRuleAnalysis serializationRuleAnalysis : this.serializationRuleAnalyses) {
            serializationRuleAnalysis.analyzeMatches();
        }
    }

    private void analyzeSerializations(@NonNull Iterable<@NonNull SerializationRuleAnalysis> serializationRuleAnalyses) {
        HashMap<@NonNull EReference, @NonNull Object> eReference2ruleAnalysisOrAnalyses = new HashMap<EReference, Object>();
        for (SerializationRuleAnalysis serializationRuleAnalysis : serializationRuleAnalyses) {
            SerializationNode rootSerializationNode = serializationRuleAnalysis.getRootSerializationNode();
            this.analyzeSerializations(rootSerializationNode, eReference2ruleAnalysisOrAnalyses);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void analyzeSerializations(@NonNull SerializationNode serializationNode, @NonNull Map<@NonNull EReference, @NonNull Object> eReference2ruleAnalysisOrAnalyses) {
        block11: {
            block10: {
                if (!(serializationNode instanceof AssignedRuleCallSerializationNode)) break block10;
                AssignedSerializationNode assignedSerializationNode = (AssignedSerializationNode)serializationNode;
                EStructuralFeature eStructuralFeature = assignedSerializationNode.getEStructuralFeature();
                if (eStructuralFeature instanceof EReference) {
                    EReference eReference = (EReference)eStructuralFeature;
                    int[] nArray = assignedSerializationNode.getAssignedRuleIndexes();
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int ruleIndex = nArray[n2];
                        AbstractRuleAnalysis newRuleAnalysis = this.grammarAnalysis.getRuleAnalysis(ruleIndex);
                        if (newRuleAnalysis instanceof ParserRuleAnalysis) {
                            Object oldRuleAnalysisOrAnalyses = SerializationUtils.maybeNull((Object)eReference2ruleAnalysisOrAnalyses.get(eReference));
                            if (oldRuleAnalysisOrAnalyses == null) {
                                eReference2ruleAnalysisOrAnalyses.put(eReference, newRuleAnalysis);
                            } else if (oldRuleAnalysisOrAnalyses instanceof ParserRuleAnalysis) {
                                if (oldRuleAnalysisOrAnalyses != newRuleAnalysis) {
                                    ArrayList<@NonNull ParserRuleAnalysis> newRuleAnalysisOrAnalyses = new ArrayList<ParserRuleAnalysis>();
                                    newRuleAnalysisOrAnalyses.add((ParserRuleAnalysis)oldRuleAnalysisOrAnalyses);
                                    newRuleAnalysisOrAnalyses.add((ParserRuleAnalysis)newRuleAnalysis);
                                    eReference2ruleAnalysisOrAnalyses.put(eReference, newRuleAnalysisOrAnalyses);
                                }
                            } else {
                                @NonNull List oldRuleAnalyses = (List)oldRuleAnalysisOrAnalyses;
                                if (!oldRuleAnalyses.contains(newRuleAnalysis)) {
                                    oldRuleAnalyses.add((ParserRuleAnalysis)newRuleAnalysis);
                                }
                            }
                        }
                        ++n2;
                    }
                }
                break block11;
            }
            if (!(serializationNode instanceof SequenceSerializationNode)) break block11;
            for (SerializationNode nestedSerializationNode : ((SequenceSerializationNode)serializationNode).getSerializationNodes()) {
                this.analyzeSerializations(nestedSerializationNode, eReference2ruleAnalysisOrAnalyses);
            }
        }
    }

    public @Nullable ParserRuleValue basicGetRuleValue() {
        return this.parserRuleValue;
    }

    protected void createSerializationRuleAnalyses(@NonNull List<@NonNull SerializationRuleAnalysis> serializationRuleAnalyses, @NonNull SerializationNode serializationNode) {
        if (serializationNode instanceof UnassignedGrammarRuleCallSerializationNode) {
            throw new IllegalStateException();
        }
        if (serializationNode instanceof UnassignedSerializationRuleCallSerializationNode) {
            UnassignedSerializationRuleCallSerializationNode unassignedRuleCallSerializationNode = (UnassignedSerializationRuleCallSerializationNode)serializationNode;
            SerializationRuleAnalysis calledSerializationRule = unassignedRuleCallSerializationNode.getCalledRuleAnalysis();
            if (!serializationRuleAnalyses.contains(calledSerializationRule)) {
                serializationRuleAnalyses.add(calledSerializationRule);
            }
        } else {
            SerializationRuleAnalysis serializationRuleAnalysis = new SerializationRuleAnalysis(this, serializationRuleAnalyses.size(), serializationNode);
            serializationRuleAnalyses.add(serializationRuleAnalysis);
        }
    }

    private void gatherFormattingIdioms(@NonNull AbstractElement abstractElement, @NonNull List<@Nullable List<@NonNull SubIdiom>> serializationIdiomsList) {
        serializationIdiomsList.add(this.getSubIdioms(abstractElement));
        if (abstractElement instanceof CompoundElement) {
            for (AbstractElement childElement : ((CompoundElement)abstractElement).getElements()) {
                assert (childElement != null);
                this.gatherFormattingIdioms(childElement, serializationIdiomsList);
            }
        }
    }

    public @NonNull Map<@NonNull EStructuralFeature, @NonNull List<@NonNull AssignmentAnalysis>> getEFeature2assignmentAnalyses() {
        return this.eFeature2assignmentAnalyses;
    }

    public @NonNull Map<@NonNull AbstractElement, @NonNull List<@NonNull SubIdiom>> getGrammarElement2subIdioms() {
        Map<@NonNull AbstractElement, @NonNull List<@NonNull SubIdiom>> grammarElement2subIdioms2 = this.grammarElement2subIdioms;
        if (grammarElement2subIdioms2 == null) {
            EClass producedEClass = (EClass)this.abstractRule.getType().getClassifier();
            assert (producedEClass != null);
            ArrayList<@NonNull Idiom> idioms = new ArrayList<Idiom>();
            for (Idiom idiom : this.grammarAnalysis.getIdioms()) {
                Matcher matcher;
                Pattern pattern;
                boolean isOk = true;
                EClass inEClass = idiom.getForEClass();
                if (inEClass != null && !AnalysisUtils.isSuperTypeOf(inEClass, producedEClass)) {
                    isOk = false;
                }
                if ((pattern = idiom.getRegexPattern()) != null && !(matcher = pattern.matcher(this.getName())).matches()) {
                    isOk = false;
                }
                if (!isOk) continue;
                idioms.add(idiom);
            }
            @Nullable IdiomGrammarMatch @NonNull [] idiomMatches = new IdiomGrammarMatch[Iterables.size(idioms)];
            AbstractElement alternatives = this.abstractRule.getAlternatives();
            assert (alternatives != null);
            this.getIdiomMatches(alternatives, idioms, idiomMatches);
            grammarElement2subIdioms2 = new HashMap<AbstractElement, List<SubIdiom>>();
            IdiomGrammarMatch[] idiomGrammarMatchArray = idiomMatches;
            int n = idiomMatches.length;
            int n2 = 0;
            while (n2 < n) {
                IdiomGrammarMatch idiomMatch = idiomGrammarMatchArray[n2];
                if (idiomMatch != null) {
                    idiomMatch.installIn(grammarElement2subIdioms2);
                }
                ++n2;
            }
            this.grammarElement2subIdioms = grammarElement2subIdioms2;
        }
        return grammarElement2subIdioms2;
    }

    private void getIdiomMatches(@NonNull AbstractElement abstractElement, @NonNull Iterable<@NonNull Idiom> idioms, @Nullable IdiomGrammarMatch @NonNull [] idiomMatches) {
        int idiomIndex = 0;
        for (Idiom idiom : idioms) {
            IdiomGrammarMatch idiomMatch = idiomMatches[idiomIndex];
            if (idiomMatch == null) {
                SubIdiom firstSubIdiom = (SubIdiom)idiom.getOwnedSubIdioms().get(0);
                assert (firstSubIdiom != null);
                boolean firstSubIdiomMatches = this.matches(firstSubIdiom, abstractElement);
                idiomMatches[idiomIndex] = firstSubIdiomMatches ? this.grammarAnalysis.createIdiomMatch(idiom, abstractElement) : null;
            } else {
                idiomMatch.nextMatch(abstractElement, this);
            }
            ++idiomIndex;
        }
        if (abstractElement instanceof CompoundElement) {
            for (AbstractElement nestedElement : ((CompoundElement)abstractElement).getElements()) {
                assert (nestedElement != null);
                this.getIdiomMatches(nestedElement, idioms, idiomMatches);
            }
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public @NonNull ParserRule getParserRule() {
        return (ParserRule)this.abstractRule;
    }

    public @NonNull EClass getReturnedEClass() {
        return this.eClass;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull ParserRuleValue getRuleValue() {
        ParserRuleValue parserRuleValue2 = this.parserRuleValue;
        if (parserRuleValue2 == null) {
            ArrayList<@NonNull ParserRuleValue> subParserRuleValueClosure = null;
            for (ParserRuleAnalysis subParserRuleAnalysis : this.getSubRuleAnalysesClosure()) {
                if (subParserRuleAnalysis == this) continue;
                if (subParserRuleValueClosure == null) {
                    subParserRuleValueClosure = new ArrayList<ParserRuleValue>();
                }
                subParserRuleValueClosure.add(subParserRuleAnalysis.getRuleValue());
            }
            GrammarRuleVector subParserRuleValueIndexes = null;
            if (subParserRuleValueClosure != null) {
                subParserRuleValueIndexes = new GrammarRuleVector();
                subParserRuleValueIndexes.set(this.index);
                for (ParserRuleValue parserRuleValue : subParserRuleValueClosure) {
                    subParserRuleValueIndexes.set(parserRuleValue.getIndex());
                }
            }
            ArrayList<@Nullable List<@NonNull SubIdiom>> formattingSubIdiomsList = new ArrayList<List<SubIdiom>>();
            AbstractElement alternatives = this.abstractRule.getAlternatives();
            assert (alternatives != null);
            this.gatherFormattingIdioms(alternatives, formattingSubIdiomsList);
            Iterable<@NonNull SerializationRuleAnalysis> serializationRuleAnalyses = this.getSerializationRuleAnalyses();
            @NonNull SerializationRule @NonNull [] serializationRules = new SerializationRule[Iterables.size(serializationRuleAnalyses)];
            @NonNull SerializationSegment @NonNull [] @NonNull [] innerFormattingSegmentsArray = new SerializationSegment[formattingSubIdiomsList.size()][];
            @NonNull SerializationSegment @NonNull [] @NonNull [] outerFormattingSegmentsArray = new SerializationSegment[formattingSubIdiomsList.size()][];
            int i = 0;
            while (i < formattingSubIdiomsList.size()) {
                SerializationSegment[] innerFormattingSegments = null;
                SerializationSegment[] outerFormattingSegments = null;
                @NonNull List formattingSubIdioms = (List)formattingSubIdiomsList.get(i);
                if (formattingSubIdioms != null) {
                    innerFormattingSegments = this.grammarAnalysis.getSerializationSegments(formattingSubIdioms, false);
                    outerFormattingSegments = this.grammarAnalysis.getSerializationSegments(formattingSubIdioms, true);
                }
                innerFormattingSegmentsArray[i] = innerFormattingSegments != null ? innerFormattingSegments : SerializationSegment.VALUE_SEGMENTS_ARRAY;
                outerFormattingSegmentsArray[i] = outerFormattingSegments != null ? outerFormattingSegments : SerializationSegment.VALUE_SEGMENTS_ARRAY;
                ++i;
            }
            this.parserRuleValue = parserRuleValue2 = new ParserRuleValue(this.index, this.getName(), serializationRules, (SerializationSegment[][])outerFormattingSegmentsArray, (SerializationSegment[][])innerFormattingSegmentsArray, subParserRuleValueIndexes);
            i = 0;
            for (SerializationRuleAnalysis serializationRuleAnalysis : serializationRuleAnalyses) {
                serializationRules[i++] = serializationRuleAnalysis.getSerializationRule();
            }
        }
        return parserRuleValue2;
    }

    public @NonNull Iterable<@NonNull SerializationRuleAnalysis> getSerializationRuleAnalyses() {
        if (this.serializationRuleAnalyses == null) {
            this.synthesizeSerializationRuleAnalyses();
        }
        assert (this.serializationRuleAnalyses != null);
        return this.serializationRuleAnalyses;
    }

    public @Nullable List<@NonNull SubIdiom> getSubIdioms(@NonNull AbstractElement grammarElement) {
        return this.getGrammarElement2subIdioms().get(grammarElement);
    }

    public @NonNull Collection<@NonNull ParserRuleAnalysis> getSubRuleAnalysesClosure() {
        assert (this.superRuleAnalysesClosure != null);
        return this.subRuleAnalysesClosure;
    }

    public @NonNull Iterable<@NonNull ParserRuleAnalysis> getSuperRuleAnalysisClosure() {
        List<@NonNull ParserRuleAnalysis> superRuleAnalysesClosureList = this.superRuleAnalysesClosure;
        if (superRuleAnalysesClosureList == null) {
            UniqueList<@NonNull ParserRuleAnalysis> superRuleAnalysesClosureSet = new UniqueList<ParserRuleAnalysis>();
            superRuleAnalysesClosureSet.add(this);
            int i = 0;
            while (i < superRuleAnalysesClosureSet.size()) {
                ParserRuleAnalysis ruleAnalysis = (ParserRuleAnalysis)SerializationUtils.nonNullState((Object)((ParserRuleAnalysis)superRuleAnalysesClosureSet.get(i)));
                Set<@NonNull ParserRuleAnalysis> superRuleAnalyses = ruleAnalysis.superRuleAnalyses;
                if (superRuleAnalyses != null) {
                    superRuleAnalysesClosureSet.addAll(superRuleAnalyses);
                }
                ++i;
            }
            superRuleAnalysesClosureList = new ArrayList<ParserRuleAnalysis>(superRuleAnalysesClosureSet);
            Collections.sort(superRuleAnalysesClosureList, AbstractRuleAnalysis.QualifiedNameableComparator.INSTANCE);
            this.superRuleAnalysesClosure = superRuleAnalysesClosureList;
            for (ParserRuleAnalysis superRuleAnalysis : superRuleAnalysesClosureList) {
                superRuleAnalysis.subRuleAnalysesClosure.add(this);
            }
        }
        return superRuleAnalysesClosureList;
    }

    public boolean matches(@NonNull SubIdiom subIdiom, @NonNull AbstractElement grammarElement) {
        Locator locator = IdiomsUtils.getLocator((SubIdiom)subIdiom);
        return this.matches(locator, grammarElement);
    }

    public boolean matches(@NonNull Locator locator, @NonNull AbstractElement grammarElement) {
        assert (!(locator instanceof ReferredLocator));
        LocatorImpl locatorImpl = (LocatorImpl)locator;
        LocatorHelper locatorHelper = (LocatorHelper)locatorImpl.basicGetHelper();
        if (locatorHelper == null) {
            LocatorHelper.LocatorSwitch subIdiomLocatorSwitch = this.grammarAnalysis.getLocatorSwitch();
            locatorHelper = (LocatorHelper)subIdiomLocatorSwitch.doSwitch((EObject)locator);
            locatorImpl.setHelper((Object)locatorHelper);
        }
        if (locatorHelper == null) {
            return false;
        }
        return locatorHelper.matches(locator, grammarElement, this);
    }

    public boolean matches(@NonNull Locator locator, @NonNull SerializationNode serializationNode) {
        assert (!(locator instanceof ReferredLocator));
        LocatorImpl locatorImpl = (LocatorImpl)locator;
        LocatorHelper locatorHelper = (LocatorHelper)locatorImpl.basicGetHelper();
        if (locatorHelper == null) {
            LocatorHelper.LocatorSwitch subIdiomLocatorSwitch = this.grammarAnalysis.getLocatorSwitch();
            locatorHelper = (LocatorHelper)subIdiomLocatorSwitch.doSwitch((EObject)locator);
            locatorImpl.setHelper((Object)locatorHelper);
        }
        if (locatorHelper == null) {
            return false;
        }
        return locatorHelper.matches(locator, serializationNode);
    }

    protected void synthesizeSerializationRuleAnalyses() {
        assert (this.serializationRuleAnalyses == null);
        SerializationElementSynthesisSwitch serializationElementSynthesisSwitch = new SerializationElementSynthesisSwitch(this);
        SerializationElement serializationResult = serializationElementSynthesisSwitch.analyze();
        ArrayList<@NonNull SerializationRuleAnalysis> serializationRuleAnalyses = new ArrayList<SerializationRuleAnalysis>();
        this.synthesizeSerializationRuleAnalyses(serializationRuleAnalyses, serializationResult);
        if (serializationRuleAnalyses.size() > 1) {
            Collections.sort(serializationRuleAnalyses, new SerializationRuleAnalysisComparator());
        }
        this.serializationRuleAnalyses = serializationRuleAnalyses;
        this.analyzeSerializations(serializationRuleAnalyses);
    }

    protected void synthesizeSerializationRuleAnalyses(@NonNull List<@NonNull SerializationRuleAnalysis> serializationRuleAnalyses, @NonNull SerializationElement serializationElement) {
        if (serializationElement.isListOfList()) {
            for (List<SerializationNode> serializationNodes : serializationElement.asListOfList().getLists()) {
                if (serializationNodes.size() == 1) {
                    SerializationNode serializationNode = (SerializationNode)SerializationUtils.nonNullState((Object)serializationNodes.get(0));
                    this.createSerializationRuleAnalyses(serializationRuleAnalyses, serializationNode);
                    continue;
                }
                CompoundElement alternatives = (CompoundElement)SerializationUtils.getAlternatives((AbstractRule)this.abstractRule);
                SerializationElement nestedSerializationResult = AbstractSerializationElement.createFrozenSequence(alternatives, GrammarCardinality.ONE, serializationNodes, true);
                this.synthesizeSerializationRuleAnalyses(serializationRuleAnalyses, nestedSerializationResult);
            }
        } else if (serializationElement.isList()) {
            SerializationNode serializationNode;
            List<@NonNull SerializationNode> serializationNodes = serializationElement.asList().getNodes();
            if (serializationNodes.size() == 1) {
                serializationNode = (SerializationNode)SerializationUtils.nonNullState((Object)serializationNodes.get(0));
            } else {
                CompoundElement alternatives = (CompoundElement)SerializationUtils.getAlternatives((AbstractRule)this.abstractRule);
                serializationNode = new SequenceSerializationNode(alternatives, GrammarCardinality.ONE, serializationNodes);
            }
            this.createSerializationRuleAnalyses(serializationRuleAnalyses, serializationNode);
        } else if (serializationElement.isNode()) {
            SerializationNode serializationNode = serializationElement.asNode();
            this.createSerializationRuleAnalyses(serializationRuleAnalyses, serializationNode);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void toDebugString(@NonNull StringBuilder s, int depth) {
        s.append(this.getQualifiedName());
        List<@NonNull ParserRuleAnalysis> superRuleAnalysesClosure2 = this.superRuleAnalysesClosure;
        if (superRuleAnalysesClosure2 != null) {
            s.append(" -> ");
            boolean isFirst1 = true;
            for (ParserRuleAnalysis superRuleAnalysis : superRuleAnalysesClosure2) {
                if (!isFirst1) {
                    s.append(", ");
                }
                s.append(superRuleAnalysis.getQualifiedName());
                isFirst1 = false;
            }
        }
        if (this.serializationRuleAnalyses != null) {
            for (SerializationRuleAnalysis serializationRuleAnalysis : this.serializationRuleAnalyses) {
                SerializationUtils.appendIndentation((StringBuilder)s, (int)(depth + 1));
                s.append(serializationRuleAnalysis);
            }
        }
    }

    protected static class ActionAndAssignmentAnalysisSwitch
    extends XtextSwitch<ActionAndAssignmentAnalysisSwitch> {
        protected final @NonNull ParserRuleAnalysis parserRuleAnalysis;
        protected final @NonNull GrammarAnalysis grammarAnalysis;
        private @Nullable RuleCall firstUnassignedRuleCall;
        private boolean isSimpleAlternative;
        private @NonNull EClass producedEClass;

        public ActionAndAssignmentAnalysisSwitch(@NonNull ParserRuleAnalysis parserRuleAnalysis) {
            this.parserRuleAnalysis = parserRuleAnalysis;
            this.grammarAnalysis = parserRuleAnalysis.getGrammarAnalysis();
            this.firstUnassignedRuleCall = null;
            this.isSimpleAlternative = true;
            this.producedEClass = parserRuleAnalysis.getReturnedEClass();
        }

        public @Nullable RuleCall analyze() {
            AbstractElement rootElement = SerializationUtils.getAlternatives((AbstractRule)this.parserRuleAnalysis.getRule());
            this.analyze(rootElement);
            return this.firstUnassignedRuleCall;
        }

        private void analyze(@NonNull AbstractElement nestedElement) {
            int classifierID = nestedElement.eClass().getClassifierID();
            this.doSwitch(classifierID, (EObject)nestedElement);
        }

        public @NonNull ActionAndAssignmentAnalysisSwitch caseAction(Action action) {
            assert (action != null);
            TypeRef type = SerializationUtils.getType((Action)action);
            this.producedEClass = (EClass)SerializationUtils.getClassifier((TypeRef)type);
            String feature = action.getFeature();
            if (feature != null) {
                assert (this.firstUnassignedRuleCall != null);
                AbstractRule currentRule = SerializationUtils.getRule((RuleCall)this.firstUnassignedRuleCall);
                ParserRuleAnalysis currentRuleAnalysis = (ParserRuleAnalysis)this.grammarAnalysis.getRuleAnalysis(currentRule);
                ActionAssignmentAnalysis assignmentAnalysis = new ActionAssignmentAnalysis(this.parserRuleAnalysis, action, currentRuleAnalysis);
                this.parserRuleAnalysis.addAssignmentAnalysis(assignmentAnalysis);
            }
            return this;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @NonNull ActionAndAssignmentAnalysisSwitch caseAlternatives(Alternatives alternatives) {
            assert (alternatives != null);
            @NonNull List elements = SerializationUtils.getElements((CompoundElement)alternatives);
            if (elements.size() == 1) {
                this.analyze((AbstractElement)elements.get(0));
            } else {
                RuleCall savedFirstUnassignedRuleCall = this.firstUnassignedRuleCall;
                boolean savedIsSimpleAlternative = this.isSimpleAlternative;
                for (AbstractElement nestedElement : SerializationUtils.getElements((CompoundElement)alternatives)) {
                    this.analyze(nestedElement);
                    this.firstUnassignedRuleCall = savedFirstUnassignedRuleCall;
                    this.isSimpleAlternative = savedIsSimpleAlternative;
                }
            }
            return this;
        }

        public @NonNull ActionAndAssignmentAnalysisSwitch caseAssignment(Assignment assignment) {
            assert (assignment != null);
            DirectAssignmentAnalysis assignmentAnalysis = new DirectAssignmentAnalysis(this.parserRuleAnalysis, this.producedEClass, assignment);
            this.parserRuleAnalysis.addAssignmentAnalysis(assignmentAnalysis);
            return this;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @NonNull ActionAndAssignmentAnalysisSwitch caseGroup(Group group) {
            assert (group != null);
            @NonNull List elements = SerializationUtils.getElements((CompoundElement)group);
            AbstractElement nonOptionalElement = null;
            for (AbstractElement nestedElement : elements) {
                if (!(nestedElement instanceof RuleCall) && !(nestedElement instanceof Group)) {
                    nonOptionalElement = null;
                    break;
                }
                GrammarCardinality grammarCardinality = GrammarCardinality.toEnum((AbstractElement)nestedElement);
                if (grammarCardinality.isOne()) {
                    if (nonOptionalElement != null) {
                        nonOptionalElement = null;
                        break;
                    }
                    nonOptionalElement = nestedElement;
                    continue;
                }
                if (grammarCardinality.mayBeZero()) continue;
                nonOptionalElement = null;
                break;
            }
            boolean savedIsSimpleAlternative = this.isSimpleAlternative;
            for (AbstractElement nestedElement : elements) {
                this.isSimpleAlternative = nestedElement == nonOptionalElement && savedIsSimpleAlternative;
                this.analyze(nestedElement);
            }
            this.isSimpleAlternative = savedIsSimpleAlternative;
            return this;
        }

        public @NonNull ActionAndAssignmentAnalysisSwitch caseKeyword(Keyword keyword) {
            assert (keyword != null);
            return this;
        }

        public @NonNull ActionAndAssignmentAnalysisSwitch caseRuleCall(RuleCall ruleCall) {
            assert (ruleCall != null);
            assert (this.firstUnassignedRuleCall == null);
            AbstractRule subRule = SerializationUtils.getRule((RuleCall)ruleCall);
            if (SerializationUtils.getClassifier((TypeRef)SerializationUtils.getType((AbstractRule)subRule)) instanceof EClass) {
                this.firstUnassignedRuleCall = ruleCall;
                if (this.isSimpleAlternative) {
                    ParserRuleAnalysis subRuleAnalysis = (ParserRuleAnalysis)this.grammarAnalysis.getRuleAnalysis(subRule);
                    subRuleAnalysis.addSuperRuleAnalysis(this.parserRuleAnalysis);
                }
            }
            return this;
        }

        public @NonNull ActionAndAssignmentAnalysisSwitch defaultCase(EObject object) {
            throw new UnsupportedOperationException("Unsupported '" + object.eClass().getName() + "' in ActionAndAssignmentAnalysisSwitch");
        }

        public @NonNull String toString() {
            return this.parserRuleAnalysis.toString();
        }
    }

    protected static class SerializationElementSynthesisSwitch
    extends XtextSwitch<SerializationElement> {
        protected final @NonNull ParserRuleAnalysis parserRuleAnalysis;
        protected final @NonNull GrammarAnalysis grammarAnalysis;
        private @NonNull EClass producedEClass;
        private boolean isRootAlternative = true;

        public SerializationElementSynthesisSwitch(@NonNull ParserRuleAnalysis parserRuleAnalysis) {
            this.parserRuleAnalysis = parserRuleAnalysis;
            this.grammarAnalysis = parserRuleAnalysis.getGrammarAnalysis();
            this.producedEClass = parserRuleAnalysis.getReturnedEClass();
        }

        public @NonNull SerializationElement analyze() {
            AbstractElement rootElement = SerializationUtils.getAlternatives((AbstractRule)this.parserRuleAnalysis.getRule());
            SerializationElement serializationElement = this.analyze(rootElement);
            if (serializationElement instanceof UnassignedGrammarRuleCallSerializationNode) {
                UnassignedGrammarRuleCallSerializationNode unassignedGrammarRuleCallSerializationNode = (UnassignedGrammarRuleCallSerializationNode)serializationElement;
                GrammarCardinality grammarCardinality = unassignedGrammarRuleCallSerializationNode.getGrammarCardinality();
                serializationElement = AbstractSerializationElement.flattenUnassignedGrammarRuleCall(unassignedGrammarRuleCallSerializationNode, grammarCardinality, this.isRootAlternative);
                assert (serializationElement != null);
            }
            assert (serializationElement.noUnassignedParserRuleCall());
            assert (serializationElement.onlyRootUnassignedSerializationRuleCall(true));
            return serializationElement;
        }

        private @NonNull SerializationElement analyze(@NonNull AbstractElement nestedElement) {
            int classifierID = nestedElement.eClass().getClassifierID();
            SerializationElement serializationElement = (SerializationElement)this.doSwitch(classifierID, (EObject)nestedElement);
            return serializationElement;
        }

        public @NonNull SerializationElement caseAction(Action action) {
            assert (action != null);
            TypeRef type = SerializationUtils.getType((Action)action);
            this.producedEClass = (EClass)SerializationUtils.getClassifier((TypeRef)type);
            String feature = action.getFeature();
            if (feature != null) {
                ActionAssignmentAnalysis assignmentAnalysis = this.grammarAnalysis.getAssignmentAnalysis(action);
                return new AssignedCurrentSerializationNode(assignmentAnalysis, GrammarCardinality.toEnum((AbstractElement)action));
            }
            return NullSerializationNode.INSTANCE;
        }

        public @NonNull SerializationElement caseAlternatives(Alternatives alternatives) {
            assert (alternatives != null);
            ArrayList<@NonNull Keyword> alternativeUnassignedKeywords = null;
            ArrayList<@NonNull EStructuralFeature> eFeatures = null;
            HashMap<EStructuralFeature, ArrayList<Keyword>> eFeature2keywords = null;
            HashMap<EStructuralFeature, ArrayList<RuleCall>> eFeature2ruleCalls = null;
            GrammarCardinality grammarCardinality = GrammarCardinality.toEnum((AbstractElement)alternatives);
            ArrayList<@NonNull SerializationElement> alternativeSerializationElements = new ArrayList<SerializationElement>();
            for (AbstractElement element : SerializationUtils.getElements((CompoundElement)alternatives)) {
                boolean doSwitchNeeded = false;
                if (element instanceof Keyword && element.getCardinality() == null) {
                    if (alternativeUnassignedKeywords == null) {
                        alternativeUnassignedKeywords = new ArrayList<Keyword>();
                    }
                    alternativeUnassignedKeywords.add((Keyword)element);
                } else if (element instanceof Assignment && element.getCardinality() == null) {
                    Assignment assignment = (Assignment)element;
                    DirectAssignmentAnalysis assignmentAnalysis = this.grammarAnalysis.getAssignmentAnalysis(assignment);
                    EStructuralFeature eFeature = assignmentAnalysis.getEStructuralFeature();
                    AbstractElement terminal = assignment.getTerminal();
                    if (terminal instanceof Keyword && terminal.getCardinality() == null) {
                        ArrayList<Keyword> keywords;
                        if (eFeatures == null) {
                            eFeatures = new ArrayList<EStructuralFeature>();
                        }
                        if (!eFeatures.contains(eFeature)) {
                            eFeatures.add(eFeature);
                        }
                        if (eFeature2keywords == null) {
                            eFeature2keywords = new HashMap<EStructuralFeature, ArrayList<Keyword>>();
                        }
                        if ((keywords = (ArrayList<Keyword>)SerializationUtils.maybeNull((Object)((List)eFeature2keywords.get(eFeature)))) == null) {
                            keywords = new ArrayList<Keyword>();
                            eFeature2keywords.put(eFeature, keywords);
                        }
                        keywords.add((Keyword)terminal);
                    } else if (terminal instanceof RuleCall && terminal.getCardinality() == null) {
                        ArrayList<RuleCall> ruleCalls;
                        if (eFeatures == null) {
                            eFeatures = new ArrayList();
                        }
                        if (!eFeatures.contains(eFeature)) {
                            eFeatures.add(eFeature);
                        }
                        if (eFeature2ruleCalls == null) {
                            eFeature2ruleCalls = new HashMap<EStructuralFeature, ArrayList<RuleCall>>();
                        }
                        if ((ruleCalls = (ArrayList<RuleCall>)SerializationUtils.maybeNull((Object)((List)eFeature2ruleCalls.get(eFeature)))) == null) {
                            ruleCalls = new ArrayList<RuleCall>();
                            eFeature2ruleCalls.put(eFeature, ruleCalls);
                        }
                        ruleCalls.add((RuleCall)terminal);
                    } else {
                        doSwitchNeeded = true;
                    }
                } else {
                    doSwitchNeeded = true;
                }
                if (!doSwitchNeeded) continue;
                boolean savedIsRootAlternative = this.isRootAlternative;
                if (grammarCardinality.isOneOrMore()) {
                    this.isRootAlternative = false;
                }
                alternativeSerializationElements.add(this.analyze(element));
                this.isRootAlternative = savedIsRootAlternative;
            }
            if (alternativeUnassignedKeywords != null) {
                if (alternativeUnassignedKeywords.size() == 1) {
                    alternativeSerializationElements.add(new UnassignedKeywordSerializationNode((Keyword)alternativeUnassignedKeywords.get(0), this.producedEClass, GrammarCardinality.ONE));
                } else {
                    AlternativeUnassignedKeywordsSerializationNode alternativeUnassignedKeywordsSerializationNode = new AlternativeUnassignedKeywordsSerializationNode(GrammarCardinality.ONE, null);
                    for (Keyword keyword : alternativeUnassignedKeywords) {
                        alternativeUnassignedKeywordsSerializationNode.addKeyword(keyword);
                    }
                    alternativeSerializationElements.add(alternativeUnassignedKeywordsSerializationNode);
                }
            }
            if (eFeatures != null) {
                for (EStructuralFeature eFeature : eFeatures) {
                    Assignment assignment;
                    List ruleCalls;
                    List keywords = eFeature2keywords != null ? (List)SerializationUtils.maybeNull((Object)((List)eFeature2keywords.get(eFeature))) : null;
                    List list = ruleCalls = eFeature2ruleCalls != null ? (List)SerializationUtils.maybeNull((Object)((List)eFeature2ruleCalls.get(eFeature))) : null;
                    if (ruleCalls == null) {
                        assert (keywords != null);
                        Keyword firstKeyword = (Keyword)SerializationUtils.nonNullState((Object)((Keyword)keywords.get(0)));
                        assignment = (Assignment)SerializationUtils.nonNullState((Object)((Assignment)firstKeyword.eContainer()));
                        DirectAssignmentAnalysis assignmentAnalysis = this.grammarAnalysis.getAssignmentAnalysis(assignment);
                        if (keywords.size() == 1) {
                            alternativeSerializationElements.add(new AssignedKeywordSerializationNode(assignmentAnalysis, GrammarCardinality.ONE, firstKeyword));
                            continue;
                        }
                        alternativeSerializationElements.add(new AlternativeAssignedKeywordsSerializationNode(assignmentAnalysis, GrammarCardinality.ONE, keywords));
                        continue;
                    }
                    if (keywords == null && ruleCalls.size() == 1) {
                        RuleCall firstRuleCall = (RuleCall)SerializationUtils.nonNullState((Object)((RuleCall)ruleCalls.get(0)));
                        assignment = (Assignment)SerializationUtils.nonNullState((Object)((Assignment)firstRuleCall.eContainer()));
                        DirectAssignmentAnalysis assignmentAnalysis = this.grammarAnalysis.getAssignmentAnalysis(assignment);
                        AbstractRuleAnalysis firstRuleAnalysis = this.grammarAnalysis.getRuleAnalysis(SerializationUtils.getRule((RuleCall)firstRuleCall));
                        alternativeSerializationElements.add(new AssignedRuleCallSerializationNode(assignmentAnalysis, GrammarCardinality.ONE, firstRuleAnalysis.getIndex()));
                        continue;
                    }
                    assert (ruleCalls != null);
                    ArrayList<@NonNull DirectAssignmentAnalysis> assignmentAnalyses = new ArrayList<DirectAssignmentAnalysis>();
                    int[] ruleIndexes = new int[ruleCalls.size()];
                    int i = 0;
                    for (RuleCall ruleCall : ruleCalls) {
                        Assignment assignment2 = (Assignment)SerializationUtils.nonNullState((Object)((Assignment)ruleCall.eContainer()));
                        assignmentAnalyses.add(this.grammarAnalysis.getAssignmentAnalysis(assignment2));
                        AbstractRuleAnalysis ruleAnalysis = this.grammarAnalysis.getRuleAnalysis(SerializationUtils.getRule((RuleCall)ruleCall));
                        ruleIndexes[i++] = ruleAnalysis.getIndex();
                    }
                    @NonNull DirectAssignmentAnalysis directAssignmentAnalysis = (DirectAssignmentAnalysis)assignmentAnalyses.get(0);
                    alternativeSerializationElements.add(new AlternativeAssignsSerializationNode(this.grammarAnalysis, directAssignmentAnalysis.getEClass(), eFeature, GrammarCardinality.ONE, keywords, ruleIndexes, this.getTargetRuleAnalyses(assignmentAnalyses)));
                }
            }
            Collections.sort(alternativeSerializationElements, new AlterantiveSerializationElementComparator((Iterable<EStructuralFeature>)eFeatures));
            return this.doAlternatives(alternatives, alternativeSerializationElements, grammarCardinality);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @NonNull SerializationElement caseAssignment(Assignment assignment) {
            assert (assignment != null);
            DirectAssignmentAnalysis assignmentAnalysis = this.grammarAnalysis.getAssignmentAnalysis(assignment);
            GrammarCardinality grammarCardinality = GrammarCardinality.toEnum((AbstractElement)assignment);
            AbstractElement terminal = SerializationUtils.getTerminal((Assignment)assignment);
            if (terminal instanceof CrossReference) {
                return new AssignedCrossReferenceSerializationNode(assignmentAnalysis, grammarCardinality, (CrossReference)terminal);
            }
            if (terminal instanceof Keyword) {
                return new AssignedKeywordSerializationNode(assignmentAnalysis, grammarCardinality, (Keyword)terminal);
            }
            if (terminal instanceof RuleCall) {
                AbstractRuleAnalysis ruleAnalysis2 = this.grammarAnalysis.getRuleAnalysis(SerializationUtils.getRule((RuleCall)((RuleCall)terminal)));
                return new AssignedRuleCallSerializationNode(assignmentAnalysis, grammarCardinality, ruleAnalysis2.getIndex());
            }
            if (terminal instanceof Alternatives) {
                Alternatives alternatives = (Alternatives)terminal;
                ArrayList<Keyword> keywords = null;
                ArrayList<AbstractRuleAnalysis> ruleAnalyses = null;
                @NonNull List elements = SerializationUtils.getElements((CompoundElement)alternatives);
                for (AbstractElement alternative : elements) {
                    assert (alternative.getCardinality() == null);
                    if (alternative instanceof Keyword) {
                        if (keywords == null) {
                            keywords = new ArrayList<Keyword>();
                        }
                        keywords.add((Keyword)alternative);
                        continue;
                    }
                    if (alternative instanceof RuleCall) {
                        if (ruleAnalyses == null) {
                            ruleAnalyses = new ArrayList<AbstractRuleAnalysis>();
                        }
                        AbstractRuleAnalysis ruleAnalysis = this.grammarAnalysis.getRuleAnalysis(SerializationUtils.getRule((RuleCall)((RuleCall)alternative)));
                        ruleAnalyses.add(ruleAnalysis);
                        continue;
                    }
                    throw new UnsupportedOperationException("Unsupported Assignment alternative terminal '" + alternative.eClass().getName() + "'");
                }
                if (ruleAnalyses != null) {
                    if (ruleAnalyses.size() > 1 || keywords != null) {
                        int[] ruleIndexes = new int[ruleAnalyses.size()];
                        int i = 0;
                        for (AbstractRuleAnalysis ruleAnalysis : ruleAnalyses) {
                            ruleIndexes[i++] = ruleAnalysis.getIndex();
                        }
                        return new AlternativeAssignsSerializationNode(assignmentAnalysis, grammarCardinality, keywords, ruleIndexes);
                    }
                    AbstractRuleAnalysis firstRuleAnalysis = (AbstractRuleAnalysis)SerializationUtils.nonNullState((Object)((AbstractRuleAnalysis)ruleAnalyses.get(0)));
                    return new AssignedRuleCallSerializationNode(assignmentAnalysis, grammarCardinality, firstRuleAnalysis.getIndex());
                }
                if (keywords != null) {
                    if (keywords.size() > 1) {
                        return new AlternativeAssignedKeywordsSerializationNode(assignmentAnalysis, grammarCardinality, (Iterable<Keyword>)keywords);
                    }
                    return new AssignedKeywordSerializationNode(assignmentAnalysis, grammarCardinality, (Keyword)keywords.get(0));
                }
            }
            throw new UnsupportedOperationException("Unsupported Assignment terminal '" + terminal.eClass().getName() + "'");
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @NonNull SerializationElement caseGroup(Group group) {
            assert (group != null);
            GrammarCardinality grammarCardinality = GrammarCardinality.toEnum((AbstractElement)group);
            boolean savedIsRootAlternative = this.isRootAlternative;
            if (grammarCardinality.isOneOrMore()) {
                this.isRootAlternative = false;
            }
            SerializationElement serializationResult = new ListOfSerializationNode();
            @NonNull List elements = SerializationUtils.getElements((CompoundElement)group);
            if (elements.size() > 1) {
                this.isRootAlternative = false;
            }
            for (AbstractElement element : elements) {
                SerializationElement serializationElement = this.analyze(element);
                serializationResult = serializationResult.addConcatenation(serializationElement);
            }
            this.isRootAlternative = savedIsRootAlternative;
            SerializationElement frozenSequence = serializationResult.freezeSequences((CompoundElement)group, GrammarCardinality.toEnum((AbstractElement)group), this.isRootAlternative);
            return frozenSequence;
        }

        public @NonNull SerializationElement caseKeyword(Keyword keyword) {
            assert (keyword != null);
            GrammarCardinality grammarCardinality = GrammarCardinality.toEnum((AbstractElement)keyword);
            if (grammarCardinality.mayBeZero()) {
                return NullSerializationNode.INSTANCE;
            }
            return new UnassignedKeywordSerializationNode(keyword, this.producedEClass, grammarCardinality);
        }

        public @NonNull SerializationElement caseRuleCall(RuleCall ruleCall) {
            assert (ruleCall != null);
            assert (!(ruleCall.eContainer() instanceof Assignment));
            AbstractRule abstractRule = SerializationUtils.getRule((RuleCall)ruleCall);
            AbstractRuleAnalysis calledRuleAnalysis = this.grammarAnalysis.getRuleAnalysis(abstractRule);
            if (!(calledRuleAnalysis instanceof ParserRuleAnalysis)) {
                return NullSerializationNode.INSTANCE;
            }
            GrammarCardinality grammarCardinality = GrammarCardinality.toEnum((AbstractElement)ruleCall);
            return new UnassignedGrammarRuleCallSerializationNode(this.producedEClass, grammarCardinality, calledRuleAnalysis);
        }

        public @NonNull SerializationNode defaultCase(EObject object) {
            throw new UnsupportedOperationException("Unsupported '" + object.eClass().getName() + "' in AbstractElement2SerializationElement");
        }

        private @NonNull SerializationElement doAlternatives(@NonNull Alternatives alternatives, @NonNull List<@NonNull SerializationElement> alternativeSerializationElements, @NonNull GrammarCardinality grammarCardinality) {
            if (grammarCardinality.isZeroOrMore()) {
                SerializationElement conjunction = new ListOfSerializationNode();
                for (SerializationElement alternativeSerializationElement : alternativeSerializationElements) {
                    SerializationElement frozen = alternativeSerializationElement.setGrammarCardinality((CompoundElement)alternatives, GrammarCardinality.ZERO_OR_MORE).freezeSequences((CompoundElement)alternatives, GrammarCardinality.ONE, this.isRootAlternative);
                    conjunction = conjunction.addConcatenation(frozen);
                }
                SerializationElement frozen = conjunction.freezeSequences((CompoundElement)alternatives, GrammarCardinality.ONE, this.isRootAlternative);
                return frozen;
            }
            if (grammarCardinality.isOneOrMore()) {
                ListOfListOfSerializationNode disjunction = new ListOfListOfSerializationNode();
                for (SerializationElement alternativeSerializationElement1 : alternativeSerializationElements) {
                    SerializationElement conjunction = new ListOfSerializationNode();
                    for (SerializationElement alternativeSerializationElement2 : alternativeSerializationElements) {
                        GrammarCardinality termCardinality = alternativeSerializationElement1 != alternativeSerializationElement2 ? GrammarCardinality.ZERO_OR_MORE : GrammarCardinality.ONE_OR_MORE;
                        conjunction = conjunction.addConcatenation(alternativeSerializationElement2.setGrammarCardinality((CompoundElement)alternatives, termCardinality));
                    }
                    SerializationElement frozen = conjunction.freezeSequences((CompoundElement)alternatives, GrammarCardinality.ONE, false);
                    disjunction = disjunction.addConjunction(frozen);
                }
                return disjunction;
            }
            if (grammarCardinality.isZeroOrOne()) {
                ListOfListOfSerializationNode disjunction = new ListOfListOfSerializationNode();
                for (SerializationElement alternativeSerializationElement : alternativeSerializationElements) {
                    SerializationElement conjunction = new ListOfSerializationNode();
                    conjunction = conjunction.addConcatenation(alternativeSerializationElement);
                    SerializationElement frozen = conjunction.freezeSequences((CompoundElement)alternatives, GrammarCardinality.ONE, this.isRootAlternative);
                    disjunction = disjunction.addConjunction(frozen);
                }
                disjunction = disjunction.addConjunction(NullSerializationNode.INSTANCE);
                return disjunction;
            }
            ListOfListOfSerializationNode disjunction = new ListOfListOfSerializationNode();
            for (SerializationElement alternativeSerializationElement : alternativeSerializationElements) {
                SerializationElement conjunction = new ListOfSerializationNode();
                conjunction = conjunction.addConcatenation(alternativeSerializationElement);
                SerializationElement frozen = conjunction.freezeSequences((CompoundElement)alternatives, GrammarCardinality.ONE, this.isRootAlternative);
                disjunction = disjunction.addConjunction(frozen);
            }
            return disjunction;
        }

        private @NonNull Iterable<@NonNull AbstractRuleAnalysis> getTargetRuleAnalyses(@NonNull Iterable<@NonNull DirectAssignmentAnalysis> assignmentAnalyses) {
            @NonNull HashSet<@NonNull AbstractRuleAnalysis> targetRuleAnalyses = new HashSet<AbstractRuleAnalysis>();
            for (DirectAssignmentAnalysis assignmentAnalysis : assignmentAnalyses) {
                targetRuleAnalyses.addAll((Collection<AbstractRuleAnalysis>)assignmentAnalysis.getTargetRuleAnalyses());
            }
            return targetRuleAnalyses;
        }

        public @NonNull String toString() {
            return this.parserRuleAnalysis.toString();
        }

        protected static final class AlterantiveSerializationElementComparator
        extends SerializationUtils.ToStringComparator<SerializationElement> {
            private @NonNull Map<@NonNull EStructuralFeature, @NonNull Integer> eFeature2index = new HashMap<EStructuralFeature, Integer>();

            public AlterantiveSerializationElementComparator(@Nullable Iterable<@NonNull EStructuralFeature> eFeatures) {
                if (eFeatures != null) {
                    int index = 0;
                    for (EStructuralFeature eFeature : eFeatures) {
                        this.eFeature2index.put(eFeature, index++);
                    }
                }
            }

            public int compare(@NonNull SerializationElement o1, @NonNull SerializationElement o2) {
                int i2;
                @Nullable Integer x1 = o1 instanceof AbstractAssignedSerializationNode ? this.eFeature2index.get(((AbstractAssignedSerializationNode)o1).getEStructuralFeature()) : null;
                Integer x2 = o2 instanceof AbstractAssignedSerializationNode ? this.eFeature2index.get(((AbstractAssignedSerializationNode)o2).getEStructuralFeature()) : null;
                int i1 = x1 != null ? x1 : -1;
                int n = i2 = x2 != null ? x2 : -1;
                if (i1 != i2) {
                    return i1 - i2;
                }
                return super.compare((Object)o1, (Object)o2);
            }
        }
    }
}

