/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import lpg.runtime.Differ;
import lpg.runtime.ILexStream;
import lpg.runtime.IPrsStream;
import lpg.runtime.LexStream;
import lpg.runtime.UnknownStreamType;
import lpg.runtime.Utf8LexStream;

public class DifferTokens
extends Differ {
    protected DifferTokens() {
    }

    public DifferTokens(IPrsStream newStream, IPrsStream oldStream) {
        super(newStream, oldStream);
    }

    public Differ.ILine[] getBuffer(IPrsStream stream) {
        Differ.ILine[] buffer = new Token[stream.getStreamLength()];
        int i = 1;
        while (i < stream.getStreamLength()) {
            buffer[i] = new Token(stream, i);
            ++i;
        }
        return buffer;
    }

    void printLines(IPrsStream prs_stream, int first_token, int last_token) {
        int start_line = prs_stream.getLine(first_token);
        int end_line = prs_stream.getLine(last_token);
        ILexStream lex_stream = prs_stream.getLexStream();
        char[] char_buffer = null;
        byte[] byte_buffer = null;
        if (lex_stream instanceof LexStream) {
            char_buffer = ((LexStream)lex_stream).getInputChars();
        } else if (lex_stream instanceof Utf8LexStream) {
            byte_buffer = ((Utf8LexStream)lex_stream).getInputBytes();
        } else {
            throw new UnknownStreamType("Unknown stream type " + lex_stream.getClass().toString());
        }
        int start = lex_stream.getLineOffset(start_line - 1) + 1;
        int end = lex_stream.getLineOffset(start_line);
        if (start_line == end_line) {
            String num = "" + start_line;
            int i = 0;
            while (i < 6 - num.length()) {
                System.out.print(' ');
                ++i;
            }
            String line = char_buffer != null ? new String(char_buffer, start, end - start) : new String(byte_buffer, start, end - start);
            System.out.println(String.valueOf(start_line) + " " + line);
            System.out.print("       ");
            int i2 = 0;
            while (i2 < prs_stream.getColumn(first_token) - 1) {
                System.out.print(' ');
                ++i2;
            }
            int length = prs_stream.getEndColumn(last_token) - prs_stream.getColumn(first_token);
            if (length < 2) {
                System.out.println('^');
            } else {
                System.out.print('<');
                int i3 = 1;
                while (i3 < length) {
                    System.out.print('-');
                    ++i3;
                }
                System.out.println('>');
            }
        } else {
            System.out.print("       ");
            int i = 0;
            while (i < prs_stream.getColumn(first_token) - 1) {
                System.out.print(' ');
                ++i;
            }
            int last_column = lex_stream.getColumn(lex_stream.getPrevious(end));
            System.out.print('<');
            int i4 = prs_stream.getColumn(first_token) + 1;
            while (i4 < last_column) {
                System.out.print('-');
                ++i4;
            }
            System.out.println();
            int line_no = start_line;
            while (line_no <= end_line) {
                start = lex_stream.getLineOffset(line_no - 1) + 1;
                end = lex_stream.getLineOffset(line_no);
                String num = "" + line_no;
                int i5 = 0;
                while (i5 < 6 - num.length()) {
                    System.out.print(' ');
                    ++i5;
                }
                String line = char_buffer != null ? new String(char_buffer, start, end - start) : new String(byte_buffer, start, end - start);
                System.out.println(String.valueOf(line_no) + " " + line);
                ++line_no;
            }
            System.out.print("       ");
            i4 = 0;
            while (i4 < prs_stream.getEndColumn(last_token) - 1) {
                System.out.print('-');
                ++i4;
            }
            System.out.println('>');
        }
    }

    void outputInsert(Differ.Change element) {
        this.insertCount += element.getNewe() - element.getNews() + 1;
        System.out.println("Insert after " + this.oldStream.getFileName() + "," + this.oldStream.getLine(element.getOlde()) + ":" + this.oldStream.getEndColumn(element.getOlde()) + " " + this.newStream.getFileName() + "," + this.newStream.getLine(element.getNews()) + ":" + this.newStream.getColumn(element.getNews()) + ".." + this.newStream.getLine(element.getNewe()) + ":" + this.newStream.getEndColumn(element.getNewe()) + ":");
        this.printLines(this.newStream, element.getNews(), element.getNewe());
    }

    void outputDelete(Differ.Change element) {
        this.deleteCount += element.getOlde() - element.getOlds() + 1;
        System.out.println("Delete after " + this.newStream.getFileName() + "," + this.newStream.getLine(element.getNewe()) + ":" + this.newStream.getEndColumn(element.getNewe()) + " " + this.oldStream.getFileName() + "," + this.oldStream.getLine(element.getOlds()) + ":" + this.oldStream.getColumn(element.getOlds()) + ".." + this.oldStream.getLine(element.getOlde()) + ":" + this.oldStream.getEndColumn(element.getOlde()) + ":");
        this.printLines(this.oldStream, element.getOlds(), element.getOlde());
    }

    void outputReplace(Differ.Change element) {
        this.replaceDeleteCount += element.getOlde() - element.getOlds() + 1;
        this.replaceInsertCount += element.getNewe() - element.getNews() + 1;
        System.out.println("Replace " + this.oldStream.getFileName() + "," + this.oldStream.getLine(element.getOlds()) + ":" + this.oldStream.getColumn(element.getOlds()) + ".." + this.oldStream.getLine(element.getOlde()) + ":" + this.oldStream.getEndColumn(element.getOlde()) + ":");
        this.printLines(this.oldStream, element.getOlds(), element.getOlde());
        System.out.println("With " + this.newStream.getFileName() + "," + this.newStream.getLine(element.getNews()) + ":" + this.newStream.getColumn(element.getNews()) + ".." + this.newStream.getLine(element.getNewe()) + ":" + this.newStream.getEndColumn(element.getNewe()) + ":");
        this.printLines(this.newStream, element.getNews(), element.getNewe());
    }

    void outputMove(Differ.Change element) {
        this.moveCount += element.getNewe() - element.getNews() + 1;
        System.out.println("Move " + this.oldStream.getFileName() + "," + this.oldStream.getLine(element.getOlds()) + ":" + this.oldStream.getColumn(element.getOlds()) + ".." + this.oldStream.getLine(element.getOlde()) + ":" + this.oldStream.getEndColumn(element.getOlde()) + " to " + this.newStream.getFileName() + "," + this.newStream.getLine(element.getNews()) + ":" + this.newStream.getColumn(element.getNews()) + ".." + this.newStream.getLine(element.getNewe()) + ":" + this.newStream.getEndColumn(element.getNewe()) + ":");
        this.printLines(this.newStream, element.getNews(), element.getNewe());
    }

    void outputMoveDelete(Differ.Change element) {
        int bound = element.getNewe() - element.getNews();
        this.moveCount += bound + 1;
        System.out.println("Move " + this.oldStream.getFileName() + "," + this.oldStream.getLine(element.getOlds()) + ":" + this.oldStream.getColumn(element.getOlds()) + ".." + this.oldStream.getLine(element.getOlds() + bound) + ":" + this.oldStream.getEndColumn(element.getOlds() + bound) + " to " + this.newStream.getFileName() + "," + this.newStream.getLine(element.getNews()) + ":" + this.newStream.getColumn(element.getNews()) + ".." + this.newStream.getLine(element.getNewe()) + ":" + this.newStream.getEndColumn(element.getNewe()) + ":");
        this.printLines(this.newStream, element.getNews(), element.getNewe());
        int oldi = element.getOlds() + bound + 1;
        this.deleteCount += element.getOlde() - oldi + 1;
        System.out.println("... And delete " + this.oldStream.getFileName() + "," + this.oldStream.getLine(oldi) + ":" + this.oldStream.getColumn(oldi) + ".." + this.oldStream.getLine(element.getOlde()) + ":" + this.oldStream.getEndColumn(element.getOlde()));
        this.printLines(this.oldStream, oldi, element.getOlde());
    }

    void outputMoveInsert(Differ.Change element) {
        int bound = element.getOlde() - element.getOlds();
        this.moveCount += element.getOlde() - element.getOlds() + 1;
        System.out.println("Move " + this.oldStream.getFileName() + "," + this.oldStream.getLine(element.getOlds()) + ":" + this.oldStream.getColumn(element.getOlds()) + ".." + this.oldStream.getLine(element.getOlde()) + ":" + this.oldStream.getEndColumn(element.getOlde()) + " to " + this.newStream.getFileName() + "," + this.newStream.getLine(element.getNews()) + ":" + this.newStream.getColumn(element.getNews()) + ".." + this.newStream.getLine(element.getNews() + bound) + ":" + this.newStream.getEndColumn(element.getNews() + bound) + ":");
        this.printLines(this.newStream, element.getNews(), element.getNews() + bound);
        int newi = element.getNews() + bound + 1;
        this.insertCount += element.getNewe() - newi + 1;
        System.out.println("... And insert " + this.newStream.getFileName() + "," + this.newStream.getLine(newi) + ":" + this.newStream.getColumn(newi) + ".." + this.newStream.getLine(element.getNewe()) + ":" + this.newStream.getEndColumn(element.getNewe()) + ":");
        this.printLines(this.newStream, newi, element.getNewe());
    }

    public class Token
    implements Differ.ILine {
        private int kind;
        private int start_line;
        private int start_column;
        private int end_line;
        private int end_column;
        private String name;
        private int hash_code;

        public Token(IPrsStream stream, int token) {
            this.kind = stream.getKind(token);
            this.name = stream.getName(token);
            this.start_line = stream.getLine(token);
            this.start_column = stream.getColumn(token);
            this.end_line = stream.getEndLine(token);
            this.end_column = stream.getEndColumn(token);
            this.hash_code = this.name.hashCode();
        }

        public final int size() {
            return this.name.length();
        }

        public final int hashCode() {
            return this.hash_code;
        }

        public final boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof Token) {
                Token another_token = (Token)anObject;
                return this.kind == another_token.kind && this.name.equals(another_token.name);
            }
            return false;
        }

        public final int getStartLine() {
            return this.start_line;
        }

        public final int getStartColumn() {
            return this.start_column;
        }

        public final int getEndLine() {
            return this.end_line;
        }

        public final int getEndColumn() {
            return this.end_column;
        }

        public final String toString() {
            return this.name;
        }
    }
}

