/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.tests.PivotTestSuite;
import org.eclipse.ocl.examples.pivot.tests.TestOCL;
import org.eclipse.ocl.examples.xtext.tests.TestFileSystem;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteEnvironment;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotTables;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.messages.StatusCodes;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.SemanticException;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.BagValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.MapValue;
import org.eclipse.ocl.pivot.values.OrderedSetValue;
import org.eclipse.ocl.pivot.values.SequenceValue;
import org.eclipse.ocl.pivot.values.SetValue;
import org.eclipse.ocl.xtext.essentialocl.cs2as.EssentialOCLCS2ASMessages;
import org.eclipse.ocl.xtext.oclinecore.OCLinEcoreStandaloneSetup;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IteratorsTest4
extends PivotTestSuite {
    public static final @NonNull String VIOLATED_TEMPLATE = "The ''{0}'' constraint is violated for ''{1}''";

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public IteratorsTest4(boolean useCodeGen) {
        super(useCodeGen);
    }

    @Override
    protected @NonNull String getTestPackageName() {
        return "Iterators";
    }

    @BeforeClass
    public static void resetCounter() throws Exception {
        PivotTestSuite.resetCounter();
    }

    @Override
    protected @NonNull MyOCL createOCL() {
        return new MyOCL(this.getTestFileSystem(), this.getTestPackageName(), this.getName());
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        PivotTables.LIBRARY.getClass();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void test_any() {
        MyOCL ocl = this.createOCL();
        EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)ocl.getEnvironmentFactory();
        ocl.getEnvironmentFactory().setSafeNavigationValidationSeverity(StatusCodes.Severity.WARNING);
        Class pkg1Type = environmentFactory.getASClass("Package");
        ocl.assertQueryEquals(ocl.pkg1, ocl.bob, "let op : Set(Package[*|?]) = ownedPackages in op->any(p : ocl::Package[?] | p?.name = 'bob')");
        ocl.assertQueryEquals(ocl.pkg1, ocl.bob, "let op : Set(Package[*|?]) = ownedPackages in op?->any(p : ocl::Package | p.name = 'bob')");
        ocl.assertQueryEquals(ocl.pkg1, ocl.bob, "let op : Set(Package[*|?]) = ownedPackages in op?->any(p : ocl::Package[1] | p.name = 'bob')");
        ocl.assertValidationErrorQuery(pkg1Type, "let op : Set(Package[*|?]) = ownedPackages in op->any(p : ocl::Package[1] | p.name = 'bob')", PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, "IteratorExp::UnsafeSourceCanNotBeNull", "op->any(p : Package[1] | p.name.=('bob'))");
        ocl.assertValidationErrorQuery(pkg1Type, "let op : Set(Package[*|?]) = ownedPackages in op->any(p : ocl::Package[?] | p.name = 'bob')", PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, "PropertyCallExp::UnsafeSourceCanNotBeNull", "p.name");
        ocl.assertQueryEquals(ocl.pkg1, ocl.bob, "let op : Set(Package[*|1]) = ownedPackages in op->any(p | p.name = 'bob')");
        ocl.assertQueryEquals(ocl.pkg1, ocl.bob, "let op : Set(Package[*|?]) = ownedPackages in op?->any(p | p.name = 'bob')");
        ocl.assertQueryEquals(ocl.pkg1, ocl.bob, "let op : Set(Package[*|?]) = ownedPackages in op?->any(name = 'bob')");
        ocl.assertQueryNotSame(ocl.pkg1, ocl.bob, "let op : Set(Package[*|?]) = ownedPackages in op?->any(name = 'pkg2')");
        ocl.assertQueryInvalid(null, "Sequence{}->any(s | s = false)");
        ocl.assertQueryFalse(null, "Sequence{false}->any(s | s = false)");
        ocl.assertQueryFalse(null, "Sequence{false, false}->any(s | s = false)");
        ocl.assertQueryInvalid(null, "Sequence{}->any(s | s = null)");
        ocl.assertValidationErrorQuery(pkg1Type, "Sequence{null}->any(s | s = null)", PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, "IteratorExp::UnsafeSourceCanNotBeNull", "Sequence{null}->any(s : OclVoid[1] | s.=(null))");
        ocl.assertValidationErrorQuery(pkg1Type, "Sequence{null, null}->any(s | s = null)", PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, "IteratorExp::UnsafeSourceCanNotBeNull", "Sequence{null, null}->any(s : OclVoid[1] | s.=(null))");
        ocl.assertQueryDefined(ocl.pkg1, "let op : Set(Package[*|1]) = ownedPackages in op->any(true)");
        ocl.assertQueryInvalid(ocl.pkg1, "let op : Set(Package[*|1]) = ownedPackages in op->any(false)");
        ocl.assertQueryDefined(ocl.pkg1, "let op : Set(Package[*|?]) = ownedPackages in op?->any(true)");
        ocl.assertQueryEquals(null, 2, "Map{2 <- 1, 1 <- 2}->any(key <- value | key > value)");
        ocl.assertQueryInvalid(null, "Map{2 <- 1, 1 <- 2}->any(key <- value | key = value)");
        ocl.dispose();
    }

    @Test
    public void test_any_invalidBody_142518() {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryInvalid(null, "Bag{1, 2, 3}->any('true')");
        ocl.assertQueryInvalid(null, "Bag{1, 2, 3}->any(2)");
        ocl.assertQueryInvalid(EcorePackage.eINSTANCE, "let b:Boolean = null in Bag{1, 2, 3}->any(b and b)");
        ocl.assertQueryInvalid(EcorePackage.eINSTANCE, "Bag{1, 2, 3}->any(null.oclAsType(Boolean))");
        ocl.dispose();
    }

    @Test
    public void test_closure() {
        MyOCL ocl = this.createOCL();
        EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)ocl.getEnvironmentFactory();
        IdResolver idResolver = ocl.getIdResolver();
        @NonNull Type packageType = (Type)ClassUtil.nonNullState((Object)environmentFactory.getASClass("Package"));
        CollectionTypeId typeId = TypeId.SET.getSpecializedId(new ElementId[]{packageType.getTypeId()});
        SetValue expected1 = idResolver.createSetOfEach(typeId, new Object[]{ocl.pkg1, ocl.pkg3, ocl.pkg5, ocl.george});
        ocl.assertQueryEquals(ocl.george, expected1, "self.oclAsType(Package)->closure(owningPackage)");
        SetValue expected2 = idResolver.createSetOfEach(typeId, new Object[]{ocl.pkg1, ocl.pkg2, ocl.jim, ocl.bob, ocl.pkg3, ocl.pkg4, ocl.pkg5, ocl.george});
        ocl.assertQueryEquals(ocl.pkg1, expected2, "self.oclAsType(Package)->closure(ownedPackages)");
        ocl.assertQueryEquals(ocl.pkg1, expected2, "self.oclAsType(Package)->closure(ownedPackages->asSequence())");
        SetValue expected3 = idResolver.createSetOfEach(typeId, new Object[]{ocl.pkg1, ocl.pkg2, ocl.jim, ocl.bob, ocl.pkg3, ocl.pkg4, ocl.pkg5, ocl.george});
        ocl.assertQueryEquals(ocl.pkg1, expected3, "self.oclAsType(Package)->asBag()->closure(ownedPackages)");
        ocl.assertQueryEquals(ocl.pkg1, expected3, "self.oclAsType(Package)->closure(ownedPackages->asBag())");
        CollectionTypeId collectedId = expected1.getTypeId();
        ocl.assertQueryEquals(ocl.pkg1, idResolver.createSetOfEach(collectedId, new Object[]{ocl.pkg1}), "self.oclAsType(Package)->closure(owningPackage)");
        collectedId = TypeId.ORDERED_SET.getSpecializedId(new ElementId[]{packageType.getTypeId()});
        ocl.assertQueryEquals(ocl.pkg1, idResolver.createOrderedSetOfEach(collectedId, new Object[]{ocl.pkg1}), "self.oclAsType(Package)->asSequence()->closure(owningPackage)");
        ocl.dispose();
    }

    @Test
    public void test_closure_cycles() {
        MyOCL ocl = this.createOCL();
        EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)ocl.getEnvironmentFactory();
        IdResolver idResolver = ocl.getIdResolver();
        @NonNull Class packageMetaclass = (Class)ClassUtil.nonNullState((Object)environmentFactory.getASClass("Package"));
        CollectionTypeId typeId = TypeId.SET.getSpecializedId(new ElementId[]{packageMetaclass.getTypeId()});
        Property ownedPackages = this.getAttribute(packageMetaclass, "ownedPackages", (Type)packageMetaclass);
        Property owningPackage = this.getAttribute(packageMetaclass, "owningPackage", (Type)packageMetaclass);
        assert (owningPackage != null && ownedPackages != null);
        SetValue expected = idResolver.createSetOfEach(typeId, new Object[]{ownedPackages, owningPackage});
        ocl.assertQueryEquals(owningPackage, expected, "self->closure(opposite)");
        ocl.assertQueryEquals(ownedPackages, expected, "self->closure(opposite)");
        ocl.dispose();
    }

    @Test
    public void test_closure_operations() {
        MyOCL ocl = this.createOCL();
        Resource fakeResource = new XMIResourceFactoryImpl().createResource(URI.createURI((String)"fake"));
        Model fakeRoot = PivotUtil.createModel(null);
        Package fakePkg = PivotUtil.createOwnedPackage((Model)fakeRoot, (String)"fake");
        fakeResource.getContents().add((Object)fakePkg);
        Class fake = ocl.createOwnedClass(fakePkg, "Fake", false);
        ocl.createGeneralization(fake, (Class)ocl.getStandardLibrary().getOclAnyType());
        Operation getFakes = ocl.createOwnedOperation(fake, "getFakes", null, null, (Type)fake, true);
        getFakes.setType((Type)ocl.getCompleteEnvironment().getSetType((Type)fake, false, null, null));
        ocl.assertQuery(fake, "self->closure(getFakes())");
        ocl.dispose();
    }

    @Test
    public void test_closureValidation_typeConformance_154695() {
        MyOCL ocl = this.createOCL();
        StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
        CompleteEnvironment completeEnvironment = ocl.getCompleteEnvironment();
        Resource fakeResource = new XMIResourceFactoryImpl().createResource(URI.createURI((String)"fake"));
        Model fakeRoot = PivotUtil.createModel(null);
        Package fakePkg = PivotUtil.createOwnedPackage((Model)fakeRoot, (String)"fake");
        fakeResource.getContents().add((Object)fakePkg);
        Class fake = ocl.createOwnedClass(fakePkg, "Fake", false);
        Operation getFakes = ocl.createOwnedOperation(fake, "getFakes", null, null, (Type)completeEnvironment.getSetType((Type)fake, false, null, null), true);
        Class subFake = ocl.createOwnedClass(fakePkg, "Subfake", false);
        ocl.createGeneralization(subFake, fake);
        ocl.createGeneralization(fake, (Class)standardLibrary.getOclAnyType());
        Operation getSubFakes = ocl.createOwnedOperation(fake, "getSubFakes", null, null, (Type)completeEnvironment.getSetType((Type)subFake, false, null, null), true);
        ocl.assertValidationErrorQuery(subFake, "self->closure(getFakes())", VIOLATED_TEMPLATE, "IteratorExp::ClosureBodyElementTypeIsIteratorType", "self.oclAsSet()->closure(1_ : fake::Subfake[1] | 1_.getFakes())");
        ocl.assertQuery(fake, "self->closure(getSubFakes())");
        ocl.dispose();
    }

    @Test
    public void test_closure_body_393509() {
        MyOCL ocl = this.createOCL();
        EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)ocl.getEnvironmentFactory();
        IdResolver idResolver = ocl.getIdResolver();
        @NonNull Class packageMetaclass = (Class)ClassUtil.nonNullState((Object)environmentFactory.getASClass("Package"));
        @NonNull Class propertyMetaclass = (Class)ClassUtil.nonNullState((Object)environmentFactory.getASClass("Property"));
        CollectionTypeId typeId = TypeId.SET.getSpecializedId(new ElementId[]{packageMetaclass.getTypeId()});
        Property owningPackage = this.getAttribute(packageMetaclass, "owningPackage", (Type)packageMetaclass);
        SetValue expected = idResolver.createSetOfEach(typeId, new Object[]{owningPackage, packageMetaclass, packageMetaclass.eContainer(), packageMetaclass.eContainer().eContainer()});
        ocl.assertQueryEquals(owningPackage, expected, "self->closure(i : OclElement | i.oclContainer())");
        ocl.assertValidationErrorQuery(propertyMetaclass, "self->closure(oclContainer())", VIOLATED_TEMPLATE, "IteratorExp::ClosureBodyElementTypeIsIteratorType", "self.oclAsSet()->closure(1_ : Property[1] | 1_.oclContainer())");
        ocl.dispose();
    }

    @Test
    public void test_closure_invalidBody_142518() {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryInvalid(ocl.getUMLMetamodel(), "let c : ocl::Type = invalid in ownedClasses->closure(c)", PivotMessages.InvalidLiteral, InvalidValueException.class);
        ocl.assertQueryResults(null, "Set{5, null}", "let c : Set(Integer) = Set{null} in 5->closure(c)");
        ocl.dispose();
    }

    @Test
    public void test_closure_recursions_401302() throws IOException {
        MyOCL ocl = this.createOCL();
        if (!EcorePlugin.IS_ECLIPSE_RUNNING) {
            OCLinEcoreStandaloneSetup.doSetup();
        }
        String nodeModel = "package nodes : nodes = 'http://nodes'{\n    class Node {\n    \tproperty nodes : Node[*] {ordered,!unique};\n    \tproperty name : String;\n\t }\n}\n";
        URI uri = this.createEcoreFile((OCL)ocl, "NodeModel", nodeModel);
        Resource ecoreResource = ocl.getResourceSet().getResource(uri, true);
        EPackage nodesEPackage = (EPackage)ecoreResource.getContents().get(0);
        EClass nodeEClass = (EClass)nodesEPackage.getEClassifier("Node");
        EAttribute nameEAttribute = (EAttribute)nodeEClass.getEStructuralFeature("name");
        EReference nodesEReference = (EReference)nodeEClass.getEStructuralFeature("nodes");
        EFactory nodesEFactory = nodesEPackage.getEFactoryInstance();
        EObject node1 = nodesEFactory.create(nodeEClass);
        EObject node2 = nodesEFactory.create(nodeEClass);
        EObject node3 = nodesEFactory.create(nodeEClass);
        EObject node4 = nodesEFactory.create(nodeEClass);
        EObject node5 = nodesEFactory.create(nodeEClass);
        node1.eSet((EStructuralFeature)nameEAttribute, (Object)"node1");
        node2.eSet((EStructuralFeature)nameEAttribute, (Object)"node2");
        node3.eSet((EStructuralFeature)nameEAttribute, (Object)"node3");
        node4.eSet((EStructuralFeature)nameEAttribute, (Object)"node4");
        node5.eSet((EStructuralFeature)nameEAttribute, (Object)"node5");
        ((List)node1.eGet((EStructuralFeature)nodesEReference)).add(node2);
        ((List)node2.eGet((EStructuralFeature)nodesEReference)).add(node1);
        ((List)node2.eGet((EStructuralFeature)nodesEReference)).add(node1);
        ((List)node2.eGet((EStructuralFeature)nodesEReference)).add(node2);
        ((List)node2.eGet((EStructuralFeature)nodesEReference)).add(node3);
        ((List)node2.eGet((EStructuralFeature)nodesEReference)).add(node4);
        ((List)node2.eGet((EStructuralFeature)nodesEReference)).add(node5);
        ((List)node2.eGet((EStructuralFeature)nodesEReference)).add(node2);
        ((List)node2.eGet((EStructuralFeature)nodesEReference)).add(node1);
        ((List)node2.eGet((EStructuralFeature)nodesEReference)).add(node1);
        ocl.assertQueryEquals(node1, 5, "self->closure(nodes)->size()");
        ocl.dispose();
    }

    @Test
    public void test_collect() {
        MyOCL ocl = this.createOCL();
        EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)ocl.getEnvironmentFactory();
        IdResolver idResolver = ocl.getIdResolver();
        @NonNull Type packageType = (Type)ClassUtil.nonNullState((Object)environmentFactory.getASClass("Package"));
        CollectionTypeId typeId = TypeId.BAG.getSpecializedId(new ElementId[]{packageType.getTypeId()});
        BagValue expected1 = idResolver.createBagOfEach(typeId, new Object[]{"pkg2", "bob", "pkg3"});
        ocl.assertQueryEquals(ocl.pkg1, expected1, "ownedPackages?->collect(p : ocl::Package | p.name)");
        ocl.assertQueryEquals(ocl.pkg1, expected1, "ownedPackages?->collect(p | p.name)");
        ocl.assertQueryEquals(ocl.pkg1, expected1, "ownedPackages?->collect(name)");
        ocl.assertQueryEquals(ocl.pkg1, expected1, "ownedPackages?.name");
        BagValue expected2 = idResolver.createBagOfEach(typeId, new Object[]{ocl.jim, ocl.pkg4, ocl.pkg5});
        ocl.assertQueryEquals(ocl.pkg1, expected2, "ownedPackages?.ownedPackages");
        ocl.assertQueryResults(ocl.pkg1, "Sequence{1,2}", "let s:Sequence(OclAny) = Sequence{'a','bb'} in s->collect(oclAsType(String)).size()");
        ocl.assertQueryResults(ocl.pkg1, "Sequence{1,4,9}", "Sequence{1..3}->collect(k | k*k)");
        ocl.assertQueryResults(ocl.pkg1, "Sequence{null, null, null}", "Sequence{1..3}->collect(k | null)");
        ocl.dispose();
    }

    @Test
    public void test_collect_empty_217461() {
        MyOCL ocl = this.createOCL();
        String self = "foo";
        List expected = Collections.emptyList();
        ocl.assertQueryEquals(self, expected, "let c : Sequence(OrderedSet(String)) = Sequence{} in c->collect(s : OrderedSet(String) | s.toUpperCase())");
        ocl.dispose();
    }

    @Test
    public void test_collect_flattens_217461() {
        MyOCL ocl = this.createOCL();
        IdResolver idResolver = ocl.getIdResolver();
        String self = "foo";
        CollectionTypeId typeId = TypeId.SEQUENCE.getSpecializedId(new ElementId[]{TypeId.STRING});
        SequenceValue expected = idResolver.createSequenceOfEach(typeId, new Object[]{"THIS AND", "THAT", "THE OTHER"});
        ocl.assertQueryEquals(self, expected, "Sequence{Sequence{'this and', 'that'}, Sequence{'the other'}}->collect(s : Sequence(String) | s.toUpperCase())");
        ocl.dispose();
    }

    @Test
    public void test_collect_implicit_unknownAttribute_232669() {
        MyOCL ocl = this.createOCL();
        EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)ocl.getEnvironmentFactory();
        ocl.assertBadInvariant(SemanticException.class, 4, environmentFactory.getASClass("Package"), "ownedPackages.unknownAttribute", PivotMessagesInternal.UnresolvedProperty_ERROR_, "Set(Package)", "unknownAttribute");
        ocl.dispose();
    }

    @Test
    public void test_collect_implicit_unknownOperation_232669() {
        MyOCL ocl = this.createOCL();
        EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)ocl.getEnvironmentFactory();
        ocl.assertBadInvariant(SemanticException.class, 4, environmentFactory.getASClass("Package"), "ownedPackages.unknownOperation(self)", PivotMessagesInternal.UnresolvedOperationCall_ERROR_, "Set(Package)", "unknownOperation", "self");
        ocl.dispose();
    }

    @Test
    public void test_collect_invalidBody_142518() {
        MyOCL ocl = this.createOCL();
        IdResolver idResolver = ocl.getIdResolver();
        ocl.assertQueryInvalid(EcorePackage.eINSTANCE, "Bag{1, 2, 3}->collect(Sequence{}->first())");
        CollectionTypeId typeId = TypeId.BAG.getSpecializedId(new ElementId[]{TypeId.OCL_ANY});
        BagValue expected = idResolver.createBagOfEach(typeId, new Object[]{null, null, null});
        ocl.assertQueryEquals(EcorePackage.eINSTANCE, expected, "let b:Boolean = null in Bag{1, 2, 3}->collect(null)");
        ocl.dispose();
    }

    @Test
    public void test_collectBy() {
        MyOCL ocl = this.createOCL();
        IdResolver idResolver = ocl.getIdResolver();
        CollectionTypeId typeId = TypeId.BAG.getSpecializedId(new ElementId[]{TypeId.INTEGER});
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        int i = 1;
        while (i <= 5) {
            map.put(i, i * i);
            ++i;
        }
        MapValue expected1 = idResolver.createMapOfAll((TypeId)TypeId.INTEGER, (TypeId)TypeId.INTEGER, map);
        SetValue expected1k = idResolver.createSetOfAll(typeId, map.keySet());
        BagValue expected1v = idResolver.createBagOfAll(typeId, map.values());
        ocl.assertQueryEquals(null, expected1, "Sequence{1..5}->collectBy(i : Integer | i*i)");
        ocl.assertQueryEquals(null, expected1k, "Sequence{1..5}->collectBy(i : Integer | i*i)->keys()");
        ocl.assertQueryEquals(null, expected1v, "Sequence{1..5}->collectBy(i : Integer | i*i)->values()");
        ocl.assertQueryEquals(null, expected1, "Sequence{1..5}->collectBy(i | i*i)");
        ocl.assertQueryResults(null, "Map{9 <- Sequence{1, 4, 9, 16, 25, 16, 16}, 10 <- Sequence{1, 4, 9, 16, 25, 16, 16}}", "Sequence{9,10,9}->collectBy(Sequence{1, 4, 9, 16, 25, 16, 16})");
        ocl.assertQueryResults(null, "Map{1 <- '1', 2 <- '2', 3 <- '3', 4 <- '4', 5 <- '5', 99 <- '99' }", "Sequence{1..5,99}->collectBy(toString())");
        ocl.assertQueryResults(null, "Sequence{1..3}->collectBy(k | k*k*k)", "Sequence{1..3}->collectBy(i | i*i)->collectBy(k <- v | k*v)");
        ocl.dispose();
    }

    @Test
    public void test_collectNested() {
        MyOCL ocl = this.createOCL();
        EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)ocl.getEnvironmentFactory();
        IdResolver idResolver = ocl.getIdResolver();
        @NonNull Type packageType = (Type)ClassUtil.nonNullState((Object)environmentFactory.getASClass("Package"));
        CollectionTypeId typeId = TypeId.BAG.getSpecializedId(new ElementId[]{packageType.getTypeId()});
        BagValue expected1 = idResolver.createBagOfEach(typeId, new Object[]{"pkg2", "bob", "pkg3"});
        ocl.assertQueryEquals(ocl.pkg1, expected1, "ownedPackages?->collectNested(p : ocl::Package | p.name)");
        ocl.assertQueryEquals(ocl.pkg1, expected1, "ownedPackages?->collectNested(p | p.name)");
        ocl.assertQueryEquals(ocl.pkg1, expected1, "ownedPackages?->collectNested(name)");
        Set<Package> e1 = Collections.singleton(ocl.jim);
        Set e2 = Collections.EMPTY_SET;
        HashSet<Object> e3 = new HashSet<Object>(Arrays.asList(ocl.pkg4, ocl.pkg5));
        BagValue expected2 = idResolver.createBagOfEach(typeId, new Object[]{e1, e2, e3});
        ocl.assertQueryEquals(ocl.pkg1, expected2, "ownedPackages?->collectNested(ownedPackages)");
        ocl.assertQueryResults(ocl.pkg1, "Sequence{1,2}", "let s:Sequence(OclAny) = Sequence{'a','bb'} in s->collectNested(oclAsType(String)).size()");
        ocl.assertQueryResults(ocl.pkg1, "Sequence{Sequence{1,2},Sequence{3,4}}", "let s:Sequence(Sequence(OclAny)) = Sequence{Sequence{'a','bb'},Sequence{'ccc','dddd'}} in s->collectNested(oclAsType(Sequence(String)))->collectNested(s | s.size())");
        ocl.assertQueryResults(ocl.pkg1, "Sequence{2,1}", "let s:Sequence(Sequence(OclAny)) = Sequence{Sequence{'a','bb'},Sequence{'ccc'}} in s->collectNested(size())");
        ocl.dispose();
    }

    @Test
    public void test_collectNested_invalidBody_142518() {
        MyOCL ocl = this.createOCL();
        IdResolver idResolver = ocl.getIdResolver();
        ocl.assertQueryInvalid(EcorePackage.eINSTANCE, "Bag{1, 2, 3}->collectNested(Sequence{}->first())");
        Set<BigInteger> e1 = Collections.singleton(BigInteger.valueOf(1L));
        Object e2 = null;
        Set<BigInteger> e3 = Collections.singleton(BigInteger.valueOf(3L));
        CollectionTypeId typeId = TypeId.BAG.getSpecializedId(new ElementId[]{TypeId.INTEGER});
        BagValue expected = idResolver.createBagOfEach(typeId, new Object[]{e1, e2, e3});
        ocl.assertQueryEquals(EcorePackage.eINSTANCE, expected, "let b:Boolean = null in Bag{1, 2, 3}->collectNested(e | if e = 2 then null else Set{e} endif)");
        ocl.dispose();
    }

    @Test
    public void test_exists() {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryFalse(null, "Sequence{Sequence{false}, Sequence{false}, Sequence{false}, Sequence{false}}->exists(e | e->first())");
        ocl.assertQueryTrue(null, "Sequence{Sequence{false}, Sequence{true}, Sequence{false}, Sequence{false}}->exists(e | e->first())");
        ocl.assertQueryTrue(null, "Sequence{Sequence{false}, Sequence{true}, Sequence{null}, Sequence{true}}->exists(e | e->first())");
        ocl.assertQueryNull(null, "Sequence{Sequence{false}, Sequence{false}, Sequence{null}, Sequence{false}}->exists(e | e->first())");
        ocl.assertQueryTrue(null, "Sequence{Sequence{false}, Sequence{true}, Sequence{null}, Sequence{}}->exists(e | e->first())");
        ocl.assertQueryInvalid(null, "Sequence{Sequence{false}, Sequence{false}, Sequence{null}, Sequence{}}->exists(e | e->first())");
        ocl.assertQueryInvalid(null, "Sequence{Sequence{false}, Sequence{false}, Sequence{}, Sequence{null}}->exists(e | e->first())");
        ocl.assertQueryInvalid(null, "Sequence{Sequence{false}, Sequence{false}, Sequence{false}, Sequence{}}->exists(e | e->first())");
        ocl.assertQueryTrue(ocl.pkg1, "Sequence{'a', 'b', 'c', 'd', 'e'}->exists(e | e = 'c')");
        ocl.assertQueryTrue(ocl.pkg1, "Sequence{'a', 'b', 'c', 'c', 'e'}->exists(e | e = 'c')");
        ocl.assertQueryFalse(ocl.pkg1, "Sequence{'a', 'b', 'd', 'e'}->exists(e | e = 'c')");
        ocl.assertQueryFalse(ocl.pkg1, "Sequence{}->exists(e | e = 'c')");
        ocl.assertQueryTrue(ocl.pkg1, "ownedPackages->exists(true)");
        ocl.assertQueryTrue(null, "Map{1 <- '1', true <- 'TRUE', false <- 'FALSE'}->exists(key <- value | key <> value)");
        ocl.assertQueryTrue(null, "Map{1 <- '1', true <- 'TRUE', false <- 'FALSE'}->exists(key | key <> null)");
        ocl.assertQueryTrue(null, "Map{1 <- '1', true <- 'TRUE', null <- null}->exists(key | key <> null)");
        ocl.assertQueryTrue(null, "Map{1 <- '1', true <- 'TRUE', null <- null}->exists(key  <- value| key = value)");
        ocl.assertQueryFalse(null, "Map{1 <- '1', true <- 'TRUE', null <- 'null'}->exists(key  <- value| key = value)");
        ocl.assertQueryFalse(null, "Map{1 <- '1', true <- 'TRUE', 'null' <- null}->exists(key  <- value| key = value)");
        ocl.assertQueryInvalid(null, "Map{1 <- '1', true <- 'TRUE', invalid <- null}->exists(key  <- value| key = value)");
        ocl.assertQueryInvalid(null, "Map{1 <- '1', true <- 'TRUE', null <- invalid}->exists(key  <- value| key = value)");
        ocl.assertQueryInvalid(null, "Map{1 <- '1', true <- 'TRUE', 'null' <- null}->exists(key  <- value| key = invalid)");
        ocl.assertQueryTrue(null, "Map{1 <- '1', true <- 'TRUE', false <- 'FALSE'}->exists(key : OclAny | key <> null)");
        ocl.assertQueryTrue(null, "Map{1 <- '1', true <- 'TRUE', false <- 'FALSE'}->exists(key1, key2 <- value2 | key1 <> value2)");
        ocl.assertQueryTrue(null, "Map{1 <- '1', true <- 'TRUE', false <- 'FALSE'}->exists(key1 : OclAny, key2 : OclAny <- value2 : String | key1 <> value2)");
        ocl.assertQueryTrue(null, "Map{1 <- '1', true <- 'TRUE', false <- 'FALSE'}->exists(key1 <- value1, key2 | key2 <> value1)");
        ocl.assertQueryTrue(null, "Map{1 <- '1', true <- 'TRUE', false <- 'FALSE'}->exists(key <- value | key.toString().toUpper() = value)");
        ocl.assertQueryTrue(null, "Map{1 <- '1', true <- 'TRUE', false <- 'FALSE'}->exists(key : OclAny <- value : String | key.toString().toUpper() = value)");
        ocl.dispose();
    }

    @Test
    public void test_exists_invalidBody_142518() {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryInvalid(null, "Bag{1, 2, 3}->exists('true')");
        ocl.assertQueryInvalid(null, "Bag{1, 2, 3}->exists(2)");
        ocl.assertQueryNull(EcorePackage.eINSTANCE, "let b:Boolean = null in Bag{1, 2, 3}->exists(b and b)");
        ocl.assertQueryNull(EcorePackage.eINSTANCE, "Bag{1, 2, 3}->exists(null)");
        ocl.assertQueryInvalid(EcorePackage.eINSTANCE, "Bag{1, 2, 3}->exists(Sequence{}->first())");
        ocl.dispose();
    }

    @Test
    public void test_exists_multipleIteratorVariables() {
        MyOCL ocl = this.createOCL();
        ocl.assertInvariantTrue(ocl.pkg1, "Sequence{1, 2, 3, 4}->exists(e1, e2 | e1 = e2)");
        ocl.assertInvariantTrue(ocl.pkg1, "Sequence{1, 2, 3, 4}->exists(e1, e2 | (e1 + e2) = 7)");
        ocl.assertInvariantFalse(ocl.pkg1, "Sequence{1, 2, 3, 4}->exists(e1, e2 | (e1 + e2) = 0)");
        ocl.assertInvariantFalse(ocl.pkg1, "Sequence{}->exists(e1, e2 | e1 = e2)");
        ocl.dispose();
    }

    @Test
    public void test_existsWithNullSource_143996() {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryInvalid(ocl.pkg1, "let e : Collection(ocl::Package) = null in e->exists(p : ocl::Package | p.name = 'bob')", StringUtil.bind((String)PivotMessages.TypedValueRequired, (Object[])new Object[]{"Iterable", ValueUtil.getTypeName(null)}), InvalidValueException.class);
        ocl.assertQueryInvalid(ocl.pkg1, "let e : Collection(ocl::Package) = invalid in e->exists(p : ocl::Package | p.name = 'bob')", PivotMessages.InvalidLiteral, InvalidValueException.class);
        ocl.dispose();
    }

    @Test
    public void test_forAll() {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryTrue(null, "Sequence{Sequence{true}, Sequence{true}, Sequence{true}, Sequence{true}}->forAll(e | e->first())");
        ocl.assertQueryFalse(null, "Sequence{Sequence{true}, Sequence{false}, Sequence{true}, Sequence{true}}->forAll(e | e->first())");
        ocl.assertQueryFalse(null, "Sequence{Sequence{true}, Sequence{false}, Sequence{null}, Sequence{false}}->forAll(e | e->first())");
        ocl.assertQueryNull(null, "Sequence{Sequence{true}, Sequence{true}, Sequence{null}, Sequence{true}}->forAll(e | e->first())");
        ocl.assertQueryFalse(null, "Sequence{Sequence{true}, Sequence{false}, Sequence{null}, Sequence{}}->forAll(e | e->first())");
        ocl.assertQueryInvalid(null, "Sequence{Sequence{true}, Sequence{true}, Sequence{null}, Sequence{}}->forAll(e | e->first())");
        ocl.assertQueryInvalid(null, "Sequence{Sequence{true}, Sequence{true}, Sequence{}, Sequence{null}}->forAll(e | e->first())");
        ocl.assertQueryInvalid(null, "Sequence{Sequence{true}, Sequence{true}, Sequence{true}, Sequence{}}->forAll(e | e->first())");
        ocl.assertQueryFalse(ocl.pkg1, "Sequence{'a', 'b', 'c', 'd', 'e'}->forAll(e | e = 'c')");
        ocl.assertQueryFalse(ocl.pkg1, "Sequence{'a', 'b', 'd', 'e'}->forAll(e | e = 'c')");
        ocl.assertQueryTrue(ocl.pkg1, "Sequence{'c', 'c', 'c', 'c'}->forAll(e | e = 'c')");
        ocl.assertQueryTrue(ocl.pkg1, "Sequence{'c'}->forAll(e | e = 'c')");
        ocl.assertQueryTrue(ocl.pkg1, "Sequence{}->forAll(e | e = 'c')");
        ocl.assertQueryTrue(ocl.pkg1, "ownedPackages->forAll(true)");
        ocl.assertQueryTrue(ocl.pkg1, "Sequence{1..0}->forAll(false)");
        ocl.assertQueryFalse(ocl.pkg1, "Sequence{1..1}->forAll(false)");
        ocl.assertQueryTrue(null, "Map{1 <- '1', true <- 'TRUE', false <- 'FALSE'}->forAll(key <- value | key <> value)");
        ocl.assertQueryTrue(null, "Map{1 <- '1', true <- 'TRUE', false <- 'FALSE'}->forAll(key | key <> null)");
        ocl.assertQueryTrue(null, "Map{1 <- '1', true <- 'TRUE', false <- 'FALSE'}->forAll(key : OclAny | key <> null)");
        ocl.assertQueryTrue(null, "Map{1 <- '1', true <- 'TRUE', false <- 'FALSE'}->forAll(key1, key2 <- value2 | key1 <> value2)");
        ocl.assertQueryTrue(null, "Map{1 <- '1', true <- 'TRUE', false <- 'FALSE'}->forAll(key1 : OclAny, key2 : OclAny <- value2 : String | key1 <> value2)");
        ocl.assertQueryTrue(null, "Map{1 <- '1', true <- 'TRUE', false <- 'FALSE'}->forAll(key1 <- value1, key2 | key2 <> value1)");
        ocl.assertQueryTrue(null, "Map{1 <- '1', true <- 'TRUE', false <- 'FALSE'}->forAll(key <- value | key.toString().toUpper() = value)");
        ocl.assertQueryTrue(null, "Map{1 <- '1', true <- 'TRUE', false <- 'FALSE'}->forAll(key : OclAny <- value : String | key.toString().toUpper() = value)");
        ocl.dispose();
    }

    @Test
    public void test_forAll_invalidBody_142518() {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryInvalid(null, "Bag{1, 2, 3}->forAll('true')");
        ocl.assertQueryInvalid(null, "Bag{1, 2, 3}->forAll(2)");
        ocl.assertQueryNull(EcorePackage.eINSTANCE, "let b:Boolean = null in Bag{1, 2, 3}->forAll(b and b)");
        ocl.assertInvariantFalse(EcorePackage.eINSTANCE, "let b:Boolean = null in Bag{1}->forAll(b and b)");
        ocl.assertQueryNull(EcorePackage.eINSTANCE, "Bag{1, 2, 3}->forAll(null)");
        ocl.assertQueryInvalid(EcorePackage.eINSTANCE, "Bag{1, 2, 3}->forAll(Sequence{}->first())");
        ocl.dispose();
    }

    @Test
    public void test_forAll_multipleIteratorVariables() {
        MyOCL ocl = this.createOCL();
        ocl.assertInvariantFalse(ocl.pkg1, "Sequence{1, 2, 3, 4}->forAll(e1, e2 | e1 = e2)");
        ocl.assertInvariantTrue(ocl.pkg1, "Sequence{1, 2, 3, 4}->forAll(e1, e2 | (e1 + e2) > e1)");
        ocl.assertInvariantTrue(ocl.pkg1, "Sequence{}->forAll(e1, e2 | e1 = e2)");
        ocl.dispose();
    }

    @Test
    public void test_isUnique_invalidBody_142518() {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryInvalid(EcorePackage.eINSTANCE, "Bag{1, 2, 3}->isUnique(Sequence{}->first())");
        ocl.assertQueryFalse(EcorePackage.eINSTANCE, "let b:Boolean = null in Bag{1, 2, 3}->isUnique(null)");
        ocl.dispose();
    }

    @Test
    public void test_isUnique_126861() {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryTrue(ocl.pkg1, "Sequence{'a', 'b', 'c', 'd', 'e'}->isUnique(e | e)");
        ocl.assertQueryFalse(ocl.pkg1, "Sequence{'a', 'b', 'c', 'c', 'e'}->isUnique(e | e)");
        ocl.assertQueryTrue(ocl.pkg1, "Sequence{}->isUnique(e | e)");
        ocl.assertQueryTrue(ocl.pkg1, "Sequence{null}->isUnique(e | e)");
        ocl.assertQueryTrue(ocl.pkg1, "Sequence{null,1}->isUnique(e | e)");
        ocl.assertQueryFalse(ocl.pkg1, "Sequence{null,null}->isUnique(e | e)");
        ocl.assertQueryTrue(ocl.pkg1, "ownedPackages?->isUnique(name)");
        ocl.assertQueryFalse(null, "Map{2 <- 1, 1 <- 2}->isUnique(key  <- value | key * value)");
        ocl.assertQueryTrue(null, "Map{2 <- 2, 1 <- 2}->isUnique(key  <- value | key * value)");
        ocl.dispose();
    }

    @Test
    public void test_iterate() {
        MyOCL ocl = this.createOCL();
        IdResolver idResolver = ocl.getIdResolver();
        CollectionTypeId typeId = TypeId.SET.getSpecializedId(new ElementId[]{TypeId.STRING});
        SetValue expected = idResolver.createSetOfEach(typeId, new Object[]{"pkg2", "bob", "pkg3"});
        ocl.assertQueryEquals(ocl.pkg1, expected, "ownedPackages?->iterate(p; s : Set(String) = Set{} | s->including(p.name))");
        ocl.assertQueryEquals(ocl.pkg1, expected, "ownedPackages?->iterate(p; s : Set(String) = Set{} | s->including(p.name))");
        ocl.assertQueryEquals(ocl.pkg1, expected, "ownedPackages?->iterate(p; s = Set(String){} | s->including(p.name))");
        ocl.assertQueryEquals(ocl.pkg1, expected, "ownedPackages?->iterate(s : Set(String) = Set{} | s->including(name))");
        ocl.assertQueryEquals(ocl.pkg1, expected, "ownedPackages?->iterate(s = Set(String){} | s->including(name))");
        ocl.assertQueryEquals(ocl.pkg1, "pfx_a_b_c", "Sequence{'a','b','c'}->iterate(e : String; s : String = 'pfx' | s + '_' + e)");
        ocl.assertQueryResults(null, "Sequence{1..3}->collectBy(k | k*k)", "Sequence{1..3}->iterate(j; acc = Map(Integer,Integer){} | acc->including(j, j*j))");
        ocl.assertQueryResults(null, "Sequence{1..3}->collectBy(k | k*k)", "Sequence{1..3}->collectBy(i | i*i)->iterate(j <- v; acc = Map(Integer,Integer){} | acc->including(j, v))");
        ocl.dispose();
    }

    @Test
    public void test_iterate_534626() {
        MyOCL ocl = this.createOCL();
        ocl.assertSemanticErrorQuery(null, "Sequence{'a','b','c'}->iterate(ch, acc:String ='' , acc+ch)", EssentialOCLCS2ASMessages.IterateExp_TooFewAccumulators, "iterate");
        ocl.assertSemanticErrorQuery(null, "Sequence{'a','b','c'}->iterate(ch | acc1+ch)", EssentialOCLCS2ASMessages.IterateExp_TooFewAccumulators, "iterate");
        ocl.assertSemanticErrorQuery(null, "Sequence{'a','b','c'}->iterate(ch; acc1:String ='', acc2:String ='' | acc1+ch)", EssentialOCLCS2ASMessages.IterateExp_TooManyAccumulators, "iterate");
        ocl.assertSemanticErrorQuery(null, "Sequence{'a','b','c'}->iterate(ch; acc1:String =''; acc2:String ='' | acc1+ch)", EssentialOCLCS2ASMessages.IterateExp_TooManyAccumulators, "iterate");
        ocl.assertSemanticWarningQuery(null, "Sequence{'a','b','c'}->iterate(ch, acc:String ='' | acc+ch)", EssentialOCLCS2ASMessages.IterateExp_BadAccumulatorSeparator, ",");
        ocl.assertQueryEquals(null, "abc", "Sequence{'a','b','c'}->iterate(ch; acc:String ='' | acc+ch)");
        ocl.assertQueryEquals(null, "abc", "Sequence{'a','b','c'}->iterate(ch; acc ='' | acc+ch)");
        ocl.dispose();
    }

    @Test
    public void test_iterateWithNullSource_143996() {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryInvalid(ocl.pkg1, "let e : Collection(ocl::Package) = null in e->iterate(p : ocl::Package; s : String = '' | s.concat(p.name))", StringUtil.bind((String)PivotMessages.TypedValueRequired, (Object[])new Object[]{"Iterable", ValueUtil.getTypeName(null)}), InvalidValueException.class);
        ocl.assertQueryInvalid(ocl.pkg1, "let e : Collection(ocl::Package) = invalid in e->iterate(p : ocl::Package; s : String = '' | s.concat(p.name))", PivotMessages.InvalidLiteral, InvalidValueException.class);
        ocl.dispose();
    }

    @Test
    public void test_one() {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryTrue(ocl.pkg1, "Sequence{'a', 'b', 'c', 'd', 'e'}->one(e | e = 'c')");
        ocl.assertQueryFalse(ocl.pkg1, "Sequence{'a', 'b', 'c', 'c', 'e'}->one(e | e = 'c')");
        ocl.assertQueryFalse(ocl.pkg1, "Sequence{'a', 'b', 'd', 'e'}->one(e | e = 'c')");
        ocl.assertQueryTrue(ocl.pkg1, "Sequence{'a'}->one(true)");
        ocl.assertQueryFalse(ocl.pkg1, "Map{}->one(k <- v | k = v)");
        ocl.assertQueryTrue(ocl.pkg1, "Map{'a' <- 'a', 'b' <- 'c' }->one(k <- v | k = v)");
        ocl.assertQueryTrue(ocl.pkg1, "Map{'a' <- 'a', 'b' <- 'c' }->one(k <- v | k <> v)");
        ocl.assertQueryFalse(ocl.pkg1, "Map{'a' <- 'a', 'b' <- 'b' }->one(k <- v | k <> v)");
        ocl.dispose();
    }

    @Test
    public void test_one_invalidBody_142518() {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryInvalid(null, "Bag{1, 2, 3}->one('true')");
        ocl.assertQueryInvalid(null, "Bag{1, 2, 3}->one(2)");
        ocl.assertQueryInvalid(EcorePackage.eINSTANCE, "let b:Boolean = null in Bag{1, 2, 3}->one(b and b)");
        ocl.assertQueryInvalid(EcorePackage.eINSTANCE, "Bag{1, 2, 3}->one(null.oclAsType(Boolean))");
        ocl.dispose();
    }

    @Test
    public void test_reject() {
        MyOCL ocl = this.createOCL();
        EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)ocl.getEnvironmentFactory();
        IdResolver idResolver = ocl.getIdResolver();
        @NonNull Type packageType = (Type)ClassUtil.nonNullState((Object)environmentFactory.getASClass("Package"));
        CollectionTypeId typeId = TypeId.SET.getSpecializedId(new ElementId[]{packageType.getTypeId()});
        SetValue expected = idResolver.createSetOfEach(typeId, new Object[]{ocl.pkg2, ocl.pkg3});
        ocl.assertQueryEquals(ocl.pkg1, expected, "ownedPackages?->reject(p : ocl::Package | p.name = 'bob')");
        ocl.assertQueryEquals(ocl.pkg1, expected, "ownedPackages?->reject(p | p.name = 'bob')");
        ocl.assertQueryEquals(ocl.pkg1, expected, "ownedPackages?->reject(name = 'bob')");
        expected = idResolver.createSetOfEach(typeId, new Object[0]);
        ocl.assertQueryEquals(ocl.pkg1, expected, "ownedPackages?->reject(true)");
        ocl.assertQueryResults(null, "Map{1 <- 1, 3 <- 9}", "Sequence{1..3}->collectBy(k | k*k)->reject(k <- v | k = 2)");
        ocl.assertQueryResults(null, "Map{1 <- 1, 3 <- 9}", "Set{1..3}->collectBy(k | k*k)->reject(k <- v | v = 4)");
        ocl.dispose();
    }

    @Test
    public void test_reject_invalidBody_142518() {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryInvalid(null, "Bag{1, 2, 3}->reject('true')");
        ocl.assertQueryInvalid(null, "Bag{1, 2, 3}->reject(2)");
        ocl.assertQueryInvalid(EcorePackage.eINSTANCE, "let b:Boolean = null in Bag{1, 2, 3}->reject(b and b)");
        ocl.assertQueryInvalid(EcorePackage.eINSTANCE, "Bag{1, 2, 3}->reject(null.oclAsType(Boolean))");
        ocl.dispose();
    }

    @Test
    public void test_select() {
        MyOCL ocl = this.createOCL();
        EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)ocl.getEnvironmentFactory();
        IdResolver idResolver = ocl.getIdResolver();
        @NonNull Type packageType = (Type)ClassUtil.nonNullState((Object)environmentFactory.getASClass("Package"));
        CollectionTypeId typeId = TypeId.SET.getSpecializedId(new ElementId[]{packageType.getTypeId()});
        SetValue expected = idResolver.createSetOfEach(typeId, new Object[]{ocl.pkg2, ocl.pkg3});
        ocl.assertQueryEquals(ocl.pkg1, expected, "ownedPackages?->select(p : ocl::Package | p.name <> 'bob')");
        ocl.assertQueryEquals(ocl.pkg1, expected, "ownedPackages?->select(p | p.name <> 'bob')");
        ocl.assertQueryEquals(ocl.pkg1, expected, "ownedPackages?->select(name <> 'bob')");
        SetValue expected2 = idResolver.createSetOfEach(typeId, new Object[]{ocl.bob, ocl.pkg2, ocl.pkg3});
        ocl.assertQueryEquals(ocl.pkg1, expected2, "ownedPackages?->select(true)");
        ocl.assertQueryResults(null, "Map{2 <- 4}", "Sequence{1..3}->collectBy(k | k*k)->select(k <- v | k = 2)");
        ocl.assertQueryResults(null, "Map{2 <- 4}", "Sequence{1..3}->collectBy(k | k*k)->select(k <- v | v = 4)");
        ocl.dispose();
    }

    @Test
    public void test_select_invalidBody_142518() {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryInvalid(null, "Bag{1, 2, 3}->select('true')");
        ocl.assertQueryInvalid(null, "Bag{1, 2, 3}->select(2)");
        ocl.assertQueryInvalid(EcorePackage.eINSTANCE, "let b:Boolean = null in Bag{1, 2, 3}->select(b and b)");
        ocl.assertQueryInvalid(EcorePackage.eINSTANCE, "Bag{1, 2, 3}->select(null.oclAsType(Boolean))");
        ocl.dispose();
    }

    @Test
    public void test_sortedBy() {
        MyOCL ocl = this.createOCL();
        EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)ocl.getEnvironmentFactory();
        IdResolver idResolver = ocl.getIdResolver();
        @NonNull Type packageType = (Type)ClassUtil.nonNullState((Object)environmentFactory.getASClass("Package"));
        CollectionTypeId typeId = TypeId.ORDERED_SET.getSpecializedId(new ElementId[]{packageType.getTypeId()});
        OrderedSetValue expectedSet = idResolver.createOrderedSetOfEach(typeId, new Object[]{ocl.bob, ocl.pkg2, ocl.pkg3});
        ocl.assertQueryEquals(ocl.pkg1, expectedSet, "ownedPackages?->sortedBy(p : ocl::Package | p.name)");
        ocl.assertQueryEquals(ocl.pkg1, expectedSet, "ownedPackages?->sortedBy(p | p.name)");
        ocl.assertQueryEquals(ocl.pkg1, expectedSet, "ownedPackages?->sortedBy(name)");
        CollectionTypeId stringsTypeId = TypeId.SEQUENCE.getSpecializedId(new ElementId[]{TypeId.STRING});
        SequenceValue expected = idResolver.createSequenceOfEach(stringsTypeId, new Object[]{"a", "b", "c", "d", "e"});
        ocl.assertQueryEquals(ocl.pkg1, expected, "Bag{'d', 'b', 'e', 'a', 'c'}->sortedBy(e | e)");
        ocl.assertQueryResults(null, "Sequence{'x', 'aa', 'zzz', 'zzz', 'zzz', 'yyyy', 'yyyy'}", "Bag{'x', 'yyyy', 'zzz', 'aa', 'zzz', 'yyyy', 'zzz'}->sortedBy(size())");
        ocl.dispose();
    }

    @Test
    public void test_sortedBy_invalidBody_142518() {
        MyOCL ocl = this.createOCL();
        ocl.assertQueryInvalid(EcorePackage.eINSTANCE, "let s : String = null in Bag{1, 2, 3}->sortedBy(s.size())", StringUtil.bind((String)PivotMessages.TypedValueRequired, (Object[])new Object[]{"String", ValueUtil.getTypeName(null)}), InvalidValueException.class);
        ocl.assertQueryInvalid(EcorePackage.eINSTANCE, "Bag{1, 2, 3}->sortedBy(null)", StringUtil.bind((String)PivotMessages.UndefinedBody, (Object[])new Object[]{"sortedBy"}), InvalidValueException.class);
        ocl.dispose();
    }

    @Test
    public void test_sortedByRequiresComparability_192729() {
        MyOCL ocl = this.createOCL();
        EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)ocl.getEnvironmentFactory();
        Class context = environmentFactory.getASClass("Package");
        Class type = environmentFactory.getASClass("Class");
        ocl.assertValidationErrorQuery(context, "ownedClasses->sortedBy(e | e)", PivotMessagesInternal.UnresolvedOperation_ERROR_, "" + type, "compareTo");
        ocl.assertQuery(context, "ownedClasses->sortedBy(e | e.name)");
        ocl.loadEPackage("ecore", (EPackage)EcorePackage.eINSTANCE);
        ocl.assertQuery(context, "let dates : Sequence(ecore::EDate) = Sequence{} in dates->sortedBy(e | e)");
        ocl.assertQueryResults(context, "Sequence{1,7,9}", "let values : Sequence(ecore::EInt) = Sequence{1,9,7} in values->sortedBy(e | e)");
        ocl.dispose();
    }

    @Test
    public void test_invalidMultipleIteratorVariables() {
        MyOCL ocl = this.createOCL();
        ocl.assertBadQuery(SemanticException.class, 4, null, "Sequence{'a', 'b', 'c'}->exists(e1, e2, e3 | e1 = e2)", PivotMessagesInternal.UnresolvedIterationCall_ERROR_, "Sequence(String)", "exists", "e1, e2, e3| e1 = e2");
        ocl.assertBadQuery(SemanticException.class, 4, null, "Sequence{'a', 'b', 'c'}->forAll(e1, e2, e3 | e1 = e2)", PivotMessagesInternal.UnresolvedIterationCall_ERROR_, "Sequence(String)", "forAll", "e1, e2, e3| e1 = e2");
        ocl.assertBadQuery(SemanticException.class, 4, null, "Sequence{'a', 'b', 'c'}->collect(e1, e2 | Tuple{a : String = e1, b : String = e2})", PivotMessagesInternal.UnresolvedIterationCall_ERROR_, "Sequence(String)", "collect", "e1, e2| Tuple{a : String = e1, b : String = e2}");
        ocl.assertBadQuery(SemanticException.class, 4, null, "Sequence{'a', 'b', 'c'}->any(e1, e2 | e1 = e2)", PivotMessagesInternal.UnresolvedIterationCall_ERROR_, "Sequence(String)", "any", "e1, e2| e1 = e2");
        ocl.assertBadQuery(SemanticException.class, 4, null, "Sequence{'a', 'b', 'c'}->one(e1, e2 | e1 = e2)", PivotMessagesInternal.UnresolvedIterationCall_ERROR_, "Sequence(String)", "one", "e1, e2| e1 = e2");
        ocl.assertBadQuery(SemanticException.class, 4, null, "Sequence{'a', 'b', 'c'}->select(e1, e2 | e1 = e2)", PivotMessagesInternal.UnresolvedIterationCall_ERROR_, "Sequence(String)", "select", "e1, e2| e1 = e2");
        ocl.assertBadQuery(SemanticException.class, 4, null, "Sequence{'a', 'b', 'c'}->reject(e1, e2 | e1 = e2)", PivotMessagesInternal.UnresolvedIterationCall_ERROR_, "Sequence(String)", "reject", "e1, e2| e1 = e2");
        ocl.assertBadQuery(SemanticException.class, 4, null, "Sequence{'a', 'b', 'c'}->isUnique(e1, e2 | e1 = e2)", PivotMessagesInternal.UnresolvedIterationCall_ERROR_, "Sequence(String)", "isUnique", "e1, e2| e1 = e2");
        ocl.dispose();
    }

    public static class MyOCL
    extends TestOCL {
        @NonNull Model root = PivotUtil.createModel(null);
        @NonNull Package pkg1 = PivotUtil.createOwnedPackage((Model)this.root, (String)"pkg1");
        @NonNull Package pkg2 = PivotUtil.createOwnedPackage((Package)this.pkg1, (String)"pkg2");
        @NonNull Package jim = PivotUtil.createOwnedPackage((Package)this.pkg2, (String)"jim");
        @NonNull Package bob = PivotUtil.createOwnedPackage((Package)this.pkg1, (String)"bob");
        @NonNull Package pkg3 = PivotUtil.createOwnedPackage((Package)this.pkg1, (String)"pkg3");
        @NonNull Package pkg4 = PivotUtil.createOwnedPackage((Package)this.pkg3, (String)"pkg4");
        @NonNull Package pkg5 = PivotUtil.createOwnedPackage((Package)this.pkg3, (String)"pkg5");
        @NonNull Package george = PivotUtil.createOwnedPackage((Package)this.pkg5, (String)"george");

        public MyOCL(@NonNull TestFileSystem testFileSystem, @NonNull String testPackageName, @NonNull String name) {
            super(testFileSystem, testPackageName, name, (ProjectManager)(useCodeGen ? IteratorsTest4.getProjectMap() : OCL.NO_PROJECTS), null);
            MetamodelManagerInternal metamodelManager = this.getMetamodelManager();
            metamodelManager.installRoot((Model)ClassUtil.nonNullState((Object)this.root));
        }
    }
}

