/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.tests.filters;

import junit.textui.TestRunner;
import org.eclipse.ocl.examples.eventmanager.EventFilter;
import org.eclipse.ocl.examples.eventmanager.EventManagerFactory;
import org.eclipse.ocl.examples.eventmanager.tests.filters.LogicalEventFilterTest;

public class OrFilterTest
extends LogicalEventFilterTest {
    public static void main(String[] args) {
        TestRunner.run(OrFilterTest.class);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.setFixture(EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.trueFilter, this.trueFilter}));
    }

    public void testMatchesFor__NotificationTwoTrue() {
        EventFilter or = EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.trueFilter, this.trueFilter});
        OrFilterTest.assertTrue((String)"Two true is true", (boolean)or.matchesFor(null));
    }

    public void testMatchesFor__NotificationTwoFalse() {
        EventFilter or = EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.falseFilter, this.falseFilter});
        OrFilterTest.assertFalse((String)"Two false is false", (boolean)or.matchesFor(null));
    }

    public void testMatchesFor__Notification() {
        EventFilter or = EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.falseFilter, this.trueFilter});
        OrFilterTest.assertTrue((String)"Two true/false is true", (boolean)or.matchesFor(null));
    }

    Object getFilterCriterion1() {
        return 1;
    }

    Object getFilterCriterion2() {
        return 2;
    }

    EventFilter getFilterFor(Object f) {
        if (f == null) {
            return EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.trueFilter, this.trueFilter});
        }
        if ((Integer)f == 1) {
            return EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.falseFilter, this.trueFilter});
        }
        return EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{this.falseFilter, this.falseFilter});
    }
}

