/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.tests.EcoreTestReflection;
import org.eclipse.ocl.options.EvaluationOptions;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.tests.GenericEvaluationOclAnyOperationTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationOclAnyOperationTest
extends GenericEvaluationOclAnyOperationTest<EObject, EPackage, EClassifier, EClassifier, EClass, EDataType, EClassifier, EEnum, EOperation, EParameter, EStructuralFeature, EAttribute, EReference, EEnumLiteral, EObject, CallOperationAction, SendSignalAction, Constraint> {
    public EcoreTestReflection getStaticReflection() {
        return EcoreTestReflection.INSTANCE;
    }

    public void testOclAsTypeInvalidLaxNullHandlingInvalid() {
        this.assertResultInvalid("invalid.oclAsType(String)");
        this.assertResultInvalid("invalid.oclAsType(EClass)");
        this.assertResultInvalid("invalid.oclAsType(OclVoid)");
        this.assertResultInvalid("invalid.oclAsType(OclInvalid)");
    }

    public void testOclAsTypeLaxNullHandlingNull() {
        this.assertResult(null, "null.oclAsType(String)");
        this.assertResult(null, "null.oclAsType(Integer)");
        this.assertResult(null, "null.oclAsType(EClass)");
        this.assertResult(null, "null.oclAsType(OclVoid)");
        this.assertResult(null, "null.oclAsType(OclInvalid)");
    }

    public void testOclAsTypeNoLaxNullHandlingInvalid() {
        Boolean oldNullHandling = (Boolean)EvaluationOptions.getValue((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.LAX_NULL_HANDLING);
        EvaluationOclAnyOperationTest.assertEquals((Object)Boolean.TRUE, (Object)oldNullHandling);
        EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.LAX_NULL_HANDLING, (Object)Boolean.FALSE);
        this.assertResultInvalid("invalid.oclAsType(String)");
        this.assertResultInvalid("invalid.oclAsType(Integer)");
        this.assertResultInvalid("invalid.oclAsType(EClass)");
        this.assertResultInvalid("invalid.oclAsType(OclVoid)");
        this.assertResultInvalid("invalid.oclAsType(OclInvalid)");
        EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.LAX_NULL_HANDLING, (Object)Boolean.TRUE);
    }

    public void testOclAsTypeNoLaxNullHandlingNull() {
        Boolean oldNullHandling = (Boolean)EvaluationOptions.getValue((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.LAX_NULL_HANDLING);
        EvaluationOclAnyOperationTest.assertEquals((Object)Boolean.TRUE, (Object)oldNullHandling);
        EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.LAX_NULL_HANDLING, (Object)Boolean.FALSE);
        this.assertResultInvalid("null.oclAsType(String)");
        this.assertResultInvalid("null.oclAsType(Integer)");
        this.assertResultInvalid("null.oclAsType(EClass)");
        this.assertResultInvalid("null.oclAsType(OclVoid)");
        this.assertResultInvalid("null.oclAsType(OclInvalid)");
        EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.LAX_NULL_HANDLING, (Object)Boolean.TRUE);
    }

    public void testOclIsKindOfInvalidLaxNullHandling() {
        this.assertResultTrue("invalid.oclIsKindOf(String)");
        this.assertResultTrue("invalid.oclIsKindOf(EClass)");
        this.assertResultTrue("invalid.oclIsKindOf(OclVoid)");
        this.assertResultTrue("null.oclIsKindOf(OclVoid)");
        this.assertResultTrue("invalid.oclIsKindOf(OclInvalid)");
        this.assertResultFalse("null.oclIsKindOf(OclInvalid)");
    }

    public void testOclIsKindOfInvalidNoLaxHandling() {
        Boolean oldNullHandling = (Boolean)EvaluationOptions.getValue((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.LAX_NULL_HANDLING);
        EvaluationOclAnyOperationTest.assertEquals((Object)Boolean.TRUE, (Object)oldNullHandling);
        EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.LAX_NULL_HANDLING, (Object)Boolean.FALSE);
        this.assertResultInvalid("invalid.oclIsKindOf(String)");
        this.assertResultInvalid("invalid.oclIsKindOf(Integer)");
        this.assertResultInvalid("invalid.oclIsKindOf(EClass)");
        this.assertResultInvalid("invalid.oclIsKindOf(OclVoid)");
        this.assertResultInvalid("invalid.oclIsKindOf(OclInvalid)");
        EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.LAX_NULL_HANDLING, (Object)Boolean.TRUE);
    }

    public void testOclIsKindOfNullLaxNullHandling() {
        this.assertResultTrue("null.oclIsKindOf(String)");
        this.assertResultTrue("null.oclIsKindOf(Integer)");
        this.assertResultTrue("null.oclIsKindOf(EClass)");
        this.assertResultTrue("null.oclIsKindOf(OclVoid)");
        this.assertResultFalse("null.oclIsKindOf(OclInvalid)");
    }

    public void testOclIsKindOfNullNoLaxHandling() {
        Boolean oldNullHandling = (Boolean)EvaluationOptions.getValue((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.LAX_NULL_HANDLING);
        EvaluationOclAnyOperationTest.assertEquals((Object)Boolean.TRUE, (Object)oldNullHandling);
        EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.LAX_NULL_HANDLING, (Object)Boolean.FALSE);
        this.assertResultInvalid("null.oclIsKindOf(String)");
        this.assertResultInvalid("null.oclIsKindOf(Integer)");
        this.assertResultInvalid("null.oclIsKindOf(EClass)");
        this.assertResultInvalid("null.oclIsKindOf(OclVoid)");
        this.assertResultInvalid("null.oclIsKindOf(OclInvalid)");
        EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.LAX_NULL_HANDLING, (Object)Boolean.TRUE);
    }

    public void testOclIsKindOfOclAny() {
        this.assertResultTrue("null.oclIsKindOf(OclAny)");
        this.assertResultTrue("'abc'.oclIsKindOf(OclAny)");
        this.assertResultTrue("invalid.oclIsKindOf(OclAny)");
    }

    public void testOclIsTypeOfInvalidLaxNullHandling() {
        this.assertResultFalse("invalid.oclIsTypeOf(String)");
        this.assertResultFalse("invalid.oclIsTypeOf(EClass)");
        this.assertResultFalse("invalid.oclIsTypeOf(OclVoid)");
        this.assertResultTrue("invalid.oclIsTypeOf(OclInvalid)");
        this.assertResultFalse("null.oclIsTypeOf(OclInvalid)");
        this.assertResultTrue("null.oclIsTypeOf(OclVoid)");
    }

    public void testOclIsTypeOfInvalidNoLaxNullHandling() {
        Boolean oldNullHandling = (Boolean)EvaluationOptions.getValue((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.LAX_NULL_HANDLING);
        EvaluationOclAnyOperationTest.assertEquals((Object)Boolean.TRUE, (Object)oldNullHandling);
        EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.LAX_NULL_HANDLING, (Object)Boolean.FALSE);
        this.assertResultInvalid("invalid.oclIsTypeOf(String)");
        this.assertResultInvalid("invalid.oclIsTypeOf(Integer)");
        this.assertResultInvalid("invalid.oclIsTypeOf(EClass)");
        this.assertResultInvalid("invalid.oclIsTypeOf(OclVoid)");
        this.assertResultInvalid("invalid.oclIsTypeOf(OclInvalid)");
        EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.LAX_NULL_HANDLING, (Object)Boolean.TRUE);
    }

    public void testOclIsTypeOfNullLaxNullHandling() {
        this.assertResultFalse("null.oclIsTypeOf(String)");
        this.assertResultFalse("null.oclIsTypeOf(Integer)");
        this.assertResultFalse("null.oclIsTypeOf(EClass)");
        this.assertResultTrue("null.oclIsTypeOf(OclVoid)");
        this.assertResultFalse("null.oclIsTypeOf(OclInvalid)");
    }

    public void testOclIsTypeOfNullNoLaxNullHandling() {
        Boolean oldNullHandling = (Boolean)EvaluationOptions.getValue((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.LAX_NULL_HANDLING);
        EvaluationOclAnyOperationTest.assertEquals((Object)Boolean.TRUE, (Object)oldNullHandling);
        EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.LAX_NULL_HANDLING, (Object)Boolean.FALSE);
        this.assertResultInvalid("null.oclIsTypeOf(String)");
        this.assertResultInvalid("null.oclIsTypeOf(Integer)");
        this.assertResultInvalid("null.oclIsTypeOf(EClass)");
        this.assertResultInvalid("null.oclIsTypeOf(OclVoid)");
        this.assertResultInvalid("null.oclIsTypeOf(OclInvalid)");
        EvaluationOptions.setOption((EvaluationEnvironment)this.ocl.getEvaluationEnvironment(), (Option)EvaluationOptions.LAX_NULL_HANDLING, (Object)Boolean.TRUE);
    }
}

