/*
 * Decompiled with CFR 0.152.
 */
package dataaccess.expressions.util;

import dataaccess.expressions.AsList;
import dataaccess.expressions.AssociationEndNavigationExpression;
import dataaccess.expressions.Conditional;
import dataaccess.expressions.ConditionalExpression;
import dataaccess.expressions.ContentEquals;
import dataaccess.expressions.Equals;
import dataaccess.expressions.Expression;
import dataaccess.expressions.ExpressionWithArgument;
import dataaccess.expressions.ExpressionsPackage;
import dataaccess.expressions.FunctionCallExpression;
import dataaccess.expressions.Head;
import dataaccess.expressions.Map;
import dataaccess.expressions.MethodCallExpression;
import dataaccess.expressions.NavigationStep;
import dataaccess.expressions.ObjectBasedExpression;
import dataaccess.expressions.ObjectCount;
import dataaccess.expressions.ObjectCreationExpression;
import dataaccess.expressions.Replace;
import dataaccess.expressions.SignatureCallExpression;
import dataaccess.expressions.Tail;
import dataaccess.expressions.Ternary;
import dataaccess.expressions.This;
import dataaccess.expressions.VariableExpression;
import dataaccess.expressions.WithArgument;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionsValidator
extends EObjectValidator {
    public static final ExpressionsValidator INSTANCE = new ExpressionsValidator();
    public static final String DIAGNOSTIC_SOURCE = "dataaccess.expressions";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected static final String VARIABLE_EXPRESSION__VARIABLE_EXPRESSION_TYPE__EEXPRESSION = "self.getType().conformsTo(self.variable.getType())";
    protected static final String METHOD_CALL_EXPRESSION__OBJECT_MUST_SUPPORT_OPERATION__EEXPRESSION = "self.object.getType().getInnermost().oclIsKindOf(data::classes::ClassTypeDefinition) and\r\n  self.object.getType().getInnermost().oclAsType(data::classes::ClassTypeDefinition).clazz.conformsTo(self.methodSignature.owner.oclAsType(data::classes::SapClass))";
    protected static final String METHOD_CALL_EXPRESSION__OUTPUT_MULTIPLICITIES__EEXPRESSION = "(self.object.getType().isMany() implies (self.getType().isMany() and not self.getType().unique)) and\r\n  (self.object.getType().lowerMultiplicity = 0 implies (self.getType()->isEmpty() or self.getType().lowerMultiplicity = 0))";
    protected static final String OBJECT_CREATION_EXPRESSION__CANNOT_INSTANTIATE_ABSTRACT_CLASS__EEXPRESSION = "not self.classToInstantiate.isAbstract()";
    protected static final String OBJECT_CREATION_EXPRESSION__EXPRESSION_TYPE__EEXPRESSION = "self.getType().oclIsKindOf(data::classes::ClassTypeDefinition) and\r\n  self.getType().oclAsType(data::classes::ClassTypeDefinition).clazz = self.classToInstantiate and\r\n  self.getType().lowerMultiplicity = 1 and\r\n  self.getType().upperMultiplicity = 1";
    protected static final String OBJECT_CREATION_EXPRESSION__HAS_TO_OWN_TYPE_DEFINITION__EEXPRESSION = "self.ownedTypeDefinition->notEmpty()";
    protected static final String OBJECT_CREATION_EXPRESSION__CANNOT_INSTANTIATE_VALUE_CLASS__EEXPRESSION = "not self.classToInstantiate.valueType";
    protected static final String OBJECT_CREATION_EXPRESSION__NO_DUPLICATE_INITIALIZERS__EEXPRESSION = "self.initializers->forAll( a, b | a <> b implies a.methodSignature <> b.methodSignature )";
    protected static final String FUNCTION_CALL_EXPRESSION__RESULT_TYPE__EEXPRESSION = "let fstd:data::classes::FunctionSignatureTypeDefinition = self.calledBlock.getType().getInnermost().oclAsType(data::classes::FunctionSignatureTypeDefinition) in\r\n\r\n  if fstd.isMany() then\r\n    -- calling multiple functions; test is somewhat fuzzy because it doesn't test condormance of nesting structure exactly\r\n    self.getType().isMany() and not self.getType().unique and\r\n    fstd.signature.output.getInnermost().conformsTo(self.getType().getInnermost()) and\r\n    (fstd.lowerMultiplicity = 0 implies (self.getType()->isEmpty() or self.getType().lowerMultiplicity = 0))\r\n  else\r\n    -- calling a single function\r\n    fstd.signature.output.conformsTo(self.getType()) and \r\n    (fstd.lowerMultiplicity = 0 implies (self.getType()->isEmpty() or self.getType().lowerMultiplicity = 0))\r\n  endif";
    protected static final String FUNCTION_CALL_EXPRESSION__CALLED_BLOCK_MUST_BE_FUNCTION__EEXPRESSION = "self.calledBlock.getType().getInnermost().oclIsKindOf(data::classes::FunctionSignatureTypeDefinition)";
    protected static final String EQUALS__CONFORMACE_ONE_WAY_OR_ANOTHER__EEXPRESSION = "self.left.getType().conformsTo(self.right.getType()) or\r\n  self.right.getType().conformsTo(self.left.getType())";
    protected static final String ASSOCIATION_END_NAVIGATION_EXPRESSION__OBJECT_TYPE_MUST_MATCH__EEXPRESSION = "self.object.getType().conformsToIgnoringMultiplicity(self.toEnd.otherEnd().type)";
    protected static final String ASSOCIATION_END_NAVIGATION_EXPRESSION__RESULT_TYPE__EEXPRESSION = "self.getType() = self.toEnd.type";
    protected static final String ASSOCIATION_END_NAVIGATION_EXPRESSION__END_MUST_BE_NAVIGABLE__EEXPRESSION = "self.toEnd.navigable";
    protected static final String SIGNATURE_CALL_EXPRESSION__PARAMETERS_TYPES_MUST_MATCH_SIGNATURE_PARAMETERS_TYPES__EEXPRESSION = "let numberOfMandatoryParameters:Integer =\r\n    self.getSignature().input->select(p|p.defaultValue->isEmpty())->size()\r\n  in\r\n  self.parameters->size() >= numberOfMandatoryParameters and\r\n  self.parameters->size() <= self.getSignature().input->size() and\r\n  self.parameters->forAll(parameter |\r\n    parameter.getType().conformsTo(self.getSignature().input->at(self.parameters->indexOf(parameter)).getType()) )";
    protected static final String SIGNATURE_CALL_EXPRESSION__CALL_TYPE_MUST_MATCH_SIGNATURE_OUTPUT__EEXPRESSION = "if self.getSignature().output.oclIsUndefined() then\r\n        self.getType().oclIsUndefined()\r\n    else \r\n        if self.getMultiplicityOfCallTarget().isMany() and self.getSignature().output.isMany() then\r\n            let ntd:data::classes::NestedTypeDefinition = self.getType().oclAsType(data::classes::NestedTypeDefinition) in\r\n                self.getType().oclIsKindOf(data::classes::NestedTypeDefinition) and \r\n                ntd.unique = false and\r\n                ntd.ordered = self.getMultiplicityOfCallTarget().ordered and\r\n                ntd.lowerMultiplicity = self.getMultiplicityOfCallTarget().lowerMultiplicity and\r\n                ntd.upperMultiplicity = self.getMultiplicityOfCallTarget().upperMultiplicity and\r\n                self.getSignature().output.conformsTo(ntd.type)\r\n        else\r\n            let target:data::classes::Multiplicity = self.getMultiplicityOfCallTarget() in\r\n            let output:data::classes::TypeDefinition = self.getSignature().output in \r\n                ( output.isMany() implies self.getType().unique = output.unique ) and\r\n                ( ( output.isMany() or target.isMany() ) implies ( self.getType().ordered = (output.ordered or target.ordered) ) ) and\r\n                ( self.getType().lowerMultiplicity = (output.lowerMultiplicity * target.lowerMultiplicity)) and\r\n                ( self.getType().upperMultiplicity = (if output.isMany() or target.isMany() then \r\n                                                        -1 \r\n                                                    else \r\n                                                        output.upperMultiplicity * target.upperMultiplicity \r\n                                                    endif)) and\r\n                self.getType().conformsToIgnoringMultiplicity(output)\r\n        endif\r\n    endif";
    protected static final String OBJECT_COUNT__TYPE_IS_NUMBER__EEXPRESSION = "self.getType().oclIsKindOf(data::classes::ClassTypeDefinition) and\r\n  self.getType().oclAsType(data::classes::ClassTypeDefinition).clazz.name = 'Number'";
    protected static final String OBJECT_COUNT__MULTIPLICITY_IS_ONE__EEXPRESSION = "self.getType().upperMultiplicity = 1 and\r\n  self.getType().lowerMultiplicity = 1";
    protected static final String REPLACE__SOURCE_OBJECT_IS_OF_VALUE_TYPE__EEXPRESSION = "self.object.getType().oclIsKindOf(data::classes::ClassTypeDefinition) and\r\n  self.object.getType().oclAsType(data::classes::ClassTypeDefinition).clazz.valueType";
    protected static final String REPLACE__WITH_TYPE_CONFORMS_TO_LAST_STEPS_TYPE__EEXPRESSION = "self.with.getType().conformsTo(self.steps->at(self.steps->size()).to.type)";
    protected static final String NAVIGATION_STEP__FROM_END_ATTACHES_TO_OUTPUT_OF_PREVIOUS_STEP__EEXPRESSION = "let i:Integer = self.replace.steps->indexOf(self) in\r\n  let t:data::classes::ClassTypeDefinition = if i=1 then\r\n      self.replace.object.getType().oclAsType(data::classes::ClassTypeDefinition)\r\n    else\r\n      self.replace.steps->at(-1 + i).to.type\r\n    endif\r\n  in\r\n\r\n  self.to.otherEnd().type.clazz.conformsTo(t.clazz)";
    protected static final String NAVIGATION_STEP__FILTER_FUNCTION_EXPRESSION_HAS_FUNCTION_TYPE__EEXPRESSION = "self.filterFunction->notEmpty() implies self.filterFunction.getType().oclIsKindOf(data::classes::FunctionSignatureTypeDefinition)";
    protected static final String NAVIGATION_STEP__FROM_END_MUST_BE_EQUALITY_RELEVANT__EEXPRESSION = "to.otherEnd().contributesToEquality";
    protected static final String HEAD__IS_ORDERED__EEXPRESSION = "self.object.getType().ordered";
    protected static final String TAIL__IS_ORDERED__EEXPRESSION = "self.object.getType().ordered";
    protected static final String CONDITIONAL__CONDITION_MUST_BE_BOOLEAN__EEXPRESSION = "self.condition.getType().upperMultiplicity = 1 and\r\n  self.condition.getType().oclIsKindOf(data::classes::ClassTypeDefinition) and\r\n  self.condition.getType().oclAsType(data::classes::ClassTypeDefinition).clazz.name = 'Boolean'";
    protected static final String TERNARY__TRUE_AND_FALSE_EXPRS_CONFORM_TO_RESULT_TYPE__EEXPRESSION = "self.trueExpr.getType().conformsTo(self.getType()) or\r\n  self.falseExpr.getType().conformsTo(self.getType())";
    protected static final String CONTENT_EQUALS__CONTENT_EQUALS_ONLY_FOR_ENTITIES__EEXPRESSION = "self.left.getType().getInnermost().oclIsKindOf(data::classes::ClassTypeDefinition) and\r\n  self.right.getType().getInnermost().oclIsKindOf(data::classes::ClassTypeDefinition) and\r\n  not self.left.getType().getInnermost().oclAsType(data::classes::ClassTypeDefinition).clazz.valueType and\r\n  not self.right.getType().getInnermost().oclAsType(data::classes::ClassTypeDefinition).clazz.valueType";
    protected static final String MAP__OBJECT_TYPE_MUST_CONFORM_TO_FUNCTION_ARGUMENT__EEXPRESSION = "let fstd:data::classes::TypeDefinition = self.argument.getType() in\r\n  let sig:data::classes::Signature = fstd.oclAsType(data::classes::FunctionSignatureTypeDefinition).signature in\r\n  let t:data::classes::TypeDefinition = self.object.getType() in\r\n  let argT:data::classes::TypeDefinition = sig.input->at(1).getType() in\r\n  -- if multiplicities match including multiplicities, that's ok\r\n  t.conformsTo(argT) or\r\n  -- otherwise, pick single multiplicity from object and try again\r\n  t.conformsToIgnoringMultiplicity(argT) or\r\n  (t.oclIsKindOf(data::classes::NestedTypeDefinition) and t.oclAsType(data::classes::NestedTypeDefinition).type.conformsTo(argT))";
    protected static final String MAP__ARGUMENT_MUST_BE_SINGLE_ARGUMENT_FUNCTION_WITH_NON_VOID_OUTPUT__EEXPRESSION = "let fstd:data::classes::TypeDefinition = self.argument.getType() in\r\n  fstd.oclIsKindOf(data::classes::FunctionSignatureTypeDefinition) and\r\n  (let sig:data::classes::Signature = fstd.oclAsType(data::classes::FunctionSignatureTypeDefinition).signature in\r\n  (sig.output->notEmpty() and\r\n  sig.input->size() = 1))";
    protected static final String MAP__MAP_FUNCTION_MUST_BE_SIDE_EFFECT_FREE__EEXPRESSION = "self.argument.getType().oclAsType(data::classes::FunctionSignatureTypeDefinition).signature.sideEffectFree";

    protected EPackage getEPackage() {
        return ExpressionsPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateExpression((Expression)value, diagnostics, context);
            }
            case 1: {
                return this.validateVariableExpression((VariableExpression)value, diagnostics, context);
            }
            case 2: {
                return this.validateMethodCallExpression((MethodCallExpression)value, diagnostics, context);
            }
            case 3: {
                return this.validateObjectBasedExpression((ObjectBasedExpression)value, diagnostics, context);
            }
            case 4: {
                return this.validateObjectCreationExpression((ObjectCreationExpression)value, diagnostics, context);
            }
            case 5: {
                return this.validateFunctionCallExpression((FunctionCallExpression)value, diagnostics, context);
            }
            case 6: {
                return this.validateWithArgument((WithArgument)value, diagnostics, context);
            }
            case 7: {
                return this.validateThis((This)value, diagnostics, context);
            }
            case 8: {
                return this.validateEquals((Equals)value, diagnostics, context);
            }
            case 9: {
                return this.validateAssociationEndNavigationExpression((AssociationEndNavigationExpression)value, diagnostics, context);
            }
            case 10: {
                return this.validateSignatureCallExpression((SignatureCallExpression)value, diagnostics, context);
            }
            case 11: {
                return this.validateObjectCount((ObjectCount)value, diagnostics, context);
            }
            case 12: {
                return this.validateReplace((Replace)value, diagnostics, context);
            }
            case 13: {
                return this.validateNavigationStep((NavigationStep)value, diagnostics, context);
            }
            case 14: {
                return this.validateHead((Head)value, diagnostics, context);
            }
            case 15: {
                return this.validateTail((Tail)value, diagnostics, context);
            }
            case 16: {
                return this.validateAsList((AsList)value, diagnostics, context);
            }
            case 17: {
                return this.validateConditional((Conditional)value, diagnostics, context);
            }
            case 18: {
                return this.validateTernary((Ternary)value, diagnostics, context);
            }
            case 19: {
                return this.validateContentEquals((ContentEquals)value, diagnostics, context);
            }
            case 20: {
                return this.validateExpressionWithArgument((ExpressionWithArgument)value, diagnostics, context);
            }
            case 21: {
                return this.validateConditionalExpression((ConditionalExpression)value, diagnostics, context);
            }
            case 22: {
                return this.validateMap((Map)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateExpression(Expression expression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(expression, diagnostics, context);
    }

    public boolean validateVariableExpression(VariableExpression variableExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(variableExpression, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(variableExpression, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(variableExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(variableExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(variableExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(variableExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(variableExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(variableExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(variableExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateVariableExpression_VariableExpressionType(variableExpression, diagnostics, context);
        }
        return result;
    }

    public boolean validateVariableExpression_VariableExpressionType(VariableExpression variableExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.VARIABLE_EXPRESSION, variableExpression, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "VariableExpressionType", VARIABLE_EXPRESSION__VARIABLE_EXPRESSION_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateMethodCallExpression(MethodCallExpression methodCallExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(methodCallExpression, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(methodCallExpression, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(methodCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(methodCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(methodCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(methodCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(methodCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(methodCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(methodCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSignatureCallExpression_ParametersTypesMustMatchSignatureParametersTypes(methodCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSignatureCallExpression_CallTypeMustMatchSignatureOutput(methodCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMethodCallExpression_ObjectMustSupportOperation(methodCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMethodCallExpression_OutputMultiplicities(methodCallExpression, diagnostics, context);
        }
        return result;
    }

    public boolean validateMethodCallExpression_ObjectMustSupportOperation(MethodCallExpression methodCallExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.METHOD_CALL_EXPRESSION, methodCallExpression, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ObjectMustSupportOperation", METHOD_CALL_EXPRESSION__OBJECT_MUST_SUPPORT_OPERATION__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateMethodCallExpression_OutputMultiplicities(MethodCallExpression methodCallExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.METHOD_CALL_EXPRESSION, methodCallExpression, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "OutputMultiplicities", METHOD_CALL_EXPRESSION__OUTPUT_MULTIPLICITIES__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateObjectBasedExpression(ObjectBasedExpression objectBasedExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(objectBasedExpression, diagnostics, context);
    }

    public boolean validateObjectCreationExpression(ObjectCreationExpression objectCreationExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(objectCreationExpression, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(objectCreationExpression, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(objectCreationExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(objectCreationExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(objectCreationExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(objectCreationExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(objectCreationExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(objectCreationExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(objectCreationExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateObjectCreationExpression_CannotInstantiateAbstractClass(objectCreationExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateObjectCreationExpression_ExpressionType(objectCreationExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateObjectCreationExpression_HasToOwnTypeDefinition(objectCreationExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateObjectCreationExpression_CannotInstantiateValueClass(objectCreationExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateObjectCreationExpression_NoDuplicateInitializers(objectCreationExpression, diagnostics, context);
        }
        return result;
    }

    public boolean validateObjectCreationExpression_CannotInstantiateAbstractClass(ObjectCreationExpression objectCreationExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.OBJECT_CREATION_EXPRESSION, objectCreationExpression, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "CannotInstantiateAbstractClass", OBJECT_CREATION_EXPRESSION__CANNOT_INSTANTIATE_ABSTRACT_CLASS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateObjectCreationExpression_ExpressionType(ObjectCreationExpression objectCreationExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.OBJECT_CREATION_EXPRESSION, objectCreationExpression, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ExpressionType", OBJECT_CREATION_EXPRESSION__EXPRESSION_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateObjectCreationExpression_HasToOwnTypeDefinition(ObjectCreationExpression objectCreationExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.OBJECT_CREATION_EXPRESSION, objectCreationExpression, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "HasToOwnTypeDefinition", OBJECT_CREATION_EXPRESSION__HAS_TO_OWN_TYPE_DEFINITION__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateObjectCreationExpression_CannotInstantiateValueClass(ObjectCreationExpression objectCreationExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.OBJECT_CREATION_EXPRESSION, objectCreationExpression, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "CannotInstantiateValueClass", OBJECT_CREATION_EXPRESSION__CANNOT_INSTANTIATE_VALUE_CLASS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateObjectCreationExpression_NoDuplicateInitializers(ObjectCreationExpression objectCreationExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.OBJECT_CREATION_EXPRESSION, objectCreationExpression, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "NoDuplicateInitializers", OBJECT_CREATION_EXPRESSION__NO_DUPLICATE_INITIALIZERS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateFunctionCallExpression(FunctionCallExpression functionCallExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(functionCallExpression, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(functionCallExpression, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(functionCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(functionCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(functionCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(functionCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(functionCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(functionCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(functionCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSignatureCallExpression_ParametersTypesMustMatchSignatureParametersTypes(functionCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSignatureCallExpression_CallTypeMustMatchSignatureOutput(functionCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFunctionCallExpression_ResultType(functionCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFunctionCallExpression_CalledBlockMustBeFunction(functionCallExpression, diagnostics, context);
        }
        return result;
    }

    public boolean validateFunctionCallExpression_ResultType(FunctionCallExpression functionCallExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.FUNCTION_CALL_EXPRESSION, functionCallExpression, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ResultType", FUNCTION_CALL_EXPRESSION__RESULT_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateFunctionCallExpression_CalledBlockMustBeFunction(FunctionCallExpression functionCallExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.FUNCTION_CALL_EXPRESSION, functionCallExpression, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "CalledBlockMustBeFunction", FUNCTION_CALL_EXPRESSION__CALLED_BLOCK_MUST_BE_FUNCTION__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateWithArgument(WithArgument withArgument, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(withArgument, diagnostics, context);
    }

    public boolean validateThis(This this_, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(this_, diagnostics, context);
    }

    public boolean validateEquals(Equals equals, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(equals, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(equals, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(equals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(equals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(equals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(equals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(equals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(equals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(equals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEquals_ConformaceOneWayOrAnother(equals, diagnostics, context);
        }
        return result;
    }

    public boolean validateEquals_ConformaceOneWayOrAnother(Equals equals, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.EQUALS, equals, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ConformaceOneWayOrAnother", EQUALS__CONFORMACE_ONE_WAY_OR_ANOTHER__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAssociationEndNavigationExpression(AssociationEndNavigationExpression associationEndNavigationExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(associationEndNavigationExpression, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(associationEndNavigationExpression, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(associationEndNavigationExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(associationEndNavigationExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(associationEndNavigationExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(associationEndNavigationExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(associationEndNavigationExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(associationEndNavigationExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(associationEndNavigationExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssociationEndNavigationExpression_ObjectTypeMustMatch(associationEndNavigationExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssociationEndNavigationExpression_ResultType(associationEndNavigationExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssociationEndNavigationExpression_EndMustBeNavigable(associationEndNavigationExpression, diagnostics, context);
        }
        return result;
    }

    public boolean validateAssociationEndNavigationExpression_ObjectTypeMustMatch(AssociationEndNavigationExpression associationEndNavigationExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.ASSOCIATION_END_NAVIGATION_EXPRESSION, associationEndNavigationExpression, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ObjectTypeMustMatch", ASSOCIATION_END_NAVIGATION_EXPRESSION__OBJECT_TYPE_MUST_MATCH__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAssociationEndNavigationExpression_ResultType(AssociationEndNavigationExpression associationEndNavigationExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.ASSOCIATION_END_NAVIGATION_EXPRESSION, associationEndNavigationExpression, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ResultType", ASSOCIATION_END_NAVIGATION_EXPRESSION__RESULT_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAssociationEndNavigationExpression_EndMustBeNavigable(AssociationEndNavigationExpression associationEndNavigationExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.ASSOCIATION_END_NAVIGATION_EXPRESSION, associationEndNavigationExpression, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "EndMustBeNavigable", ASSOCIATION_END_NAVIGATION_EXPRESSION__END_MUST_BE_NAVIGABLE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateSignatureCallExpression(SignatureCallExpression signatureCallExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(signatureCallExpression, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(signatureCallExpression, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(signatureCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(signatureCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(signatureCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(signatureCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(signatureCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(signatureCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(signatureCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSignatureCallExpression_ParametersTypesMustMatchSignatureParametersTypes(signatureCallExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSignatureCallExpression_CallTypeMustMatchSignatureOutput(signatureCallExpression, diagnostics, context);
        }
        return result;
    }

    public boolean validateSignatureCallExpression_ParametersTypesMustMatchSignatureParametersTypes(SignatureCallExpression signatureCallExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.SIGNATURE_CALL_EXPRESSION, signatureCallExpression, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ParametersTypesMustMatchSignatureParametersTypes", SIGNATURE_CALL_EXPRESSION__PARAMETERS_TYPES_MUST_MATCH_SIGNATURE_PARAMETERS_TYPES__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateSignatureCallExpression_CallTypeMustMatchSignatureOutput(SignatureCallExpression signatureCallExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.SIGNATURE_CALL_EXPRESSION, signatureCallExpression, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "CallTypeMustMatchSignatureOutput", SIGNATURE_CALL_EXPRESSION__CALL_TYPE_MUST_MATCH_SIGNATURE_OUTPUT__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateObjectCount(ObjectCount objectCount, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(objectCount, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(objectCount, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(objectCount, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(objectCount, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(objectCount, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(objectCount, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(objectCount, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(objectCount, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(objectCount, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateObjectCount_TypeIsNumber(objectCount, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateObjectCount_MultiplicityIsOne(objectCount, diagnostics, context);
        }
        return result;
    }

    public boolean validateObjectCount_TypeIsNumber(ObjectCount objectCount, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.OBJECT_COUNT, objectCount, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "TypeIsNumber", OBJECT_COUNT__TYPE_IS_NUMBER__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateObjectCount_MultiplicityIsOne(ObjectCount objectCount, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.OBJECT_COUNT, objectCount, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "MultiplicityIsOne", OBJECT_COUNT__MULTIPLICITY_IS_ONE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateReplace(Replace replace, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(replace, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(replace, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(replace, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(replace, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(replace, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(replace, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(replace, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(replace, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(replace, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateReplace_SourceObjectIsOfValueType(replace, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateReplace_WithTypeConformsToLastStepsType(replace, diagnostics, context);
        }
        return result;
    }

    public boolean validateReplace_SourceObjectIsOfValueType(Replace replace, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.REPLACE, replace, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "SourceObjectIsOfValueType", REPLACE__SOURCE_OBJECT_IS_OF_VALUE_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateReplace_WithTypeConformsToLastStepsType(Replace replace, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.REPLACE, replace, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "WithTypeConformsToLastStepsType", REPLACE__WITH_TYPE_CONFORMS_TO_LAST_STEPS_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateNavigationStep(NavigationStep navigationStep, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(navigationStep, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(navigationStep, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(navigationStep, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(navigationStep, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(navigationStep, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(navigationStep, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(navigationStep, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(navigationStep, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(navigationStep, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNavigationStep_FromEndAttachesToOutputOfPreviousStep(navigationStep, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNavigationStep_FilterFunctionExpressionHasFunctionType(navigationStep, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNavigationStep_FromEndMustBeEqualityRelevant(navigationStep, diagnostics, context);
        }
        return result;
    }

    public boolean validateNavigationStep_FromEndAttachesToOutputOfPreviousStep(NavigationStep navigationStep, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.NAVIGATION_STEP, navigationStep, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "FromEndAttachesToOutputOfPreviousStep", NAVIGATION_STEP__FROM_END_ATTACHES_TO_OUTPUT_OF_PREVIOUS_STEP__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateNavigationStep_FilterFunctionExpressionHasFunctionType(NavigationStep navigationStep, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.NAVIGATION_STEP, navigationStep, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "FilterFunctionExpressionHasFunctionType", NAVIGATION_STEP__FILTER_FUNCTION_EXPRESSION_HAS_FUNCTION_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateNavigationStep_FromEndMustBeEqualityRelevant(NavigationStep navigationStep, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.NAVIGATION_STEP, navigationStep, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "FromEndMustBeEqualityRelevant", NAVIGATION_STEP__FROM_END_MUST_BE_EQUALITY_RELEVANT__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateHead(Head head, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(head, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(head, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(head, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(head, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(head, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(head, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(head, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(head, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(head, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateHead_IsOrdered(head, diagnostics, context);
        }
        return result;
    }

    public boolean validateHead_IsOrdered(Head head, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.HEAD, head, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "IsOrdered", "self.object.getType().ordered", 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateTail(Tail tail, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(tail, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(tail, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(tail, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(tail, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(tail, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(tail, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(tail, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(tail, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(tail, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTail_IsOrdered(tail, diagnostics, context);
        }
        return result;
    }

    public boolean validateTail_IsOrdered(Tail tail, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.TAIL, tail, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "IsOrdered", "self.object.getType().ordered", 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAsList(AsList asList, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(asList, diagnostics, context);
    }

    public boolean validateConditional(Conditional conditional, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(conditional, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(conditional, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(conditional, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(conditional, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(conditional, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(conditional, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(conditional, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(conditional, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(conditional, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateConditional_ConditionMustBeBoolean(conditional, diagnostics, context);
        }
        return result;
    }

    public boolean validateConditional_ConditionMustBeBoolean(Conditional conditional, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.CONDITIONAL, conditional, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ConditionMustBeBoolean", CONDITIONAL__CONDITION_MUST_BE_BOOLEAN__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateTernary(Ternary ternary, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(ternary, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(ternary, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(ternary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(ternary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(ternary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(ternary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(ternary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(ternary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(ternary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateConditional_ConditionMustBeBoolean(ternary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTernary_TrueAndFalseExprsConformToResultType(ternary, diagnostics, context);
        }
        return result;
    }

    public boolean validateTernary_TrueAndFalseExprsConformToResultType(Ternary ternary, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.TERNARY, ternary, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "TrueAndFalseExprsConformToResultType", TERNARY__TRUE_AND_FALSE_EXPRS_CONFORM_TO_RESULT_TYPE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateContentEquals(ContentEquals contentEquals, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(contentEquals, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(contentEquals, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(contentEquals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(contentEquals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(contentEquals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(contentEquals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(contentEquals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(contentEquals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(contentEquals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEquals_ConformaceOneWayOrAnother(contentEquals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateContentEquals_ContentEqualsOnlyForEntities(contentEquals, diagnostics, context);
        }
        return result;
    }

    public boolean validateContentEquals_ContentEqualsOnlyForEntities(ContentEquals contentEquals, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.CONTENT_EQUALS, contentEquals, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ContentEqualsOnlyForEntities", CONTENT_EQUALS__CONTENT_EQUALS_ONLY_FOR_ENTITIES__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateExpressionWithArgument(ExpressionWithArgument expressionWithArgument, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(expressionWithArgument, diagnostics, context);
    }

    public boolean validateConditionalExpression(ConditionalExpression conditionalExpression, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(conditionalExpression, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(conditionalExpression, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(conditionalExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(conditionalExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(conditionalExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(conditionalExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(conditionalExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(conditionalExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(conditionalExpression, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateConditional_ConditionMustBeBoolean(conditionalExpression, diagnostics, context);
        }
        return result;
    }

    public boolean validateMap(Map map, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(map, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(map, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(map, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(map, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(map, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(map, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(map, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(map, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(map, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMap_ObjectTypeMustConformToFunctionArgument(map, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMap_ArgumentMustBeSingleArgumentFunctionWithNonVoidOutput(map, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMap_MapFunctionMustBeSideEffectFree(map, diagnostics, context);
        }
        return result;
    }

    public boolean validateMap_ObjectTypeMustConformToFunctionArgument(Map map, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.MAP, map, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ObjectTypeMustConformToFunctionArgument", MAP__OBJECT_TYPE_MUST_CONFORM_TO_FUNCTION_ARGUMENT__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateMap_ArgumentMustBeSingleArgumentFunctionWithNonVoidOutput(Map map, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.MAP, map, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ArgumentMustBeSingleArgumentFunctionWithNonVoidOutput", MAP__ARGUMENT_MUST_BE_SINGLE_ARGUMENT_FUNCTION_WITH_NON_VOID_OUTPUT__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateMap_MapFunctionMustBeSideEffectFree(Map map, DiagnosticChain diagnostics, java.util.Map<Object, Object> context) {
        return this.validate(ExpressionsPackage.Literals.MAP, map, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "MapFunctionMustBeSideEffectFree", MAP__MAP_FUNCTION_MUST_BE_SIDE_EFFECT_FREE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

