/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import java.util.Comparator;
import prefuse.data.Tuple;
import prefuse.util.collections.DefaultLiteralComparator;
import prefuse.util.collections.LiteralComparator;

public class TupleComparator
implements Comparator {
    private String m_field;
    private int m_col;
    private Comparator m_cmp;
    private Class m_type;
    private int m_rev;

    public TupleComparator(String field, Class type, boolean ascend) {
        this(field, type, ascend, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public TupleComparator(String field, Class type, boolean ascend, Comparator c) {
        this.m_field = field;
        this.m_col = -1;
        this.m_type = type;
        this.m_rev = ascend ? 1 : -1;
        this.m_cmp = c;
    }

    public TupleComparator(int col, Class type, boolean ascend) {
        this(col, type, ascend, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public TupleComparator(int col, Class type, boolean ascend, Comparator c) {
        this.m_field = null;
        this.m_col = col;
        this.m_type = type;
        this.m_rev = ascend ? 1 : -1;
        this.m_cmp = c;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int compare(Object o1, Object o2) {
        Tuple t1 = (Tuple)o1;
        Tuple t2 = (Tuple)o2;
        int c = 0;
        if (this.m_col == -1) {
            if (this.m_type == Integer.TYPE || this.m_type == Byte.TYPE) {
                c = ((LiteralComparator)this.m_cmp).compare(t1.getInt(this.m_field), t2.getInt(this.m_field));
                return this.m_rev * c;
            } else if (this.m_type == Double.TYPE) {
                c = ((LiteralComparator)this.m_cmp).compare(t1.getDouble(this.m_field), t2.getDouble(this.m_field));
                return this.m_rev * c;
            } else if (this.m_type == Long.TYPE) {
                c = ((LiteralComparator)this.m_cmp).compare(t1.getLong(this.m_field), t2.getLong(this.m_field));
                return this.m_rev * c;
            } else if (this.m_type == Float.TYPE) {
                c = ((LiteralComparator)this.m_cmp).compare(t1.getFloat(this.m_field), t2.getFloat(this.m_field));
                return this.m_rev * c;
            } else if (this.m_type == Boolean.TYPE) {
                c = ((LiteralComparator)this.m_cmp).compare(t1.getBoolean(this.m_field), t2.getBoolean(this.m_field));
                return this.m_rev * c;
            } else {
                if (this.m_type.isPrimitive()) throw new IllegalStateException("Unsupported type: " + this.m_type.getName());
                c = this.m_cmp.compare(t1.get(this.m_field), t2.get(this.m_field));
            }
            return this.m_rev * c;
        } else if (this.m_type == Integer.TYPE || this.m_type == Byte.TYPE) {
            c = ((LiteralComparator)this.m_cmp).compare(t1.getInt(this.m_col), t2.getInt(this.m_col));
            return this.m_rev * c;
        } else if (this.m_type == Double.TYPE) {
            c = ((LiteralComparator)this.m_cmp).compare(t1.getDouble(this.m_col), t2.getDouble(this.m_col));
            return this.m_rev * c;
        } else if (this.m_type == Long.TYPE) {
            c = ((LiteralComparator)this.m_cmp).compare(t1.getLong(this.m_col), t2.getLong(this.m_col));
            return this.m_rev * c;
        } else if (this.m_type == Float.TYPE) {
            c = ((LiteralComparator)this.m_cmp).compare(t1.getFloat(this.m_col), t2.getFloat(this.m_col));
            return this.m_rev * c;
        } else if (this.m_type == Boolean.TYPE) {
            c = ((LiteralComparator)this.m_cmp).compare(t1.getBoolean(this.m_col), t2.getBoolean(this.m_col));
            return this.m_rev * c;
        } else {
            if (this.m_type.isPrimitive()) throw new IllegalStateException("Unsupported type: " + this.m_type.getName());
            c = this.m_cmp.compare(t1.get(this.m_col), t2.get(this.m_col));
        }
        return this.m_rev * c;
    }
}

