/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.usecase.modelfilter.dependencies.ui.internal.editor;

import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.prefuse.PrefuseGraphContainer;
import org.eclipse.modisco.java.ASTNode;
import org.eclipse.modisco.java.Model;
import org.eclipse.modisco.java.NamedElement;
import org.eclipse.modisco.java.Package;
import org.eclipse.modisco.java.Type;
import org.eclipse.modisco.java.internal.util.JavaUtil;
import org.eclipse.modisco.usecase.modelfilter.dependencies.ui.internal.Activator;
import org.eclipse.modisco.usecase.modelfilter.dependencies.ui.internal.Messages;
import org.eclipse.modisco.usecase.modelfilter.dependencies.ui.internal.editor.GetUsedPackages;
import org.eclipse.modisco.usecase.modelfilter.dependencies.ui.internal.editor.GetUsedTypes;
import org.eclipse.modisco.usecase.modelfilter.dependencies.ui.internal.editor.PrefuseGraphInput;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import prefuse.controls.Control;
import prefuse.controls.ControlAdapter;
import prefuse.data.Edge;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.visual.VisualItem;

public class DependenciesEditor
extends EditorPart {
    public static final String EDITOR_ID = "org.eclipse.modisco.usecase.modelfilter.dependencies.modeleditor.prefuse.EditorID";
    private PrefuseGraphInput editorInput;
    private final String nameAttribute = "name";
    private final String javaElement = "javaElement";
    private Graph currentGraph = null;
    private final Map<NamedElement, Node> dependenciesNodes = new HashMap<NamedElement, Node>();

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setPartName(Messages.DependenciesEditor_partName);
        if (input instanceof PrefuseGraphInput) {
            this.editorInput = (PrefuseGraphInput)input;
            this.setInput(this.editorInput);
        } else if (input instanceof FileEditorInput) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI resourceURI = EditUIUtil.getURI((IEditorInput)input);
            Resource result = resourceSet.getResource(resourceURI, true);
            IJavaProject tempProject = null;
            IProject project = ((FileEditorInput)input).getFile().getProject();
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    tempProject = JavaCore.create((IProject)project);
                }
            }
            catch (CoreException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
            this.editorInput = new PrefuseGraphInput(result, tempProject);
            this.setInput(this.editorInput);
        } else {
            throw new PartInitException(Messages.DependenciesEditor_incorrectInputType);
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        if (this.editorInput != null) {
            Graph graph = null;
            if (this.editorInput.getInputResource() != null) {
                Resource resource = this.editorInput.getInputResource();
                Model model = null;
                for (EObject eObject : resource.getContents()) {
                    if (!(eObject instanceof Model)) continue;
                    model = (Model)eObject;
                }
                if (model != null) {
                    this.setPartName(Messages.DependenciesEditor_modelPartName + model.getName());
                    graph = this.initializeDependenciesGraph(model);
                }
            } else if (this.editorInput.getInputPackage() != null) {
                Package packageNode = this.editorInput.getInputPackage();
                this.setPartName(Messages.DependenciesEditor_packagePartName + JavaUtil.getQualifiedName((ASTNode)packageNode));
                graph = this.initializeDependenciesGraph((NamedElement)packageNode);
            } else if (this.editorInput.getInputType() != null) {
                Type typeNode = this.editorInput.getInputType();
                this.setPartName(Messages.DependenciesEditor_typePartName + JavaUtil.getQualifiedName((ASTNode)typeNode));
                graph = this.initializeDependenciesGraph((NamedElement)typeNode);
            }
            JPanel treeview = PrefuseGraphContainer.getInstance().initializeGraphViewContainer(graph, "name", (Control)this.initializeControlAdapter());
            PrefuseGraphContainer.getInstance().createPartControl(parent, treeview);
        }
    }

    public void setFocus() {
    }

    private final ControlAdapter initializeControlAdapter() {
        ControlAdapter controlAdapter = new ControlAdapter(){

            public void itemClicked(VisualItem item, MouseEvent e) {
                if (e.getButton() == 1) {
                    if (e.getClickCount() == 1) {
                        DependenciesEditor.this.completeDependenciesGraph(item);
                    } else if (e.getClickCount() > 1) {
                        DependenciesEditor.this.updateDependenciesGraph(item);
                    }
                }
            }
        };
        return controlAdapter;
    }

    protected final void completeDependenciesGraph(VisualItem item) {
        NamedElement element;
        Tuple tuple = item.getSourceTuple();
        if (tuple.canGet("javaElement", NamedElement.class) && (element = (NamedElement)tuple.get("javaElement")) instanceof Type) {
            this.generateDependenciesNode(null, element);
        }
    }

    protected final void updateDependenciesGraph(VisualItem item) {
        Tuple tuple = item.getSourceTuple();
        if (tuple.canGet("javaElement", NamedElement.class)) {
            NamedElement element = (NamedElement)tuple.get("javaElement");
            if (element instanceof Type) {
                MoDiscoLogger.logWarning((String)"not implemented", (Plugin)Activator.getDefault());
            } else if (element instanceof Package) {
                this.clearData();
                Package packElement = (Package)element;
                for (Package ownedPackage : packElement.getOwnedPackages()) {
                    this.generateDependenciesNode(null, (NamedElement)ownedPackage);
                }
                for (Type ownedType : packElement.getOwnedElements()) {
                    this.generateDependenciesNode(null, (NamedElement)ownedType);
                }
                item.getVisualization().run("draw");
            }
        }
    }

    private final void clearData() {
        this.dependenciesNodes.clear();
        this.currentGraph.clear();
    }

    private final Graph initializeDependenciesGraph(Model root) {
        Graph result = this.intializeDependenciesGraph();
        for (Package rootElement : root.getOwnedElements()) {
            this.generateDependenciesNode(null, (NamedElement)rootElement);
        }
        return result;
    }

    private final Graph initializeDependenciesGraph(NamedElement packageNode) {
        Graph result = this.intializeDependenciesGraph();
        this.generateDependenciesNode(null, packageNode);
        return result;
    }

    private final Graph intializeDependenciesGraph() {
        this.currentGraph = new Graph(true);
        Table nodes = this.currentGraph.getNodeTable();
        nodes.addColumn("name", String.class);
        nodes.addColumn("javaElement", NamedElement.class);
        return this.currentGraph;
    }

    private final void generateDependenciesNode(Node parentNode, NamedElement element) {
        block7: {
            Node activeNode;
            block8: {
                activeNode = null;
                if (this.dependenciesNodes.containsKey(element)) {
                    activeNode = this.dependenciesNodes.get(element);
                } else {
                    activeNode = this.currentGraph.addNode();
                    activeNode.set("javaElement", (Object)element);
                    activeNode.set("name", (Object)JavaUtil.getQualifiedName((ASTNode)element));
                    this.dependenciesNodes.put(element, activeNode);
                }
                if (activeNode == null) break block7;
                if (parentNode == null) break block8;
                Edge edge = this.currentGraph.getEdge(parentNode, activeNode);
                if (edge != null) break block7;
                edge = this.currentGraph.addEdge(parentNode, activeNode);
                break block7;
            }
            if (element instanceof Package) {
                GetUsedPackages query = new GetUsedPackages();
                for (Package usedPackage : query.getUsedPackages((Package)element)) {
                    this.generateDependenciesNode(activeNode, (NamedElement)usedPackage);
                }
            } else if (element instanceof Type) {
                GetUsedTypes query = new GetUsedTypes();
                for (Type usedType : query.getUsedTypes((Type)element)) {
                    this.generateDependenciesNode(activeNode, (NamedElement)usedType);
                }
            }
        }
    }
}

