/**
 * Copyright (c) 2004-2006 Regents of the University of California.
 * See "license-prefuse.txt" for licensing terms.
 */
package prefuse.util.collections;

import java.util.NoSuchElementException;

/**
 * IntIterator implementation that provides an iteration over the
 * contents of an int array.
 * 
 * @author <a href="http://jheer.org">jeffrey heer</a>
 */
public class IntArrayIterator extends IntIterator {

    private int[] m_array;
    private int m_cur;
    private int m_end;
    
    public IntArrayIterator(int[] array, int start, int len) {
        this.m_array = array;
        this.m_cur = start;
        this.m_end = start+len;
    }
    
    /**
     * @see prefuse.util.collections.IntIterator#nextInt()
     */
    public int nextInt() {
        if ( this.m_cur >= this.m_end )
            throw new NoSuchElementException();
        return this.m_array[this.m_cur++];
    }

    /**
     * @see java.util.Iterator#hasNext()
     */
    public boolean hasNext() {
        return this.m_cur < this.m_end;
    }
    
    public void remove() {
        throw new UnsupportedOperationException();
    }

} // end of class IntArrayIterator
