/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.functions.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.Function;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.functions.internal.TypesComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolymorphicResolver {
    private final QualifiedName _name;
    private static final Comparator<Function> _paramTypeComparator = new Comparator<Function>(){
        private final TypesComparator _typesComparator = new TypesComparator();

        @Override
        public int compare(Function o1, Function o2) {
            return this._typesComparator.compare(o1.getParameterTypes(), o2.getParameterTypes());
        }
    };

    public PolymorphicResolver(QualifiedName functionName) {
        this._name = functionName;
    }

    public Collection<Function> getBestFitCandidates(Collection<Function> functions) {
        if (functions.size() <= 1) {
            return functions;
        }
        ArrayList<Function> sorted = new ArrayList<Function>(functions);
        Collections.sort(sorted, _paramTypeComparator);
        ArrayList<Function> result = new ArrayList<Function>();
        for (Function f : sorted) {
            if (_paramTypeComparator.compare(f, (Function)sorted.get(0)) != 0) break;
            result.add(f);
        }
        return result;
    }

    private Function evaluateGuards(ExecutionContext ctx, Function function) {
        if (function.getGuard() == null) {
            return function;
        }
        if (Boolean.TRUE.equals(function.getGuard().evaluate(ctx))) {
            return function;
        }
        throw new IllegalArgumentException("guard of the only implementation of " + this._name + " evaluated to false");
    }

    public Function evaluateGuards(ExecutionContext ctx, Collection<Function> functions) {
        if (functions.size() == 1) {
            return this.evaluateGuards(ctx, functions.iterator().next());
        }
        ArrayList<Function> unguarded = new ArrayList<Function>();
        Function passedInspection = null;
        for (Function f : functions) {
            if (f.getGuard() == null) {
                unguarded.add(f);
                continue;
            }
            if (!Boolean.TRUE.equals(f.getGuard().evaluate(ctx))) continue;
            if (passedInspection != null) {
                throw new IllegalArgumentException("ambiguous call to " + this._name + " - both " + passedInspection + " and " + f + " had guard expressions that evaluated to true");
            }
            passedInspection = f;
        }
        if (passedInspection != null) {
            return passedInspection;
        }
        if (unguarded.size() == 1) {
            return (Function)unguarded.get(0);
        }
        if (unguarded.isEmpty()) {
            throw new IllegalArgumentException("call to " + this._name + " could not be resolved - no guard allowed passage, and there are no unguarded implementations.");
        }
        throw new IllegalArgumentException("call to " + this._name + " could not be resolved - ambiuity between " + unguarded);
    }
}

