/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.types.xsd.internal;

import java.util.Arrays;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.Function;
import org.eclipse.xtend.backend.common.Property;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.functions.AbstractFunction;
import org.eclipse.xtend.backend.types.AbstractProperty;
import org.eclipse.xtend.backend.types.AbstractType;
import org.eclipse.xtend.backend.types.builtin.ObjectType;
import org.eclipse.xtend.backend.types.builtin.StringType;
import org.eclipse.xtend.backend.types.xsd.XsdTypesystem;

public class EMapEntryType
extends AbstractType {
    private BackendType _keyType;
    private BackendType _valueType;

    public EMapEntryType(String name, XsdTypesystem ts, EClassifier innerType) {
        super(name, "{xsd}" + name, new BackendType[0]);
        this.determineTypes(innerType);
        Class<EClassifier> innerTypeClass = null;
        if (innerTypeClass != null) {
            innerType.getClass();
        } else {
            innerTypeClass = EClassifier.class;
        }
        this.register((Property)new AbstractProperty((BackendType)this, innerTypeClass, "value", true, true){

            protected Object getRaw(ExecutionContext ctx, Object target) {
                Map.Entry ent = (Map.Entry)target;
                return ent.getValue();
            }

            public BackendType getType(BackendTypesystem ts) {
                return EMapEntryType.this._valueType;
            }
        }, this._valueType);
        this.register((Property)new AbstractProperty((BackendType)this, innerTypeClass, "key", true, true){

            protected Object getRaw(ExecutionContext ctx, Object target) {
                Map.Entry ent = (Map.Entry)target;
                return ent.getKey();
            }

            public BackendType getType(BackendTypesystem ts) {
                return EMapEntryType.this._keyType;
            }
        }, this._keyType);
        this.register(new QualifiedName("setValue"), (Function)new AbstractFunction(null, Arrays.asList(new BackendType[]{this, this._valueType}), this._valueType, false){

            public Object invoke(ExecutionContext ctx, Object[] params) {
                Map.Entry ent = (Map.Entry)params[0];
                Object old = ent.getValue();
                ent.setValue(params[1]);
                return old;
            }
        });
    }

    private void determineTypes(EClassifier emfType) {
        EClass str2str = EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY;
        if (emfType != null && emfType instanceof EClass && str2str.isSuperTypeOf((EClass)emfType)) {
            this._keyType = StringType.INSTANCE;
            this._valueType = StringType.INSTANCE;
        } else {
            this._keyType = ObjectType.INSTANCE;
            this._valueType = ObjectType.INSTANCE;
        }
    }

    public BackendType getKeyType() {
        return this._keyType;
    }

    public BackendType getValueType() {
        return this._valueType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        if (other instanceof EMapEntryType) {
            EMapEntryType eMapEntryType = (EMapEntryType)((Object)other);
        }
        return true;
    }

    public static boolean isEMapEntry(ETypedElement element) {
        EClassifier t = element.getEType();
        return element != null && element.eContainer() instanceof EClass && t != null && t.getInstanceClass() != null && Map.Entry.class.isAssignableFrom(t.getInstanceClass()) && !element.isMany();
    }

    public static boolean isEMapEntryObject(Object o) {
        return o instanceof Map.Entry;
    }
}

