/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.xtend.internal.xtend;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.xtend.ast.Check;
import org.eclipse.internal.xtend.xtend.ast.ExtensionFile;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.Function;
import org.eclipse.xtend.backend.common.NamedFunction;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.common.SourcePos;
import org.eclipse.xtend.backend.expr.AndExpression;
import org.eclipse.xtend.backend.expr.IfExpression;
import org.eclipse.xtend.backend.expr.InitClosureExpression;
import org.eclipse.xtend.backend.expr.InvocationOnObjectExpression;
import org.eclipse.xtend.backend.expr.LiteralExpression;
import org.eclipse.xtend.backend.expr.LocalVarEvalExpression;
import org.eclipse.xtend.backend.expr.OrExpression;
import org.eclipse.xtend.backend.expr.SequenceExpression;
import org.eclipse.xtend.backend.functions.SourceDefinedFunction;
import org.eclipse.xtend.backend.types.builtin.BooleanType;
import org.eclipse.xtend.backend.types.builtin.CollectionType;
import org.eclipse.xtend.backend.types.builtin.ObjectType;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Resource;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.middleend.xtend.OldHelper;
import org.eclipse.xtend.middleend.xtend.internal.OldExpressionConverter;
import org.eclipse.xtend.middleend.xtend.internal.TypeToBackendType;

public final class CheckConverter {
    public static final QualifiedName ALL_CHECKS_FUNCTION_NAME = new QualifiedName("CheckAllChecks");
    public static final String ISSUES_PARAM_NAME = "$issues";
    public static final String ALL_OBJECTS_PARAM_NAME = "$allObjects";
    private final TypeToBackendType _typeConverter;
    private final ExecutionContext _emptyExecutionContext;

    public CheckConverter(ExecutionContext ctx, TypeToBackendType typeConverter) {
        this._emptyExecutionContext = ctx;
        this._typeConverter = typeConverter;
    }

    public NamedFunction createCheckFunction(BackendTypesystem ts, ExtensionFile extensionFile) {
        OldExpressionConverter exprConv = new OldExpressionConverter(this._emptyExecutionContext.cloneWithResource((Resource)extensionFile), this._typeConverter, OldHelper.normalizeXtendResourceName(extensionFile.getFullyQualifiedName()));
        List<String> paramNames = Arrays.asList(ISSUES_PARAM_NAME, ALL_OBJECTS_PARAM_NAME);
        List<BackendType> paramTypes = Arrays.asList(ts.findType(Issues.class), CollectionType.INSTANCE);
        ArrayList<ExpressionBase> allChecks = new ArrayList<ExpressionBase>();
        for (Check chk : extensionFile.getChecks()) {
            if (exprConv.hasThis()) continue;
            ExecutionContext oldCtx = exprConv.getExecutionContext();
            exprConv.setExecutionContext(oldCtx.cloneWithVariable(new Variable("this", (Object)oldCtx.getTypeForName(chk.getType().toString()))));
            allChecks.add(this.convertCheck(chk, exprConv));
            exprConv.setExecutionContext(oldCtx);
        }
        SequenceExpression body = new SequenceExpression(allChecks, exprConv.getSourcePos((SyntaxElement)extensionFile));
        return new NamedFunction(ALL_CHECKS_FUNCTION_NAME, (Function)new SourceDefinedFunction(ALL_CHECKS_FUNCTION_NAME, paramNames, paramTypes, (BackendType)BooleanType.INSTANCE, (ExpressionBase)body, false, null));
    }

    private ExpressionBase convertCheck(Check chk, OldExpressionConverter exprConv) {
        SourcePos sourcePos = exprConv.getSourcePos((SyntaxElement)chk);
        OrExpression preCondExpression = chk.getGuard() == null ? exprConv.convert(chk.getConstraint()) : new OrExpression((ExpressionBase)new InvocationOnObjectExpression(new QualifiedName("operatorNot"), Arrays.asList(exprConv.convert(chk.getGuard())), true, sourcePos), (ExpressionBase)new AndExpression(exprConv.convert(chk.getGuard()), exprConv.convert(chk.getConstraint()), sourcePos), sourcePos);
        String addIssueMethodName = chk.isErrorCheck() ? "addError" : "addWarning";
        ArrayList<Object> failureParams = new ArrayList<Object>();
        failureParams.add(new LocalVarEvalExpression(ISSUES_PARAM_NAME, sourcePos));
        failureParams.add(exprConv.convert(chk.getMsg()));
        failureParams.add(new LocalVarEvalExpression("this", sourcePos));
        InvocationOnObjectExpression failureExpression = new InvocationOnObjectExpression(new QualifiedName(addIssueMethodName), failureParams, true, sourcePos);
        IfExpression onEachExpression = new IfExpression((ExpressionBase)preCondExpression, (ExpressionBase)new LiteralExpression(null, sourcePos), (ExpressionBase)failureExpression, sourcePos);
        ArrayList<Object> typeSelectParams = new ArrayList<Object>();
        typeSelectParams.add(new LocalVarEvalExpression(ALL_OBJECTS_PARAM_NAME, sourcePos));
        typeSelectParams.add(new LiteralExpression((Object)this._typeConverter.convertToBackendType(chk.getType()), sourcePos));
        InvocationOnObjectExpression typeSelectExpression = new InvocationOnObjectExpression(new QualifiedName("typeSelect"), typeSelectParams, true, sourcePos);
        ArrayList<Object> collectParams = new ArrayList<Object>();
        collectParams.add(typeSelectExpression);
        collectParams.add(new InitClosureExpression(Arrays.asList("this"), Arrays.asList(ObjectType.INSTANCE), (ExpressionBase)onEachExpression, sourcePos));
        return new InvocationOnObjectExpression(new QualifiedName("collect"), collectParams, true, sourcePos);
    }
}

