/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.lib;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.NamedFunction;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.common.SourcePos;
import org.eclipse.xtend.backend.functions.java.internal.JavaBuiltinConverter;
import org.eclipse.xtend.backend.functions.java.internal.JavaBuiltinConverterFactory;
import org.eclipse.xtend.backend.functions.java.internal.ParameterConverter;
import org.eclipse.xtend.backend.syslib.CollectionOperations;
import org.eclipse.xtend.backend.util.ErrorHandler;
import org.eclipse.xtend.middleend.javaannotations.ExecutionContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoker {
    public static Object invokeOnObject(QualifiedName functionName, List<Object> params, ExecutionContext ctx, boolean firstParamIsThis) {
        return ctx.getFunctionDefContext().invoke(ctx, functionName, params, firstParamIsThis);
    }

    public static Object invokeOnObjectNullChecked(QualifiedName functionName, List<Object> params, ExecutionContext ctx, boolean firstParamIsThis, SourcePos pos) {
        if (params.size() > 0 && params.get(0) == null) {
            ctx.logNullDeRef(pos);
            return null;
        }
        return ctx.getFunctionDefContext().invoke(ctx, functionName, params, firstParamIsThis);
    }

    public static Object invokeOnCollection(QualifiedName functionName, Collection<?> coll, List<Object> params, ExecutionContext ctx, boolean firstParamIsThis, SourcePos pos) {
        if (coll == null) {
            ctx.logNullDeRef(pos);
            return null;
        }
        Collection<Object> result = CollectionOperations.createMatchingCollection(coll);
        for (Object o : coll) {
            params.set(0, o);
            CollectionOperations.addFlattened(result, ctx.getFunctionDefContext().invoke(ctx, functionName, params, firstParamIsThis));
        }
        return result;
    }

    public static Object invokeOnWhatEver(QualifiedName functionName, List<Object> params, ExecutionContext ctx, boolean firstParamIsThis) {
        if (params.get(0) instanceof Collection) {
            if (ctx.getFunctionDefContext().hasMatch(ctx, functionName, params)) {
                return ctx.getFunctionDefContext().invoke(ctx, functionName, params, firstParamIsThis);
            }
            Collection coll = (Collection)params.get(0);
            Collection<Object> result = CollectionOperations.createMatchingCollection(coll);
            for (Object o : coll) {
                params.set(0, o);
                CollectionOperations.addFlattened(result, ctx.getFunctionDefContext().invoke(ctx, functionName, params, firstParamIsThis));
            }
            return result;
        }
        return ctx.getFunctionDefContext().invoke(ctx, functionName, params, firstParamIsThis);
    }

    public static Object invokeOnWhatEverNullChecked(QualifiedName functionName, List<Object> params, ExecutionContext ctx, boolean firstParamIsThis, SourcePos pos) {
        if (params.get(0) == null) {
            ctx.logNullDeRef(pos);
            return null;
        }
        if (params.get(0) instanceof Collection) {
            if (ctx.getFunctionDefContext().hasMatch(ctx, functionName, params)) {
                return ctx.getFunctionDefContext().invoke(ctx, functionName, params, firstParamIsThis);
            }
            Collection coll = (Collection)params.get(0);
            Collection<Object> result = CollectionOperations.createMatchingCollection(coll);
            for (Object o : coll) {
                params.set(0, o);
                CollectionOperations.addFlattened(result, ctx.getFunctionDefContext().invoke(ctx, functionName, params, firstParamIsThis));
            }
            return result;
        }
        return ctx.getFunctionDefContext().invoke(ctx, functionName, params, firstParamIsThis);
    }

    public static Object invokeOnObject(NamedFunction function, List<Object> params, ExecutionContext ctx, boolean nullIfFirstParamIsNull, boolean firstParamIsThis, SourcePos pos) {
        if (nullIfFirstParamIsNull && params.size() > 0 && params.get(0) == null) {
            ctx.logNullDeRef(pos);
            return null;
        }
        return ctx.getFunctionInvoker().invoke(ctx, function.getFunction(), params);
    }

    public static Object invokeOnCollection(NamedFunction function, Collection<?> coll, List<Object> params, ExecutionContext ctx, boolean nullIfFirstParamIsNull, boolean firstParamIsThis, SourcePos pos) {
        if (coll == null) {
            ctx.logNullDeRef(pos);
            return null;
        }
        Collection<Object> result = CollectionOperations.createMatchingCollection(coll);
        for (Object o : coll) {
            params.set(0, o);
            CollectionOperations.addFlattened(result, ctx.getFunctionInvoker().invoke(ctx, function.getFunction(), params));
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static Object invokeMethod(Method method, List<Object> params, boolean isStatic, ExecutionContext ctx, boolean nullIfFirstParamIsNull, boolean firstParamIsThis, SourcePos pos) {
        if (nullIfFirstParamIsNull && params.size() > 0 && params.get(0) == null) {
            ctx.logNullDeRef(pos);
            return null;
        }
        rawParams = params.toArray(new Object[params.size()]);
        try {
            parameterConverters = Invoker.getParameterConverters(method);
            returnValueConverter = Invoker.getReturnValueConverter(method);
            i = 0;
            while (i < parameterConverters.size()) {
                parameterConverters.get(i).convert(rawParams);
                ++i;
            }
            o = Invoker.getInstance(ctx, method, isStatic);
            if (o instanceof ExecutionContextAware) {
                ((ExecutionContextAware)o).setExecutionContext(ctx);
            }
            resultRaw = method.invoke(o, rawParams);
            return returnValueConverter.javaToBackend(resultRaw);
        }
        catch (Exception e) {
            paramTypes = new ArrayList<String>();
            ** for (p : params)
        }
lbl-1000:
        // 1 sources

        {
            if (p == null) {
                paramTypes.add(Void.TYPE.getName());
                continue;
            }
            paramTypes.add(p.getClass().getName());
            continue;
        }
lbl28:
        // 1 sources

        ErrorHandler.handle("could not invoke method " + method + " with parameters " + params + " of types " + paramTypes, e);
        return null;
    }

    private static Object getInstance(ExecutionContext ctx, Method method, boolean isStatic) {
        Class<?> clazz = method.getDeclaringClass();
        if (isStatic) {
            return null;
        }
        try {
            Object result = ctx.getContributionStateContext().retrieveState(clazz);
            if (result == null) {
                result = clazz.newInstance();
                ctx.getContributionStateContext().storeState(clazz, result);
            }
            return result;
        }
        catch (Exception exc) {
            ErrorHandler.handle(exc);
            return null;
        }
    }

    public static List<BackendType> guessParameterTypes(Method mtd, BackendTypesystem ts) {
        ArrayList<BackendType> result = new ArrayList<BackendType>();
        Class<?>[] classArray = mtd.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cls = classArray[n2];
            result.add(ts.findType(cls));
            ++n2;
        }
        return result;
    }

    private static List<ParameterConverter> getParameterConverters(Method mtd) {
        ArrayList<ParameterConverter> parameterConverters = new ArrayList<ParameterConverter>(mtd.getParameterTypes().length);
        int i = 0;
        while (i < mtd.getParameterTypes().length) {
            ParameterConverter pc = JavaBuiltinConverterFactory.getParameterConverter(mtd.getParameterTypes()[i], i);
            if (pc != null) {
                parameterConverters.add(pc);
            }
            ++i;
        }
        return parameterConverters;
    }

    private static JavaBuiltinConverter getReturnValueConverter(Method mtd) {
        JavaBuiltinConverter converter = JavaBuiltinConverterFactory.getConverter(mtd.getReturnType());
        return converter;
    }
}

