/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.xtend.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.internal.xtend.expression.ast.DeclaredParameter;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.xtend.XtendFile;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Around
extends SyntaxElement {
    private static final List<DeclaredParameter> EMPTY_DECLAREDPARAMETERS = Collections.emptyList();
    public static final String CONTEXT_PARAM_NAME = "ctx";
    private final Identifier pointcut;
    private final List<DeclaredParameter> params;
    private final boolean wildparams;
    private final Expression expression;
    private XtendFile parent = null;
    private Pattern p;

    public Around(Identifier pointcut, List<DeclaredParameter> params, boolean wildparams, Expression expr) {
        this.pointcut = pointcut;
        this.params = params != null && !params.isEmpty() ? params : EMPTY_DECLAREDPARAMETERS;
        this.wildparams = wildparams;
        this.expression = expr;
    }

    public Identifier getPointCut() {
        return this.pointcut;
    }

    public boolean isWildparams() {
        return this.wildparams;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public List<DeclaredParameter> getParams() {
        return this.params;
    }

    public void setParent(XtendFile parent) {
        this.parent = parent;
    }

    public XtendFile getParent() {
        return this.parent;
    }

    public List<Type> getParamTypes(ExecutionContext ctx) {
        ExecutionContext _ctx = ctx.cloneWithResource(this.getParent());
        ArrayList<Type> result = new ArrayList<Type>();
        for (DeclaredParameter dp : this.getParams()) {
            result.add(_ctx.getTypeForName(dp.getType().getValue()));
        }
        return result;
    }

    public boolean nameMatches(String fqn) {
        if (this.p == null) {
            this.p = Pattern.compile(this.pointcut.getValue().replaceAll("\\*", ".*"));
        }
        Matcher m = this.p.matcher(fqn);
        return m.matches();
    }

    public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        ExecutionContext _ctx = ctx.cloneWithoutVariables();
        _ctx = _ctx.cloneWithResource(this.getParent());
        for (DeclaredParameter dp : this.getParams()) {
            String name = dp.getName().getValue();
            if (name.equals(CONTEXT_PARAM_NAME)) {
                issues.add(new AnalysationIssue(AnalysationIssue.SYNTAX_ERROR, "The variable name 'ctx' is not allowed here!", dp.getName()));
            }
            Type t = _ctx.getTypeForName(dp.getType().getValue());
            _ctx = _ctx.cloneWithVariable(new Variable(name, t));
        }
        _ctx = _ctx.cloneWithVariable(new Variable(CONTEXT_PARAM_NAME, _ctx.getTypeForName("xtend::AdviceContext")));
        this.expression.analyze(_ctx, issues);
    }

    public String toString() {
        return " around " + this.pointcut + "(" + this.paramsToString() + (this.isWildparams() ? " * " : "") + ") from " + this.getParent().getFullyQualifiedName();
    }

    private String paramsToString() {
        StringBuffer b = new StringBuffer("");
        Iterator<DeclaredParameter> iter = this.getParams().iterator();
        while (iter.hasNext()) {
            DeclaredParameter dp = iter.next();
            b.append(dp.getType() + " " + dp.getName());
            if (!iter.hasNext()) continue;
            b.append(",");
        }
        return b.toString();
    }
}

