/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.uml2.profile;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.issues.IssuesImpl;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.xtend.typesystem.uml2.Setup;

public class ProfilingExtensions {
    private static final Log LOG = LogFactory.getLog(ProfilingExtensions.class);

    public static Profile applyProfile(Model model, String uri) {
        Profile profile;
        new Setup().setStandardUML2Setup(true);
        if (!uri.endsWith(".profile.uml2") && !uri.endsWith(".profile.uml")) {
            uri = String.valueOf(uri) + ".profile.uml";
        }
        if ((profile = (Profile)new XmiReader().load(uri)) == null) {
            throw new NullPointerException("Profile '" + uri + "' not loaded.");
        }
        model.applyProfile(profile);
        return profile;
    }

    public static void applyStereotype(Element elem, String stereotypeName) {
        Stereotype st = elem.getApplicableStereotype(stereotypeName);
        if (st != null && !elem.isStereotypeApplied(st)) {
            elem.applyStereotype(st);
        }
        if (elem.getAppliedStereotype(stereotypeName) != null) {
            LOG.debug((Object)("Stereotype '" + stereotypeName + "' applied for '" + elem));
        }
    }

    public static void setTaggedValue(Element elem, String stereotypeName, String taggedValueName, Object value) {
        Stereotype st = elem.getApplicableStereotype(stereotypeName);
        if (st != null) {
            if (!elem.isStereotypeApplied(st)) {
                elem.applyStereotype(st);
            }
            try {
                if (value == null) {
                    LOG.warn((Object)(String.valueOf(taggedValueName) + ": Tried to set null value for element " + (elem instanceof NamedElement ? ((NamedElement)elem).getName() : elem)));
                } else {
                    elem.setValue(st, taggedValueName, value);
                }
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)(String.valueOf(taggedValueName) + ": " + e.getMessage()));
            }
        }
    }

    public static void addTaggedValue(Element elem, String stereotypeName, String taggedValueName, Object value) {
        Stereotype st = elem.getApplicableStereotype(stereotypeName);
        if (st != null) {
            if (!elem.isStereotypeApplied(st)) {
                elem.applyStereotype(st);
            }
            try {
                if (value == null) {
                    LOG.warn((Object)(String.valueOf(taggedValueName) + ": Tried to set null value for element " + (elem instanceof NamedElement ? ((NamedElement)elem).getName() : elem)));
                } else {
                    List list = (List)elem.getValue(st, taggedValueName);
                    list.add(value);
                }
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)(String.valueOf(taggedValueName) + ": " + e.getMessage()));
            }
        }
    }

    private static class XmiReader
    extends org.eclipse.xtend.typesystem.emf.XmiReader {
        public XmiReader() {
            this.setMetaModelPackage(UMLPackage.class.getName());
        }

        public Element load(String file) {
            this.setModelFile(file);
            IssuesImpl issues = new IssuesImpl();
            File f = this.loadFile((Issues)issues);
            if (issues.hasErrors()) {
                throw new RuntimeException(issues.toString());
            }
            URI fileURI = URI.createFileURI((String)f.getAbsolutePath());
            Resource r = new ResourceSetImpl().createResource(fileURI);
            try {
                r.load(null);
            }
            catch (IOException e) {
                throw new ConfigurationException((Throwable)e);
            }
            if (AnyType.class.isAssignableFrom(((EObject)r.getContents().get(0)).getClass())) {
                throw new ConfigurationException("Profile not loaded correctly. Root element is of type AnyType - could not be instantiated as Profile.");
            }
            return (Element)r.getContents().get(0);
        }
    }
}

