/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.taglib.ExtensionTagDefinitionImpl;
import org.eclipse.jet.taglib.CustomTagKind;
import org.eclipse.jet.taglib.TagDefinition;
import org.eclipse.jet.taglib.TagInstanceFactory;
import org.eclipse.jet.taglib.TagLibrary;

public class ExtensionTagLibraryImpl
implements TagLibrary {
    private static final String TAG_FACTORY_ATTRIBUTE = "tagFactory";
    private static final String DEPRECATED__ATTR = "deprecated";
    private static final String STANDARD_PREFIX__ATTR = "standardPrefix";
    private static final String NAME__ATTR = "name";
    private static final String DESCRIPTION__ELEMENT = "description";
    private static final String OTHER_TAG_ELEMENT = "otherTag";
    private static final String FUNCTION_TAG_ELEMENT = "functionTag";
    private static final String ITERATING_TAG_ELEMENT = "iteratingTag";
    private static final String CONDITIONAL_TAG_ELEMENT = "conditionalTag";
    private static final String EMPTY_TAG_ELEMENT = "emptyTag";
    private static final String CONTAINER_TAG_ELEMENT = "containerTag";
    private static final String TAG_NAME_ATTRIBUTE = "name";
    private static final Map tagToKindMap = new HashMap(5);
    private final String id;
    private final boolean deprecated;
    private final String name;
    private final String description;
    private final Map tagMap;
    private final String standardPrefix;
    private String[] tagNames = null;
    private static final String[] EMPTY_TAGNAME_ARRAY;
    private final TagInstanceFactory tagInstanceFactory;

    static {
        tagToKindMap.put(OTHER_TAG_ELEMENT, CustomTagKind.OTHER);
        tagToKindMap.put(FUNCTION_TAG_ELEMENT, CustomTagKind.FUNCTION);
        tagToKindMap.put(ITERATING_TAG_ELEMENT, CustomTagKind.ITERATING);
        tagToKindMap.put(CONDITIONAL_TAG_ELEMENT, CustomTagKind.CONDITIONAL);
        tagToKindMap.put(EMPTY_TAG_ELEMENT, CustomTagKind.EMPTY);
        tagToKindMap.put(CONTAINER_TAG_ELEMENT, CustomTagKind.CONTAINER);
        EMPTY_TAGNAME_ARRAY = new String[0];
    }

    public ExtensionTagLibraryImpl(String id, IConfigurationElement configElement) {
        this.id = id;
        this.deprecated = Boolean.valueOf(configElement.getAttribute(DEPRECATED__ATTR));
        this.standardPrefix = configElement.getAttribute(STANDARD_PREFIX__ATTR);
        this.name = configElement.getAttribute("name");
        this.description = ExtensionTagLibraryImpl.getDescription(configElement);
        IConfigurationElement[] children = configElement.getChildren();
        this.tagMap = new HashMap(children.length);
        int i = 0;
        while (i < children.length) {
            String tagName = children[i].getAttribute("name");
            CustomTagKind kind = (CustomTagKind)tagToKindMap.get(children[i].getName());
            if (kind != null && tagName != null && !this.tagMap.containsKey(tagName)) {
                this.tagMap.put(tagName, ExtensionTagDefinitionImpl.createInstance(tagName, children[i], kind, this));
            }
            ++i;
        }
        TagInstanceFactory factory = null;
        try {
            if (configElement.getAttribute(TAG_FACTORY_ATTRIBUTE) != null) {
                factory = (TagInstanceFactory)configElement.createExecutableExtension(TAG_FACTORY_ATTRIBUTE);
            }
        }
        catch (CoreException e) {
            InternalJET2Platform.log(e.getStatus());
        }
        this.tagInstanceFactory = factory;
    }

    static String getDescription(IConfigurationElement configElement) {
        IConfigurationElement[] descriptions = configElement.getChildren(DESCRIPTION__ELEMENT);
        String desc = "";
        if (descriptions != null && descriptions.length > 0) {
            desc = descriptions[0].getValue();
        }
        return desc;
    }

    public String getLibraryId() {
        return this.id;
    }

    public TagDefinition getTagDefinition(String name) {
        return (TagDefinition)this.tagMap.get(name);
    }

    public String[] getTagNames() {
        if (this.tagNames == null) {
            ArrayList tagList = new ArrayList(this.tagMap.keySet());
            Collections.sort(tagList);
            this.tagNames = tagList.toArray(EMPTY_TAGNAME_ARRAY);
        }
        return this.tagNames;
    }

    public boolean hasTag(String tagNCName) {
        return this.tagMap.containsKey(tagNCName);
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String getLibraryName() {
        return this.name;
    }

    public String getDefaultPrefix() {
        return this.standardPrefix == null ? "" : this.standardPrefix;
    }

    public String getDescription() {
        return this.description;
    }

    public TagInstanceFactory getTagInstanceFactory() {
        return this.tagInstanceFactory;
    }
}

