/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.compiler;

import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;

class TemplatePathUtil {
    private TemplatePathUtil() {
    }

    public static URI baseLocationURI(String workspaceFullPath) {
        String projectName = new Path(workspaceFullPath).segment(0);
        return projectName == null ? null : ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocationURI();
    }

    public static URI baseLocationURI(IFile templateFile) {
        return templateFile.getProject().getLocationURI();
    }

    public static String templatePath(String workspaceFullPath) {
        Path wsPath = new Path(workspaceFullPath);
        return wsPath.segmentCount() == 0 ? "" : wsPath.removeFirstSegments(1).makeRelative().toString();
    }

    public static String templatePath(IFile templateFile) {
        return templateFile.getProjectRelativePath().toString();
    }

    public static IFile workspaceFile(URI baseLocation, String templatePath) {
        IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(baseLocation);
        if (containers.length > 0) {
            if (containers[0].getType() == 4) {
                throw new IllegalArgumentException();
            }
            return ((IProject)containers[0]).getFile(templatePath);
        }
        return null;
    }
}

